/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.languages;

import io.swagger.codegen.CliOption;
import io.swagger.codegen.CodegenConfig;
import io.swagger.codegen.CodegenModel;
import io.swagger.codegen.CodegenOperation;
import io.swagger.codegen.CodegenProperty;
import io.swagger.codegen.CodegenResponse;
import io.swagger.codegen.CodegenType;
import io.swagger.codegen.SupportingFile;
import io.swagger.codegen.languages.JavaClientCodegen;
import io.swagger.models.Operation;
import io.swagger.models.Path;
import io.swagger.models.Swagger;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class JavaResteasyServerCodegen
extends JavaClientCodegen
implements CodegenConfig {
    protected String dateLibrary = "default";
    protected String title = "Swagger Server";
    protected String implFolder = "src/main/java";
    public static final String DATE_LIBRARY = "dateLibrary";

    public JavaResteasyServerCodegen() {
        this.sourceFolder = "src/gen/java";
        this.invokerPackage = "io.swagger.api";
        this.artifactId = "swagger-jaxrs-resteasy-server";
        this.outputFolder = "generated-code/javaJaxRS";
        this.modelTemplateFiles.put("model.mustache", ".java");
        this.apiTemplateFiles.put("api.mustache", ".java");
        this.apiTemplateFiles.put("apiService.mustache", ".java");
        this.apiTemplateFiles.put("apiServiceImpl.mustache", ".java");
        this.apiTemplateFiles.put("apiServiceFactory.mustache", ".java");
        this.apiPackage = "io.swagger.api";
        this.modelPackage = "io.swagger.model";
        this.additionalProperties.put("title", this.title);
        this.embeddedTemplateDir = this.templateDir = "JavaJaxRS" + File.separator + "resteasy";
        for (int i = 0; i < this.cliOptions.size(); ++i) {
            if (!"library".equals(((CliOption)this.cliOptions.get(i)).getOpt())) continue;
            this.cliOptions.remove(i);
            break;
        }
        CliOption dateLibrary = new CliOption(DATE_LIBRARY, "Option. Date library to use");
        HashMap<String, String> dateOptions = new HashMap<String, String>();
        dateOptions.put("java8", "Java 8 native");
        dateOptions.put("joda", "Joda");
        dateLibrary.setEnum(dateOptions);
        this.cliOptions.add(dateLibrary);
        CliOption library = new CliOption("library", "library template (sub-template) to use");
        library.setDefault("<default>");
        LinkedHashMap<String, String> supportedLibraries = new LinkedHashMap<String, String>();
        supportedLibraries.put("<default>", "Resteasy core 3.0.11");
        library.setEnum(supportedLibraries);
        this.cliOptions.add(library);
        this.cliOptions.add(new CliOption("implFolder", "folder for generated implementation code"));
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.SERVER;
    }

    @Override
    public String getName() {
        return "jaxrs-resteasy";
    }

    @Override
    public String getHelp() {
        return "Generates a Java JAXRS-Resteasy Server application.";
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (this.additionalProperties.containsKey("implFolder")) {
            this.implFolder = (String)this.additionalProperties.get("implFolder");
        }
        this.supportingFiles.clear();
        this.writeOptional(this.outputFolder, new SupportingFile("pom.mustache", "", "pom.xml"));
        this.writeOptional(this.outputFolder, new SupportingFile("gradle.mustache", "", "build.gradle"));
        this.writeOptional(this.outputFolder, new SupportingFile("settingsGradle.mustache", "", "settings.gradle"));
        this.writeOptional(this.outputFolder, new SupportingFile("README.mustache", "", "README.md"));
        this.supportingFiles.add(new SupportingFile("ApiException.mustache", (this.sourceFolder + '/' + this.apiPackage).replace(".", "/"), "ApiException.java"));
        this.supportingFiles.add(new SupportingFile("ApiOriginFilter.mustache", (this.sourceFolder + '/' + this.apiPackage).replace(".", "/"), "ApiOriginFilter.java"));
        this.supportingFiles.add(new SupportingFile("ApiResponseMessage.mustache", (this.sourceFolder + '/' + this.apiPackage).replace(".", "/"), "ApiResponseMessage.java"));
        this.supportingFiles.add(new SupportingFile("NotFoundException.mustache", (this.sourceFolder + '/' + this.apiPackage).replace(".", "/"), "NotFoundException.java"));
        this.writeOptional(this.outputFolder, new SupportingFile("web.mustache", "src/main/webapp/WEB-INF", "web.xml"));
        this.writeOptional(this.outputFolder, new SupportingFile("jboss-web.mustache", "src/main/webapp/WEB-INF", "jboss-web.xml"));
        this.writeOptional(this.outputFolder, new SupportingFile("RestApplication.mustache", (this.sourceFolder + '/' + this.invokerPackage).replace(".", "/"), "RestApplication.java"));
        this.supportingFiles.add(new SupportingFile("StringUtil.mustache", (this.sourceFolder + '/' + this.invokerPackage).replace(".", "/"), "StringUtil.java"));
        if (this.additionalProperties.containsKey(DATE_LIBRARY)) {
            this.setDateLibrary(this.additionalProperties.get(DATE_LIBRARY).toString());
            this.additionalProperties.put(this.dateLibrary, "true");
        }
        if ("joda".equals(this.dateLibrary)) {
            this.typeMapping.put("date", "LocalDate");
            this.typeMapping.put("DateTime", "DateTime");
            this.importMapping.put("LocalDate", "org.joda.time.LocalDate");
            this.importMapping.put("DateTime", "org.joda.time.DateTime");
            this.supportingFiles.add(new SupportingFile("JacksonConfig.mustache", (this.sourceFolder + '/' + this.invokerPackage).replace(".", "/"), "JacksonConfig.java"));
            this.supportingFiles.add(new SupportingFile("JodaDateTimeProvider.mustache", (this.sourceFolder + '/' + this.apiPackage).replace(".", "/"), "JodaDateTimeProvider.java"));
            this.supportingFiles.add(new SupportingFile("JodaLocalDateProvider.mustache", (this.sourceFolder + '/' + this.apiPackage).replace(".", "/"), "JodaLocalDateProvider.java"));
        } else if ("java8".equals(this.dateLibrary)) {
            this.additionalProperties.put("java8", "true");
            this.additionalProperties.put("javaVersion", "1.8");
            this.typeMapping.put("date", "LocalDate");
            this.typeMapping.put("DateTime", "LocalDateTime");
            this.importMapping.put("LocalDate", "java.time.LocalDate");
            this.importMapping.put("LocalDateTime", "java.time.LocalDateTime");
            this.supportingFiles.add(new SupportingFile("LocalDateTimeProvider.mustache", (this.sourceFolder + '/' + this.apiPackage).replace(".", "/"), "LocalDateTimeProvider.java"));
            this.supportingFiles.add(new SupportingFile("LocalDateProvider.mustache", (this.sourceFolder + '/' + this.apiPackage).replace(".", "/"), "LocalDateProvider.java"));
        }
    }

    @Override
    public void addOperationToGroup(String tag, String resourcePath, Operation operation, CodegenOperation co, Map<String, List<CodegenOperation>> operations) {
        int pos;
        String basePath = resourcePath;
        if (basePath.startsWith("/")) {
            basePath = basePath.substring(1);
        }
        if ((pos = basePath.indexOf("/")) > 0) {
            basePath = basePath.substring(0, pos);
        }
        if (basePath == "") {
            basePath = "default";
        } else {
            if (co.path.startsWith("/" + basePath)) {
                co.path = co.path.substring(("/" + basePath).length());
            }
            co.subresourceOperation = !co.path.isEmpty();
        }
        List<CodegenOperation> opList = operations.get(basePath);
        if (opList == null) {
            opList = new ArrayList<CodegenOperation>();
            operations.put(basePath, opList);
        }
        opList.add(co);
        co.baseName = basePath;
    }

    @Override
    public void preprocessSwagger(Swagger swagger) {
        String[] parts;
        if ("/".equals(swagger.getBasePath())) {
            swagger.setBasePath("");
        }
        String host = swagger.getHost();
        String port = "8080";
        if (host != null && (parts = host.split(":")).length > 1) {
            port = parts[1];
        }
        this.additionalProperties.put("serverPort", port);
        if (swagger != null && swagger.getPaths() != null) {
            for (String pathname : swagger.getPaths().keySet()) {
                Path path = swagger.getPath(pathname);
                if (path.getOperations() == null) continue;
                for (Operation operation : path.getOperations()) {
                    if (operation.getTags() == null) continue;
                    ArrayList tags = new ArrayList();
                    for (String tag : operation.getTags()) {
                        HashMap<String, String> value = new HashMap<String, String>();
                        value.put("tag", tag);
                        value.put("hasMore", "true");
                        tags.add(value);
                    }
                    if (tags.size() > 0) {
                        ((Map)tags.get(tags.size() - 1)).remove("hasMore");
                    }
                    if (operation.getTags().size() > 0) {
                        String tag = (String)operation.getTags().get(0);
                        operation.setTags(Arrays.asList(tag));
                    }
                    operation.setVendorExtension("x-tags", tags);
                }
            }
        }
    }

    @Override
    public Map<String, Object> postProcessOperations(Map<String, Object> objs) {
        Map operations = (Map)objs.get("operations");
        if (operations != null) {
            List ops = (List)operations.get("operation");
            for (CodegenOperation operation : ops) {
                int end;
                String rt;
                List<CodegenResponse> responses;
                Map<String, String> firstType;
                if (operation.hasConsumes == Boolean.TRUE && (firstType = operation.consumes.get(0)) != null && "multipart/form-data".equals(firstType.get("mediaType"))) {
                    operation.isMultipart = Boolean.TRUE;
                }
                if ((responses = operation.responses) != null) {
                    for (CodegenResponse resp : responses) {
                        if (!"0".equals(resp.code)) continue;
                        resp.code = "200";
                    }
                }
                if (operation.returnType == null) {
                    operation.returnType = "Void";
                    continue;
                }
                if (operation.returnType.startsWith("List")) {
                    rt = operation.returnType;
                    int end2 = rt.lastIndexOf(">");
                    if (end2 <= 0) continue;
                    operation.returnType = rt.substring("List<".length(), end2).trim();
                    operation.returnContainer = "List";
                    continue;
                }
                if (operation.returnType.startsWith("Map")) {
                    rt = operation.returnType;
                    int end3 = rt.lastIndexOf(">");
                    if (end3 <= 0) continue;
                    operation.returnType = rt.substring("Map<".length(), end3).split(",")[1].trim();
                    operation.returnContainer = "Map";
                    continue;
                }
                if (!operation.returnType.startsWith("Set") || (end = (rt = operation.returnType).lastIndexOf(">")) <= 0) continue;
                operation.returnType = rt.substring("Set<".length(), end).trim();
                operation.returnContainer = "Set";
            }
        }
        return objs;
    }

    @Override
    public String toApiName(String name) {
        if (name.length() == 0) {
            return "DefaultApi";
        }
        name = this.sanitizeName(name);
        return JavaResteasyServerCodegen.camelize(name) + "Api";
    }

    @Override
    public String apiFilename(String templateName, String tag) {
        String result = super.apiFilename(templateName, tag);
        if (templateName.endsWith("Impl.mustache")) {
            int ix = result.lastIndexOf(47);
            result = result.substring(0, ix) + "/impl" + result.substring(ix, result.length() - 5) + "ServiceImpl.java";
            result = result.replace(this.apiFileFolder(), this.implFileFolder(this.implFolder));
        } else if (templateName.endsWith("Factory.mustache")) {
            int ix = result.lastIndexOf(47);
            result = result.substring(0, ix) + "/factories" + result.substring(ix, result.length() - 5) + "ServiceFactory.java";
            result = result.replace(this.apiFileFolder(), this.implFileFolder(this.implFolder));
        } else if (templateName.endsWith("Service.mustache")) {
            int ix = result.lastIndexOf(46);
            result = result.substring(0, ix) + "Service.java";
        }
        return result;
    }

    private String implFileFolder(String output) {
        return this.outputFolder + "/" + output + "/" + this.apiPackage().replace('.', '/');
    }

    @Override
    public boolean shouldOverwrite(String filename) {
        return super.shouldOverwrite(filename) && !filename.endsWith("ServiceImpl.java") && !filename.endsWith("ServiceFactory.java");
    }

    @Override
    public void setDateLibrary(String library) {
        this.dateLibrary = library;
    }

    @Override
    public void postProcessModelProperty(CodegenModel model, CodegenProperty property) {
        String lib;
        if (this.serializeBigDecimalAsString && property.baseType.equals("BigDecimal")) {
            property.vendorExtensions.put("extraAnnotation", "@JsonSerialize(using = ToStringSerializer.class)");
            model.imports.add("ToStringSerializer");
            model.imports.add("JsonSerialize");
        }
        if ((model.isEnum == null || model.isEnum.booleanValue()) && StringUtils.isEmpty((String)(lib = this.getLibrary()))) {
            model.imports.add("JsonProperty");
            if (model.hasEnums != null || model.hasEnums.booleanValue()) {
                model.imports.add("JsonValue");
            }
        }
    }
}

