/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.languages;

import com.google.common.collect.ImmutableMap;
import io.swagger.codegen.CliOption;
import io.swagger.codegen.CodegenModel;
import io.swagger.codegen.CodegenOperation;
import io.swagger.codegen.CodegenProperty;
import io.swagger.codegen.CodegenType;
import io.swagger.codegen.SupportingFile;
import io.swagger.codegen.languages.AbstractCSharpCodegen;
import io.swagger.models.Model;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.WordUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSharpClientCodegen
extends AbstractCSharpCodegen {
    private static final Logger LOGGER = LoggerFactory.getLogger(CSharpClientCodegen.class);
    private static final String NET45 = "v4.5";
    private static final String NET35 = "v3.5";
    private static final String DATA_TYPE_WITH_ENUM_EXTENSION = "plainDatatypeWithEnum";
    protected String packageGuid = "{" + UUID.randomUUID().toString().toUpperCase() + "}";
    protected String packageTitle = "Swagger Library";
    protected String packageProductName = "SwaggerLibrary";
    protected String packageDescription = "A library generated from a Swagger doc";
    protected String packageCompany = "Swagger";
    protected String packageCopyright = "No Copyright";
    protected String clientPackage = "IO.Swagger.Client";
    protected String localVariablePrefix = "";
    protected String targetFramework = "v4.5";
    protected String targetFrameworkNuget = "net45";
    protected boolean supportsAsync = Boolean.TRUE;
    protected final Map<String, String> frameworks;

    public CSharpClientCodegen() {
        this.modelTemplateFiles.put("model.mustache", ".cs");
        this.apiTemplateFiles.put("api.mustache", ".cs");
        this.modelTestTemplateFiles.put("model_test.mustache", ".cs");
        this.apiTestTemplateFiles.put("api_test.mustache", ".cs");
        this.setSourceFolder("src" + File.separator + "main" + File.separator + "csharp");
        this.cliOptions.clear();
        this.addOption("packageName", "C# package name (convention: Title.Case).", this.packageName);
        this.addOption("packageVersion", "C# package version.", this.packageVersion);
        this.addOption("sourceFolder", "source folder for generated code", this.sourceFolder);
        this.addOption("packageGuid", "The GUID that will be associated with the C# project", null);
        CliOption framework = new CliOption("targetFramework", "The target .NET framework version.");
        this.frameworks = new ImmutableMap.Builder().put((Object)NET35, (Object)".NET Framework 3.5 compatible").put((Object)NET45, (Object)".NET Framework 4.5+ compatible").build();
        framework.defaultValue(this.targetFramework);
        framework.setEnum(this.frameworks);
        this.cliOptions.add(framework);
        this.addSwitch("sortParamsByRequiredFlag", "Sort method arguments to place required parameters before optional parameters.", this.sortParamsByRequiredFlag);
        this.addSwitch("useDateTimeOffset", "Use DateTimeOffset to model date-time properties", this.useDateTimeOffsetFlag);
        this.addSwitch("useCollection", "Deserialize array types to Collection<T> instead of List<T>.", this.useCollection);
        this.addSwitch("returnICollection", "Return ICollection<T> instead of the concrete type.", this.returnICollection);
        this.addSwitch("optionalMethodArgument", "C# Optional method argument, e.g. void square(int x=10) (.net 4.0+ only).", this.optionalMethodArgumentFlag);
        this.addSwitch("optionalAssemblyInfo", "Generate AssemblyInfo.cs.", this.optionalAssemblyInfoFlag);
        this.addSwitch("optionalProjectFile", "Generate {PackageName}.csproj.", this.optionalProjectFileFlag);
        this.addSwitch("optionalEmitDefaultValues", "Set DataMember's EmitDefaultValue, default false.", this.optionalEmitDefaultValue);
    }

    @Override
    public void processOpts() {
        super.processOpts();
        this.apiPackage = this.packageName + ".Api";
        this.modelPackage = this.packageName + ".Model";
        this.clientPackage = this.packageName + ".Client";
        this.additionalProperties.put("clientPackage", this.clientPackage);
        this.additionalProperties.put("packageTitle", this.packageTitle);
        this.additionalProperties.put("packageProductName", this.packageProductName);
        this.additionalProperties.put("packageDescription", this.packageDescription);
        this.additionalProperties.put("packageCompany", this.packageCompany);
        this.additionalProperties.put("packageCopyright", this.packageCopyright);
        this.additionalProperties.put("emitDefaultValue", this.optionalEmitDefaultValue);
        if (this.additionalProperties.containsKey("targetFramework")) {
            this.setTargetFramework((String)this.additionalProperties.get("targetFramework"));
        }
        if (NET35.equals(this.targetFramework)) {
            this.setTargetFrameworkNuget("net35");
            this.setSupportsAsync(Boolean.FALSE);
            if (this.additionalProperties.containsKey("supportsAsync")) {
                this.additionalProperties.remove("supportsAsync");
            }
        } else {
            this.setTargetFrameworkNuget("net45");
            this.setSupportsAsync(Boolean.TRUE);
            this.additionalProperties.put("supportsAsync", this.supportsAsync);
        }
        this.additionalProperties.put("targetFrameworkNuget", this.targetFrameworkNuget);
        if (this.additionalProperties.containsKey("optionalProjectFile")) {
            this.setOptionalProjectFileFlag(Boolean.valueOf(this.additionalProperties.get("optionalProjectFile").toString()));
        }
        if (this.additionalProperties.containsKey("packageGuid")) {
            this.setPackageGuid((String)this.additionalProperties.get("packageGuid"));
        }
        this.additionalProperties.put("packageGuid", this.packageGuid);
        if (this.additionalProperties.containsKey("optionalMethodArgument")) {
            this.setOptionalMethodArgumentFlag(Boolean.valueOf(this.additionalProperties.get("optionalMethodArgument").toString()));
        }
        this.additionalProperties.put("optionalMethodArgument", this.optionalMethodArgumentFlag);
        if (this.additionalProperties.containsKey("optionalAssemblyInfo")) {
            this.setOptionalAssemblyInfoFlag(Boolean.valueOf(this.additionalProperties.get("optionalAssemblyInfo").toString()));
        }
        String packageFolder = this.sourceFolder + File.separator + this.packageName.replace(".", File.separator);
        String clientPackageDir = this.sourceFolder + File.separator + this.clientPackage.replace(".", File.separator);
        int packageDepth = packageFolder.length() - packageFolder.replace(File.separator, "").length();
        String binRelativePath = "..\\";
        for (int i = 0; i < packageDepth; ++i) {
            binRelativePath = binRelativePath + "..\\";
        }
        binRelativePath = binRelativePath + "vendor\\";
        this.additionalProperties.put("binRelativePath", binRelativePath);
        this.supportingFiles.add(new SupportingFile("Configuration.mustache", clientPackageDir, "Configuration.cs"));
        this.supportingFiles.add(new SupportingFile("ApiClient.mustache", clientPackageDir, "ApiClient.cs"));
        this.supportingFiles.add(new SupportingFile("ApiException.mustache", clientPackageDir, "ApiException.cs"));
        this.supportingFiles.add(new SupportingFile("ApiResponse.mustache", clientPackageDir, "ApiResponse.cs"));
        this.supportingFiles.add(new SupportingFile("compile.mustache", "", "compile.bat"));
        this.supportingFiles.add(new SupportingFile("compile-mono.sh.mustache", "", "compile-mono.sh"));
        this.supportingFiles.add(new SupportingFile("packages.config.mustache", "vendor" + File.separator, "packages.config"));
        this.supportingFiles.add(new SupportingFile("README.md", "", "README.md"));
        this.supportingFiles.add(new SupportingFile("git_push.sh.mustache", "", "git_push.sh"));
        this.supportingFiles.add(new SupportingFile("gitignore.mustache", "", ".gitignore"));
        if (this.optionalAssemblyInfoFlag) {
            this.supportingFiles.add(new SupportingFile("AssemblyInfo.mustache", packageFolder + File.separator + "Properties", "AssemblyInfo.cs"));
        }
        if (this.optionalProjectFileFlag) {
            this.supportingFiles.add(new SupportingFile("Project.mustache", packageFolder, this.clientPackage + ".csproj"));
        }
    }

    @Override
    public Map<String, Object> postProcessOperations(Map<String, Object> objs) {
        Map operations;
        super.postProcessOperations(objs);
        if (objs != null && (operations = (Map)objs.get("operations")) != null) {
            List ops = (List)operations.get("operation");
            for (CodegenOperation operation : ops) {
                int genericStart;
                if (operation.returnType == null) continue;
                operation.returnContainer = operation.returnType;
                if (!this.returnICollection || !operation.returnType.startsWith("List") && !operation.returnType.startsWith("Collection") || (genericStart = operation.returnType.indexOf("<")) <= 0) continue;
                operation.returnType = "ICollection" + operation.returnType.substring(genericStart);
            }
        }
        return objs;
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.CLIENT;
    }

    @Override
    public String getName() {
        return "csharp";
    }

    @Override
    public String getHelp() {
        return "Generates a CSharp client library.";
    }

    public void setOptionalAssemblyInfoFlag(boolean flag) {
        this.optionalAssemblyInfoFlag = flag;
    }

    @Override
    public CodegenModel fromModel(String name, Model model, Map<String, Model> allDefinitions) {
        CodegenModel codegenModel = super.fromModel(name, model, allDefinitions);
        if (allDefinitions != null && codegenModel != null && codegenModel.parent != null && codegenModel.hasEnums.booleanValue()) {
            Model parentModel = allDefinitions.get(this.toModelName(codegenModel.parent));
            CodegenModel parentCodegenModel = super.fromModel(codegenModel.parent, parentModel);
            codegenModel = this.reconcileInlineEnums(codegenModel, parentCodegenModel);
        }
        return codegenModel;
    }

    public void setOptionalProjectFileFlag(boolean flag) {
        this.optionalProjectFileFlag = flag;
    }

    public void setPackageGuid(String packageGuid) {
        this.packageGuid = packageGuid;
    }

    @Override
    public Map<String, Object> postProcessModels(Map<String, Object> objMap) {
        Map<String, Object> objs = super.postProcessModels(objMap);
        List models = (List)objs.get("models");
        for (Object _mo : models) {
            Map mo = (Map)_mo;
            CodegenModel cm = (CodegenModel)mo.get("model");
            for (CodegenProperty var : cm.vars) {
                List values;
                Map<String, Object> allowableValues = var.allowableValues;
                if (var.items != null) {
                    allowableValues = var.items.allowableValues;
                }
                if (allowableValues == null || (values = (List)allowableValues.get("values")) == null) continue;
                ArrayList enumVars = new ArrayList();
                String commonPrefix = this.findCommonPrefixOfVars(values);
                int truncateIdx = commonPrefix.length();
                for (String value : values) {
                    String enumName;
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    if (truncateIdx == 0) {
                        enumName = value;
                    } else {
                        enumName = value.substring(truncateIdx);
                        if ("".equals(enumName)) {
                            enumName = value;
                        }
                    }
                    hashMap.put("name", this.toEnumVarName(enumName));
                    hashMap.put("jsonname", value);
                    hashMap.put("value", value);
                    enumVars.add(hashMap);
                }
                allowableValues.put("enumVars", enumVars);
                if (var.datatypeWithEnum != null) {
                    var.vendorExtensions.put(DATA_TYPE_WITH_ENUM_EXTENSION, var.datatypeWithEnum.substring(0, var.datatypeWithEnum.length() - 1));
                }
                if (var.defaultValue == null) continue;
                String enumName = null;
                for (Map map : enumVars) {
                    if (!var.defaultValue.replace("\"", "").equals(map.get("value"))) continue;
                    enumName = (String)map.get("name");
                    break;
                }
                if (enumName == null || !var.vendorExtensions.containsKey(DATA_TYPE_WITH_ENUM_EXTENSION)) continue;
                var.defaultValue = var.vendorExtensions.get(DATA_TYPE_WITH_ENUM_EXTENSION) + "." + enumName;
            }
        }
        return objs;
    }

    public void setTargetFramework(String dotnetFramework) {
        if (!this.frameworks.containsKey(dotnetFramework)) {
            LOGGER.warn("Invalid .NET framework version, defaulting to " + this.targetFramework);
        } else {
            this.targetFramework = dotnetFramework;
        }
        LOGGER.info("Generating code for .NET Framework " + this.targetFramework);
    }

    private CodegenModel reconcileInlineEnums(CodegenModel codegenModel, CodegenModel parentCodegenModel) {
        if (parentCodegenModel.hasEnums.booleanValue()) {
            List<CodegenProperty> parentModelCodegenProperties = parentCodegenModel.vars;
            List<CodegenProperty> codegenProperties = codegenModel.vars;
            boolean removedChildEnum = false;
            for (CodegenProperty parentModelCodegenPropery : parentModelCodegenProperties) {
                if (!parentModelCodegenPropery.isEnum) continue;
                Iterator<CodegenProperty> iterator = codegenProperties.iterator();
                while (iterator.hasNext()) {
                    CodegenProperty codegenProperty = iterator.next();
                    if (!codegenProperty.isEnum || !codegenProperty.equals(parentModelCodegenPropery)) continue;
                    iterator.remove();
                    removedChildEnum = true;
                }
            }
            if (removedChildEnum) {
                int count = 0;
                int numVars = codegenProperties.size();
                for (CodegenProperty codegenProperty : codegenProperties) {
                    codegenProperty.hasMore = ++count < numVars ? Boolean.valueOf(true) : null;
                }
                codegenModel.vars = codegenProperties;
            }
        }
        return codegenModel;
    }

    private String findCommonPrefixOfVars(List<String> vars) {
        String prefix = StringUtils.getCommonPrefix((String[])vars.toArray(new String[vars.size()]));
        return prefix.replaceAll("[a-zA-Z0-9]+\\z", "");
    }

    private String toEnumVarName(String value) {
        String var = value.replaceAll("_", " ");
        var = WordUtils.capitalizeFully((String)var);
        if ((var = var.replaceAll("\\W+", "")).matches("\\d.*")) {
            return "_" + var;
        }
        return var;
    }

    @Override
    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    @Override
    public void setPackageVersion(String packageVersion) {
        this.packageVersion = packageVersion;
    }

    public void setTargetFrameworkNuget(String targetFrameworkNuget) {
        this.targetFrameworkNuget = targetFrameworkNuget;
    }

    public void setSupportsAsync(Boolean supportsAsync) {
        this.supportsAsync = supportsAsync;
    }
}

