/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.languages;

import io.swagger.codegen.CliOption;
import io.swagger.codegen.CodegenConfig;
import io.swagger.codegen.CodegenType;
import io.swagger.codegen.DefaultCodegen;
import io.swagger.codegen.SupportingFile;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.BooleanProperty;
import io.swagger.models.properties.DateProperty;
import io.swagger.models.properties.DateTimeProperty;
import io.swagger.models.properties.DoubleProperty;
import io.swagger.models.properties.FloatProperty;
import io.swagger.models.properties.IntegerProperty;
import io.swagger.models.properties.LongProperty;
import io.swagger.models.properties.MapProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.StringProperty;
import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import org.apache.commons.lang.StringUtils;

public class PythonClientCodegen
extends DefaultCodegen
implements CodegenConfig {
    protected String packageName;
    protected String packageVersion;

    public PythonClientCodegen() {
        this.modelPackage = "models";
        this.apiPackage = "api";
        this.outputFolder = "generated-code" + File.separatorChar + "python";
        this.modelTemplateFiles.put("model.mustache", ".py");
        this.apiTemplateFiles.put("api.mustache", ".py");
        this.templateDir = "python";
        this.embeddedTemplateDir = "python";
        this.languageSpecificPrimitives.clear();
        this.languageSpecificPrimitives.add("int");
        this.languageSpecificPrimitives.add("float");
        this.languageSpecificPrimitives.add("list");
        this.languageSpecificPrimitives.add("bool");
        this.languageSpecificPrimitives.add("str");
        this.languageSpecificPrimitives.add("datetime");
        this.languageSpecificPrimitives.add("date");
        this.typeMapping.clear();
        this.typeMapping.put("integer", "int");
        this.typeMapping.put("float", "float");
        this.typeMapping.put("number", "float");
        this.typeMapping.put("long", "int");
        this.typeMapping.put("double", "float");
        this.typeMapping.put("array", "list");
        this.typeMapping.put("map", "dict");
        this.typeMapping.put("boolean", "bool");
        this.typeMapping.put("string", "str");
        this.typeMapping.put("date", "date");
        this.typeMapping.put("DateTime", "datetime");
        this.typeMapping.put("object", "object");
        this.typeMapping.put("file", "file");
        this.reservedWords = new HashSet<String>(Arrays.asList("all_params", "resource_path", "method", "path_params", "query_params", "header_params", "form_params", "files", "body_params", "auth_settings", "and", "del", "from", "not", "while", "as", "elif", "global", "or", "with", "assert", "else", "if", "pass", "yield", "break", "except", "import", "print", "class", "exec", "in", "raise", "continue", "finally", "is", "return", "def", "for", "lambda", "try", "self"));
        this.cliOptions.clear();
        this.cliOptions.add(new CliOption("packageName", "python package name (convention: snake_case).").defaultValue("swagger_client"));
        this.cliOptions.add(new CliOption("packageVersion", "python package version.").defaultValue("1.0.0"));
        this.cliOptions.add(CliOption.newBoolean("sortParamsByRequiredFlag", "Sort method arguments to place required parameters before optional parameters.").defaultValue(Boolean.TRUE.toString()));
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (this.additionalProperties.containsKey("packageName")) {
            this.setPackageName((String)this.additionalProperties.get("packageName"));
        } else {
            this.setPackageName("swagger_client");
        }
        if (this.additionalProperties.containsKey("packageVersion")) {
            this.setPackageVersion((String)this.additionalProperties.get("packageVersion"));
        } else {
            this.setPackageVersion("1.0.0");
        }
        this.additionalProperties.put("packageName", this.packageName);
        this.additionalProperties.put("packageVersion", this.packageVersion);
        String swaggerFolder = this.packageName;
        this.modelPackage = swaggerFolder + File.separatorChar + "models";
        this.apiPackage = swaggerFolder + File.separatorChar + "apis";
        this.supportingFiles.add(new SupportingFile("README.mustache", "", "README.md"));
        this.supportingFiles.add(new SupportingFile("setup.mustache", "", "setup.py"));
        this.supportingFiles.add(new SupportingFile("api_client.mustache", swaggerFolder, "api_client.py"));
        this.supportingFiles.add(new SupportingFile("rest.mustache", swaggerFolder, "rest.py"));
        this.supportingFiles.add(new SupportingFile("configuration.mustache", swaggerFolder, "configuration.py"));
        this.supportingFiles.add(new SupportingFile("__init__package.mustache", swaggerFolder, "__init__.py"));
        this.supportingFiles.add(new SupportingFile("__init__model.mustache", this.modelPackage, "__init__.py"));
        this.supportingFiles.add(new SupportingFile("__init__api.mustache", this.apiPackage, "__init__.py"));
    }

    private static String dropDots(String str) {
        return str.replaceAll("\\.", "_");
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.CLIENT;
    }

    @Override
    public String getName() {
        return "python";
    }

    @Override
    public String getHelp() {
        return "Generates a Python client library.";
    }

    @Override
    public String escapeReservedWord(String name) {
        return "_" + name;
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + File.separatorChar + this.apiPackage().replace('.', File.separatorChar);
    }

    @Override
    public String modelFileFolder() {
        return this.outputFolder + File.separatorChar + this.modelPackage().replace('.', File.separatorChar);
    }

    @Override
    public String getTypeDeclaration(Property p) {
        if (p instanceof ArrayProperty) {
            ArrayProperty ap = (ArrayProperty)p;
            Property inner = ap.getItems();
            return this.getSwaggerType(p) + "[" + this.getTypeDeclaration(inner) + "]";
        }
        if (p instanceof MapProperty) {
            MapProperty mp = (MapProperty)p;
            Property inner = mp.getAdditionalProperties();
            return this.getSwaggerType(p) + "(str, " + this.getTypeDeclaration(inner) + ")";
        }
        return super.getTypeDeclaration(p);
    }

    @Override
    public String getSwaggerType(Property p) {
        String swaggerType = super.getSwaggerType(p);
        String type = null;
        if (this.typeMapping.containsKey(swaggerType)) {
            type = (String)this.typeMapping.get(swaggerType);
            if (this.languageSpecificPrimitives.contains(type)) {
                return type;
            }
        } else {
            type = this.toModelName(swaggerType);
        }
        return type;
    }

    @Override
    public String toVarName(String name) {
        name = this.sanitizeName(name);
        if ((name = name.replaceAll("$", "")).matches("^[A-Z_]*$")) {
            name = name.toLowerCase();
        }
        name = PythonClientCodegen.underscore(name);
        if (this.reservedWords.contains(name = name.replaceAll("^_*", "")) || name.matches("^\\d.*")) {
            name = this.escapeReservedWord(name);
        }
        return name;
    }

    @Override
    public String toParamName(String name) {
        return this.toVarName(name);
    }

    @Override
    public String toModelName(String name) {
        name = this.sanitizeName(name);
        if (this.reservedWords.contains(name = name.replaceAll("$", ""))) {
            throw new RuntimeException(name + " (reserved word) cannot be used as a model name");
        }
        return PythonClientCodegen.camelize(name);
    }

    @Override
    public String toModelFilename(String name) {
        if (this.reservedWords.contains(name)) {
            throw new RuntimeException(name + " (reserved word) cannot be used as a model name");
        }
        return PythonClientCodegen.underscore(PythonClientCodegen.dropDots(name));
    }

    @Override
    public String toApiFilename(String name) {
        name = name.replaceAll("-", "_");
        return PythonClientCodegen.underscore(name) + "_api";
    }

    @Override
    public String toApiName(String name) {
        if (name.length() == 0) {
            return "DefaultApi";
        }
        return PythonClientCodegen.camelize(name) + "Api";
    }

    @Override
    public String toApiVarName(String name) {
        if (name.length() == 0) {
            return "default_api";
        }
        return PythonClientCodegen.underscore(name) + "_api";
    }

    @Override
    public String toOperationId(String operationId) {
        if (StringUtils.isEmpty((String)operationId)) {
            throw new RuntimeException("Empty method name (operationId) not allowed");
        }
        if (this.reservedWords.contains(operationId)) {
            throw new RuntimeException(operationId + " (reserved word) cannot be used as method name");
        }
        return PythonClientCodegen.underscore(this.sanitizeName(operationId));
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public void setPackageVersion(String packageVersion) {
        this.packageVersion = packageVersion;
    }

    public String generatePackageName(String packageName) {
        return PythonClientCodegen.underscore(packageName.replaceAll("[^\\w]+", ""));
    }

    @Override
    public String toDefaultValue(Property p) {
        if (p instanceof StringProperty) {
            StringProperty dp = (StringProperty)p;
            if (dp.getDefault() != null) {
                return "'" + dp.getDefault().toString() + "'";
            }
        } else if (p instanceof BooleanProperty) {
            BooleanProperty dp = (BooleanProperty)p;
            if (dp.getDefault() != null) {
                if (dp.getDefault().toString().equalsIgnoreCase("false")) {
                    return "False";
                }
                return "True";
            }
        } else if (!(p instanceof DateProperty) && !(p instanceof DateTimeProperty)) {
            LongProperty dp;
            if (p instanceof DoubleProperty) {
                DoubleProperty dp2 = (DoubleProperty)p;
                if (dp2.getDefault() != null) {
                    return dp2.getDefault().toString();
                }
            } else if (p instanceof FloatProperty) {
                FloatProperty dp3 = (FloatProperty)p;
                if (dp3.getDefault() != null) {
                    return dp3.getDefault().toString();
                }
            } else if (p instanceof IntegerProperty) {
                IntegerProperty dp4 = (IntegerProperty)p;
                if (dp4.getDefault() != null) {
                    return dp4.getDefault().toString();
                }
            } else if (p instanceof LongProperty && (dp = (LongProperty)p).getDefault() != null) {
                return dp.getDefault().toString();
            }
        }
        return null;
    }
}

