/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.languages;

import io.swagger.codegen.CliOption;
import io.swagger.codegen.CodegenConfig;
import io.swagger.codegen.CodegenOperation;
import io.swagger.codegen.CodegenType;
import io.swagger.codegen.DefaultCodegen;
import io.swagger.codegen.SupportingFile;
import io.swagger.models.Contact;
import io.swagger.models.Info;
import io.swagger.models.License;
import io.swagger.models.Swagger;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class ClojureClientCodegen
extends DefaultCodegen
implements CodegenConfig {
    private static final String PROJECT_NAME = "projectName";
    private static final String PROJECT_DESCRIPTION = "projectDescription";
    private static final String PROJECT_VERSION = "projectVersion";
    private static final String PROJECT_URL = "projectUrl";
    private static final String PROJECT_LICENSE_NAME = "projectLicenseName";
    private static final String PROJECT_LICENSE_URL = "projectLicenseUrl";
    private static final String BASE_NAMESPACE = "baseNamespace";
    protected String projectName;
    protected String projectDescription;
    protected String projectVersion;
    protected String baseNamespace;
    protected String sourceFolder = "src";

    public ClojureClientCodegen() {
        this.outputFolder = "generated-code" + File.separator + "clojure";
        this.apiTemplateFiles.put("api.mustache", ".clj");
        this.templateDir = "clojure";
        this.embeddedTemplateDir = "clojure";
        this.cliOptions.add(new CliOption(PROJECT_NAME, "name of the project (Default: generated from info.title or \"swagger-clj-client\")"));
        this.cliOptions.add(new CliOption(PROJECT_DESCRIPTION, "description of the project (Default: using info.description or \"Client library of <projectNname>\")"));
        this.cliOptions.add(new CliOption(PROJECT_VERSION, "version of the project (Default: using info.version or \"1.0.0\")"));
        this.cliOptions.add(new CliOption(PROJECT_URL, "URL of the project (Default: using info.contact.url or not included in project.clj)"));
        this.cliOptions.add(new CliOption(PROJECT_LICENSE_NAME, "name of the license the project uses (Default: using info.license.name or not included in project.clj)"));
        this.cliOptions.add(new CliOption(PROJECT_LICENSE_URL, "URL of the license the project uses (Default: using info.license.url or not included in project.clj)"));
        this.cliOptions.add(new CliOption(BASE_NAMESPACE, "the base/top namespace (Default: generated from projectName)"));
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.CLIENT;
    }

    @Override
    public String getName() {
        return "clojure";
    }

    @Override
    public String getHelp() {
        return "Generates a Clojure client library.";
    }

    @Override
    public void preprocessSwagger(Swagger swagger) {
        super.preprocessSwagger(swagger);
        if (this.additionalProperties.containsKey(PROJECT_NAME)) {
            this.projectName = (String)this.additionalProperties.get(PROJECT_NAME);
        }
        if (this.additionalProperties.containsKey(PROJECT_DESCRIPTION)) {
            this.projectDescription = (String)this.additionalProperties.get(PROJECT_DESCRIPTION);
        }
        if (this.additionalProperties.containsKey(PROJECT_VERSION)) {
            this.projectVersion = (String)this.additionalProperties.get(PROJECT_VERSION);
        }
        if (this.additionalProperties.containsKey(BASE_NAMESPACE)) {
            this.baseNamespace = (String)this.additionalProperties.get(BASE_NAMESPACE);
        }
        if (swagger.getInfo() != null) {
            Info info = swagger.getInfo();
            if (this.projectName == null && info.getTitle() != null) {
                this.projectName = this.dashize(info.getTitle());
            }
            if (this.projectVersion == null) {
                this.projectVersion = info.getVersion();
            }
            if (this.projectDescription == null) {
                this.projectDescription = info.getDescription();
            }
            if (info.getContact() != null) {
                Contact contact = info.getContact();
                if (this.additionalProperties.get(PROJECT_URL) == null) {
                    this.additionalProperties.put(PROJECT_URL, contact.getUrl());
                }
            }
            if (info.getLicense() != null) {
                License license = info.getLicense();
                if (this.additionalProperties.get(PROJECT_LICENSE_NAME) == null) {
                    this.additionalProperties.put(PROJECT_LICENSE_NAME, license.getName());
                }
                if (this.additionalProperties.get(PROJECT_LICENSE_URL) == null) {
                    this.additionalProperties.put(PROJECT_LICENSE_URL, license.getUrl());
                }
            }
        }
        if (this.projectName == null) {
            this.projectName = "swagger-clj-client";
        }
        if (this.projectVersion == null) {
            this.projectVersion = "1.0.0";
        }
        if (this.projectDescription == null) {
            this.projectDescription = "Client library of " + this.projectName;
        }
        if (this.baseNamespace == null) {
            this.baseNamespace = this.dashize(this.projectName);
        }
        this.apiPackage = this.baseNamespace + ".api";
        this.additionalProperties.put(PROJECT_NAME, this.projectName);
        this.additionalProperties.put(PROJECT_DESCRIPTION, this.escapeText(this.projectDescription));
        this.additionalProperties.put(PROJECT_VERSION, this.projectVersion);
        this.additionalProperties.put(BASE_NAMESPACE, this.baseNamespace);
        this.additionalProperties.put("apiPackage", this.apiPackage);
        String baseNamespaceFolder = this.sourceFolder + File.separator + this.namespaceToFolder(this.baseNamespace);
        this.supportingFiles.add(new SupportingFile("project.mustache", "", "project.clj"));
        this.supportingFiles.add(new SupportingFile("core.mustache", baseNamespaceFolder, "core.clj"));
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + File.separator + this.sourceFolder + File.separator + this.namespaceToFolder(this.apiPackage);
    }

    @Override
    public String toOperationId(String operationId) {
        if (StringUtils.isEmpty((String)operationId)) {
            throw new RuntimeException("Empty method/operation name (operationId) not allowed");
        }
        return this.dashize(this.sanitizeName(operationId));
    }

    @Override
    public String toApiName(String name) {
        return this.dashize(name);
    }

    @Override
    public String toParamName(String name) {
        return this.toVarName(name);
    }

    @Override
    public String toVarName(String name) {
        name = name.replaceAll("[^a-zA-Z0-9_-]+", "");
        name = this.dashize(name);
        return name;
    }

    @Override
    public String escapeText(String input) {
        if (input == null) {
            return null;
        }
        return input.trim().replace("\\", "\\\\").replace("\"", "\\\"");
    }

    @Override
    public Map<String, Object> postProcessOperations(Map<String, Object> operations) {
        Map objs = (Map)operations.get("operations");
        List ops = (List)objs.get("operation");
        for (CodegenOperation op : ops) {
            op.httpMethod = op.httpMethod.toLowerCase();
        }
        return operations;
    }

    protected String namespaceToFolder(String ns) {
        return ns.replace(".", File.separator).replace("-", "_");
    }
}

