/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.languages;

import io.swagger.codegen.CodegenConfig;
import io.swagger.codegen.CodegenType;
import io.swagger.codegen.DefaultCodegen;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.FileProperty;
import io.swagger.models.properties.MapProperty;
import io.swagger.models.properties.Property;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractTypeScriptClientCodegen
extends DefaultCodegen
implements CodegenConfig {
    @Override
    public CodegenType getTag() {
        return CodegenType.CLIENT;
    }

    public AbstractTypeScriptClientCodegen() {
        this.supportsInheritance = true;
        this.reservedWords = new HashSet<String>(Arrays.asList("path", "queryParameters", "headerParams", "formParams", "useFormData", "deferred", "requestOptions", "abstract", "await", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "debugger", "default", "delete", "do", "double", "else", "enum", "export", "extends", "false", "final", "finally", "float", "for", "function", "goto", "if", "implements", "import", "in", "instanceof", "int", "interface", "let", "long", "native", "new", "null", "package", "private", "protected", "public", "return", "short", "static", "super", "switch", "synchronized", "this", "throw", "transient", "true", "try", "typeof", "var", "void", "volatile", "while", "with", "yield"));
        this.languageSpecificPrimitives = new HashSet<String>(Arrays.asList("String", "boolean", "Boolean", "Double", "Integer", "Long", "Float", "Object"));
        this.instantiationTypes.put("array", "Array");
        this.typeMapping = new HashMap();
        this.typeMapping.put("Array", "Array");
        this.typeMapping.put("array", "Array");
        this.typeMapping.put("List", "Array");
        this.typeMapping.put("boolean", "boolean");
        this.typeMapping.put("string", "string");
        this.typeMapping.put("int", "number");
        this.typeMapping.put("float", "number");
        this.typeMapping.put("number", "number");
        this.typeMapping.put("long", "number");
        this.typeMapping.put("short", "number");
        this.typeMapping.put("char", "string");
        this.typeMapping.put("double", "number");
        this.typeMapping.put("object", "any");
        this.typeMapping.put("integer", "number");
        this.typeMapping.put("Map", "any");
        this.typeMapping.put("DateTime", "Date");
    }

    @Override
    public String escapeReservedWord(String name) {
        return "_" + name;
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + "/" + this.apiPackage().replace('.', File.separatorChar);
    }

    @Override
    public String modelFileFolder() {
        return this.outputFolder + "/" + this.modelPackage().replace('.', File.separatorChar);
    }

    @Override
    public String toVarName(String name) {
        if ((name = name.replaceAll("-", "_")).matches("^[A-Z_]*$")) {
            return name;
        }
        if (this.reservedWords.contains(name = AbstractTypeScriptClientCodegen.camelize(name, true)) || name.matches("^\\d.*")) {
            name = this.escapeReservedWord(name);
        }
        return name;
    }

    @Override
    public String toParamName(String name) {
        return this.toVarName(name);
    }

    @Override
    public String toModelName(String name) {
        if (this.reservedWords.contains(name)) {
            throw new RuntimeException(name + " (reserved word) cannot be used as a model name");
        }
        return AbstractTypeScriptClientCodegen.camelize(name);
    }

    @Override
    public String toModelFilename(String name) {
        return this.toModelName(name);
    }

    @Override
    public String getTypeDeclaration(Property p) {
        if (p instanceof ArrayProperty) {
            ArrayProperty ap = (ArrayProperty)p;
            Property inner = ap.getItems();
            return this.getSwaggerType(p) + "<" + this.getTypeDeclaration(inner) + ">";
        }
        if (p instanceof MapProperty) {
            MapProperty mp = (MapProperty)p;
            Property inner = mp.getAdditionalProperties();
            return "{ [key: string]: " + this.getTypeDeclaration(inner) + "; }";
        }
        if (p instanceof FileProperty) {
            return "any";
        }
        return super.getTypeDeclaration(p);
    }

    @Override
    public String getSwaggerType(Property p) {
        String swaggerType = super.getSwaggerType(p);
        String type = null;
        if (this.typeMapping.containsKey(swaggerType)) {
            type = (String)this.typeMapping.get(swaggerType);
            if (this.languageSpecificPrimitives.contains(type)) {
                return type;
            }
        } else {
            type = swaggerType;
        }
        return type;
    }

    @Override
    public String toOperationId(String operationId) {
        if (StringUtils.isEmpty((String)operationId)) {
            throw new RuntimeException("Empty method name (operationId) not allowed");
        }
        if (this.reservedWords.contains(operationId)) {
            return this.escapeReservedWord(AbstractTypeScriptClientCodegen.camelize(this.sanitizeName(operationId), true));
        }
        return AbstractTypeScriptClientCodegen.camelize(this.sanitizeName(operationId), true);
    }
}

