/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.languages;

import io.swagger.codegen.CodegenConfig;
import io.swagger.codegen.CodegenType;
import io.swagger.codegen.DefaultCodegen;
import io.swagger.codegen.SupportingFile;
import io.swagger.models.Swagger;
import io.swagger.util.Yaml;
import java.io.File;
import org.apache.commons.io.FileUtils;

public class SwaggerYamlGenerator
extends DefaultCodegen
implements CodegenConfig {
    public SwaggerYamlGenerator() {
        this.templateDir = "swagger";
        this.outputFolder = "generated-code/swagger";
        this.supportingFiles.add(new SupportingFile("README.md", "", "README.md"));
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.DOCUMENTATION;
    }

    @Override
    public String getName() {
        return "swagger-yaml";
    }

    @Override
    public String getHelp() {
        return "Creates a static swagger.yaml file.";
    }

    @Override
    public void processSwagger(Swagger swagger) {
        try {
            String swaggerString = Yaml.mapper().writeValueAsString((Object)swagger);
            String outputFile = this.outputFolder + File.separator + "swagger.yaml";
            FileUtils.writeStringToFile((File)new File(outputFile), (String)swaggerString);
            System.out.println("wrote file to " + outputFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

