/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.languages;

import io.swagger.codegen.CodegenConfig;
import io.swagger.codegen.CodegenType;
import io.swagger.codegen.DefaultCodegen;
import io.swagger.codegen.SupportingFile;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.MapProperty;
import io.swagger.models.properties.Property;
import java.io.File;
import java.util.Arrays;
import java.util.HashSet;

public class SinatraServerCodegen
extends DefaultCodegen
implements CodegenConfig {
    protected String gemName = null;
    protected String moduleName = null;
    protected String gemVersion = "1.0.0";
    protected String libFolder = "lib";

    public SinatraServerCodegen() {
        this.apiPackage = "lib";
        this.outputFolder = "generated-code" + File.separator + "sinatra";
        this.modelTemplateFiles.clear();
        this.apiTemplateFiles.put("api.mustache", ".rb");
        this.templateDir = "sinatra";
        this.typeMapping.clear();
        this.languageSpecificPrimitives.clear();
        this.reservedWords = new HashSet<String>(Arrays.asList("__FILE__", "and", "def", "end", "in", "or", "self", "unless", "__LINE__", "begin", "defined?", "ensure", "module", "redo", "super", "until", "BEGIN", "break", "do", "false", "next", "rescue", "then", "when", "END", "case", "else", "for", "nil", "retry", "true", "while", "alias", "class", "elsif", "if", "not", "return", "undef", "yield"));
        this.languageSpecificPrimitives.add("int");
        this.languageSpecificPrimitives.add("array");
        this.languageSpecificPrimitives.add("map");
        this.languageSpecificPrimitives.add("string");
        this.languageSpecificPrimitives.add("DateTime");
        this.typeMapping.put("long", "int");
        this.typeMapping.put("integer", "int");
        this.typeMapping.put("Array", "array");
        this.typeMapping.put("String", "string");
        this.typeMapping.put("List", "array");
        this.typeMapping.put("map", "map");
        this.cliOptions.clear();
    }

    @Override
    public void processOpts() {
        super.processOpts();
        this.setApiPackage("api");
        this.supportingFiles.add(new SupportingFile("my_app.mustache", "", "my_app.rb"));
        this.supportingFiles.add(new SupportingFile("Swaggering.rb", this.libFolder, "swaggering.rb"));
        this.supportingFiles.add(new SupportingFile("config.ru", "", "config.ru"));
        this.supportingFiles.add(new SupportingFile("Gemfile", "", "Gemfile"));
        this.supportingFiles.add(new SupportingFile("README.md", "", "README.md"));
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.SERVER;
    }

    @Override
    public String getName() {
        return "sinatra";
    }

    @Override
    public String getHelp() {
        return "Generates a Sinatra server library.";
    }

    @Override
    public String escapeReservedWord(String name) {
        return "_" + name;
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + File.separator + this.apiPackage.replace("/", File.separator);
    }

    @Override
    public String getTypeDeclaration(Property p) {
        if (p instanceof ArrayProperty) {
            ArrayProperty ap = (ArrayProperty)p;
            Property inner = ap.getItems();
            return this.getSwaggerType(p) + "[" + this.getTypeDeclaration(inner) + "]";
        }
        if (p instanceof MapProperty) {
            MapProperty mp = (MapProperty)p;
            Property inner = mp.getAdditionalProperties();
            return this.getSwaggerType(p) + "[string," + this.getTypeDeclaration(inner) + "]";
        }
        return super.getTypeDeclaration(p);
    }

    @Override
    public String getSwaggerType(Property p) {
        String swaggerType = super.getSwaggerType(p);
        String type = null;
        if (this.typeMapping.containsKey(swaggerType)) {
            type = (String)this.typeMapping.get(swaggerType);
            if (this.languageSpecificPrimitives.contains(type)) {
                return type;
            }
        } else {
            type = swaggerType;
        }
        if (type == null) {
            return null;
        }
        return type;
    }

    @Override
    public String toDefaultValue(Property p) {
        return "null";
    }

    @Override
    public String toVarName(String name) {
        if ((name = name.replaceAll("-", "_")).matches("^[A-Z_]*$")) {
            name = name.toLowerCase();
        }
        if (this.reservedWords.contains(name = SinatraServerCodegen.underscore(name)) || name.matches("^\\d.*")) {
            name = this.escapeReservedWord(name);
        }
        return name;
    }

    @Override
    public String toParamName(String name) {
        return this.toVarName(name);
    }

    @Override
    public String toModelName(String name) {
        if (this.reservedWords.contains(name)) {
            throw new RuntimeException(name + " (reserved word) cannot be used as a model name");
        }
        return SinatraServerCodegen.camelize(name);
    }

    @Override
    public String toModelFilename(String name) {
        if (this.reservedWords.contains(name)) {
            throw new RuntimeException(name + " (reserved word) cannot be used as a model name");
        }
        return SinatraServerCodegen.underscore(name);
    }

    @Override
    public String toApiFilename(String name) {
        name = name.replaceAll("-", "_");
        return SinatraServerCodegen.underscore(name) + "_api";
    }

    @Override
    public String toApiName(String name) {
        if (name.length() == 0) {
            return "DefaultApi";
        }
        return SinatraServerCodegen.camelize(name) + "Api";
    }

    @Override
    public String toOperationId(String operationId) {
        if (this.reservedWords.contains(operationId)) {
            throw new RuntimeException(operationId + " (reserved word) cannot be used as method name");
        }
        return SinatraServerCodegen.underscore(operationId);
    }
}

