/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.languages;

import io.swagger.codegen.CliOption;
import io.swagger.codegen.CodegenConfig;
import io.swagger.codegen.CodegenType;
import io.swagger.codegen.DefaultCodegen;
import io.swagger.codegen.SupportingFile;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.MapProperty;
import io.swagger.models.properties.Property;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;

public class DartClientCodegen
extends DefaultCodegen
implements CodegenConfig {
    protected boolean browserClient = true;
    protected String pubName = "swagger";
    protected String pubVersion = "1.0.0";
    protected String pubDescription = "Swagger API client";
    protected String sourceFolder = "";

    public DartClientCodegen() {
        this.outputFolder = "generated-code/dart";
        this.modelTemplateFiles.put("model.mustache", ".dart");
        this.apiTemplateFiles.put("api.mustache", ".dart");
        this.templateDir = "dart";
        this.apiPackage = "lib.api";
        this.modelPackage = "lib.model";
        this.reservedWords = new HashSet<String>(Arrays.asList("abstract", "as", "assert", "async", "async*", "await", "break", "case", "catch", "class", "const", "continue", "default", "deferred", "do", "dynamic", "else", "enum", "export", "external", "extends", "factory", "false", "final", "finally", "for", "get", "if", "implements", "import", "in", "is", "library", "new", "null", "operator", "part", "rethrow", "return", "set", "static", "super", "switch", "sync*", "this", "throw", "true", "try", "typedef", "var", "void", "while", "with", "yield", "yield*"));
        this.languageSpecificPrimitives = new HashSet<String>(Arrays.asList("String", "bool", "num", "int", "float"));
        this.instantiationTypes.put("array", "List");
        this.instantiationTypes.put("map", "Map");
        this.typeMapping = new HashMap();
        this.typeMapping.put("Array", "List");
        this.typeMapping.put("array", "List");
        this.typeMapping.put("List", "List");
        this.typeMapping.put("boolean", "bool");
        this.typeMapping.put("string", "String");
        this.typeMapping.put("int", "int");
        this.typeMapping.put("float", "num");
        this.typeMapping.put("long", "int");
        this.typeMapping.put("short", "int");
        this.typeMapping.put("char", "String");
        this.typeMapping.put("double", "num");
        this.typeMapping.put("object", "Object");
        this.typeMapping.put("integer", "int");
        this.typeMapping.put("Date", "DateTime");
        this.typeMapping.put("date", "DateTime");
        this.typeMapping.put("File", "MultipartFile");
        this.cliOptions.add(new CliOption("browserClient", "Is the client browser based"));
        this.cliOptions.add(new CliOption("pubName", "Name in generated pubspec"));
        this.cliOptions.add(new CliOption("pubVersion", "Version in generated pubspec"));
        this.cliOptions.add(new CliOption("sourceFolder", "source folder for generated code"));
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.CLIENT;
    }

    @Override
    public String getName() {
        return "dart";
    }

    @Override
    public String getHelp() {
        return "Generates a Dart client library.";
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (this.additionalProperties.containsKey("browserClient")) {
            this.setBrowserClient(Boolean.parseBoolean((String)this.additionalProperties.get("browserClient")));
            this.additionalProperties.put("browserClient", this.browserClient);
        } else {
            this.additionalProperties.put("browserClient", this.browserClient);
        }
        if (this.additionalProperties.containsKey("pubName")) {
            this.setPubName((String)this.additionalProperties.get("pubName"));
        } else {
            this.additionalProperties.put("pubName", this.pubName);
        }
        if (this.additionalProperties.containsKey("pubVersion")) {
            this.setPubVersion((String)this.additionalProperties.get("pubVersion"));
        } else {
            this.additionalProperties.put("pubVersion", this.pubVersion);
        }
        if (this.additionalProperties.containsKey("pubDescription")) {
            this.setPubDescription((String)this.additionalProperties.get("pubDescription"));
        } else {
            this.additionalProperties.put("pubDescription", this.pubDescription);
        }
        if (this.additionalProperties.containsKey("sourceFolder")) {
            this.setSourceFolder((String)this.additionalProperties.get("sourceFolder"));
        }
        String libFolder = this.sourceFolder + File.separator + "lib";
        this.supportingFiles.add(new SupportingFile("pubspec.mustache", "", "pubspec.yaml"));
        this.supportingFiles.add(new SupportingFile("api_client.mustache", libFolder, "api_client.dart"));
        this.supportingFiles.add(new SupportingFile("apiException.mustache", libFolder, "api_exception.dart"));
        this.supportingFiles.add(new SupportingFile("apilib.mustache", libFolder, "api.dart"));
        String authFolder = this.sourceFolder + File.separator + "lib" + File.separator + "auth";
        this.supportingFiles.add(new SupportingFile("auth/authentication.mustache", authFolder, "authentication.dart"));
        this.supportingFiles.add(new SupportingFile("auth/http_basic_auth.mustache", authFolder, "http_basic_auth.dart"));
        this.supportingFiles.add(new SupportingFile("auth/api_key_auth.mustache", authFolder, "api_key_auth.dart"));
        this.supportingFiles.add(new SupportingFile("auth/oauth.mustache", authFolder, "oauth.dart"));
    }

    @Override
    public String escapeReservedWord(String name) {
        return "_" + name;
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + "/" + this.sourceFolder + "/" + this.apiPackage().replace('.', File.separatorChar);
    }

    @Override
    public String modelFileFolder() {
        return this.outputFolder + "/" + this.sourceFolder + "/" + this.modelPackage().replace('.', File.separatorChar);
    }

    @Override
    public String toVarName(String name) {
        if ((name = name.replaceAll("-", "_")).matches("^[A-Z_]*$")) {
            return name;
        }
        if (this.reservedWords.contains(name = DartClientCodegen.camelize(name, true)) || name.matches("^\\d.*")) {
            name = this.escapeReservedWord(name);
        }
        return name;
    }

    @Override
    public String toParamName(String name) {
        return this.toVarName(name);
    }

    @Override
    public String toModelName(String name) {
        if (this.reservedWords.contains(name)) {
            throw new RuntimeException(name + " (reserved word) cannot be used as a model name");
        }
        return DartClientCodegen.camelize(name);
    }

    @Override
    public String toModelFilename(String name) {
        return DartClientCodegen.underscore(this.toModelName(name));
    }

    @Override
    public String toApiFilename(String name) {
        return DartClientCodegen.underscore(this.toApiName(name));
    }

    @Override
    public String toDefaultValue(Property p) {
        if (p instanceof MapProperty) {
            MapProperty ap = (MapProperty)p;
            String inner = this.getSwaggerType(ap.getAdditionalProperties());
            return "{}";
        }
        if (p instanceof ArrayProperty) {
            ArrayProperty ap = (ArrayProperty)p;
            String inner = this.getSwaggerType(ap.getItems());
            return "[]";
        }
        return super.toDefaultValue(p);
    }

    @Override
    public String getTypeDeclaration(Property p) {
        if (p instanceof ArrayProperty) {
            ArrayProperty ap = (ArrayProperty)p;
            Property inner = ap.getItems();
            return this.getSwaggerType(p) + "<" + this.getTypeDeclaration(inner) + ">";
        }
        if (p instanceof MapProperty) {
            MapProperty mp = (MapProperty)p;
            Property inner = mp.getAdditionalProperties();
            return this.getSwaggerType(p) + "<String, " + this.getTypeDeclaration(inner) + ">";
        }
        return super.getTypeDeclaration(p);
    }

    @Override
    public String getSwaggerType(Property p) {
        String swaggerType = super.getSwaggerType(p);
        String type = null;
        if (this.typeMapping.containsKey(swaggerType)) {
            type = (String)this.typeMapping.get(swaggerType);
            if (this.languageSpecificPrimitives.contains(type)) {
                return type;
            }
        } else {
            type = swaggerType;
        }
        return this.toModelName(type);
    }

    @Override
    public String toOperationId(String operationId) {
        if (this.reservedWords.contains(operationId)) {
            throw new RuntimeException(operationId + " (reserved word) cannot be used as method name");
        }
        return DartClientCodegen.camelize(operationId, true);
    }

    public void setBrowserClient(boolean browserClient) {
        this.browserClient = browserClient;
    }

    public void setPubName(String pubName) {
        this.pubName = pubName;
    }

    public void setPubVersion(String pubVersion) {
        this.pubVersion = pubVersion;
    }

    public void setPubDescription(String pubDescription) {
        this.pubDescription = pubDescription;
    }

    public void setSourceFolder(String sourceFolder) {
        this.sourceFolder = sourceFolder;
    }
}

