/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.config;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import io.swagger.codegen.CliOption;
import io.swagger.codegen.ClientOptInput;
import io.swagger.codegen.ClientOpts;
import io.swagger.codegen.CodegenConfig;
import io.swagger.codegen.CodegenConfigLoader;
import io.swagger.codegen.auth.AuthParser;
import io.swagger.models.Swagger;
import io.swagger.models.auth.AuthorizationValue;
import io.swagger.parser.SwaggerParser;
import io.swagger.util.Json;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodegenConfigurator {
    public static final Logger LOG = LoggerFactory.getLogger(CodegenConfigurator.class);
    private String lang;
    private String inputSpec;
    private String outputDir;
    private boolean verbose = false;
    private boolean skipOverwrite = false;
    private String templateDir;
    private String auth;
    private String apiPackage;
    private String modelPackage;
    private String invokerPackage;
    private String groupId;
    private String artifactId;
    private String artifactVersion;
    private String library;
    private Map<String, String> systemProperties = new HashMap<String, String>();
    private Map<String, String> instantiationTypes = new HashMap<String, String>();
    private Map<String, String> typeMappings = new HashMap<String, String>();
    private Map<String, String> additionalProperties = new HashMap<String, String>();
    private Map<String, String> importMappings = new HashMap<String, String>();
    private Set<String> languageSpecificPrimitives = new HashSet<String>();
    private final Map<String, String> dynamicProperties = new HashMap<String, String>();

    public CodegenConfigurator() {
        this.setOutputDir(".");
    }

    public CodegenConfigurator setLang(String lang) {
        this.lang = lang;
        return this;
    }

    public CodegenConfigurator setInputSpec(String inputSpec) {
        this.inputSpec = inputSpec;
        return this;
    }

    public String getInputSpec() {
        return this.inputSpec;
    }

    public String getOutputDir() {
        return this.outputDir;
    }

    public CodegenConfigurator setOutputDir(String outputDir) {
        this.outputDir = CodegenConfigurator.toAbsolutePathStr(outputDir);
        return this;
    }

    public String getModelPackage() {
        return this.modelPackage;
    }

    public CodegenConfigurator setModelPackage(String modelPackage) {
        this.modelPackage = modelPackage;
        return this;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public CodegenConfigurator setVerbose(boolean verbose) {
        this.verbose = verbose;
        return this;
    }

    public boolean isSkipOverwrite() {
        return this.skipOverwrite;
    }

    public CodegenConfigurator setSkipOverwrite(boolean skipOverwrite) {
        this.skipOverwrite = skipOverwrite;
        return this;
    }

    public String getLang() {
        return this.lang;
    }

    public String getTemplateDir() {
        return this.templateDir;
    }

    public CodegenConfigurator setTemplateDir(String templateDir) {
        this.templateDir = new File(templateDir).getAbsolutePath();
        return this;
    }

    public String getAuth() {
        return this.auth;
    }

    public CodegenConfigurator setAuth(String auth) {
        this.auth = auth;
        return this;
    }

    public String getApiPackage() {
        return this.apiPackage;
    }

    public CodegenConfigurator setApiPackage(String apiPackage) {
        this.apiPackage = apiPackage;
        return this;
    }

    public String getInvokerPackage() {
        return this.invokerPackage;
    }

    public CodegenConfigurator setInvokerPackage(String invokerPackage) {
        this.invokerPackage = invokerPackage;
        return this;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public CodegenConfigurator setGroupId(String groupId) {
        this.groupId = groupId;
        return this;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public CodegenConfigurator setArtifactId(String artifactId) {
        this.artifactId = artifactId;
        return this;
    }

    public String getArtifactVersion() {
        return this.artifactVersion;
    }

    public CodegenConfigurator setArtifactVersion(String artifactVersion) {
        this.artifactVersion = artifactVersion;
        return this;
    }

    public Map<String, String> getSystemProperties() {
        return this.systemProperties;
    }

    public CodegenConfigurator setSystemProperties(Map<String, String> systemProperties) {
        this.systemProperties = systemProperties;
        return this;
    }

    public CodegenConfigurator addSystemProperty(String key, String value) {
        this.systemProperties.put(key, value);
        return this;
    }

    public Map<String, String> getInstantiationTypes() {
        return this.instantiationTypes;
    }

    public CodegenConfigurator setInstantiationTypes(Map<String, String> instantiationTypes) {
        this.instantiationTypes = instantiationTypes;
        return this;
    }

    public CodegenConfigurator addInstantiationType(String key, String value) {
        this.instantiationTypes.put(key, value);
        return this;
    }

    public Map<String, String> getTypeMappings() {
        return this.typeMappings;
    }

    public CodegenConfigurator setTypeMappings(Map<String, String> typeMappings) {
        this.typeMappings = typeMappings;
        return this;
    }

    public CodegenConfigurator addTypeMapping(String key, String value) {
        this.typeMappings.put(key, value);
        return this;
    }

    public Map<String, String> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public CodegenConfigurator setAdditionalProperties(Map<String, String> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    public CodegenConfigurator addAdditionalProperty(String key, String value) {
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, String> getImportMappings() {
        return this.importMappings;
    }

    public CodegenConfigurator setImportMappings(Map<String, String> importMappings) {
        this.importMappings = importMappings;
        return this;
    }

    public CodegenConfigurator addImportMapping(String key, String value) {
        this.importMappings.put(key, value);
        return this;
    }

    public Set<String> getLanguageSpecificPrimitives() {
        return this.languageSpecificPrimitives;
    }

    public CodegenConfigurator setLanguageSpecificPrimitives(Set<String> languageSpecificPrimitives) {
        this.languageSpecificPrimitives = languageSpecificPrimitives;
        return this;
    }

    public CodegenConfigurator addLanguageSpecificPrimitive(String value) {
        this.languageSpecificPrimitives.add(value);
        return this;
    }

    public String getLibrary() {
        return this.library;
    }

    public CodegenConfigurator setLibrary(String library) {
        this.library = library;
        return this;
    }

    public ClientOptInput toClientOptInput() {
        Validate.notEmpty((CharSequence)this.lang, (String)"language must be specified", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)this.inputSpec, (String)"input spec must be specified", (Object[])new Object[0]);
        this.setVerboseFlags();
        this.setSystemProperties();
        CodegenConfig config = CodegenConfigLoader.forName(this.lang);
        config.setOutputDir(this.outputDir);
        config.setSkipOverwrite(this.skipOverwrite);
        config.instantiationTypes().putAll(this.instantiationTypes);
        config.typeMapping().putAll(this.typeMappings);
        config.importMapping().putAll(this.importMappings);
        config.languageSpecificPrimitives().addAll(this.languageSpecificPrimitives);
        this.checkAndSetAdditionalProperty(this.apiPackage, "apiPackage");
        this.checkAndSetAdditionalProperty(this.modelPackage, "modelPackage");
        this.checkAndSetAdditionalProperty(this.invokerPackage, "invokerPackage");
        this.checkAndSetAdditionalProperty(this.groupId, "groupId");
        this.checkAndSetAdditionalProperty(this.artifactId, "artifactId");
        this.checkAndSetAdditionalProperty(this.artifactVersion, "artifactVersion");
        this.checkAndSetAdditionalProperty(this.templateDir, CodegenConfigurator.toAbsolutePathStr(this.templateDir), "templateDir");
        this.handleDynamicProperties(config);
        if (StringUtils.isNotEmpty((CharSequence)this.library)) {
            config.setLibrary(this.library);
        }
        config.additionalProperties().putAll(this.additionalProperties);
        ClientOptInput input = new ClientOptInput().config(config);
        List<AuthorizationValue> authorizationValues = AuthParser.parse(this.auth);
        Swagger swagger = new SwaggerParser().read(this.inputSpec, authorizationValues, true);
        input.opts(new ClientOpts()).swagger(swagger);
        return input;
    }

    @JsonAnySetter
    public CodegenConfigurator addDynamicProperty(String name, Object value) {
        this.dynamicProperties.put(name, value.toString());
        return this;
    }

    @JsonAnyGetter
    public Map<String, String> getDynamicProperties() {
        return this.dynamicProperties;
    }

    private void handleDynamicProperties(CodegenConfig codegenConfig) {
        for (CliOption langCliOption : codegenConfig.cliOptions()) {
            String opt = langCliOption.getOpt();
            if (!this.dynamicProperties.containsKey(opt)) continue;
            codegenConfig.additionalProperties().put(opt, this.dynamicProperties.get(opt));
        }
    }

    private void setVerboseFlags() {
        if (!this.verbose) {
            return;
        }
        LOG.info("\nVERBOSE MODE: ON. Additional debug options are injected\n - [debugSwagger] prints the swagger specification as interpreted by the codegen\n - [debugModels] prints models passed to the template engine\n - [debugOperations] prints operations passed to the template engine\n - [debugSupportingFiles] prints additional data passed to the template engine");
        System.setProperty("debugSwagger", "");
        System.setProperty("debugModels", "");
        System.setProperty("debugOperations", "");
        System.setProperty("debugSupportingFiles", "");
    }

    private void setSystemProperties() {
        for (Map.Entry<String, String> entry : this.systemProperties.entrySet()) {
            System.setProperty(entry.getKey(), entry.getValue());
        }
    }

    private static String toAbsolutePathStr(String path) {
        if (StringUtils.isNotEmpty((CharSequence)path)) {
            return Paths.get(path, new String[0]).toAbsolutePath().toString();
        }
        return path;
    }

    private void checkAndSetAdditionalProperty(String property, String propertyKey) {
        this.checkAndSetAdditionalProperty(property, property, propertyKey);
    }

    private void checkAndSetAdditionalProperty(String property, String valueToSet, String propertyKey) {
        if (StringUtils.isNotEmpty((CharSequence)property)) {
            this.additionalProperties.put(propertyKey, valueToSet);
        }
    }

    public static CodegenConfigurator fromFile(String configFile) {
        if (StringUtils.isNotEmpty((CharSequence)configFile)) {
            try {
                CodegenConfigurator result = (CodegenConfigurator)Json.mapper().readValue(new File(configFile), CodegenConfigurator.class);
                return result;
            }
            catch (IOException e) {
                LOG.error("Unable to deserialize config file: " + configFile, (Throwable)e);
            }
        }
        return null;
    }
}

