/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen;

import io.swagger.models.ArrayModel;
import io.swagger.models.ComposedModel;
import io.swagger.models.Model;
import io.swagger.models.ModelImpl;
import io.swagger.models.Operation;
import io.swagger.models.Path;
import io.swagger.models.RefModel;
import io.swagger.models.Response;
import io.swagger.models.Swagger;
import io.swagger.models.Xml;
import io.swagger.models.parameters.BodyParameter;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.MapProperty;
import io.swagger.models.properties.ObjectProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.RefProperty;
import io.swagger.util.Json;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class InlineModelResolver {
    private Swagger swagger = null;
    private boolean skipMatches = false;
    Map<String, Model> addedModels = new HashMap<String, Model>();
    Map<String, String> generatedSignature = new HashMap<String, String>();

    public void flatten(Swagger swagger) {
        this.swagger = swagger;
        if (swagger.getDefinitions() == null) {
            swagger.setDefinitions(new HashMap());
        }
        Map paths = swagger.getPaths();
        Map models = swagger.getDefinitions();
        if (paths != null) {
            for (String pathname : paths.keySet()) {
                Path path = (Path)paths.get(pathname);
                for (Operation operation : path.getOperations()) {
                    Map responses;
                    ObjectProperty op;
                    List parameters = operation.getParameters();
                    if (parameters != null) {
                        for (Parameter parameter : parameters) {
                            ArrayModel am;
                            Property inner;
                            BodyParameter bp;
                            if (!(parameter instanceof BodyParameter) || (bp = (BodyParameter)parameter).getSchema() == null) continue;
                            Model model = bp.getSchema();
                            if (model instanceof ModelImpl) {
                                String modelName = this.uniqueName(bp.getName());
                                ModelImpl obj = (ModelImpl)model;
                                this.flattenProperties(obj.getProperties(), pathname);
                                bp.setSchema((Model)new RefModel(modelName));
                                this.addGenerated(modelName, model);
                                swagger.addDefinition(modelName, model);
                                continue;
                            }
                            if (!(model instanceof ArrayModel) || !((inner = (am = (ArrayModel)model).getItems()) instanceof ObjectProperty)) continue;
                            op = (ObjectProperty)inner;
                            this.flattenProperties(op.getProperties(), pathname);
                        }
                    }
                    if ((responses = operation.getResponses()) == null) continue;
                    for (String key : responses.keySet()) {
                        MapProperty op2;
                        Property innerProperty;
                        Response response = (Response)responses.get(key);
                        if (response.getSchema() == null) continue;
                        Property property = response.getSchema();
                        if (property instanceof ObjectProperty) {
                            op = (ObjectProperty)property;
                            String modelName = this.uniqueName("inline_response_" + key);
                            Model model = this.modelFromProperty(op, modelName);
                            String existing = this.matchGenerated(model);
                            if (existing != null) {
                                response.setSchema((Property)new RefProperty(existing));
                                continue;
                            }
                            response.setSchema((Property)new RefProperty(modelName));
                            this.addGenerated(modelName, model);
                            swagger.addDefinition(modelName, model);
                            continue;
                        }
                        if (property instanceof ArrayProperty) {
                            ArrayProperty ap = (ArrayProperty)property;
                            if (!(ap.getItems() instanceof ObjectProperty)) continue;
                            op = (ObjectProperty)ap.getItems();
                            Map props = op.getProperties();
                            this.flattenProperties(props, "path");
                            continue;
                        }
                        if (!(property instanceof MapProperty) || !((innerProperty = (op2 = (MapProperty)property).getAdditionalProperties()) instanceof ObjectProperty)) continue;
                        ModelImpl innerModel = new ModelImpl();
                        innerModel.setTitle(property.getTitle());
                        property.getVendorExtensions();
                        property.getRequired();
                        property.getReadOnly();
                        property.getAccess();
                        innerModel.setDescription(property.getDescription());
                        innerModel.setExample((Object)property.getExample());
                        innerModel.setName(property.getName());
                        innerModel.setXml(property.getXml());
                        innerModel.setAdditionalProperties(innerProperty);
                        String modelName = this.uniqueName("inline_response_" + key);
                        String existing = this.matchGenerated((Model)innerModel);
                        if (existing != null) {
                            response.setSchema((Property)new RefProperty(existing));
                            continue;
                        }
                        response.setSchema((Property)new RefProperty(modelName));
                        this.addGenerated(modelName, (Model)innerModel);
                        swagger.addDefinition(modelName, (Model)innerModel);
                    }
                }
            }
        }
        if (models != null) {
            ArrayList modelNames = new ArrayList(models.keySet());
            for (String modelName : modelNames) {
                ModelImpl m;
                Model model = (Model)models.get(modelName);
                if (model instanceof ModelImpl) {
                    m = (ModelImpl)model;
                    Map properties = m.getProperties();
                    this.flattenProperties(properties, modelName);
                    continue;
                }
                if (model instanceof ArrayModel) {
                    m = (ArrayModel)model;
                    Property inner = m.getItems();
                    if (!(inner instanceof ObjectProperty)) continue;
                    String innerModelName = this.uniqueName(modelName + "_inner");
                    Model innerModel = this.modelFromProperty((ObjectProperty)inner, modelName);
                    String existing = this.matchGenerated(innerModel);
                    if (existing == null) {
                        swagger.addDefinition(innerModelName, innerModel);
                        this.addGenerated(innerModelName, innerModel);
                        m.setItems((Property)new RefProperty(innerModelName));
                        continue;
                    }
                    m.setItems((Property)new RefProperty(existing));
                    continue;
                }
                if (!(model instanceof ComposedModel)) continue;
                m = (ComposedModel)model;
            }
        }
    }

    public String matchGenerated(Model model) {
        if (this.skipMatches) {
            return null;
        }
        String json = Json.pretty((Object)model);
        if (this.generatedSignature.containsKey(json)) {
            return this.generatedSignature.get(json);
        }
        return null;
    }

    public void addGenerated(String name, Model model) {
        this.generatedSignature.put(Json.pretty((Object)model), name);
    }

    public String uniqueName(String key) {
        int count = 0;
        boolean done = false;
        key = key.replaceAll("[^a-z_\\.A-Z0-9 ]", "");
        while (!done) {
            String name = key;
            if (count > 0) {
                name = key + "_" + count;
            }
            if (this.swagger.getDefinitions() == null) {
                return name;
            }
            if (!this.swagger.getDefinitions().containsKey(name)) {
                return name;
            }
            ++count;
        }
        return key;
    }

    public void flattenProperties(Map<String, Property> properties, String path) {
        if (properties == null) {
            return;
        }
        HashMap<String, RefProperty> propsToUpdate = new HashMap<String, RefProperty>();
        HashMap<String, Model> modelsToAdd = new HashMap<String, Model>();
        for (String key : properties.keySet()) {
            Property property = properties.get(key);
            if (!(property instanceof ObjectProperty) || ((ObjectProperty)property).getProperties().size() <= 0) continue;
            ObjectProperty op = (ObjectProperty)property;
            String modelName = this.uniqueName(path + "_" + key);
            Model model = this.modelFromProperty(op, modelName);
            String existing = this.matchGenerated(model);
            if (existing != null) {
                propsToUpdate.put(key, new RefProperty(existing));
                continue;
            }
            propsToUpdate.put(key, new RefProperty(modelName));
            modelsToAdd.put(modelName, model);
            this.addGenerated(modelName, model);
            this.swagger.addDefinition(modelName, model);
        }
        if (propsToUpdate.size() > 0) {
            for (String key : propsToUpdate.keySet()) {
                properties.put(key, (Property)propsToUpdate.get(key));
            }
        }
        for (String key : modelsToAdd.keySet()) {
            this.swagger.addDefinition(key, (Model)modelsToAdd.get(key));
            this.addedModels.put(key, (Model)modelsToAdd.get(key));
        }
    }

    public Model modelFromProperty(ArrayProperty object, String path) {
        String access = object.getAccess();
        String description = object.getDescription();
        String example = object.getExample();
        String name = object.getName();
        Integer position = object.getPosition();
        Boolean readOnly = object.getReadOnly();
        Boolean required = object.getRequired();
        String title = object.getTitle();
        Map extensions = object.getVendorExtensions();
        Xml xml = object.getXml();
        Property inner = object.getItems();
        if (inner instanceof ObjectProperty) {
            ArrayModel model = new ArrayModel();
            model.setDescription(description);
            model.setExample((Object)example);
            model.setItems(object.getItems());
            return model;
        }
        return null;
    }

    public Model modelFromProperty(ObjectProperty object, String path) {
        String access = object.getAccess();
        String description = object.getDescription();
        String example = object.getExample();
        String name = object.getName();
        Integer position = object.getPosition();
        Boolean readOnly = object.getReadOnly();
        Boolean required = object.getRequired();
        String title = object.getTitle();
        Map extensions = object.getVendorExtensions();
        Xml xml = object.getXml();
        Map properties = object.getProperties();
        ModelImpl model = new ModelImpl();
        model.setDescription(description);
        model.setExample((Object)example);
        model.setName(name);
        model.setXml(xml);
        if (properties != null) {
            this.flattenProperties(properties, path);
            model.setProperties(properties);
        }
        return model;
    }

    public Model modelFromProperty(MapProperty object, String path) {
        String access = object.getAccess();
        String description = object.getDescription();
        String example = object.getExample();
        String name = object.getName();
        Integer position = object.getPosition();
        Boolean readOnly = object.getReadOnly();
        Boolean required = object.getRequired();
        String title = object.getTitle();
        Map extensions = object.getVendorExtensions();
        Xml xml = object.getXml();
        ArrayModel model = new ArrayModel();
        model.setDescription(description);
        model.setExample((Object)example);
        model.setItems(object.getAdditionalProperties());
        return model;
    }

    public boolean isSkipMatches() {
        return this.skipMatches;
    }

    public void setSkipMatches(boolean skipMatches) {
        this.skipMatches = skipMatches;
    }
}

