/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.v3.parser.processors;

import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.callbacks.Callback;
import io.swagger.v3.oas.models.examples.Example;
import io.swagger.v3.oas.models.headers.Header;
import io.swagger.v3.oas.models.links.Link;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.security.SecurityScheme;
import io.swagger.v3.parser.ResolverCache;
import io.swagger.v3.parser.models.RefFormat;
import io.swagger.v3.parser.util.RefUtils;
import java.net.URI;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExternalRefProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExternalRefProcessor.class);
    private final ResolverCache cache;
    private final OpenAPI openAPI;

    public ExternalRefProcessor(ResolverCache cache, OpenAPI openAPI) {
        this.cache = cache;
        this.openAPI = openAPI;
    }

    public String processRefToExternalSchema(String $ref, RefFormat refFormat) {
        String possiblyConflictingDefinitionName;
        Schema existingModel;
        LinkedHashMap schemas;
        String renamedRef = this.cache.getRenamedRef($ref);
        if (renamedRef != null) {
            return renamedRef;
        }
        Schema schema = this.cache.loadRef($ref, refFormat, Schema.class);
        if (schema == null) {
            LOGGER.warn("unable to load model reference from `" + $ref + "`.  It may not be available or the reference isn't a valid model schema");
            return $ref;
        }
        if (this.openAPI.getComponents() == null) {
            this.openAPI.setComponents(new Components());
        }
        if ((schemas = this.openAPI.getComponents().getSchemas()) == null) {
            schemas = new LinkedHashMap();
        }
        if ((existingModel = (Schema)schemas.get(possiblyConflictingDefinitionName = RefUtils.computeDefinitionName($ref, schemas.keySet()))) != null) {
            LOGGER.debug("A model for " + existingModel + " already exists");
            if (existingModel.get$ref() != null) {
                existingModel = null;
            }
        }
        String newRef = possiblyConflictingDefinitionName;
        this.cache.putRenamedRef($ref, newRef);
        if (existingModel == null) {
            Map subProps;
            this.openAPI.getComponents().addSchemas(newRef, schema);
            this.cache.addReferencedKey(newRef);
            String file = $ref.split("#/")[0];
            if (schema.get$ref() != null) {
                RefFormat format = RefUtils.computeRefFormat(schema.get$ref());
                if (RefUtils.isAnExternalRefFormat(format)) {
                    schema.set$ref(this.processRefToExternalSchema(schema.get$ref(), format));
                } else {
                    this.processRefToExternalSchema(file + schema.get$ref(), RefFormat.RELATIVE);
                }
            }
            if ((subProps = schema.getProperties()) != null) {
                for (Map.Entry prop : subProps.entrySet()) {
                    if (((Schema)prop.getValue()).get$ref() != null) {
                        this.processRefProperty((Schema)prop.getValue(), file);
                        continue;
                    }
                    if (prop.getValue() instanceof ArraySchema) {
                        ArraySchema arrayProp = (ArraySchema)prop.getValue();
                        if (arrayProp.getItems().get$ref() == null) continue;
                        this.processRefProperty(arrayProp.getItems(), file);
                        continue;
                    }
                    if (((Schema)prop.getValue()).getAdditionalProperties() == null) continue;
                    Schema mapProp = (Schema)prop.getValue();
                    if (mapProp.getAdditionalProperties().get$ref() != null) {
                        this.processRefProperty(mapProp.getAdditionalProperties(), file);
                        continue;
                    }
                    if (!(mapProp.getAdditionalProperties() instanceof ArraySchema) || ((ArraySchema)mapProp.getAdditionalProperties()).getItems().get$ref() == null) continue;
                    this.processRefProperty(((ArraySchema)mapProp.getAdditionalProperties()).getItems(), file);
                }
            }
            if (schema instanceof ArraySchema && ((ArraySchema)schema).getItems().get$ref() != null) {
                this.processRefProperty(((ArraySchema)schema).getItems(), file);
            }
        }
        return newRef;
    }

    public String processRefToExternalResponse(String $ref, RefFormat refFormat) {
        String possiblyConflictingDefinitionName;
        ApiResponse existingResponse;
        LinkedHashMap responses;
        String renamedRef = this.cache.getRenamedRef($ref);
        if (renamedRef != null) {
            return renamedRef;
        }
        ApiResponse response = this.cache.loadRef($ref, refFormat, ApiResponse.class);
        if (response == null) {
            LOGGER.warn("unable to load model reference from `" + $ref + "`.  It may not be available or the reference isn't a valid model schema");
            return $ref;
        }
        if (this.openAPI.getComponents() == null) {
            this.openAPI.setComponents(new Components());
        }
        if ((responses = this.openAPI.getComponents().getResponses()) == null) {
            responses = new LinkedHashMap();
        }
        if ((existingResponse = (ApiResponse)responses.get(possiblyConflictingDefinitionName = RefUtils.computeDefinitionName($ref, responses.keySet()))) != null) {
            LOGGER.debug("A model for " + existingResponse + " already exists");
            if (existingResponse.get$ref() != null) {
                existingResponse = null;
            }
        }
        String newRef = possiblyConflictingDefinitionName;
        this.cache.putRenamedRef($ref, newRef);
        if (existingResponse == null) {
            this.openAPI.getComponents().addResponses(newRef, response);
            this.cache.addReferencedKey(newRef);
            String file = $ref.split("#/")[0];
            if (response.get$ref() != null) {
                RefFormat format = RefUtils.computeRefFormat(response.get$ref());
                if (RefUtils.isAnExternalRefFormat(format)) {
                    response.set$ref(this.processRefToExternalResponse(response.get$ref(), format));
                } else {
                    this.processRefToExternalResponse(file + response.get$ref(), RefFormat.RELATIVE);
                }
            }
        }
        return newRef;
    }

    public String processRefToExternalRequestBody(String $ref, RefFormat refFormat) {
        String possiblyConflictingDefinitionName;
        RequestBody existingBody;
        LinkedHashMap bodies;
        String renamedRef = this.cache.getRenamedRef($ref);
        if (renamedRef != null) {
            return renamedRef;
        }
        RequestBody body = this.cache.loadRef($ref, refFormat, RequestBody.class);
        if (body == null) {
            LOGGER.warn("unable to load model reference from `" + $ref + "`.  It may not be available or the reference isn't a valid model schema");
            return $ref;
        }
        if (this.openAPI.getComponents() == null) {
            this.openAPI.setComponents(new Components());
        }
        if ((bodies = this.openAPI.getComponents().getRequestBodies()) == null) {
            bodies = new LinkedHashMap();
        }
        if ((existingBody = (RequestBody)bodies.get(possiblyConflictingDefinitionName = RefUtils.computeDefinitionName($ref, bodies.keySet()))) != null) {
            LOGGER.debug("A model for " + existingBody + " already exists");
            if (existingBody.get$ref() != null) {
                existingBody = null;
            }
        }
        String newRef = possiblyConflictingDefinitionName;
        this.cache.putRenamedRef($ref, newRef);
        if (existingBody == null) {
            this.openAPI.getComponents().addRequestBodies(newRef, body);
            this.cache.addReferencedKey(newRef);
            String file = $ref.split("#/")[0];
            if (body.get$ref() != null) {
                RefFormat format = RefUtils.computeRefFormat(body.get$ref());
                if (RefUtils.isAnExternalRefFormat(format)) {
                    body.set$ref(this.processRefToExternalRequestBody(body.get$ref(), format));
                } else {
                    this.processRefToExternalRequestBody(file + body.get$ref(), RefFormat.RELATIVE);
                }
            }
        }
        return newRef;
    }

    public String processRefToExternalHeader(String $ref, RefFormat refFormat) {
        String possiblyConflictingDefinitionName;
        Header existingHeader;
        LinkedHashMap headers;
        String renamedRef = this.cache.getRenamedRef($ref);
        if (renamedRef != null) {
            return renamedRef;
        }
        Header header = this.cache.loadRef($ref, refFormat, Header.class);
        if (header == null) {
            LOGGER.warn("unable to load model reference from `" + $ref + "`.  It may not be available or the reference isn't a valid model schema");
            return $ref;
        }
        if (this.openAPI.getComponents() == null) {
            this.openAPI.setComponents(new Components());
        }
        if ((headers = this.openAPI.getComponents().getHeaders()) == null) {
            headers = new LinkedHashMap();
        }
        if ((existingHeader = (Header)headers.get(possiblyConflictingDefinitionName = RefUtils.computeDefinitionName($ref, headers.keySet()))) != null) {
            LOGGER.debug("A model for " + existingHeader + " already exists");
            if (existingHeader.get$ref() != null) {
                existingHeader = null;
            }
        }
        String newRef = possiblyConflictingDefinitionName;
        this.cache.putRenamedRef($ref, newRef);
        if (existingHeader == null) {
            this.openAPI.getComponents().addHeaders(newRef, header);
            this.cache.addReferencedKey(newRef);
            String file = $ref.split("#/")[0];
            if (header.get$ref() != null) {
                RefFormat format = RefUtils.computeRefFormat(header.get$ref());
                if (RefUtils.isAnExternalRefFormat(format)) {
                    header.set$ref(this.processRefToExternalHeader(header.get$ref(), format));
                } else {
                    this.processRefToExternalHeader(file + header.get$ref(), RefFormat.RELATIVE);
                }
            }
        }
        return newRef;
    }

    public String processRefToExternalSecurityScheme(String $ref, RefFormat refFormat) {
        String possiblyConflictingDefinitionName;
        SecurityScheme existingSecurityScheme;
        LinkedHashMap securitySchemeMap;
        String renamedRef = this.cache.getRenamedRef($ref);
        if (renamedRef != null) {
            return renamedRef;
        }
        SecurityScheme securityScheme = this.cache.loadRef($ref, refFormat, SecurityScheme.class);
        if (securityScheme == null) {
            LOGGER.warn("unable to load model reference from `" + $ref + "`.  It may not be available or the reference isn't a valid model schema");
            return $ref;
        }
        if (this.openAPI.getComponents() == null) {
            this.openAPI.setComponents(new Components());
        }
        if ((securitySchemeMap = this.openAPI.getComponents().getSecuritySchemes()) == null) {
            securitySchemeMap = new LinkedHashMap();
        }
        if ((existingSecurityScheme = (SecurityScheme)securitySchemeMap.get(possiblyConflictingDefinitionName = RefUtils.computeDefinitionName($ref, securitySchemeMap.keySet()))) != null) {
            LOGGER.debug("A model for " + existingSecurityScheme + " already exists");
            if (existingSecurityScheme.get$ref() != null) {
                existingSecurityScheme = null;
            }
        }
        String newRef = possiblyConflictingDefinitionName;
        this.cache.putRenamedRef($ref, newRef);
        if (existingSecurityScheme == null) {
            this.openAPI.getComponents().addSecuritySchemes(newRef, securityScheme);
            this.cache.addReferencedKey(newRef);
            String file = $ref.split("#/")[0];
            if (securityScheme.get$ref() != null) {
                RefFormat format = RefUtils.computeRefFormat(securityScheme.get$ref());
                if (RefUtils.isAnExternalRefFormat(format)) {
                    securityScheme.set$ref(this.processRefToExternalSecurityScheme(securityScheme.get$ref(), format));
                } else {
                    this.processRefToExternalSecurityScheme(file + securityScheme.get$ref(), RefFormat.RELATIVE);
                }
            }
        }
        return newRef;
    }

    public String processRefToExternalLink(String $ref, RefFormat refFormat) {
        String possiblyConflictingDefinitionName;
        Link existingLink;
        LinkedHashMap links;
        String renamedRef = this.cache.getRenamedRef($ref);
        if (renamedRef != null) {
            return renamedRef;
        }
        Link link = this.cache.loadRef($ref, refFormat, Link.class);
        if (link == null) {
            LOGGER.warn("unable to load model reference from `" + $ref + "`.  It may not be available or the reference isn't a valid model schema");
            return $ref;
        }
        if (this.openAPI.getComponents() == null) {
            this.openAPI.setComponents(new Components());
        }
        if ((links = this.openAPI.getComponents().getLinks()) == null) {
            links = new LinkedHashMap();
        }
        if ((existingLink = (Link)links.get(possiblyConflictingDefinitionName = RefUtils.computeDefinitionName($ref, links.keySet()))) != null) {
            LOGGER.debug("A model for " + existingLink + " already exists");
            if (existingLink.get$ref() != null) {
                existingLink = null;
            }
        }
        String newRef = possiblyConflictingDefinitionName;
        this.cache.putRenamedRef($ref, newRef);
        if (existingLink == null) {
            this.openAPI.getComponents().addLinks(newRef, link);
            this.cache.addReferencedKey(newRef);
            String file = $ref.split("#/")[0];
            if (link.get$ref() != null) {
                RefFormat format = RefUtils.computeRefFormat(link.get$ref());
                if (RefUtils.isAnExternalRefFormat(format)) {
                    link.set$ref(this.processRefToExternalLink(link.get$ref(), format));
                } else {
                    this.processRefToExternalLink(file + link.get$ref(), RefFormat.RELATIVE);
                }
            }
        }
        return newRef;
    }

    public String processRefToExternalExample(String $ref, RefFormat refFormat) {
        String possiblyConflictingDefinitionName;
        Example existingExample;
        LinkedHashMap examples;
        String renamedRef = this.cache.getRenamedRef($ref);
        if (renamedRef != null) {
            return renamedRef;
        }
        Example example = this.cache.loadRef($ref, refFormat, Example.class);
        if (example == null) {
            LOGGER.warn("unable to load model reference from `" + $ref + "`.  It may not be available or the reference isn't a valid model schema");
            return $ref;
        }
        if (this.openAPI.getComponents() == null) {
            this.openAPI.setComponents(new Components());
        }
        if ((examples = this.openAPI.getComponents().getExamples()) == null) {
            examples = new LinkedHashMap();
        }
        if ((existingExample = (Example)examples.get(possiblyConflictingDefinitionName = RefUtils.computeDefinitionName($ref, examples.keySet()))) != null) {
            LOGGER.debug("A model for " + existingExample + " already exists");
            if (existingExample.get$ref() != null) {
                existingExample = null;
            }
        }
        String newRef = possiblyConflictingDefinitionName;
        this.cache.putRenamedRef($ref, newRef);
        if (existingExample == null) {
            this.openAPI.getComponents().addExamples(newRef, example);
            this.cache.addReferencedKey(newRef);
            String file = $ref.split("#/")[0];
            if (example.get$ref() != null) {
                RefFormat format = RefUtils.computeRefFormat(example.get$ref());
                if (RefUtils.isAnExternalRefFormat(format)) {
                    example.set$ref(this.processRefToExternalExample(example.get$ref(), format));
                } else {
                    this.processRefToExternalExample(file + example.get$ref(), RefFormat.RELATIVE);
                }
            }
        }
        return newRef;
    }

    public String processRefToExternalParameter(String $ref, RefFormat refFormat) {
        String possiblyConflictingDefinitionName;
        Parameter existingParameters;
        LinkedHashMap parameters;
        String renamedRef = this.cache.getRenamedRef($ref);
        if (renamedRef != null) {
            return renamedRef;
        }
        Parameter parameter = this.cache.loadRef($ref, refFormat, Parameter.class);
        if (parameter == null) {
            LOGGER.warn("unable to load model reference from `" + $ref + "`.  It may not be available or the reference isn't a valid model schema");
            return $ref;
        }
        if (this.openAPI.getComponents() == null) {
            this.openAPI.setComponents(new Components());
        }
        if ((parameters = this.openAPI.getComponents().getParameters()) == null) {
            parameters = new LinkedHashMap();
        }
        if ((existingParameters = (Parameter)parameters.get(possiblyConflictingDefinitionName = RefUtils.computeDefinitionName($ref, parameters.keySet()))) != null) {
            LOGGER.debug("A model for " + existingParameters + " already exists");
            if (existingParameters.get$ref() != null) {
                existingParameters = null;
            }
        }
        String newRef = possiblyConflictingDefinitionName;
        this.cache.putRenamedRef($ref, newRef);
        if (existingParameters == null) {
            this.openAPI.getComponents().addParameters(newRef, parameter);
            this.cache.addReferencedKey(newRef);
            String file = $ref.split("#/")[0];
            if (parameter.get$ref() != null) {
                RefFormat format = RefUtils.computeRefFormat(parameter.get$ref());
                if (RefUtils.isAnExternalRefFormat(format)) {
                    parameter.set$ref(this.processRefToExternalParameter(parameter.get$ref(), format));
                } else {
                    this.processRefToExternalParameter(file + parameter.get$ref(), RefFormat.RELATIVE);
                }
            }
        }
        return newRef;
    }

    public String processRefToExternalCallback(String $ref, RefFormat refFormat) {
        String possiblyConflictingDefinitionName;
        Callback existingCallback;
        LinkedHashMap callbacks;
        String renamedRef = this.cache.getRenamedRef($ref);
        if (renamedRef != null) {
            return renamedRef;
        }
        Callback callback = this.cache.loadRef($ref, refFormat, Callback.class);
        if (callback == null) {
            LOGGER.warn("unable to load model reference from `" + $ref + "`.  It may not be available or the reference isn't a valid model schema");
            return $ref;
        }
        if (this.openAPI.getComponents() == null) {
            this.openAPI.setComponents(new Components());
        }
        if ((callbacks = this.openAPI.getComponents().getCallbacks()) == null) {
            callbacks = new LinkedHashMap();
        }
        if ((existingCallback = (Callback)callbacks.get(possiblyConflictingDefinitionName = RefUtils.computeDefinitionName($ref, callback.keySet()))) != null) {
            LOGGER.debug("A model for " + existingCallback + " already exists");
            if (((PathItem)existingCallback.get((Object)"$ref")).get$ref() != null) {
                existingCallback = null;
            }
        }
        String newRef = possiblyConflictingDefinitionName;
        this.cache.putRenamedRef($ref, newRef);
        if (existingCallback == null) {
            this.openAPI.getComponents().addCallbacks(newRef, callback);
            this.cache.addReferencedKey(newRef);
            String file = $ref.split("#/")[0];
            if (callback.get((Object)"$ref") != null && ((PathItem)callback.get((Object)"$ref")).get$ref() != null) {
                RefFormat format = RefUtils.computeRefFormat(((PathItem)callback.get((Object)"$ref")).get$ref());
                if (RefUtils.isAnExternalRefFormat(format)) {
                    ((PathItem)callback.get((Object)"$ref")).set$ref(this.processRefToExternalCallback(((PathItem)callback.get((Object)"$ref")).get$ref(), format));
                } else {
                    this.processRefToExternalCallback(file + ((PathItem)callback.get((Object)"$ref")).get$ref(), RefFormat.RELATIVE);
                }
            }
        }
        return newRef;
    }

    private void processRefProperty(Schema subRef, String externalFile) {
        RefFormat format = RefUtils.computeRefFormat(subRef.get$ref());
        if (RefUtils.isAnExternalRefFormat(format)) {
            String $ref = this.constructRef(subRef, externalFile);
            subRef.set$ref($ref);
            if ($ref.startsWith(".")) {
                this.processRefToExternalSchema($ref, RefFormat.RELATIVE);
            } else {
                this.processRefToExternalSchema($ref, RefFormat.URL);
            }
        } else {
            this.processRefToExternalSchema(externalFile + subRef.get$ref(), RefFormat.RELATIVE);
        }
    }

    protected String constructRef(Schema refProperty, String rootLocation) {
        String ref = refProperty.get$ref();
        return ExternalRefProcessor.join(rootLocation, ref);
    }

    public static String join(String source, String fragment) {
        try {
            boolean isRelative = false;
            if (source.startsWith("/") || source.startsWith(".")) {
                isRelative = true;
            }
            URI uri = new URI(source);
            if (!source.endsWith("/") && fragment.startsWith("./") && "".equals(uri.getPath())) {
                uri = new URI(source + "/");
            } else if ("".equals(uri.getPath()) && !fragment.startsWith("/")) {
                uri = new URI(source + "/");
            }
            URI f = new URI(fragment);
            URI resolved = uri.resolve(f);
            URI normalized = resolved.normalize();
            if (Character.isAlphabetic(normalized.toString().charAt(0)) && isRelative) {
                return "./" + normalized.toString();
            }
            return normalized.toString();
        }
        catch (Exception e) {
            return source;
        }
    }
}

