/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.v3.templates;

import com.github.jknack.handlebars.io.URLTemplateLoader;
import java.io.File;
import java.io.IOException;
import java.net.URL;

public class CodegenTemplateLoader
extends URLTemplateLoader {
    private String templateDir;
    private String customTemplateDir;

    public CodegenTemplateLoader() {
        this.setSuffix(".mustache");
    }

    public String resolve(String uri) {
        File templateFile;
        if (!uri.endsWith(this.getSuffix())) {
            uri = uri + this.getSuffix();
        }
        if ((templateFile = new File(uri)).exists()) {
            return templateFile.toString();
        }
        templateFile = new File(this.getPrefix() + this.normalize(uri));
        if (templateFile.exists()) {
            return templateFile.toString();
        }
        if (this.customTemplateDir != null && (templateFile = new File(this.customTemplateDir, this.normalize(uri))).exists()) {
            return templateFile.toString();
        }
        if (((Object)((Object)this)).getClass().getResource(this.getPrefix() + this.normalize(uri)) != null) {
            return this.getPrefix() + this.normalize(uri);
        }
        return this.templateDir + this.normalize(uri);
    }

    public URL getResource(String location) throws IOException {
        if (this.customTemplateDir == null) {
            return ((Object)((Object)this)).getClass().getResource(location);
        }
        File file = new File(location);
        if (file.exists()) {
            return file.toURI().toURL();
        }
        return ((Object)((Object)this)).getClass().getResource(location);
    }

    public String getCustomTemplateDir() {
        return this.customTemplateDir;
    }

    public void setCustomTemplateDir(String customTemplateDir) {
        this.customTemplateDir = customTemplateDir;
    }

    public CodegenTemplateLoader customTemplateDir(String customTemplateDir) {
        this.customTemplateDir = customTemplateDir;
        return this;
    }

    public String getTemplateDir() {
        return this.templateDir;
    }

    public void setTemplateDir(String templateDir) {
        this.templateDir = this.getPrefix() + templateDir;
        if (!this.templateDir.endsWith("/")) {
            this.templateDir = this.templateDir + "/";
        }
    }

    public CodegenTemplateLoader templateDir(String templateDir) {
        this.setTemplateDir(templateDir);
        return this;
    }
}

