/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.v3.ignore.rules;

import io.swagger.codegen.v3.ignore.rules.ParserException;
import io.swagger.codegen.v3.ignore.rules.Part;
import java.util.ArrayList;
import java.util.List;

public class IgnoreLineParser {
    static List<Part> parse(String text) throws ParserException {
        ArrayList<Part> parts = new ArrayList<Part>();
        StringBuilder sb = new StringBuilder();
        String current = null;
        String next = null;
        char[] characters = text.toCharArray();
        int totalLength = characters.length;
        for (int i = 0; i < totalLength; ++i) {
            char character = characters[i];
            current = String.valueOf(character);
            String string = next = i < totalLength - 1 ? String.valueOf(characters[i + 1]) : null;
            if (i == 0) {
                if ("#".equals(current)) {
                    parts.add(new Part(Token.COMMENT, text));
                    i = totalLength;
                    continue;
                }
                if ("!".equals(current)) {
                    if (i == totalLength - 1) {
                        throw new ParserException("Negation with no negated pattern.");
                    }
                    parts.add(new Part(Token.NEGATE));
                    continue;
                }
                if ("\\".equals(current) && "#".equals(next)) {
                    current = next;
                    next = null;
                    ++i;
                }
            }
            if (Token.MATCH_ANY.pattern.equals(current)) {
                if (Token.MATCH_ANY.pattern.equals(next)) {
                    if (i + 2 < totalLength - 1 && String.valueOf(characters[i + 2]).equals(Token.MATCH_ANY.pattern)) {
                        throw new ParserException("The pattern *** is invalid.");
                    }
                    parts.add(new Part(Token.MATCH_ALL));
                    ++i;
                    continue;
                }
                if (sb.length() > 0) {
                    parts.add(new Part(Token.TEXT, sb.toString()));
                    sb.delete(0, sb.length());
                }
                parts.add(new Part(Token.MATCH_ANY));
                continue;
            }
            if (i == 0 && Token.ROOTED_MARKER.pattern.equals(current)) {
                parts.add(new Part(Token.ROOTED_MARKER));
                continue;
            }
            if ("\\".equals(current) && " ".equals(next)) {
                parts.add(new Part(Token.ESCAPED_SPACE));
                ++i;
                continue;
            }
            if ("\\".equals(current) && "!".equals(next)) {
                parts.add(new Part(Token.ESCAPED_EXCLAMATION));
                ++i;
                continue;
            }
            if (Token.PATH_DELIM.pattern.equals(current)) {
                if (i != totalLength - 1) {
                    if (sb.length() > 0) {
                        parts.add(new Part(Token.TEXT, sb.toString()));
                        sb.delete(0, sb.length());
                    }
                    parts.add(new Part(Token.PATH_DELIM));
                    if (!Token.PATH_DELIM.pattern.equals(next)) continue;
                    ++i;
                    continue;
                }
                if (i == totalLength - 1) {
                    parts.add(new Part(Token.TEXT, sb.toString()));
                    sb.delete(0, sb.length());
                    parts.add(new Part(Token.DIRECTORY_MARKER));
                    continue;
                }
            }
            sb.append(current);
        }
        if (sb.length() > 0) {
            parts.add(new Part(Token.TEXT, sb.toString().trim()));
        }
        return parts;
    }

    static enum Token {
        MATCH_ALL("**"),
        MATCH_ANY("*"),
        ESCAPED_EXCLAMATION("\\!"),
        ESCAPED_SPACE("\\ "),
        PATH_DELIM("/"),
        NEGATE("!"),
        TEXT(null),
        DIRECTORY_MARKER("/"),
        ROOTED_MARKER("/"),
        COMMENT(null);

        private String pattern;

        private Token(String pattern) {
            this.pattern = pattern;
        }

        public String getPattern() {
            return this.pattern;
        }
    }
}

