/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.v3.generators.dotnet;

import com.google.common.collect.ImmutableMap;
import com.samskivert.mustache.Mustache;
import io.swagger.codegen.v3.CliOption;
import io.swagger.codegen.v3.CodegenConstants;
import io.swagger.codegen.v3.CodegenModel;
import io.swagger.codegen.v3.CodegenOperation;
import io.swagger.codegen.v3.CodegenParameter;
import io.swagger.codegen.v3.CodegenProperty;
import io.swagger.codegen.v3.CodegenType;
import io.swagger.codegen.v3.SupportingFile;
import io.swagger.codegen.v3.VendorExtendable;
import io.swagger.codegen.v3.generators.dotnet.AbstractCSharpCodegen;
import io.swagger.codegen.v3.generators.handlebars.ExtensionHelper;
import io.swagger.v3.oas.models.media.Schema;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSharpClientCodegen
extends AbstractCSharpCodegen {
    private static final Logger LOGGER = LoggerFactory.getLogger(CSharpClientCodegen.class);
    private static final String NET471 = "v4.7.1";
    private static final String NET45 = "v4.5";
    private static final String NET40 = "v4.0";
    private static final String NET35 = "v3.5";
    private static final String NETSTANDARD = "v5.0";
    private static final String UWP = "uwp";
    private static final String MCS_NET_VERSION_KEY = "x-mcs-sdk";
    protected String packageGuid = "{" + UUID.randomUUID().toString().toUpperCase() + "}";
    protected String clientPackage = "IO.Swagger.Client";
    protected String localVariablePrefix = "";
    protected String apiDocPath = "docs/";
    protected String modelDocPath = "docs/";
    protected String targetFramework = "v4.7.1";
    protected String targetFrameworkNuget = "net471";
    protected boolean supportsAsync = Boolean.TRUE;
    protected boolean supportsUWP = Boolean.FALSE;
    protected boolean netStandard = Boolean.FALSE;
    protected boolean generatePropertyChanged = Boolean.FALSE;
    protected boolean validatable = Boolean.TRUE;
    protected Map<Character, String> regexModifiers;
    protected final Map<String, String> frameworks;
    protected boolean nonPublicApi = Boolean.FALSE;

    public CSharpClientCodegen() {
        this.supportsInheritance = true;
        this.modelTemplateFiles.put("model.mustache", ".cs");
        this.apiTemplateFiles.put("api.mustache", ".cs");
        this.modelDocTemplateFiles.put("model_doc.mustache", ".md");
        this.apiDocTemplateFiles.put("api_doc.mustache", ".md");
        this.hideGenerationTimestamp = Boolean.TRUE;
        this.cliOptions.clear();
        this.addOption("packageName", "C# package name (convention: Title.Case).", this.packageName);
        this.addOption("packageVersion", "C# package version.", this.packageVersion);
        this.addOption("sourceFolder", "source folder for generated code", this.sourceFolder);
        this.addOption("packageGuid", "The GUID that will be associated with the C# project", null);
        this.addOption("interfacePrefix", "Prefix interfaces with a community standard or widely accepted prefix.", this.interfacePrefix);
        CliOption framework = new CliOption("targetFramework", "The target .NET framework version.");
        this.frameworks = new ImmutableMap.Builder().put((Object)NET35, (Object)".NET Framework 3.5 compatible").put((Object)NET40, (Object)".NET Framework 4.0 compatible").put((Object)NET45, (Object)".NET Framework 4.5+ compatible").put((Object)NET471, (Object)".NET Framework 4.71+ compatible").put((Object)NETSTANDARD, (Object)".NET Standard 1.3 compatible").put((Object)UWP, (Object)"Universal Windows Platform (IMPORTANT: this will be decommissioned and replaced by v5.0)").build();
        framework.defaultValue(this.targetFramework);
        framework.setEnum(this.frameworks);
        this.cliOptions.add(framework);
        CliOption modelPropertyNaming = new CliOption("modelPropertyNaming", "Naming convention for the property: 'camelCase', 'PascalCase', 'snake_case' and 'original', which keeps the original name");
        this.cliOptions.add(modelPropertyNaming.defaultValue("PascalCase"));
        this.addSwitch("hideGenerationTimestamp", "Hides the generation timestamp when files are generated.", this.hideGenerationTimestamp);
        this.addSwitch("sortParamsByRequiredFlag", "Sort method arguments to place required parameters before optional parameters.", this.sortParamsByRequiredFlag);
        this.addSwitch("useDateTimeOffset", "Use DateTimeOffset to model date-time properties", this.useDateTimeOffsetFlag);
        this.addSwitch("useCollection", "Deserialize array types to Collection<T> instead of List<T>.", this.useCollection);
        this.addSwitch("returnICollection", "Return ICollection<T> instead of the concrete type.", this.returnICollection);
        this.addSwitch("optionalMethodArgument", "C# Optional method argument, e.g. void square(int x=10) (.net 4.0+ only).", this.optionalMethodArgumentFlag);
        this.addSwitch("optionalAssemblyInfo", "Generate AssemblyInfo.cs.", this.optionalAssemblyInfoFlag);
        this.addSwitch("optionalProjectFile", "Generate {PackageName}.csproj.", this.optionalProjectFileFlag);
        this.addSwitch("optionalEmitDefaultValues", "Set DataMember's EmitDefaultValue.", this.optionalEmitDefaultValue);
        this.addSwitch("generatePropertyChanged", "Specifies a AssemblyDescription for the .NET Framework global assembly attributes stored in the AssemblyInfo file.", this.generatePropertyChanged);
        this.addSwitch("nonPublicApi", "Generates code with reduced access modifiers; allows embedding elsewhere without exposing non-public API calls to consumers.", this.nonPublicApi);
        this.addSwitch("allowUnicodeIdentifiers", "boolean, toggles whether unicode identifiers are allowed in names or not, default is false", this.allowUnicodeIdentifiers);
        this.addSwitch("netCoreProjectFile", "Use the new format (.NET Core) for .NET project files (.csproj).", this.netCoreProjectFileFlag);
        this.addSwitch("validatable", "Generates self-validatable models.", this.validatable);
        this.regexModifiers = new HashMap<Character, String>();
        this.regexModifiers.put(Character.valueOf('i'), "IgnoreCase");
        this.regexModifiers.put(Character.valueOf('m'), "Multiline");
        this.regexModifiers.put(Character.valueOf('s'), "Singleline");
        this.regexModifiers.put(Character.valueOf('x'), "IgnorePatternWhitespace");
    }

    @Override
    public void processOpts() {
        if (this.additionalProperties.containsKey("targetFramework")) {
            this.setTargetFramework((String)this.additionalProperties.get("targetFramework"));
        } else {
            this.setTargetFramework(NET471);
            this.additionalProperties.put("targetFramework", this.targetFramework);
        }
        super.processOpts();
        if (this.additionalProperties.containsKey("modelPropertyNaming")) {
            this.setModelPropertyNaming((String)this.additionalProperties.get("modelPropertyNaming"));
        }
        if (StringUtils.isEmpty((CharSequence)this.apiPackage)) {
            this.setApiPackage("Api");
        }
        if (StringUtils.isEmpty((CharSequence)this.modelPackage)) {
            this.setModelPackage("Model");
        }
        this.clientPackage = "Client";
        Boolean excludeTests = false;
        if (this.additionalProperties.containsKey("excludeTests")) {
            excludeTests = this.convertPropertyToBooleanAndWriteBack("excludeTests");
        }
        if (this.additionalProperties.containsKey("validatable")) {
            this.setValidatable(this.convertPropertyToBooleanAndWriteBack("validatable"));
        } else {
            this.additionalProperties.put("validatable", this.validatable);
        }
        if (NET35.equals(this.targetFramework)) {
            this.additionalProperties.put(MCS_NET_VERSION_KEY, "4");
            this.additionalProperties.put("net35", true);
            if (this.additionalProperties.containsKey("supportsAsync")) {
                LOGGER.warn(".NET 3.5 generator does not support async.");
                this.additionalProperties.remove("supportsAsync");
            }
            this.setTargetFrameworkNuget("net35");
            this.setValidatable(Boolean.FALSE);
            this.setSupportsAsync(Boolean.FALSE);
        } else if (NETSTANDARD.equals(this.targetFramework)) {
            this.additionalProperties.put(MCS_NET_VERSION_KEY, "4.6-api");
            if (this.additionalProperties.containsKey("supportsUWP")) {
                LOGGER.warn(".NET v5.0 generator does not support UWP.");
                this.additionalProperties.remove("supportsUWP");
            }
            this.setTargetFrameworkNuget("netstandard1.3");
            this.setSupportsAsync(Boolean.TRUE);
            this.setSupportsUWP(Boolean.FALSE);
            this.setNetStandard(Boolean.TRUE);
            excludeTests = true;
        } else if (UWP.equals(this.targetFramework)) {
            this.setTargetFrameworkNuget(UWP);
            this.setSupportsAsync(Boolean.TRUE);
            this.setSupportsUWP(Boolean.TRUE);
        } else if (NET40.equals(this.targetFramework)) {
            this.additionalProperties.put(MCS_NET_VERSION_KEY, "4");
            this.additionalProperties.put("isNet40", true);
            if (this.additionalProperties.containsKey("supportsAsync")) {
                LOGGER.warn(".NET v4.0 generator does not support async.");
                this.additionalProperties.remove("supportsAsync");
            }
            this.setTargetFrameworkNuget("net40");
            this.setSupportsAsync(Boolean.FALSE);
        } else if (NET45.equals(this.targetFramework)) {
            this.additionalProperties.put(MCS_NET_VERSION_KEY, "4.5.2-api");
            this.setTargetFrameworkNuget("net45");
            this.setSupportsAsync(Boolean.TRUE);
        } else {
            this.additionalProperties.put(MCS_NET_VERSION_KEY, "4.7.1-api");
            this.setTargetFrameworkNuget("net471");
            this.setSupportsAsync(Boolean.TRUE);
        }
        if (this.additionalProperties.containsKey("generatePropertyChanged")) {
            if (NET35.equals(this.targetFramework)) {
                LOGGER.warn("generatePropertyChanged is only supported by generated code for .NET 4+.");
                this.additionalProperties.remove("generatePropertyChanged");
            } else if (NETSTANDARD.equals(this.targetFramework)) {
                LOGGER.warn("generatePropertyChanged is not supported in .NET Standard generated code.");
                this.additionalProperties.remove("generatePropertyChanged");
            } else if (Boolean.TRUE.equals(this.netCoreProjectFileFlag)) {
                LOGGER.warn("generatePropertyChanged is not supported in .NET Core csproj project format.");
                this.additionalProperties.remove("generatePropertyChanged");
            } else {
                this.setGeneratePropertyChanged(this.convertPropertyToBooleanAndWriteBack("generatePropertyChanged"));
            }
        }
        this.additionalProperties.put("apiPackage", this.apiPackage);
        this.additionalProperties.put("modelPackage", this.modelPackage);
        this.additionalProperties.put("clientPackage", this.clientPackage);
        this.additionalProperties.put("excludeTests", excludeTests);
        this.additionalProperties.put("validatable", this.validatable);
        this.additionalProperties.put("supportsAsync", this.supportsAsync);
        this.additionalProperties.put("supportsUWP", this.supportsUWP);
        this.additionalProperties.put("netStandard", this.netStandard);
        this.additionalProperties.put("targetFrameworkNuget", this.targetFrameworkNuget);
        this.additionalProperties.put("emitDefaultValue", this.optionalEmitDefaultValue);
        if (this.additionalProperties.containsKey("optionalProjectFile")) {
            this.setOptionalProjectFileFlag(this.convertPropertyToBooleanAndWriteBack("optionalProjectFile"));
        } else {
            this.additionalProperties.put("optionalProjectFile", this.optionalProjectFileFlag);
        }
        if (this.additionalProperties.containsKey("packageGuid")) {
            this.setPackageGuid((String)this.additionalProperties.get("packageGuid"));
        } else {
            this.additionalProperties.put("packageGuid", this.packageGuid);
        }
        if (this.additionalProperties.containsKey("optionalMethodArgument")) {
            this.setOptionalMethodArgumentFlag(this.convertPropertyToBooleanAndWriteBack("optionalMethodArgument"));
        } else {
            this.additionalProperties.put("optionalMethodArgument", this.optionalMethodArgumentFlag);
        }
        if (this.additionalProperties.containsKey("optionalAssemblyInfo")) {
            this.setOptionalAssemblyInfoFlag(this.convertPropertyToBooleanAndWriteBack("optionalAssemblyInfo"));
        } else {
            this.additionalProperties.put("optionalAssemblyInfo", this.optionalAssemblyInfoFlag);
        }
        if (this.additionalProperties.containsKey("nonPublicApi")) {
            this.setNonPublicApi(this.convertPropertyToBooleanAndWriteBack("nonPublicApi"));
        } else {
            this.additionalProperties.put("nonPublicApi", this.isNonPublicApi());
        }
        String testPackageName = this.testPackageName();
        String packageFolder = this.sourceFolder + File.separator + this.packageName;
        String clientPackageDir = packageFolder + File.separator + this.clientPackage;
        String testPackageFolder = this.testFolder + File.separator + testPackageName;
        this.additionalProperties.put("testPackageName", testPackageName);
        int packageDepth = packageFolder.length() - packageFolder.replace(File.separator, "").length();
        String binRelativePath = "..\\";
        for (int i = 0; i < packageDepth; ++i) {
            binRelativePath = binRelativePath + "..\\";
        }
        binRelativePath = binRelativePath + "vendor";
        this.additionalProperties.put("binRelativePath", binRelativePath);
        this.supportingFiles.add(new SupportingFile("IApiAccessor.mustache", clientPackageDir, "IApiAccessor.cs"));
        this.supportingFiles.add(new SupportingFile("Configuration.mustache", clientPackageDir, "Configuration.cs"));
        this.supportingFiles.add(new SupportingFile("ApiClient.mustache", clientPackageDir, "ApiClient.cs"));
        this.supportingFiles.add(new SupportingFile("ApiException.mustache", clientPackageDir, "ApiException.cs"));
        this.supportingFiles.add(new SupportingFile("ApiResponse.mustache", clientPackageDir, "ApiResponse.cs"));
        this.supportingFiles.add(new SupportingFile("ExceptionFactory.mustache", clientPackageDir, "ExceptionFactory.cs"));
        this.supportingFiles.add(new SupportingFile("SwaggerDateConverter.mustache", clientPackageDir, "SwaggerDateConverter.cs"));
        if (NET40.equals(this.targetFramework)) {
            this.supportingFiles.add(new SupportingFile("ReadOnlyDictionary.mustache", clientPackageDir, "ReadOnlyDictionary.cs"));
        }
        if (Boolean.FALSE.equals(this.netStandard) && Boolean.FALSE.equals(this.netCoreProjectFileFlag) && !NET471.equals(this.targetFramework)) {
            this.supportingFiles.add(new SupportingFile("compile.mustache", "", "build.bat"));
            this.supportingFiles.add(new SupportingFile("compile-mono.sh.mustache", "", "build.sh"));
            if (!NET471.equals(this.targetFramework)) {
                this.supportingFiles.add(new SupportingFile("packages.config.mustache", packageFolder + File.separator, "packages.config"));
            }
            this.supportingFiles.add(new SupportingFile("travis.mustache", "", ".travis.yml"));
        } else if (Boolean.FALSE.equals(this.netCoreProjectFileFlag) && !NET471.equals(this.targetFramework)) {
            this.supportingFiles.add(new SupportingFile("project.json.mustache", packageFolder + File.separator, "project.json"));
        }
        this.supportingFiles.add(new SupportingFile("IReadableConfiguration.mustache", clientPackageDir, "IReadableConfiguration.cs"));
        this.supportingFiles.add(new SupportingFile("GlobalConfiguration.mustache", clientPackageDir, "GlobalConfiguration.cs"));
        if (Boolean.FALSE.equals(excludeTests)) {
            this.supportingFiles.add(new SupportingFile("mono_nunit_test.mustache", "", "mono_nunit_test.sh"));
            this.modelTestTemplateFiles.put("model_test.mustache", ".cs");
            this.apiTestTemplateFiles.put("api_test.mustache", ".cs");
            if (Boolean.FALSE.equals(this.netCoreProjectFileFlag)) {
                this.supportingFiles.add(new SupportingFile("packages_test.config.mustache", testPackageFolder + File.separator, "packages.config"));
            }
            if (NET40.equals(this.targetFramework)) {
                this.supportingFiles.add(new SupportingFile("JsonSubTypesTests.mustache", testPackageFolder + File.separator + "Client", "JsonSubTypesTests.cs"));
            }
        }
        if (Boolean.TRUE.equals(this.generatePropertyChanged)) {
            this.supportingFiles.add(new SupportingFile("FodyWeavers.xml", packageFolder, "FodyWeavers.xml"));
        }
        this.supportingFiles.add(new SupportingFile("README.mustache", "", "README.md"));
        this.supportingFiles.add(new SupportingFile("git_push.sh.mustache", "", "git_push.sh"));
        this.supportingFiles.add(new SupportingFile("gitignore.mustache", "", ".gitignore"));
        if (this.optionalAssemblyInfoFlag && Boolean.FALSE.equals(this.netCoreProjectFileFlag) && !NET471.equals(this.targetFramework)) {
            this.supportingFiles.add(new SupportingFile("AssemblyInfo.mustache", packageFolder + File.separator + "Properties", "AssemblyInfo.cs"));
        }
        if (this.optionalProjectFileFlag) {
            this.supportingFiles.add(new SupportingFile("Solution.mustache", "", this.packageName + ".sln"));
            if (Boolean.TRUE.equals(this.netCoreProjectFileFlag)) {
                this.supportingFiles.add(new SupportingFile("netcore_project.mustache", packageFolder, this.packageName + ".csproj"));
            } else {
                this.supportingFiles.add(new SupportingFile("Project.mustache", packageFolder, this.packageName + ".csproj"));
                if (Boolean.FALSE.equals(this.netStandard)) {
                    this.supportingFiles.add(new SupportingFile("nuspec.mustache", packageFolder, this.packageName + ".nuspec"));
                }
            }
            if (Boolean.FALSE.equals(excludeTests)) {
                if (Boolean.TRUE.equals(this.netCoreProjectFileFlag)) {
                    this.supportingFiles.add(new SupportingFile("netcore_testproject.mustache", testPackageFolder, testPackageName + ".csproj"));
                } else {
                    this.supportingFiles.add(new SupportingFile("TestProject.mustache", testPackageFolder, testPackageName + ".csproj"));
                }
            }
        }
        this.additionalProperties.put("apiDocPath", this.apiDocPath);
        this.additionalProperties.put("modelDocPath", this.modelDocPath);
    }

    public void setModelPropertyNaming(String naming) {
        if (!("original".equals(naming) || "camelCase".equals(naming) || "PascalCase".equals(naming) || "snake_case".equals(naming))) {
            throw new IllegalArgumentException("Invalid model property naming '" + naming + "'. Must be 'original', 'camelCase', 'PascalCase' or 'snake_case'");
        }
        this.modelPropertyNaming = naming;
    }

    public String getModelPropertyNaming() {
        return this.modelPropertyNaming;
    }

    @Override
    public Map<String, Object> postProcessOperations(Map<String, Object> objs) {
        Map operations;
        super.postProcessOperations(objs);
        if (objs != null && (operations = (Map)objs.get("operations")) != null) {
            List ops = (List)operations.get("operation");
            for (CodegenOperation operation : ops) {
                int genericStart;
                if (operation.returnType == null) continue;
                operation.returnContainer = operation.returnType;
                if (!this.returnICollection || !operation.returnType.startsWith("List") && !operation.returnType.startsWith("Collection") || (genericStart = operation.returnType.indexOf("<")) <= 0) continue;
                operation.returnType = "ICollection" + operation.returnType.substring(genericStart);
            }
        }
        return objs;
    }

    public CodegenType getTag() {
        return CodegenType.CLIENT;
    }

    public String getName() {
        return "csharp";
    }

    @Override
    public String getDefaultTemplateDir() {
        if (NET471.equals(this.targetFramework)) {
            return "csharp-471";
        }
        return "csharp";
    }

    public String getHelp() {
        return "Generates a CSharp client library.";
    }

    public void setOptionalAssemblyInfoFlag(boolean flag) {
        this.optionalAssemblyInfoFlag = flag;
    }

    @Override
    public CodegenModel fromModel(String name, Schema schema, Map<String, Schema> allDefinitions) {
        Schema parentModel;
        CodegenModel codegenModel = super.fromModel(name, schema, allDefinitions);
        if (allDefinitions != null && codegenModel != null && codegenModel.parent != null && (parentModel = allDefinitions.get(this.toModelName(codegenModel.parent))) != null) {
            CodegenModel parentCodegenModel = super.fromModel(codegenModel.parent, parentModel, allDefinitions);
            boolean hasEnums = ExtensionHelper.getBooleanValue((VendorExtendable)codegenModel, "x-has-enums");
            if (hasEnums) {
                codegenModel = this.reconcileInlineEnums(codegenModel, parentCodegenModel);
            }
            HashMap<String, CodegenProperty> propertyHash = new HashMap<String, CodegenProperty>(codegenModel.vars.size());
            for (CodegenProperty property : codegenModel.vars) {
                propertyHash.put(property.name, property);
            }
            for (CodegenProperty property : codegenModel.readWriteVars) {
                if (property.defaultValue != null || !property.baseName.equals(parentCodegenModel.discriminator)) continue;
                property.defaultValue = "\"" + name + "\"";
            }
            CodegenProperty last = null;
            for (CodegenProperty property : parentCodegenModel.vars) {
                if (propertyHash.containsKey(property.name)) continue;
                CodegenProperty parentVar = property.clone();
                parentVar.getVendorExtensions().put("x-is-inherited", Boolean.TRUE);
                parentVar.getVendorExtensions().put("x-has-more", Boolean.TRUE);
                last = parentVar;
                LOGGER.info("adding parent variable {}", (Object)property.name);
                codegenModel.parentVars.add(parentVar);
            }
            if (last != null) {
                last.getVendorExtensions().put("x-has-more", Boolean.FALSE);
            }
        }
        if (codegenModel != null && codegenModel.readWriteVars != null && codegenModel.readWriteVars.size() > 1) {
            int length;
            for (int i = length = codegenModel.readWriteVars.size() - 1; i > length / 2; --i) {
                CodegenProperty codegenProperty = (CodegenProperty)codegenModel.readWriteVars.get(i);
                if (codegenModel.readWriteVars.indexOf(codegenProperty) >= i) continue;
                codegenModel.readWriteVars.remove(i);
            }
        }
        return codegenModel;
    }

    public void setOptionalProjectFileFlag(boolean flag) {
        this.optionalProjectFileFlag = flag;
    }

    public void setPackageGuid(String packageGuid) {
        this.packageGuid = packageGuid;
    }

    @Override
    public void postProcessParameter(CodegenParameter parameter) {
        this.postProcessPattern(parameter.pattern, parameter.vendorExtensions);
        super.postProcessParameter(parameter);
    }

    @Override
    public void postProcessModelProperty(CodegenModel model, CodegenProperty property) {
        this.postProcessPattern(property.pattern, property.vendorExtensions);
        super.postProcessModelProperty(model, property);
    }

    @Override
    protected void fixUpParentAndInterfaces(CodegenModel codegenModel, Map<String, CodegenModel> allModels) {
        super.fixUpParentAndInterfaces(codegenModel, allModels);
        CodegenModel parentModel = codegenModel.getParentModel();
        if (parentModel == null || codegenModel.getReadWriteVars() == null || codegenModel.getReadWriteVars().isEmpty() || parentModel.getVars() == null || parentModel.getVars().isEmpty()) {
            return;
        }
        codegenModel.setParentVars(parentModel.getVars());
        parentModel.getVars().forEach(parentProperty -> codegenModel.getReadWriteVars().stream().filter(codegenProperty -> parentProperty.getName().equalsIgnoreCase(codegenProperty.getName())).findFirst().ifPresent(codegenProperty -> {
            codegenProperty.setDatatype(parentProperty.getDatatype());
            codegenProperty.setDatatypeWithEnum(parentProperty.getDatatypeWithEnum());
        }));
    }

    public void postProcessPattern(String pattern, Map<String, Object> vendorExtensions) {
        if (pattern != null) {
            int i = pattern.lastIndexOf(47);
            if (pattern.charAt(0) != '/' || i < 2) {
                pattern = String.format("/%s/", pattern);
                i = pattern.lastIndexOf(47);
            }
            String regex = pattern.substring(1, i).replace("'", "'");
            ArrayList<String> modifiers = new ArrayList<String>();
            modifiers.add("CultureInvariant");
            for (char c : pattern.substring(i).toCharArray()) {
                if (this.regexModifiers.containsKey(Character.valueOf(c))) {
                    String modifier = this.regexModifiers.get(Character.valueOf(c));
                    modifiers.add(modifier);
                    continue;
                }
                if (c != 'l') continue;
                modifiers.remove("CultureInvariant");
            }
            vendorExtensions.put("x-regex", regex);
            vendorExtensions.put("x-modifiers", modifiers);
        }
    }

    public void setTargetFramework(String dotnetFramework) {
        if (!this.frameworks.containsKey(dotnetFramework)) {
            LOGGER.warn("Invalid .NET framework version, defaulting to " + this.targetFramework);
        } else {
            this.targetFramework = dotnetFramework;
        }
        LOGGER.info("Generating code for .NET Framework " + this.targetFramework);
    }

    private CodegenModel reconcileInlineEnums(CodegenModel codegenModel, CodegenModel parentCodegenModel) {
        boolean hasEnums = ExtensionHelper.getBooleanValue((VendorExtendable)parentCodegenModel, "x-has-enums");
        if (hasEnums) {
            List parentModelCodegenProperties = parentCodegenModel.vars;
            List codegenProperties = codegenModel.vars;
            boolean removedChildEnum = false;
            for (CodegenProperty parentModelCodegenPropery : parentModelCodegenProperties) {
                boolean isEnum = ExtensionHelper.getBooleanValue((VendorExtendable)parentModelCodegenPropery, "x-is-enum");
                if (!isEnum) continue;
                Iterator iterator = codegenProperties.iterator();
                while (iterator.hasNext()) {
                    CodegenProperty codegenProperty = (CodegenProperty)iterator.next();
                    isEnum = ExtensionHelper.getBooleanValue((VendorExtendable)codegenProperty, "x-is-enum");
                    if (!isEnum || !codegenProperty.equals((Object)parentModelCodegenPropery)) continue;
                    iterator.remove();
                    removedChildEnum = true;
                }
            }
            if (removedChildEnum) {
                int count = 0;
                int numVars = codegenProperties.size();
                for (CodegenProperty codegenProperty : codegenProperties) {
                    codegenProperty.getVendorExtensions().put("x-has-more", ++count < numVars);
                }
                codegenModel.vars = codegenProperties;
            }
        }
        return codegenModel;
    }

    @Override
    public String toEnumVarName(String value, String datatype) {
        if (value.length() == 0) {
            return "Empty";
        }
        if (this.getSymbolName(value) != null) {
            return CSharpClientCodegen.camelize(this.getSymbolName(value));
        }
        if (datatype.startsWith("int") || datatype.startsWith("long") || datatype.startsWith("double") || datatype.startsWith("float")) {
            String varName = "NUMBER_" + value;
            varName = varName.replaceAll("-", "MINUS_");
            varName = varName.replaceAll("\\+", "PLUS_");
            varName = varName.replaceAll("\\.", "_DOT_");
            return varName;
        }
        String var = value.replaceAll("_", " ");
        var = CSharpClientCodegen.camelize(var);
        if ((var = var.replaceAll("\\W+", "")).matches("\\d.*")) {
            return "_" + var;
        }
        return var;
    }

    @Override
    public String toVarName(String name) {
        if ((name = this.sanitizeName(name)).matches("^[A-Z_]*$")) {
            return name;
        }
        if (this.isReservedWord(name = this.getNameUsingModelPropertyNaming(name)) || name.matches("^\\d.*")) {
            name = this.escapeReservedWord(name);
        }
        return name;
    }

    public String getNameUsingModelPropertyNaming(String name) {
        switch (CodegenConstants.MODEL_PROPERTY_NAMING_TYPE.valueOf((String)this.getModelPropertyNaming())) {
            case original: {
                return name;
            }
            case camelCase: {
                return CSharpClientCodegen.camelize(name, true);
            }
            case PascalCase: {
                return CSharpClientCodegen.camelize(name);
            }
            case snake_case: {
                return CSharpClientCodegen.underscore(name);
            }
        }
        throw new IllegalArgumentException("Invalid model property naming '" + name + "'. Must be 'original', 'camelCase', 'PascalCase' or 'snake_case'");
    }

    @Override
    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    @Override
    public void setPackageVersion(String packageVersion) {
        this.packageVersion = packageVersion;
    }

    public void setTargetFrameworkNuget(String targetFrameworkNuget) {
        this.targetFrameworkNuget = targetFrameworkNuget;
    }

    public void setSupportsAsync(Boolean supportsAsync) {
        this.supportsAsync = supportsAsync;
    }

    public void setSupportsUWP(Boolean supportsUWP) {
        this.supportsUWP = supportsUWP;
    }

    public void setNetStandard(Boolean netStandard) {
        this.netStandard = netStandard;
    }

    public void setGeneratePropertyChanged(Boolean generatePropertyChanged) {
        this.generatePropertyChanged = generatePropertyChanged;
    }

    public boolean isNonPublicApi() {
        return this.nonPublicApi;
    }

    public void setNonPublicApi(boolean nonPublicApi) {
        this.nonPublicApi = nonPublicApi;
    }

    public void setValidatable(boolean validatable) {
        this.validatable = validatable;
    }

    @Override
    public String toModelDocFilename(String name) {
        return this.toModelFilename(name);
    }

    @Override
    public String apiDocFileFolder() {
        return (this.outputFolder + "/" + this.apiDocPath).replace('/', File.separatorChar);
    }

    @Override
    public String modelDocFileFolder() {
        return (this.outputFolder + "/" + this.modelDocPath).replace('/', File.separatorChar);
    }

    @Override
    public String apiTestFileFolder() {
        return this.outputFolder + File.separator + this.testFolder + File.separator + this.testPackageName() + File.separator + this.apiPackage();
    }

    @Override
    public String modelTestFileFolder() {
        return this.outputFolder + File.separator + this.testFolder + File.separator + this.testPackageName() + File.separator + this.modelPackage();
    }

    @Override
    public Mustache.Compiler processCompiler(Mustache.Compiler compiler) {
        return super.processCompiler(compiler).emptyStringIsFalse(true);
    }
}

