/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.v3.generators.dotnet;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.samskivert.mustache.Mustache;
import io.swagger.codegen.v3.CodegenOperation;
import io.swagger.codegen.v3.CodegenType;
import io.swagger.codegen.v3.SupportingFile;
import io.swagger.codegen.v3.generators.dotnet.AbstractCSharpCodegen;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.oas.models.OpenAPI;
import java.io.File;
import java.util.Arrays;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AspNetCoreServerCodegen
extends AbstractCSharpCodegen {
    private String packageGuid = "{" + UUID.randomUUID().toString().toUpperCase() + "}";
    protected Logger LOGGER = LoggerFactory.getLogger(AspNetCoreServerCodegen.class);

    public AspNetCoreServerCodegen() {
        this.setSourceFolder("src");
        this.outputFolder = "generated-code" + File.separator + this.getName();
        this.modelTemplateFiles.put("model.mustache", ".cs");
        this.apiTemplateFiles.put("controller.mustache", ".cs");
        this.reservedWords.addAll(Arrays.asList("var", "async", "await", "dynamic", "yield"));
        this.cliOptions.clear();
        this.addOption("packageName", "C# package name (convention: Title.Case).", this.packageName);
        this.addOption("packageVersion", "C# package version.", this.packageVersion);
        this.addOption("packageGuid", "The GUID that will be associated with the C# project", null);
        this.addOption("sourceFolder", "source folder for generated code", this.sourceFolder);
        this.addOption("preserveNewlinesInComments", "Preserve newlines in comments", String.valueOf(this.preserveNewLines));
        this.addSwitch("sortParamsByRequiredFlag", "Sort method arguments to place required parameters before optional parameters.", this.sortParamsByRequiredFlag);
        this.addSwitch("useDateTimeOffset", "Use DateTimeOffset to model date-time properties", this.useDateTimeOffsetFlag);
        this.addSwitch("useCollection", "Deserialize array types to Collection<T> instead of List<T>.", this.useCollection);
        this.addSwitch("returnICollection", "Return ICollection<T> instead of the concrete type.", this.returnICollection);
    }

    public CodegenType getTag() {
        return CodegenType.SERVER;
    }

    public String getName() {
        return "aspnetcore";
    }

    public String getHelp() {
        return "Generates an ASP.NET Core Web API server.";
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (this.additionalProperties.containsKey("packageGuid")) {
            this.setPackageGuid((String)this.additionalProperties.get("packageGuid"));
        }
        this.additionalProperties.put("packageGuid", this.packageGuid);
        this.additionalProperties.put("dockerTag", this.packageName.toLowerCase());
        this.apiPackage = this.packageName + ".Controllers";
        this.modelPackage = this.packageName + ".Models";
        String packageFolder = this.sourceFolder + File.separator + this.packageName;
        this.supportingFiles.add(new SupportingFile("NuGet.Config", "", "NuGet.Config"));
        this.supportingFiles.add(new SupportingFile("build.sh.mustache", "", "build.sh"));
        this.supportingFiles.add(new SupportingFile("build.bat.mustache", "", "build.bat"));
        this.supportingFiles.add(new SupportingFile("README.mustache", "", "README.md"));
        this.supportingFiles.add(new SupportingFile("Solution.mustache", "", this.packageName + ".sln"));
        this.supportingFiles.add(new SupportingFile("Dockerfile.mustache", packageFolder, "Dockerfile"));
        this.supportingFiles.add(new SupportingFile("gitignore", packageFolder, ".gitignore"));
        this.supportingFiles.add(new SupportingFile("appsettings.json", packageFolder, "appsettings.json"));
        this.supportingFiles.add(new SupportingFile("Startup.mustache", packageFolder, "Startup.cs"));
        this.supportingFiles.add(new SupportingFile("Program.mustache", packageFolder, "Program.cs"));
        this.supportingFiles.add(new SupportingFile("validateModel.mustache", packageFolder + File.separator + "Attributes", "ValidateModelStateAttribute.cs"));
        this.supportingFiles.add(new SupportingFile("web.config", packageFolder, "web.config"));
        this.supportingFiles.add(new SupportingFile("Project.csproj.mustache", packageFolder, this.packageName + ".csproj"));
        this.supportingFiles.add(new SupportingFile("Properties" + File.separator + "launchSettings.json", packageFolder + File.separator + "Properties", "launchSettings.json"));
        this.supportingFiles.add(new SupportingFile("Filters" + File.separator + "BasePathFilter.mustache", packageFolder + File.separator + "Filters", "BasePathFilter.cs"));
        this.supportingFiles.add(new SupportingFile("Filters" + File.separator + "GeneratePathParamsValidationFilter.mustache", packageFolder + File.separator + "Filters", "GeneratePathParamsValidationFilter.cs"));
        this.supportingFiles.add(new SupportingFile("wwwroot" + File.separator + "README.md", packageFolder + File.separator + "wwwroot", "README.md"));
        this.supportingFiles.add(new SupportingFile("wwwroot" + File.separator + "index.html", packageFolder + File.separator + "wwwroot", "index.html"));
        this.supportingFiles.add(new SupportingFile("wwwroot" + File.separator + "web.config", packageFolder + File.separator + "wwwroot", "web.config"));
        this.supportingFiles.add(new SupportingFile("wwwroot" + File.separator + "swagger-original.mustache", packageFolder + File.separator + "wwwroot", "swagger-original.json"));
    }

    @Override
    public void setSourceFolder(String sourceFolder) {
        if (sourceFolder == null) {
            this.LOGGER.warn("No sourceFolder specified, using default");
            this.sourceFolder = "src" + File.separator + this.packageName;
        } else if (!sourceFolder.equals("src") && !sourceFolder.startsWith("src")) {
            this.LOGGER.warn("ASP.NET Core requires source code exists under src. Adjusting.");
            this.sourceFolder = "src" + File.separator + sourceFolder;
        } else {
            this.sourceFolder = sourceFolder;
        }
    }

    public void setPackageGuid(String packageGuid) {
        this.packageGuid = packageGuid;
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + File.separator + this.sourceFolder + File.separator + this.packageName + File.separator + "Controllers";
    }

    @Override
    public String modelFileFolder() {
        return this.outputFolder + File.separator + this.sourceFolder + File.separator + this.packageName + File.separator + "Models";
    }

    @Override
    public Map<String, Object> postProcessSupportingFileData(Map<String, Object> objs) {
        OpenAPI openAPI = (OpenAPI)objs.get("openAPI");
        if (openAPI != null) {
            try {
                objs.put("swagger-json", Json.pretty().writeValueAsString((Object)openAPI).replace("\r\n", "\n"));
            }
            catch (JsonProcessingException e) {
                this.LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
        return super.postProcessSupportingFileData(objs);
    }

    @Override
    protected void processOperation(CodegenOperation operation) {
        super.processOperation(operation);
        if (operation.path != null) {
            String original = operation.path;
            operation.path = operation.path.replace("?", "/");
            if (!original.equals(operation.path)) {
                this.LOGGER.warn("Normalized " + original + " to " + operation.path + ". Please verify generated source.");
            }
        }
        operation.httpMethod = "Http" + operation.httpMethod.substring(0, 1) + operation.httpMethod.substring(1).toLowerCase();
    }

    @Override
    public Mustache.Compiler processCompiler(Mustache.Compiler compiler) {
        return super.processCompiler(compiler).emptyStringIsFalse(true);
    }
}

