/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.v3.generators.java;

import com.samskivert.mustache.Mustache;
import com.samskivert.mustache.Template;
import io.swagger.codegen.v3.CliOption;
import io.swagger.codegen.v3.CodegenContent;
import io.swagger.codegen.v3.CodegenModel;
import io.swagger.codegen.v3.CodegenOperation;
import io.swagger.codegen.v3.CodegenParameter;
import io.swagger.codegen.v3.CodegenProperty;
import io.swagger.codegen.v3.CodegenResponse;
import io.swagger.codegen.v3.CodegenSecurity;
import io.swagger.codegen.v3.CodegenType;
import io.swagger.codegen.v3.SupportingFile;
import io.swagger.codegen.v3.VendorExtendable;
import io.swagger.codegen.v3.generators.features.BeanValidationFeatures;
import io.swagger.codegen.v3.generators.features.NotNullAnnotationFeatures;
import io.swagger.codegen.v3.generators.features.OptionalFeatures;
import io.swagger.codegen.v3.generators.handlebars.ExtensionHelper;
import io.swagger.codegen.v3.generators.java.AbstractJavaCodegen;
import io.swagger.codegen.v3.generators.util.OpenAPIUtil;
import io.swagger.codegen.v3.utils.URLPathUtil;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpringCodegen
extends AbstractJavaCodegen
implements BeanValidationFeatures,
OptionalFeatures,
NotNullAnnotationFeatures {
    static Logger LOGGER = LoggerFactory.getLogger(SpringCodegen.class);
    public static final String DEFAULT_LIBRARY = "spring-boot";
    public static final String TITLE = "title";
    public static final String CONFIG_PACKAGE = "configPackage";
    public static final String BASE_PACKAGE = "basePackage";
    public static final String INTERFACE_ONLY = "interfaceOnly";
    public static final String DELEGATE_PATTERN = "delegatePattern";
    public static final String SINGLE_CONTENT_TYPES = "singleContentTypes";
    public static final String ASYNC = "async";
    public static final String RESPONSE_WRAPPER = "responseWrapper";
    public static final String USE_TAGS = "useTags";
    public static final String SPRING_MVC_LIBRARY = "spring-mvc";
    public static final String SPRING_CLOUD_LIBRARY = "spring-cloud";
    public static final String IMPLICIT_HEADERS = "implicitHeaders";
    public static final String SWAGGER_DOCKET_CONFIG = "swaggerDocketConfig";
    public static final String TARGET_OPENFEIGN = "generateForOpenFeign";
    public static final String DEFAULT_INTERFACES = "defaultInterfaces";
    public static final String SPRING_BOOT_VERSION = "springBootVersion";
    public static final String SPRING_BOOT_VERSION_2 = "springBootV2";
    public static final String THROWS_EXCEPTION = "throwsException";
    protected String title = "swagger-petstore";
    protected String configPackage = "io.swagger.configuration";
    protected String basePackage = "io.swagger";
    protected boolean interfaceOnly = false;
    protected boolean delegatePattern = false;
    protected boolean delegateMethod = false;
    protected boolean singleContentTypes = false;
    protected boolean java8 = false;
    protected boolean async = false;
    protected String responseWrapper = "";
    protected boolean useTags = false;
    protected boolean useBeanValidation = true;
    protected boolean implicitHeaders = false;
    protected boolean swaggerDocketConfig = false;
    protected boolean useOptional = false;
    protected boolean openFeign = false;
    protected boolean defaultInterfaces = true;
    protected String springBootVersion = "2.1.16.RELEASE";
    protected boolean throwsException = false;
    private boolean notNullJacksonAnnotation = false;

    public SpringCodegen() {
        this.outputFolder = "generated-code/javaSpring";
        this.apiPackage = "io.swagger.api";
        this.modelPackage = "io.swagger.model";
        this.invokerPackage = "io.swagger.api";
        this.artifactId = "swagger-spring";
        this.additionalProperties.put(CONFIG_PACKAGE, this.configPackage);
        this.additionalProperties.put(BASE_PACKAGE, this.basePackage);
        this.additionalProperties.put("jackson", "true");
        this.cliOptions.add(new CliOption(TITLE, "server title name or client service name"));
        this.cliOptions.add(new CliOption(CONFIG_PACKAGE, "configuration package for generated code"));
        this.cliOptions.add(new CliOption(BASE_PACKAGE, "base package (invokerPackage) for generated code"));
        this.cliOptions.add(CliOption.newBoolean((String)INTERFACE_ONLY, (String)"Whether to generate only API interface stubs without the server files."));
        this.cliOptions.add(CliOption.newBoolean((String)DELEGATE_PATTERN, (String)"Whether to generate the server files using the delegate pattern"));
        this.cliOptions.add(CliOption.newBoolean((String)SINGLE_CONTENT_TYPES, (String)"Whether to select only one produces/consumes content-type by operation."));
        this.cliOptions.add(CliOption.newBoolean((String)ASYNC, (String)"use async Callable controllers"));
        this.cliOptions.add(new CliOption(RESPONSE_WRAPPER, "wrap the responses in given type (Future,Callable,CompletableFuture,ListenableFuture,DeferredResult,HystrixCommand,RxObservable,RxSingle or fully qualified type)"));
        this.cliOptions.add(CliOption.newBoolean((String)USE_TAGS, (String)"use tags for creating interface and controller classnames"));
        this.cliOptions.add(CliOption.newBoolean((String)"useBeanValidation", (String)"Use BeanValidation API annotations"));
        this.cliOptions.add(CliOption.newBoolean((String)IMPLICIT_HEADERS, (String)"Use of @ApiImplicitParams for headers."));
        this.cliOptions.add(CliOption.newBoolean((String)SWAGGER_DOCKET_CONFIG, (String)"Generate Spring Swagger Docket configuration class."));
        this.cliOptions.add(CliOption.newBoolean((String)"useOptional", (String)"Use Optional container for optional parameters"));
        this.cliOptions.add(CliOption.newBoolean((String)TARGET_OPENFEIGN, (String)"Generate for usage with OpenFeign (instead of feign)"));
        this.cliOptions.add(CliOption.newBoolean((String)DEFAULT_INTERFACES, (String)"Generate default implementations for interfaces").defaultValue("true"));
        this.cliOptions.add(CliOption.newBoolean((String)THROWS_EXCEPTION, (String)"Throws Exception in operation methods").defaultValue("false"));
        this.supportedLibraries.put(DEFAULT_LIBRARY, "Spring-boot Server application using the SpringFox integration.");
        this.supportedLibraries.put(SPRING_MVC_LIBRARY, "Spring-MVC Server application using the SpringFox integration.");
        this.supportedLibraries.put(SPRING_CLOUD_LIBRARY, "Spring-Cloud-Feign client with Spring-Boot auto-configured settings.");
        this.setLibrary(DEFAULT_LIBRARY);
        CliOption library = new CliOption("library", "library template (sub-template) to use");
        library.setDefault(DEFAULT_LIBRARY);
        library.setEnum(this.supportedLibraries);
        library.setDefault(DEFAULT_LIBRARY);
        this.cliOptions.add(library);
        CliOption springBootVersionOption = new CliOption(SPRING_BOOT_VERSION, "Spring boot version");
        HashMap<String, String> springBootEnum = new HashMap<String, String>();
        springBootEnum.put("1.5.22.RELEASE", "1.5.22.RELEASE");
        springBootEnum.put("2.1.7.RELEASE", "2.1.7.RELEASE");
        springBootVersionOption.setEnum(springBootEnum);
        this.cliOptions.add(springBootVersionOption);
    }

    @Override
    protected void addCodegenContentParameters(CodegenOperation codegenOperation, List<CodegenContent> codegenContents) {
        for (CodegenContent content : codegenContents) {
            this.addParameters(content, codegenOperation.headerParams);
            this.addParameters(content, codegenOperation.queryParams);
            this.addParameters(content, codegenOperation.pathParams);
            this.addParameters(content, codegenOperation.cookieParams);
            this.addParameters(content, codegenOperation.bodyParams);
        }
    }

    public CodegenType getTag() {
        return CodegenType.SERVER;
    }

    public String getName() {
        return "spring";
    }

    public String getHelp() {
        return "Generates a Java SpringBoot Server application using the SpringFox integration.";
    }

    @Override
    public void processOpts() {
        if (this.additionalProperties.containsKey("java8")) {
            this.setJava8(Boolean.valueOf(this.additionalProperties.get("java8").toString()));
        }
        if (this.additionalProperties.containsKey("dateLibrary") && this.additionalProperties.get("dateLibrary").toString().startsWith("java8")) {
            this.setJava8(true);
        }
        if (this.java8) {
            this.additionalProperties.put("javaVersion", "1.8");
            this.additionalProperties.put("jdk8", true);
            if (!this.additionalProperties.containsKey("dateLibrary")) {
                this.setDateLibrary("java8");
            }
        } else {
            this.defaultInterfaces = false;
        }
        if (this.additionalProperties.containsKey("invokerPackage")) {
            this.setBasePackage((String)this.additionalProperties.get("invokerPackage"));
            this.additionalProperties.put(BASE_PACKAGE, this.basePackage);
            LOGGER.info("Set base package to invoker package (" + this.basePackage + ")");
        }
        super.processOpts();
        this.modelDocTemplateFiles.remove("model_doc.mustache");
        this.apiDocTemplateFiles.remove("api_doc.mustache");
        if (this.additionalProperties.containsKey(TITLE)) {
            this.setTitle((String)this.additionalProperties.get(TITLE));
        }
        if (this.additionalProperties.containsKey(CONFIG_PACKAGE)) {
            this.setConfigPackage((String)this.additionalProperties.get(CONFIG_PACKAGE));
        }
        if (this.additionalProperties.containsKey(BASE_PACKAGE)) {
            this.setBasePackage((String)this.additionalProperties.get(BASE_PACKAGE));
        }
        if (this.additionalProperties.containsKey(INTERFACE_ONLY)) {
            this.setInterfaceOnly(Boolean.valueOf(this.additionalProperties.get(INTERFACE_ONLY).toString()));
        }
        if (this.additionalProperties.containsKey(THROWS_EXCEPTION)) {
            this.setThrowsException(Boolean.valueOf(this.additionalProperties.get(THROWS_EXCEPTION).toString()));
            this.additionalProperties.put(THROWS_EXCEPTION, this.throwsException);
        }
        if (this.additionalProperties.containsKey(DELEGATE_PATTERN)) {
            this.setDelegatePattern(Boolean.valueOf(this.additionalProperties.get(DELEGATE_PATTERN).toString()));
        }
        if (this.additionalProperties.containsKey(SINGLE_CONTENT_TYPES)) {
            this.setSingleContentTypes(Boolean.valueOf(this.additionalProperties.get(SINGLE_CONTENT_TYPES).toString()));
        }
        if (this.additionalProperties.containsKey(ASYNC)) {
            this.setAsync(Boolean.valueOf(this.additionalProperties.get(ASYNC).toString()));
        }
        if (this.additionalProperties.containsKey(RESPONSE_WRAPPER)) {
            this.setResponseWrapper((String)this.additionalProperties.get(RESPONSE_WRAPPER));
        }
        if (this.additionalProperties.containsKey(USE_TAGS)) {
            this.setUseTags(Boolean.valueOf(this.additionalProperties.get(USE_TAGS).toString()));
        }
        if (this.additionalProperties.containsKey("useBeanValidation")) {
            this.setUseBeanValidation(this.convertPropertyToBoolean("useBeanValidation"));
        }
        if (this.additionalProperties.containsKey("useOptional")) {
            this.setUseOptional(this.convertPropertyToBoolean("useOptional"));
        }
        if (this.additionalProperties.containsKey(TARGET_OPENFEIGN)) {
            this.setOpenFeign(this.convertPropertyToBoolean(TARGET_OPENFEIGN));
        }
        if (this.additionalProperties.containsKey(DEFAULT_INTERFACES)) {
            this.setDefaultInterfaces(Boolean.valueOf(this.additionalProperties.get(DEFAULT_INTERFACES).toString()));
        }
        this.additionalProperties.put(DEFAULT_INTERFACES, this.defaultInterfaces);
        if (this.additionalProperties.containsKey(SPRING_BOOT_VERSION)) {
            this.springBootVersion = this.additionalProperties.get(SPRING_BOOT_VERSION).toString();
        }
        this.additionalProperties.put(SPRING_BOOT_VERSION, this.springBootVersion);
        if (this.springBootVersion.startsWith("2")) {
            this.additionalProperties.put(SPRING_BOOT_VERSION_2, true);
            this.setOpenFeign(true);
        }
        if (this.useBeanValidation) {
            this.writePropertyBack("useBeanValidation", this.useBeanValidation);
        }
        if (this.additionalProperties.containsKey(IMPLICIT_HEADERS)) {
            this.setImplicitHeaders(Boolean.valueOf(this.additionalProperties.get(IMPLICIT_HEADERS).toString()));
        }
        if (this.additionalProperties.containsKey(SWAGGER_DOCKET_CONFIG)) {
            this.setSwaggerDocketConfig(Boolean.valueOf(this.additionalProperties.get(SWAGGER_DOCKET_CONFIG).toString()));
        }
        this.typeMapping.put("file", "Resource");
        this.typeMapping.put("binary", "Resource");
        this.importMapping.put("Resource", "org.springframework.core.io.Resource");
        if (this.useOptional) {
            this.writePropertyBack("useOptional", this.useOptional);
        }
        if (this.interfaceOnly && this.delegatePattern) {
            if (this.java8) {
                this.delegateMethod = true;
                this.additionalProperties.put("delegate-method", true);
            } else {
                throw new IllegalArgumentException(String.format("Can not generate code with `%s` and `%s` true while `%s` is false.", DELEGATE_PATTERN, INTERFACE_ONLY, "java8"));
            }
        }
        this.supportingFiles.add(new SupportingFile("pom.mustache", "", "pom.xml"));
        this.supportingFiles.add(new SupportingFile("README.mustache", "", "README.md"));
        if (!this.interfaceOnly) {
            if (this.isDefaultLibrary()) {
                this.apiTestTemplateFiles.clear();
                this.supportingFiles.add(new SupportingFile("homeController.mustache", (this.sourceFolder + File.separator + this.configPackage).replace(".", File.separator), "HomeController.java"));
                this.supportingFiles.add(new SupportingFile("swagger2SpringBoot.mustache", (this.sourceFolder + File.separator + this.basePackage).replace(".", File.separator), "Swagger2SpringBoot.java"));
                this.supportingFiles.add(new SupportingFile("RFC3339DateFormat.mustache", (this.sourceFolder + File.separator + this.basePackage).replace(".", File.separator), "RFC3339DateFormat.java"));
                this.supportingFiles.add(new SupportingFile("swaggerUiConfiguration.mustache", (this.sourceFolder + File.separator + this.configPackage).replace(".", File.separator), "SwaggerUiConfiguration.java"));
                this.supportingFiles.add(new SupportingFile("application.mustache", "src.main.resources".replace(".", File.separator), "application.properties"));
            }
            if (this.isSpringMvcLibrary()) {
                this.forceOas2();
                this.supportingFiles.add(new SupportingFile("webApplication.mustache", (this.sourceFolder + File.separator + this.configPackage).replace(".", File.separator), "WebApplication.java"));
                this.supportingFiles.add(new SupportingFile("webMvcConfiguration.mustache", (this.sourceFolder + File.separator + this.configPackage).replace(".", File.separator), "WebMvcConfiguration.java"));
                this.supportingFiles.add(new SupportingFile("swaggerUiConfiguration.mustache", (this.sourceFolder + File.separator + this.configPackage).replace(".", File.separator), "SwaggerUiConfiguration.java"));
                this.supportingFiles.add(new SupportingFile("RFC3339DateFormat.mustache", (this.sourceFolder + File.separator + this.configPackage).replace(".", File.separator), "RFC3339DateFormat.java"));
                this.supportingFiles.add(new SupportingFile("application.properties.mustache", "src.main.resources".replace(".", File.separator), "swagger.properties"));
            }
            if (this.isSpringCloudLibrary()) {
                this.forceOas2();
                this.supportingFiles.add(new SupportingFile("apiKeyRequestInterceptor.mustache", (this.sourceFolder + File.separator + this.configPackage).replace(".", File.separator), "ApiKeyRequestInterceptor.java"));
                this.supportingFiles.add(new SupportingFile("clientConfiguration.mustache", (this.sourceFolder + File.separator + this.configPackage).replace(".", File.separator), "ClientConfiguration.java"));
                this.apiTemplateFiles.put("apiClient.mustache", "Client.java");
                if (!this.additionalProperties.containsKey(SINGLE_CONTENT_TYPES)) {
                    this.additionalProperties.put(SINGLE_CONTENT_TYPES, "true");
                    this.setSingleContentTypes(true);
                }
                if (this.additionalProperties.containsKey("generateApiTests") && Boolean.valueOf(this.additionalProperties.get("generateApiTests").toString()).booleanValue()) {
                    this.apiTestTemplateFiles.clear();
                    this.supportingFiles.add(new SupportingFile("application-test.mustache", "src.test.resources".replace(".", File.separator), "application.yml"));
                    this.supportingFiles.add(new SupportingFile("TestUtils.mustache", (this.testFolder + File.separator + this.basePackage).replace(".", File.separator), "TestUtils.java"));
                    this.supportingFiles.add(new SupportingFile("Application.mustache", (this.testFolder + File.separator + this.basePackage).replace(".", File.separator), "Application.java"));
                }
            } else {
                this.apiTemplateFiles.put("apiController.mustache", "Controller.java");
                this.supportingFiles.add(new SupportingFile("apiException.mustache", (this.sourceFolder + File.separator + this.apiPackage).replace(".", File.separator), "ApiException.java"));
                this.supportingFiles.add(new SupportingFile("apiResponseMessage.mustache", (this.sourceFolder + File.separator + this.apiPackage).replace(".", File.separator), "ApiResponseMessage.java"));
                this.supportingFiles.add(new SupportingFile("notFoundException.mustache", (this.sourceFolder + File.separator + this.apiPackage).replace(".", File.separator), "NotFoundException.java"));
                this.supportingFiles.add(new SupportingFile("apiOriginFilter.mustache", (this.sourceFolder + File.separator + this.apiPackage).replace(".", File.separator), "ApiOriginFilter.java"));
                this.supportingFiles.add(new SupportingFile("swaggerDocumentationConfig.mustache", (this.sourceFolder + File.separator + this.configPackage).replace(".", File.separator), "SwaggerDocumentationConfig.java"));
            }
        } else if (this.swaggerDocketConfig && !this.isSpringCloudLibrary()) {
            this.supportingFiles.add(new SupportingFile("swaggerDocumentationConfig.mustache", (this.sourceFolder + File.separator + this.configPackage).replace(".", File.separator), "SwaggerDocumentationConfig.java"));
        }
        if (this.interfaceOnly) {
            this.apiTestTemplateFiles.clear();
        }
        if ("threetenbp".equals(this.dateLibrary)) {
            this.supportingFiles.add(new SupportingFile("customInstantDeserializer.mustache", (this.sourceFolder + File.separator + this.configPackage).replace(".", File.separator), "CustomInstantDeserializer.java"));
            if (this.isDefaultLibrary() || this.isSpringCloudLibrary()) {
                this.supportingFiles.add(new SupportingFile("jacksonConfiguration.mustache", (this.sourceFolder + File.separator + this.configPackage).replace(".", File.separator), "JacksonConfiguration.java"));
            }
        }
        if (!this.delegatePattern && this.java8 || this.delegateMethod) {
            this.additionalProperties.put("jdk8-no-delegate", true);
        }
        if (this.delegatePattern && !this.delegateMethod) {
            this.additionalProperties.put("isDelegate", "true");
            this.apiTemplateFiles.put("apiDelegate.mustache", "Delegate.java");
        }
        if (this.java8) {
            if (this.async) {
                this.additionalProperties.put(RESPONSE_WRAPPER, "CompletableFuture");
            }
        } else if (this.async) {
            this.additionalProperties.put(RESPONSE_WRAPPER, "Callable");
        }
        if (this.openFeign) {
            this.additionalProperties.put("isOpenFeign", true);
        }
        switch (this.responseWrapper) {
            case "Future": 
            case "Callable": 
            case "CompletableFuture": {
                this.additionalProperties.put(RESPONSE_WRAPPER, "java.util.concurrent" + this.responseWrapper);
                break;
            }
            case "ListenableFuture": {
                this.additionalProperties.put(RESPONSE_WRAPPER, "org.springframework.util.concurrent.ListenableFuture");
                break;
            }
            case "DeferredResult": {
                this.additionalProperties.put(RESPONSE_WRAPPER, "org.springframework.web.context.request.async.DeferredResult");
                break;
            }
            case "HystrixCommand": {
                this.additionalProperties.put(RESPONSE_WRAPPER, "com.netflix.hystrix.HystrixCommand");
                break;
            }
            case "RxObservable": {
                this.additionalProperties.put(RESPONSE_WRAPPER, "rx.Observable");
                break;
            }
            case "RxSingle": {
                this.additionalProperties.put(RESPONSE_WRAPPER, "rx.Single");
                break;
            }
        }
        this.additionalProperties.put("lambdaEscapeDoubleQuote", new Mustache.Lambda(){

            public void execute(Template.Fragment fragment, Writer writer) throws IOException {
                writer.write(fragment.execute().replaceAll("\"", Matcher.quoteReplacement("\\\"")));
            }
        });
        this.additionalProperties.put("lambdaRemoveLineBreak", new Mustache.Lambda(){

            public void execute(Template.Fragment fragment, Writer writer) throws IOException {
                writer.write(fragment.execute().replaceAll("\\r|\\n", ""));
            }
        });
        if (this.java8 && !this.defaultInterfaces || !this.java8) {
            this.additionalProperties.put("fullController", true);
        }
    }

    @Override
    public void addOperationToGroup(String tag, String resourcePath, Operation operation, CodegenOperation co, Map<String, List<CodegenOperation>> operations) {
        if ((this.isDefaultLibrary() || this.isSpringMvcLibrary()) && !this.useTags) {
            int pos;
            String basePath = resourcePath;
            if (basePath.startsWith("/")) {
                basePath = basePath.substring(1);
            }
            if ((pos = basePath.indexOf("/")) > 0) {
                basePath = basePath.substring(0, pos);
            }
            if (basePath.equals("")) {
                basePath = "default";
            } else {
                co.subresourceOperation = !co.path.isEmpty();
            }
            List<CodegenOperation> opList = operations.get(basePath);
            if (opList == null) {
                opList = new ArrayList<CodegenOperation>();
                operations.put(basePath, opList);
            }
            opList.add(co);
            co.baseName = basePath;
        } else {
            super.addOperationToGroup(tag, resourcePath, operation, co, operations);
        }
    }

    @Override
    public String getArgumentsLocation() {
        return "/arguments/spring.yaml";
    }

    @Override
    public String getDefaultTemplateDir() {
        return "JavaSpring";
    }

    @Override
    public void preprocessOpenAPI(OpenAPI openAPI) {
        super.preprocessOpenAPI(openAPI);
        if (!this.additionalProperties.containsKey(TITLE)) {
            String title = openAPI.getInfo().getTitle();
            if (title != null) {
                if ((title = title.trim().replace(" ", "-")).toUpperCase().endsWith("API")) {
                    title = title.substring(0, title.length() - 3);
                }
                this.title = SpringCodegen.camelize(this.sanitizeName(title), true);
            }
            this.additionalProperties.put(TITLE, this.title);
        }
        URL urlInfo = URLPathUtil.getServerURL((OpenAPI)openAPI);
        String port = "8080";
        if (urlInfo != null && urlInfo.getPort() > 0) {
            port = String.valueOf(urlInfo.getPort());
        }
        this.additionalProperties.put("serverPort", port);
        if (openAPI.getPaths() != null) {
            for (String pathname : openAPI.getPaths().keySet()) {
                PathItem pathItem = (PathItem)openAPI.getPaths().get((Object)pathname);
                List operations = pathItem.readOperations();
                for (Operation operation : operations) {
                    if (operation.getTags() == null) continue;
                    ArrayList tags = new ArrayList();
                    for (String tag : operation.getTags()) {
                        HashMap<String, String> value = new HashMap<String, String>();
                        value.put("tag", tag);
                        value.put("hasMore", "true");
                        tags.add(value);
                    }
                    if (tags.size() > 0) {
                        ((Map)tags.get(tags.size() - 1)).remove("hasMore");
                    }
                    if (operation.getTags().size() > 0) {
                        String tag = (String)operation.getTags().get(0);
                        operation.setTags(Arrays.asList(tag));
                    }
                    operation.addExtension("x-tags", tags);
                }
            }
        }
    }

    @Override
    public Map<String, Object> postProcessOperations(Map<String, Object> objs) {
        Map operations = (Map)objs.get("operations");
        if (operations != null) {
            List ops = (List)operations.get("operation");
            for (final CodegenOperation operation : ops) {
                List responses = operation.responses;
                if (responses != null) {
                    for (final CodegenResponse resp : responses) {
                        if ("0".equals(resp.code)) {
                            resp.code = "200";
                        }
                        if (resp.baseType == null) {
                            resp.vendorExtensions.put("x-java-is-response-void", true);
                        }
                        this.doDataTypeAssignment(resp.dataType, new DataTypeAssigner(){

                            @Override
                            public void setReturnType(String returnType) {
                                resp.dataType = returnType;
                            }

                            @Override
                            public void setReturnContainer(String returnContainer) {
                                resp.containerType = returnContainer;
                            }
                        });
                    }
                }
                this.doDataTypeAssignment(operation.returnType, new DataTypeAssigner(){

                    @Override
                    public void setReturnType(String returnType) {
                        operation.returnType = returnType;
                    }

                    @Override
                    public void setReturnContainer(String returnContainer) {
                        operation.returnContainer = returnContainer;
                    }
                });
                if (this.implicitHeaders) {
                    this.removeHeadersFromAllParams(operation.allParams);
                    this.removeHeadersFromContents(operation.contents);
                }
                if (operation.examples == null) continue;
                for (Map example : operation.examples) {
                    for (Map.Entry entry : example.entrySet()) {
                        String val = ((String)entry.getValue()).replace("\"", "\\\"").replace("\r", "\\r").replace("\n", "\\n");
                        entry.setValue(val);
                    }
                }
            }
        }
        return objs;
    }

    @Override
    public void setNotNullJacksonAnnotation(boolean notNullJacksonAnnotation) {
        this.notNullJacksonAnnotation = notNullJacksonAnnotation;
    }

    @Override
    public boolean isNotNullJacksonAnnotation() {
        return this.notNullJacksonAnnotation;
    }

    private void doDataTypeAssignment(String returnType, DataTypeAssigner dataTypeAssigner) {
        int end;
        String rt = returnType;
        if (rt == null) {
            dataTypeAssigner.setReturnType("Void");
        } else if (rt.startsWith("List")) {
            int end2 = rt.lastIndexOf(">");
            if (end2 > 0) {
                dataTypeAssigner.setReturnType(rt.substring("List<".length(), end2).trim());
                dataTypeAssigner.setReturnContainer("List");
            }
        } else if (rt.startsWith("Map")) {
            int end3 = rt.lastIndexOf(">");
            if (end3 > 0) {
                String mapTypes = rt.substring("Map<".length(), end3);
                String mapKey = mapTypes.split(",")[0];
                String mapValue = mapTypes.substring(mapKey.length() + 1).trim();
                dataTypeAssigner.setReturnType(mapValue);
                dataTypeAssigner.setReturnContainer("Map");
            }
        } else if (rt.startsWith("Set") && (end = rt.lastIndexOf(">")) > 0) {
            dataTypeAssigner.setReturnType(rt.substring("Set<".length(), end).trim());
            dataTypeAssigner.setReturnContainer("Set");
        }
    }

    private void removeHeadersFromAllParams(List<CodegenParameter> allParams) {
        if (allParams.isEmpty()) {
            return;
        }
        ArrayList<CodegenParameter> copy = new ArrayList<CodegenParameter>(allParams);
        allParams.clear();
        for (CodegenParameter p : copy) {
            if (ExtensionHelper.getBooleanValue((VendorExtendable)p, "x-is-header-param")) continue;
            allParams.add(p);
        }
        allParams.get(allParams.size() - 1).getVendorExtensions().put("x-has-more", Boolean.FALSE);
    }

    private void removeHeadersFromContents(List<CodegenContent> contents) {
        if (contents == null || contents.isEmpty()) {
            return;
        }
        for (int index = 0; index < contents.size(); ++index) {
            CodegenContent codegenContent = contents.get(index);
            List parameters = codegenContent.getParameters();
            if (parameters == null || parameters.isEmpty()) continue;
            List filteredParameters = parameters.stream().filter(codegenParameter -> !ExtensionHelper.getBooleanValue((VendorExtendable)codegenParameter, "x-is-header-param")).collect(Collectors.toList());
            parameters.clear();
            parameters.addAll(filteredParameters);
            ((CodegenParameter)parameters.get(parameters.size() - 1)).getVendorExtensions().put("x-has-more", Boolean.FALSE);
        }
    }

    private void forceOas2() {
        this.setUseOas2(true);
        this.additionalProperties.put("useOas2", true);
    }

    private boolean isSpringCloudLibrary() {
        return this.library.equals(SPRING_CLOUD_LIBRARY);
    }

    private boolean isSpringMvcLibrary() {
        return this.library.equals(SPRING_MVC_LIBRARY);
    }

    private boolean isDefaultLibrary() {
        return this.library.equals(DEFAULT_LIBRARY);
    }

    @Override
    public Map<String, Object> postProcessSupportingFileData(Map<String, Object> objs) {
        List authMethods;
        if (this.isSpringCloudLibrary() && (authMethods = (List)objs.get("authMethods")) != null) {
            for (CodegenSecurity authMethod : authMethods) {
                authMethod.name = SpringCodegen.camelize(this.sanitizeName(authMethod.name), true);
            }
        }
        return objs;
    }

    @Override
    public String toApiName(String name) {
        if (name.length() == 0) {
            return "DefaultApi";
        }
        name = this.sanitizeName(name);
        return SpringCodegen.camelize(name) + "Api";
    }

    @Override
    public String toApiTestFilename(String name) {
        if (this.isSpringMvcLibrary()) {
            return this.toApiName(name) + "ControllerIT";
        }
        if (this.isSpringCloudLibrary()) {
            return this.toApiName(name) + "Test";
        }
        return this.toApiName(name) + "ControllerIntegrationTest";
    }

    @Override
    public void setParameterExampleValue(CodegenParameter p) {
        String type = p.baseType;
        if (type == null) {
            type = p.dataType;
        }
        if ("File".equalsIgnoreCase(type)) {
            String example = p.defaultValue == null ? p.example : p.defaultValue;
            if (example == null) {
                example = "/path/to/file";
            }
            p.example = example = "new org.springframework.core.io.FileSystemResource(new java.io.File(\"" + this.escapeText(example) + "\"))";
        } else {
            super.setParameterExampleValue(p);
        }
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setConfigPackage(String configPackage) {
        this.configPackage = configPackage;
    }

    public void setBasePackage(String configPackage) {
        this.basePackage = configPackage;
    }

    public void setInterfaceOnly(boolean interfaceOnly) {
        this.interfaceOnly = interfaceOnly;
    }

    public void setDelegatePattern(boolean delegatePattern) {
        this.delegatePattern = delegatePattern;
    }

    public void setSingleContentTypes(boolean singleContentTypes) {
        this.singleContentTypes = singleContentTypes;
    }

    public void setJava8(boolean java8) {
        this.java8 = java8;
    }

    public void setAsync(boolean async) {
        this.async = async;
    }

    public void setResponseWrapper(String responseWrapper) {
        this.responseWrapper = responseWrapper;
    }

    public void setUseTags(boolean useTags) {
        this.useTags = useTags;
    }

    public void setImplicitHeaders(boolean implicitHeaders) {
        this.implicitHeaders = implicitHeaders;
    }

    public void setSwaggerDocketConfig(boolean swaggerDocketConfig) {
        this.swaggerDocketConfig = swaggerDocketConfig;
    }

    @Override
    public void postProcessModelProperty(CodegenModel model, CodegenProperty property) {
        boolean isEnum;
        super.postProcessModelProperty(model, property);
        if ("null".equals(property.example)) {
            property.example = null;
        }
        if (!Boolean.TRUE.equals(isEnum = ExtensionHelper.getBooleanValue((VendorExtendable)model, "x-is-enum"))) {
            model.imports.add("JsonProperty");
            boolean hasEnums = ExtensionHelper.getBooleanValue((VendorExtendable)model, "x-has-enums");
            if (Boolean.TRUE.equals(hasEnums)) {
                model.imports.add("JsonValue");
            }
        } else if (this.additionalProperties.containsKey("jackson")) {
            model.imports.add("JsonCreator");
        }
    }

    @Override
    public Map<String, Object> postProcessAllModels(Map<String, Object> objs) {
        Map<String, Object> allProcessedModels = super.postProcessAllModels(objs);
        ArrayList allModels = new ArrayList();
        for (String name : allProcessedModels.keySet()) {
            Map models = (Map)allProcessedModels.get(name);
            try {
                allModels.add(((List)models.get("models")).get(0));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.additionalProperties.put("parent", this.modelInheritanceSupport(allModels));
        return allProcessedModels;
    }

    protected List<Map<String, Object>> modelInheritanceSupport(List<?> allModels) {
        LinkedHashMap<CodegenModel, List> byParent = new LinkedHashMap<CodegenModel, List>();
        for (Object model : allModels) {
            Map entry = (Map)model;
            CodegenModel parent = ((CodegenModel)entry.get((Object)"model")).parentModel;
            if (null == parent) continue;
            byParent.computeIfAbsent(parent, k -> new LinkedList()).add((CodegenModel)entry.get("model"));
        }
        ArrayList<Map<String, Object>> parentsList = new ArrayList<Map<String, Object>>();
        for (Map.Entry parentModelEntry : byParent.entrySet()) {
            CodegenModel parentModel = (CodegenModel)parentModelEntry.getKey();
            ArrayList childrenList = new ArrayList();
            HashMap<String, Object> parent = new HashMap<String, Object>();
            parent.put("classname", parentModel.classname);
            List childrenModels = (List)byParent.get(parentModel);
            for (CodegenModel model : childrenModels) {
                HashMap<String, String> child = new HashMap<String, String>();
                child.put("name", model.name);
                child.put("classname", model.classname);
                childrenList.add(child);
            }
            parent.put("children", childrenList);
            parent.put("discriminator", parentModel.discriminator);
            if (parentModel.discriminator != null && parentModel.discriminator.getMapping() != null) {
                parentModel.discriminator.getMapping().replaceAll((key, value) -> OpenAPIUtil.getSimpleRef(value));
            }
            parentsList.add(parent);
        }
        return parentsList;
    }

    @Override
    public Map<String, Object> postProcessModelsEnum(Map<String, Object> objs) {
        objs = super.postProcessModelsEnum(objs);
        List imports = (List)objs.get("imports");
        List models = (List)objs.get("models");
        for (Object _mo : models) {
            Map mo = (Map)_mo;
            CodegenModel cm = (CodegenModel)mo.get("model");
            boolean isEnum = ExtensionHelper.getBooleanValue((VendorExtendable)cm, "x-is-enum");
            if (!Boolean.TRUE.equals(isEnum) || cm.allowableValues == null) continue;
            cm.imports.add(this.importMapping.get("JsonValue"));
            HashMap item = new HashMap();
            item.put("import", this.importMapping.get("JsonValue"));
            imports.add(item);
        }
        return objs;
    }

    @Override
    public void setUseBeanValidation(boolean useBeanValidation) {
        this.useBeanValidation = useBeanValidation;
    }

    @Override
    public void setUseOptional(boolean useOptional) {
        this.useOptional = useOptional;
    }

    public void setOpenFeign(boolean openFeign) {
        this.openFeign = openFeign;
    }

    public void setDefaultInterfaces(boolean defaultInterfaces) {
        this.defaultInterfaces = defaultInterfaces;
    }

    public void setThrowsException(boolean throwsException) {
        this.throwsException = throwsException;
    }

    private static interface DataTypeAssigner {
        public void setReturnType(String var1);

        public void setReturnContainer(String var1);
    }
}

