/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.transform.internal;

import io.sundr.adapter.api.AdapterContextAware;
import io.sundr.adapter.api.Adapters;
import io.sundr.adapter.api.TypeLookup;
import io.sundr.adapter.apt.AptContext;
import io.sundr.adapter.apt.utils.Apt;
import io.sundr.codegen.api.CodeGenerator;
import io.sundr.codegen.api.Output;
import io.sundr.codegen.api.Renderer;
import io.sundr.codegen.apt.GenericAptOutput;
import io.sundr.codegen.apt.TypeDefAptOutput;
import io.sundr.codegen.apt.processor.AbstractCodeGeneratingProcessor;
import io.sundr.codegen.template.TemplateRenderer;
import io.sundr.codegen.template.TemplateRenderers;
import io.sundr.model.TypeDef;
import io.sundr.model.TypeDefBuilder;
import io.sundr.model.repo.DefinitionRepository;
import io.sundr.model.utils.Types;
import io.sundr.transform.annotations.AnnotationSelector;
import io.sundr.transform.annotations.PackageSelector;
import io.sundr.transform.annotations.ResourceSelector;
import io.sundr.transform.annotations.TemplateTransformation;
import io.sundr.transform.annotations.TemplateTransformations;
import io.sundr.utils.Strings;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.processing.Filer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.tools.FileObject;
import javax.tools.StandardLocation;

@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
@SupportedAnnotationTypes(value={"io.sundr.transform.annotations.TemplateTransformation", "io.sundr.transform.annotations.TemplateTransformations"})
public class TemplateTransformationProcessor
extends AbstractCodeGeneratingProcessor {
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.generator = CodeGenerator.newGenerator(TypeDef.class).withOutput((Output)new TypeDefAptOutput(processingEnv.getFiler())).build();
    }

    /*
     * Could not resolve type clashes
     */
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment env) {
        Elements elements = this.processingEnv.getElementUtils();
        javax.lang.model.util.Types types = this.processingEnv.getTypeUtils();
        Filer filer = this.processingEnv.getFiler();
        AptContext aptContext = AptContext.create((Elements)elements, (javax.lang.model.util.Types)types, (DefinitionRepository)DefinitionRepository.getRepository());
        HashMap annotatedTypes = new HashMap();
        for (TypeElement typeElement : annotations) {
            for (Element element : env.getElementsAnnotatedWith(typeElement)) {
                TemplateTransformations transformations = element.getAnnotation(TemplateTransformations.class);
                TemplateTransformation transformation = element.getAnnotation(TemplateTransformation.class);
                ArrayList<Object> all = new ArrayList<Object>();
                if (transformation != null) {
                    all.add(transformation);
                }
                if (transformations != null) {
                    for (Annotation[] t2 : transformations.value()) {
                        all.add(t2);
                    }
                }
                TypeDef def = new TypeDefBuilder(Adapters.adaptType((Object)Apt.getClassElement((Element)element), (AdapterContextAware)aptContext)).build();
                for (TemplateTransformation t3 : all) {
                    Annotation selector;
                    int n;
                    int n2;
                    Annotation[] t2;
                    if (!annotatedTypes.containsKey(t3)) {
                        annotatedTypes.put(t3, new HashMap());
                    }
                    if (transformations == null) {
                        ((Map)annotatedTypes.get(t3)).put(def.getFullyQualifiedName(), def);
                        continue;
                    }
                    if (transformations.annotations().length > 0) {
                        t2 = transformations.annotations();
                        n2 = t2.length;
                        for (n = 0; n < n2; ++n) {
                            selector = t2[n];
                            this.selectAnnotated(env, types, (AnnotationSelector)selector, (Map)annotatedTypes.get(t3));
                        }
                        continue;
                    }
                    if (transformations.packages().length > 0) {
                        t2 = transformations.packages();
                        n2 = t2.length;
                        for (n = 0; n < n2; ++n) {
                            selector = t2[n];
                            this.selectPackages(elements, (PackageSelector)selector, (Map)annotatedTypes.get(t3));
                        }
                        continue;
                    }
                    if (transformations.resources().length > 0) {
                        t2 = transformations.resources();
                        n2 = t2.length;
                        for (n = 0; n < n2; ++n) {
                            selector = t2[n];
                            this.selectFromResource(elements, filer, (ResourceSelector)selector, (Map)annotatedTypes.get(t3));
                        }
                        continue;
                    }
                    ((Map)annotatedTypes.get(t3)).put(def.getFullyQualifiedName(), def);
                }
            }
            for (Map.Entry entry : annotatedTypes.entrySet()) {
                TemplateTransformation transformation = (TemplateTransformation)entry.getKey();
                Map annotated = (Map)entry.getValue();
                try {
                    if (transformation.gather()) {
                        URL templateUrl = this.readTemplateURL(filer, null, transformation.value());
                        TemplateRenderer renderer = (TemplateRenderer)TemplateRenderers.getTemplateRenderer(Map.class, (URL)templateUrl, (String[])new String[0]).orElseThrow(() -> new IllegalStateException("No template renderer found for:" + templateUrl));
                        CodeGenerator.newGenerator(Map.class).withRenderer((Renderer)renderer).withOutput((Output)new GenericAptOutput(filer, transformation.outputPath())).skipping(i -> false).generate((Object[])new Map[]{annotated});
                        continue;
                    }
                    for (TypeDef typeDef : annotated.values()) {
                        URL templateUrl = this.readTemplateURL(filer, typeDef.getPackageName(), transformation.value());
                        TemplateRenderer renderer = (TemplateRenderer)TemplateRenderers.getTemplateRenderer(TypeDef.class, (URL)templateUrl, (String[])new String[0]).orElseThrow(() -> new IllegalStateException("No template renderer found for:" + templateUrl));
                        Function<TypeDef, String> identifier = t -> Types.parseFullyQualifiedName((String)renderer.render(t));
                        CodeGenerator.newGenerator(TypeDef.class).withRenderer((Renderer)renderer).withIdentifier(identifier).withOutput((Output)new TypeDefAptOutput(filer, (Renderer)renderer)).skipping(t -> TypeLookup.lookup((String)((String)identifier.apply(typeDef)), (AdapterContextAware)AptContext.getContext()).isPresent()).generate((Object[])new TypeDef[]{typeDef});
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return false;
    }

    public void selectFromResource(Elements elements, Filer filer, ResourceSelector selector, Map<String, TypeDef> definitions) {
        try {
            FileObject fileObject = filer.getResource(StandardLocation.CLASS_PATH, "", selector.value());
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(fileObject.openInputStream()));){
                List lines = reader.lines().map(String::trim).filter(l -> !Strings.isNullOrEmpty((String)l)).collect(Collectors.toList());
                AptContext aptContext = AptContext.getContext();
                Map<String, TypeDef> map = lines.stream().map(l -> elements.getTypeElement((CharSequence)l)).filter(e -> e instanceof TypeElement).map(e -> Adapters.adaptType((Object)e, (AdapterContextAware)aptContext)).collect(Collectors.toMap(e -> e.getFullyQualifiedName(), e -> e));
                definitions.putAll(map);
            }
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
    }

    public void selectAnnotated(RoundEnvironment env, javax.lang.model.util.Types types, AnnotationSelector selector, Map<String, TypeDef> definitions) {
        for (Element element : env.getElementsAnnotatedWith((TypeElement)types.asElement(this.annotationMirror(selector)))) {
            if (!(element instanceof TypeElement)) continue;
            TypeDef typeDef = new TypeDefBuilder(Adapters.adaptType((Object)Apt.getClassElement((Element)element), (AdapterContextAware)AptContext.getContext())).build();
            definitions.put(typeDef.getFullyQualifiedName(), typeDef);
        }
    }

    public void selectPackages(Elements elements, PackageSelector selector, Map<String, TypeDef> definitions) {
        Pattern pattern = Pattern.compile(selector.pattern());
        PackageElement packageElement = elements.getPackageElement(selector.value());
        ArrayList<TypeElement> typeElements = new ArrayList<TypeElement>();
        if (packageElement != null) {
            for (Element element : packageElement.getEnclosedElements()) {
                if (!(element instanceof TypeElement)) continue;
                typeElements.add((TypeElement)element);
            }
        } else {
            TypeElement e = elements.getTypeElement(selector.value());
            if (e != null) {
                typeElements.add(e);
            }
        }
        for (TypeElement typeElement : typeElements) {
            TypeDef typeDef = new TypeDefBuilder(Adapters.adaptType((Object)Apt.getClassElement((Element)typeElement), (AdapterContextAware)AptContext.getContext())).build();
            Matcher m = pattern.matcher(typeDef.getName());
            if (!m.matches()) continue;
            definitions.put(typeDef.getFullyQualifiedName(), typeDef);
        }
    }

    private TypeMirror annotationMirror(AnnotationSelector selector) {
        try {
            selector.value();
            return null;
        }
        catch (MirroredTypeException m) {
            return m.getTypeMirror();
        }
    }

    private static FileObject getTemplateFileObject(Filer filer, String pkg, String template) throws IOException {
        if (template == null) {
            throw new IllegalArgumentException("Template in:" + TemplateTransformation.class.getName() + " cannot be null.");
        }
        String targetPkg = pkg == null || template != null && template.startsWith("/") ? "" : pkg;
        String targetTemplate = template.startsWith("/") ? template.substring(1) : template;
        try {
            return filer.getResource(StandardLocation.SOURCE_PATH, targetPkg, targetTemplate);
        }
        catch (IOException e) {
            try {
                return filer.getResource(StandardLocation.CLASS_PATH, targetPkg, targetTemplate);
            }
            catch (IOException ex) {
                throw e;
            }
        }
    }

    private URL readTemplateURL(Filer filer, String pkg, String template) throws IOException {
        FileObject o = TemplateTransformationProcessor.getTemplateFileObject(filer, pkg, template);
        if (o == null) {
            throw new IOException("Template resource: " + template + " couldn't be found in sources or classpath.");
        }
        return o.toUri().toURL();
    }

    private String readTemplate(Filer filer, String pkg, String template) throws IOException {
        FileObject o = TemplateTransformationProcessor.getTemplateFileObject(filer, pkg, template);
        if (o == null) {
            throw new IOException("Template resource: " + template + " couldn't be found in sources or classpath.");
        }
        return o.getCharContent(false).toString();
    }
}

