/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.model;

import io.sundr.model.ClassRef;
import io.sundr.model.Expression;
import io.sundr.model.Renderable;
import io.sundr.model.TypeRef;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class Construct
implements Expression {
    private final ClassRef type;
    private final List<TypeRef> parameters;
    private final List<Expression> arguments;

    public Construct(ClassRef type, List<TypeRef> parameters, List<Expression> arguments) {
        this.type = type;
        this.parameters = parameters;
        this.arguments = arguments;
    }

    public Construct(ClassRef type, List<Expression> arguments) {
        this(type, Collections.emptyList(), arguments);
    }

    public Construct(ClassRef type, Expression ... arguments) {
        this(type, Collections.emptyList(), Arrays.asList(arguments));
    }

    public Construct(Class type, List<TypeRef> parameters, List<Expression> arguments) {
        this(ClassRef.forName(type.getName()), parameters, arguments);
    }

    public Construct(Class type, List<Expression> arguments) {
        this(ClassRef.forName(type.getName()), Collections.emptyList(), arguments);
    }

    public Construct(Class type, Expression ... arguments) {
        this(ClassRef.forName(type.getName()), Collections.emptyList(), Arrays.asList(arguments));
    }

    public ClassRef getType() {
        return this.type;
    }

    public List<TypeRef> getParameters() {
        return this.parameters;
    }

    public List<Expression> getArguments() {
        return this.arguments;
    }

    @Override
    public String render() {
        StringBuilder sb = new StringBuilder();
        sb.append("new ").append(this.type.getFullyQualifiedName());
        if (!this.parameters.isEmpty()) {
            sb.append(this.parameters.stream().map(Renderable::render).collect(Collectors.joining(", ", "<", ">")));
        }
        sb.append(this.arguments.stream().map(Renderable::render).collect(Collectors.joining(", ", "(", ")")));
        return sb.toString();
    }
}

