/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.builder.internal.processor;

import io.sundr.builder.Constants;
import io.sundr.builder.annotations.Inline;
import io.sundr.builder.internal.BuilderContext;
import io.sundr.builder.internal.BuilderContextManager;
import io.sundr.builder.internal.functions.TypeAs;
import io.sundr.builder.internal.utils.BuilderUtils;
import io.sundr.codegen.model.EditableJavaMethod;
import io.sundr.codegen.model.EditableJavaProperty;
import io.sundr.codegen.model.EditableJavaType;
import io.sundr.codegen.model.JavaClazz;
import io.sundr.codegen.model.JavaClazzBuilder;
import io.sundr.codegen.model.JavaMethod;
import io.sundr.codegen.model.JavaMethodBuilder;
import io.sundr.codegen.model.JavaMethodFluent;
import io.sundr.codegen.model.JavaProperty;
import io.sundr.codegen.model.JavaPropertyBuilder;
import io.sundr.codegen.model.JavaType;
import io.sundr.codegen.model.JavaTypeBuilder;
import io.sundr.codegen.processor.JavaGeneratingProcessor;
import io.sundr.codegen.utils.StringUtils;
import io.sundr.codegen.utils.TypeUtils;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import javax.lang.model.element.Modifier;

public abstract class AbstractBuilderProcessor
extends JavaGeneratingProcessor {
    private static final String EMPTY_FUNCTION_TEXT = StringUtils.loadResourceQuietly((String)"snippets/empty-function.txt");
    private static final String BUILDER = "builder";
    private static final String FUNCTION = "function";
    private static final String ITEM = "item";
    private static final String NEW_BUILDER_AND_EMTPY_FUNCTION_FORMAT = "this.builder=new %s(this, item);this.function=new %s;";
    private static final String NEW_BULDER_AND_SET_FUNCTION_FORMAT = "this.builder=new %s(this);this.function=function;";
    private static final String BUILD_AND_APPLY_FUNCTION = " return function.apply(builder.build());";

    void generateLocalDependenciesIfNeeded() {
        BuilderContext context = BuilderContextManager.getContext();
        if (context.getGenerateBuilderPackage().booleanValue() && !"io.sundr.builder".equals(context.getBuilderPackage())) {
            try {
                this.generateFromClazz(context.getVisitableInterface(), "templates/builder/interface.vm");
                this.generateFromClazz(context.getVisitorInterface(), "templates/builder/interface.vm");
                this.generateFromClazz(context.getTypedVisitorInterface(), "templates/builder/class.vm");
                this.generateFromClazz(context.getVisitableBuilderInterface(), "templates/builder/interface.vm");
                this.generateFromClazz(context.getBuilderInterface(), "templates/builder/interface.vm");
                this.generateFromClazz(context.getFluentInterface(), "templates/builder/interface.vm");
                this.generateFromClazz(context.getBaseFluentClass(), "templates/builder/class.vm");
                this.generateFromClazz(context.getNestedInterface(), "templates/builder/interface.vm");
                this.generateFromClazz(context.getEditableInterface(), "templates/builder/interface.vm");
                this.generateFromClazz(context.getFunctionInterface(), "templates/builder/interface.vm");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    String selectBuilderTemplate(boolean validationEnabled) {
        if (validationEnabled) {
            return "templates/builder/validating-builder.vm";
        }
        return "templates/builder/builder.vm";
    }

    JavaClazz inlineableOf(BuilderContext ctx, JavaClazz clazz, Inline inline) {
        JavaType returnType;
        LinkedHashSet<EditableJavaMethod> constructors = new LinkedHashSet<EditableJavaMethod>();
        JavaType type = clazz.getType();
        JavaType typeWithUnboundParameters = (JavaType)TypeAs.REMOVE_GENERICS_BOUNDS.apply(clazz.getType());
        JavaType builderType = (JavaType)TypeAs.SHALLOW_BUILDER.apply(typeWithUnboundParameters);
        JavaType inlineableType = (JavaType)TypeAs.INLINEABLE.apply(type);
        if (!inline.name().isEmpty()) {
            inlineableType = ((JavaTypeBuilder)new JavaTypeBuilder(inlineableType).withClassName(inline.name())).build();
        }
        if ((returnType = BuilderUtils.getInlineReturnType(ctx, inline)).equals((Object)Constants.BOXED_VOID)) {
            returnType = typeWithUnboundParameters;
        }
        JavaType functionType = TypeUtils.typeGenericOf((JavaType)ctx.getFunctionInterface().getType(), (JavaType[])new JavaType[]{typeWithUnboundParameters, returnType});
        EditableJavaProperty builderProperty = ((JavaPropertyBuilder)((JavaPropertyBuilder)((JavaPropertyBuilder)((JavaPropertyBuilder)new JavaPropertyBuilder().withType((JavaType)TypeAs.BUILDER.apply(typeWithUnboundParameters))).withName(BUILDER)).addToModifiers(new Modifier[]{Modifier.PRIVATE})).addToModifiers(new Modifier[]{Modifier.FINAL})).build();
        EditableJavaProperty functionProperty = ((JavaPropertyBuilder)((JavaPropertyBuilder)((JavaPropertyBuilder)((JavaPropertyBuilder)new JavaPropertyBuilder().withType(functionType)).withName(FUNCTION)).addToModifiers(new Modifier[]{Modifier.PRIVATE})).addToModifiers(new Modifier[]{Modifier.FINAL})).build();
        if (returnType.equals((Object)Constants.BOXED_VOID)) {
            returnType = clazz.getType();
        }
        JavaType baseInterface = TypeUtils.typeGenericOf((JavaType)BuilderUtils.getInlineType(ctx, inline), (JavaType[])new JavaType[]{returnType});
        JavaType fluentImpl = (JavaType)TypeAs.FLUENT_IMPL.apply(clazz.getType());
        JavaType fluentInterface = (JavaType)TypeAs.FLUENT_INTERFACE.apply(clazz.getType());
        EditableJavaType shallowInlineType = ((JavaTypeBuilder)((JavaTypeBuilder)new JavaTypeBuilder(inlineableType).withClassName(inline.prefix() + inlineableType.getClassName() + inline.suffix())).withInterfaces(new JavaType[]{baseInterface})).build();
        ArrayList<Object> generics = new ArrayList<Object>();
        for (JavaType generic : clazz.getType().getGenericTypes()) {
            generics.add(generic);
        }
        generics.add(shallowInlineType);
        EditableJavaType inlineType = ((JavaTypeBuilder)((JavaTypeBuilder)new JavaTypeBuilder((JavaType)shallowInlineType).withSuperClass((JavaType)TypeAs.REMOVE_GENERICS_BOUNDS.apply(TypeUtils.typeGenericOf((JavaType)fluentImpl, (JavaType[])generics.toArray(new JavaType[generics.size()]))))).addToInterfaces(new JavaType[]{(JavaType)TypeAs.REMOVE_GENERICS_BOUNDS.apply(TypeUtils.typeGenericOf((JavaType)fluentInterface, (JavaType[])generics.toArray(new JavaType[generics.size()])))})).build();
        EditableJavaMethod inlineMethod = ((JavaMethodBuilder)((JavaMethodBuilder)((JavaMethodBuilder)((JavaMethodBuilder)new JavaMethodBuilder().withReturnType(returnType)).withName(inline.value())).addToAttributes("BODY", (Object)BUILD_AND_APPLY_FUNCTION)).addToModifiers(new Modifier[]{Modifier.PUBLIC})).build();
        constructors.add(((JavaMethodBuilder)((JavaMethodBuilder)((JavaMethodBuilder)((JavaMethodFluent.ArgumentsNested)((JavaMethodFluent.ArgumentsNested)((JavaMethodBuilder)((JavaMethodBuilder)((JavaMethodFluent.ReturnTypeNested)new JavaMethodBuilder().withNewReturnTypeLike((JavaType)inlineType).withGenericTypes(new JavaType[0])).endReturnType()).withName("")).addNewArgument().withName(FUNCTION)).withType(functionType)).and()).addToModifiers(new Modifier[]{Modifier.PUBLIC})).addToAttributes("BODY", (Object)String.format(NEW_BULDER_AND_SET_FUNCTION_FORMAT, builderType.getSimpleName()))).build());
        constructors.add(((JavaMethodBuilder)((JavaMethodBuilder)((JavaMethodBuilder)((JavaMethodFluent.ArgumentsNested)((JavaMethodFluent.ArgumentsNested)((JavaMethodBuilder)((JavaMethodFluent.ArgumentsNested)((JavaMethodFluent.ArgumentsNested)((JavaMethodBuilder)((JavaMethodBuilder)((JavaMethodFluent.ReturnTypeNested)new JavaMethodBuilder().withNewReturnTypeLike((JavaType)inlineType).withGenericTypes(new JavaType[0])).endReturnType()).withName("")).addNewArgument().withName(ITEM)).withType(typeWithUnboundParameters)).and()).addNewArgument().withName(FUNCTION)).withType(functionType)).and()).addToModifiers(new Modifier[]{Modifier.PUBLIC})).addToAttributes("BODY", (Object)String.format(NEW_BULDER_AND_SET_FUNCTION_FORMAT, builderType.getSimpleName()))).build());
        if (clazz.getType().equals((Object)returnType)) {
            constructors.add(((JavaMethodBuilder)((JavaMethodBuilder)((JavaMethodBuilder)((JavaMethodFluent.ArgumentsNested)((JavaMethodFluent.ArgumentsNested)((JavaMethodBuilder)((JavaMethodBuilder)((JavaMethodFluent.ReturnTypeNested)new JavaMethodBuilder().withNewReturnTypeLike((JavaType)inlineType).withGenericTypes(new JavaType[0])).endReturnType()).withName("")).addNewArgument().withName(FUNCTION)).withType(functionType)).and()).addToModifiers(new Modifier[]{Modifier.PUBLIC})).addToAttributes("BODY", (Object)String.format(NEW_BUILDER_AND_EMTPY_FUNCTION_FORMAT, builderType.getSimpleName(), String.format(EMPTY_FUNCTION_TEXT, typeWithUnboundParameters.getSimpleName(), typeWithUnboundParameters.getSimpleName(), typeWithUnboundParameters.getSimpleName(), typeWithUnboundParameters.getSimpleName())))).build());
            constructors.add(((JavaMethodBuilder)((JavaMethodBuilder)((JavaMethodBuilder)((JavaMethodFluent.ArgumentsNested)((JavaMethodFluent.ArgumentsNested)((JavaMethodBuilder)((JavaMethodBuilder)((JavaMethodFluent.ReturnTypeNested)new JavaMethodBuilder().withNewReturnTypeLike((JavaType)inlineType).withGenericTypes(new JavaType[0])).endReturnType()).withName("")).addNewArgument().withName(ITEM)).withType(typeWithUnboundParameters)).and()).addToModifiers(new Modifier[]{Modifier.PUBLIC})).addToAttributes("BODY", (Object)String.format(NEW_BUILDER_AND_EMTPY_FUNCTION_FORMAT, builderType.getSimpleName(), String.format(EMPTY_FUNCTION_TEXT, typeWithUnboundParameters.getSimpleName(), typeWithUnboundParameters.getSimpleName(), typeWithUnboundParameters.getSimpleName(), typeWithUnboundParameters.getSimpleName())))).build());
        }
        return ((JavaClazzBuilder)((JavaClazzBuilder)((JavaClazzBuilder)((JavaClazzBuilder)new JavaClazzBuilder().withType((JavaType)inlineType)).withConstructors(constructors)).addToFields(new JavaProperty[]{builderProperty, functionProperty})).addToMethods(new JavaMethod[]{inlineMethod})).build();
    }
}

