/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.builder.internal.functions;

import io.sundr.CachingFunction;
import io.sundr.Function;
import io.sundr.builder.Constants;
import io.sundr.builder.internal.BuildableRepository;
import io.sundr.builder.internal.BuilderContext;
import io.sundr.builder.internal.BuilderContextManager;
import io.sundr.builder.internal.functions.TypeAs;
import io.sundr.codegen.model.EditableJavaType;
import io.sundr.codegen.model.JavaClazz;
import io.sundr.codegen.model.JavaProperty;
import io.sundr.codegen.model.JavaPropertyBuilder;
import io.sundr.codegen.model.JavaType;
import io.sundr.codegen.model.JavaTypeBuilder;
import io.sundr.codegen.utils.StringUtils;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.lang.model.element.TypeElement;

public class Decendants {
    public static final Function<JavaType, Set<JavaType>> BUILDABLE_DECENDANTS = CachingFunction.wrap((Function)new Function<JavaType, Set<JavaType>>(){

        public Set<JavaType> apply(JavaType item) {
            if (item.getFullyQualifiedName().equals(Constants.OBJECT.getFullyQualifiedName())) {
                return new LinkedHashSet<JavaType>();
            }
            LinkedHashSet<JavaType> result = new LinkedHashSet<JavaType>();
            BuilderContext ctx = BuilderContextManager.getContext();
            BuildableRepository repository = ctx.getRepository();
            for (TypeElement element : repository.getBuildables()) {
                JavaClazz clazz = (JavaClazz)ctx.getTypeElementToJavaClazz().apply((Object)element);
                JavaType type = clazz.getType();
                if (!type.isConcrete() || !Decendants.isDescendant(type, item)) continue;
                result.add(type);
            }
            return result;
        }
    });
    public static Function<JavaProperty, Set<JavaProperty>> PROPERTY_BUILDABLE_ANCESTORS = CachingFunction.wrap((Function)new Function<JavaProperty, Set<JavaProperty>>(){

        public Set<JavaProperty> apply(JavaProperty property) {
            LinkedHashSet<JavaProperty> result = new LinkedHashSet<JavaProperty>();
            JavaType baseType = property.getType();
            if (baseType.isCollection()) {
                JavaType candidate = (JavaType)TypeAs.UNWRAP_COLLECTION_OF.apply(baseType);
                for (JavaType descendant : (Set)BUILDABLE_DECENDANTS.apply((Object)candidate)) {
                    EditableJavaType collectionType = ((JavaTypeBuilder)new JavaTypeBuilder(baseType).withGenericTypes(new JavaType[]{descendant})).build();
                    String propertyName = StringUtils.deCaptializeFirst((String)descendant.getClassName()) + property.getNameCapitalized();
                    result.add((JavaProperty)((JavaPropertyBuilder)((JavaPropertyBuilder)((JavaPropertyBuilder)((JavaPropertyBuilder)new JavaPropertyBuilder(property).withName(propertyName)).withType((JavaType)collectionType)).addToAttributes("DESCENDANT_OF", (Object)property)).addToAttributes("BUILDABLE", (Object)true)).build());
                }
            } else {
                for (JavaType descendant : (Set)BUILDABLE_DECENDANTS.apply((Object)baseType)) {
                    String propertyName = descendant.getSimpleName() + property.getNameCapitalized();
                    result.add((JavaProperty)((JavaPropertyBuilder)((JavaPropertyBuilder)((JavaPropertyBuilder)((JavaPropertyBuilder)new JavaPropertyBuilder(property).withName(propertyName)).withType(descendant)).addToAttributes("DESCENDANT_OF", (Object)property)).addToAttributes("BUILDABLE", (Object)true)).build());
                }
            }
            return result;
        }
    });

    public static boolean isDescendant(JavaType item, JavaType candidate) {
        if (item == null || candidate == null) {
            return false;
        }
        if (item.getFullyQualifiedName().equals(candidate.getFullyQualifiedName())) {
            return true;
        }
        if (Decendants.isDescendant(item.getSuperClass(), candidate)) {
            return true;
        }
        for (JavaType interfaceType : item.getInterfaces()) {
            if (!Decendants.isDescendant(interfaceType, candidate)) continue;
            return true;
        }
        return false;
    }
}

