/*
 * Decompiled with CFR 0.152.
 */
package io.substrait.relation.physical;

import io.substrait.relation.physical.AbstractExchangeRel;
import io.substrait.relation.physical.TargetType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public final class ImmutableExchangeTarget
extends AbstractExchangeRel.ExchangeTarget {
    private final List<Integer> partitionIds;
    private final TargetType type;

    private ImmutableExchangeTarget(List<Integer> partitionIds, TargetType type) {
        this.partitionIds = partitionIds;
        this.type = type;
    }

    @Override
    public List<Integer> getPartitionIds() {
        return this.partitionIds;
    }

    @Override
    public TargetType getType() {
        return this.type;
    }

    public final ImmutableExchangeTarget withPartitionIds(int ... elements) {
        ArrayList<Integer> wrappedList = new ArrayList<Integer>(elements.length);
        for (int element : elements) {
            wrappedList.add(element);
        }
        List<Integer> newValue = ImmutableExchangeTarget.createUnmodifiableList(false, wrappedList);
        return new ImmutableExchangeTarget(newValue, this.type);
    }

    public final ImmutableExchangeTarget withPartitionIds(Iterable<Integer> elements) {
        if (this.partitionIds == elements) {
            return this;
        }
        List<Integer> newValue = ImmutableExchangeTarget.createUnmodifiableList(false, ImmutableExchangeTarget.createSafeList(elements, true, false));
        return new ImmutableExchangeTarget(newValue, this.type);
    }

    public final ImmutableExchangeTarget withType(TargetType value) {
        if (this.type == value) {
            return this;
        }
        TargetType newValue = Objects.requireNonNull(value, "type");
        return new ImmutableExchangeTarget(this.partitionIds, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableExchangeTarget && this.equalsByValue((ImmutableExchangeTarget)another);
    }

    private boolean equalsByValue(ImmutableExchangeTarget another) {
        return this.partitionIds.equals(another.partitionIds) && this.type.equals(another.type);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.partitionIds.hashCode();
        h += (h << 5) + this.type.hashCode();
        return h;
    }

    public String toString() {
        return "ExchangeTarget{partitionIds=" + this.partitionIds + ", type=" + this.type + "}";
    }

    public static ImmutableExchangeTarget copyOf(AbstractExchangeRel.ExchangeTarget instance) {
        if (instance instanceof ImmutableExchangeTarget) {
            return (ImmutableExchangeTarget)instance;
        }
        return ImmutableExchangeTarget.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<? extends T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_TYPE = 1L;
        private long initBits = 1L;
        private List<Integer> partitionIds = new ArrayList<Integer>();
        private TargetType type;

        private Builder() {
        }

        public final Builder from(AbstractExchangeRel.ExchangeTarget instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllPartitionIds(instance.getPartitionIds());
            this.type(instance.getType());
            return this;
        }

        public final Builder addPartitionIds(int element) {
            this.partitionIds.add(element);
            return this;
        }

        public final Builder addPartitionIds(int ... elements) {
            for (int element : elements) {
                this.partitionIds.add(element);
            }
            return this;
        }

        public final Builder partitionIds(Iterable<Integer> elements) {
            this.partitionIds.clear();
            return this.addAllPartitionIds(elements);
        }

        public final Builder addAllPartitionIds(Iterable<Integer> elements) {
            for (Integer element : elements) {
                this.partitionIds.add(Objects.requireNonNull(element, "partitionIds element"));
            }
            return this;
        }

        public final Builder type(TargetType type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableExchangeTarget build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableExchangeTarget(ImmutableExchangeTarget.createUnmodifiableList(true, this.partitionIds), this.type);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("type");
            }
            return "Cannot build ExchangeTarget, some of required attributes are not set " + attributes;
        }
    }
}

