/*
 * Decompiled with CFR 0.152.
 */
package io.substrait.expression;

import io.substrait.expression.Expression;
import io.substrait.expression.FunctionArg;
import io.substrait.extension.SimpleExtension;
import io.substrait.type.Type;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

class VariadicParameterConsistencyValidator {
    VariadicParameterConsistencyValidator() {
    }

    public static void validate(SimpleExtension.Function func, List<FunctionArg> arguments) {
        Optional<SimpleExtension.VariadicBehavior> variadic = func.variadic();
        if (!variadic.isPresent()) {
            return;
        }
        SimpleExtension.VariadicBehavior variadicBehavior = variadic.get();
        if (variadicBehavior.parameterConsistency() != SimpleExtension.VariadicBehavior.ParameterConsistency.CONSISTENT) {
            return;
        }
        List argumentTypes = arguments.stream().filter(arg -> arg instanceof Expression || arg instanceof Type).map(arg -> {
            if (arg instanceof Expression) {
                return ((Expression)arg).getType();
            }
            return (Type)arg;
        }).collect(Collectors.toList());
        int nonVariadicArgCount = 0;
        for (int i = 0; i < func.args().size() && i < arguments.size(); ++i) {
            FunctionArg arg2 = arguments.get(i);
            if (!(arg2 instanceof Expression) && !(arg2 instanceof Type)) continue;
            ++nonVariadicArgCount;
        }
        if (argumentTypes.size() <= nonVariadicArgCount) {
            return;
        }
        int firstVariadicArgIdx = nonVariadicArgCount;
        Type firstVariadicType = (Type)argumentTypes.get(firstVariadicArgIdx);
        for (int i = firstVariadicArgIdx + 1; i < argumentTypes.size(); ++i) {
            Type currentType = (Type)argumentTypes.get(i);
            if (!firstVariadicType.equalsIgnoringNullability(currentType)) {
                throw new AssertionError((Object)String.format("Variadic arguments must have consistent types when parameterConsistency is CONSISTENT. Argument at index %d has type %s but argument at index %d has type %s", firstVariadicArgIdx, firstVariadicType, i, currentType));
            }
        }
    }
}

