/*
 * Decompiled with CFR 0.152.
 */
package io.substrait.plan;

import io.substrait.plan.Plan;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;

public final class ImmutableVersion
extends Plan.Version {
    private final int major;
    private final int minor;
    private final int patch;
    private final String gitHash;
    private final String producer;

    private ImmutableVersion(int major, int minor, int patch, String gitHash, String producer) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        this.gitHash = gitHash;
        this.producer = producer;
    }

    @Override
    public int getMajor() {
        return this.major;
    }

    @Override
    public int getMinor() {
        return this.minor;
    }

    @Override
    public int getPatch() {
        return this.patch;
    }

    @Override
    public Optional<String> getGitHash() {
        return Optional.ofNullable(this.gitHash);
    }

    @Override
    public Optional<String> getProducer() {
        return Optional.ofNullable(this.producer);
    }

    public final ImmutableVersion withMajor(int value) {
        if (this.major == value) {
            return this;
        }
        return new ImmutableVersion(value, this.minor, this.patch, this.gitHash, this.producer);
    }

    public final ImmutableVersion withMinor(int value) {
        if (this.minor == value) {
            return this;
        }
        return new ImmutableVersion(this.major, value, this.patch, this.gitHash, this.producer);
    }

    public final ImmutableVersion withPatch(int value) {
        if (this.patch == value) {
            return this;
        }
        return new ImmutableVersion(this.major, this.minor, value, this.gitHash, this.producer);
    }

    public final ImmutableVersion withGitHash(String value) {
        String newValue = Objects.requireNonNull(value, "gitHash");
        if (Objects.equals(this.gitHash, newValue)) {
            return this;
        }
        return new ImmutableVersion(this.major, this.minor, this.patch, newValue, this.producer);
    }

    public final ImmutableVersion withGitHash(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.gitHash, value)) {
            return this;
        }
        return new ImmutableVersion(this.major, this.minor, this.patch, value, this.producer);
    }

    public final ImmutableVersion withProducer(String value) {
        String newValue = Objects.requireNonNull(value, "producer");
        if (Objects.equals(this.producer, newValue)) {
            return this;
        }
        return new ImmutableVersion(this.major, this.minor, this.patch, this.gitHash, newValue);
    }

    public final ImmutableVersion withProducer(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.producer, value)) {
            return this;
        }
        return new ImmutableVersion(this.major, this.minor, this.patch, this.gitHash, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableVersion && this.equalsByValue((ImmutableVersion)another);
    }

    private boolean equalsByValue(ImmutableVersion another) {
        return this.major == another.major && this.minor == another.minor && this.patch == another.patch && Objects.equals(this.gitHash, another.gitHash) && Objects.equals(this.producer, another.producer);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.major;
        h += (h << 5) + this.minor;
        h += (h << 5) + this.patch;
        h += (h << 5) + Objects.hashCode(this.gitHash);
        h += (h << 5) + Objects.hashCode(this.producer);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Version{");
        builder.append("major=").append(this.major);
        builder.append(", ");
        builder.append("minor=").append(this.minor);
        builder.append(", ");
        builder.append("patch=").append(this.patch);
        if (this.gitHash != null) {
            builder.append(", ");
            builder.append("gitHash=").append(this.gitHash);
        }
        if (this.producer != null) {
            builder.append(", ");
            builder.append("producer=").append(this.producer);
        }
        return builder.append("}").toString();
    }

    public static ImmutableVersion copyOf(Plan.Version instance) {
        if (instance instanceof ImmutableVersion) {
            return (ImmutableVersion)instance;
        }
        return ImmutableVersion.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_MAJOR = 1L;
        private static final long INIT_BIT_MINOR = 2L;
        private static final long INIT_BIT_PATCH = 4L;
        private long initBits = 7L;
        private int major;
        private int minor;
        private int patch;
        private String gitHash;
        private String producer;

        private Builder() {
        }

        public final Builder from(Plan.Version instance) {
            Optional<String> producerOptional;
            Objects.requireNonNull(instance, "instance");
            this.major(instance.getMajor());
            this.minor(instance.getMinor());
            this.patch(instance.getPatch());
            Optional<String> gitHashOptional = instance.getGitHash();
            if (gitHashOptional.isPresent()) {
                this.gitHash(gitHashOptional);
            }
            if ((producerOptional = instance.getProducer()).isPresent()) {
                this.producer(producerOptional);
            }
            return this;
        }

        public final Builder major(int major) {
            this.major = major;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder minor(int minor) {
            this.minor = minor;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder patch(int patch) {
            this.patch = patch;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder gitHash(String gitHash) {
            this.gitHash = Objects.requireNonNull(gitHash, "gitHash");
            return this;
        }

        public final Builder gitHash(Optional<String> gitHash) {
            this.gitHash = gitHash.orElse(null);
            return this;
        }

        public final Builder producer(String producer) {
            this.producer = Objects.requireNonNull(producer, "producer");
            return this;
        }

        public final Builder producer(Optional<String> producer) {
            this.producer = producer.orElse(null);
            return this;
        }

        public ImmutableVersion build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableVersion(this.major, this.minor, this.patch, this.gitHash, this.producer);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("major");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("minor");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("patch");
            }
            return "Cannot build Version, some of required attributes are not set " + attributes;
        }
    }
}

