/*
 * Decompiled with CFR 0.152.
 */
package io.substrait.extension;

import io.substrait.extension.AbstractExtensionLookup;
import io.substrait.extension.BidiMap;
import io.substrait.extension.DefaultExtensionCatalog;
import io.substrait.extension.SimpleExtension;
import io.substrait.proto.ExtendedExpression;
import io.substrait.proto.Plan;
import io.substrait.proto.SimpleExtensionDeclaration;
import io.substrait.proto.SimpleExtensionURI;
import io.substrait.proto.SimpleExtensionURN;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class ExtensionCollector
extends AbstractExtensionLookup {
    private final BidiMap<Integer, SimpleExtension.FunctionAnchor> funcMap;
    private final BidiMap<Integer, SimpleExtension.TypeAnchor> typeMap;
    private final SimpleExtension.ExtensionCollection extensionCollection;
    private int counter = 0;

    private String getUriFromUrn(String urn) {
        return this.extensionCollection.getUriFromUrn(urn);
    }

    public ExtensionCollector() {
        this(DefaultExtensionCatalog.DEFAULT_COLLECTION);
    }

    public ExtensionCollector(SimpleExtension.ExtensionCollection extensionCollection) {
        super(new HashMap<Integer, SimpleExtension.FunctionAnchor>(), new HashMap<Integer, SimpleExtension.TypeAnchor>());
        if (extensionCollection == null) {
            throw new IllegalArgumentException("ExtensionCollection is required");
        }
        this.funcMap = new BidiMap(this.functionAnchorMap);
        this.typeMap = new BidiMap(this.typeAnchorMap);
        this.extensionCollection = extensionCollection;
    }

    public int getFunctionReference(SimpleExtension.Function declaration) {
        Integer i = this.funcMap.reverseGet(declaration.getAnchor());
        if (i != null) {
            return i;
        }
        ++this.counter;
        this.funcMap.put(this.counter, declaration.getAnchor());
        return this.counter;
    }

    public int getTypeReference(SimpleExtension.TypeAnchor typeAnchor) {
        Integer i = this.typeMap.reverseGet(typeAnchor);
        if (i != null) {
            return i;
        }
        ++this.counter;
        this.typeMap.put(this.counter, typeAnchor);
        return this.counter;
    }

    public void addExtensionsToPlan(Plan.Builder builder) {
        SimpleExtensions simpleExtensions = this.getExtensions();
        builder.addAllExtensionUrns(simpleExtensions.urns.values());
        builder.addAllExtensionUris(simpleExtensions.uris.values());
        builder.addAllExtensions(simpleExtensions.extensionList);
    }

    public void addExtensionsToExtendedExpression(ExtendedExpression.Builder builder) {
        SimpleExtensions simpleExtensions = this.getExtensions();
        builder.addAllExtensionUrns(simpleExtensions.urns.values());
        builder.addAllExtensionUris(simpleExtensions.uris.values());
        builder.addAllExtensions(simpleExtensions.extensionList);
    }

    private SimpleExtensions getExtensions() {
        SimpleExtensionDeclaration decl;
        SimpleExtensionURI uriObj;
        SimpleExtensionURN urnObj;
        String uri;
        String urn;
        AtomicInteger urnPos = new AtomicInteger(1);
        AtomicInteger uriPos = new AtomicInteger(1);
        HashMap<String, SimpleExtensionURN> urns = new HashMap<String, SimpleExtensionURN>();
        HashMap<String, SimpleExtensionURI> uris = new HashMap<String, SimpleExtensionURI>();
        ArrayList<SimpleExtensionDeclaration> extensionList = new ArrayList<SimpleExtensionDeclaration>();
        for (Map.Entry<Integer, SimpleExtension.FunctionAnchor> entry : this.funcMap.forwardEntrySet()) {
            urn = entry.getValue().urn();
            uri = this.getUriFromUrn(urn);
            urnObj = urns.computeIfAbsent(urn, k -> SimpleExtensionURN.newBuilder().setExtensionUrnAnchor(urnPos.getAndIncrement()).setUrn((String)k).build());
            uriObj = null;
            if (uri != null) {
                uriObj = uris.computeIfAbsent(uri, k -> SimpleExtensionURI.newBuilder().setExtensionUriAnchor(uriPos.getAndIncrement()).setUri((String)k).build());
            }
            SimpleExtensionDeclaration.ExtensionFunction.Builder funcBuilder = SimpleExtensionDeclaration.ExtensionFunction.newBuilder().setFunctionAnchor(entry.getKey()).setName(entry.getValue().key()).setExtensionUrnReference(urnObj.getExtensionUrnAnchor());
            if (uriObj != null) {
                funcBuilder.setExtensionUriReference(uriObj.getExtensionUriAnchor());
            }
            decl = SimpleExtensionDeclaration.newBuilder().setExtensionFunction(funcBuilder).build();
            extensionList.add(decl);
        }
        for (Map.Entry<Integer, SimpleExtension.Anchor> entry : this.typeMap.forwardEntrySet()) {
            urn = ((SimpleExtension.TypeAnchor)entry.getValue()).urn();
            uri = this.getUriFromUrn(urn);
            urnObj = urns.computeIfAbsent(urn, k -> SimpleExtensionURN.newBuilder().setExtensionUrnAnchor(urnPos.getAndIncrement()).setUrn((String)k).build());
            uriObj = null;
            if (uri != null) {
                uriObj = uris.computeIfAbsent(uri, k -> SimpleExtensionURI.newBuilder().setExtensionUriAnchor(uriPos.getAndIncrement()).setUri((String)k).build());
            }
            SimpleExtensionDeclaration.ExtensionType.Builder typeBuilder = SimpleExtensionDeclaration.ExtensionType.newBuilder().setTypeAnchor(entry.getKey()).setName(((SimpleExtension.TypeAnchor)entry.getValue()).key()).setExtensionUrnReference(urnObj.getExtensionUrnAnchor());
            if (uriObj != null) {
                typeBuilder.setExtensionUriReference(uriObj.getExtensionUriAnchor());
            }
            decl = SimpleExtensionDeclaration.newBuilder().setExtensionType(typeBuilder).build();
            extensionList.add(decl);
        }
        return new SimpleExtensions(urns, uris, extensionList);
    }

    private static final class SimpleExtensions {
        final HashMap<String, SimpleExtensionURN> urns;
        final HashMap<String, SimpleExtensionURI> uris;
        final ArrayList<SimpleExtensionDeclaration> extensionList;

        SimpleExtensions(HashMap<String, SimpleExtensionURN> urns, HashMap<String, SimpleExtensionURI> uris, ArrayList<SimpleExtensionDeclaration> extensionList) {
            this.urns = urns;
            this.uris = uris;
            this.extensionList = extensionList;
        }
    }
}

