/*
 * Decompiled with CFR 0.152.
 */
package io.substrait.relation;

import io.substrait.expression.Expression;
import io.substrait.relation.Aggregate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public final class ImmutableGrouping
extends Aggregate.Grouping {
    private final List<Expression> expressions;

    private ImmutableGrouping(List<Expression> expressions) {
        this.expressions = expressions;
    }

    @Override
    public List<Expression> getExpressions() {
        return this.expressions;
    }

    public final ImmutableGrouping withExpressions(Expression ... elements) {
        List<Expression> newValue = ImmutableGrouping.createUnmodifiableList(false, ImmutableGrouping.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableGrouping(newValue);
    }

    public final ImmutableGrouping withExpressions(Iterable<? extends Expression> elements) {
        if (this.expressions == elements) {
            return this;
        }
        List<Expression> newValue = ImmutableGrouping.createUnmodifiableList(false, ImmutableGrouping.createSafeList(elements, true, false));
        return new ImmutableGrouping(newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGrouping && this.equalsByValue((ImmutableGrouping)another);
    }

    private boolean equalsByValue(ImmutableGrouping another) {
        return this.expressions.equals(another.expressions);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.expressions.hashCode();
        return h;
    }

    public String toString() {
        return "Grouping{expressions=" + this.expressions + "}";
    }

    public static ImmutableGrouping copyOf(Aggregate.Grouping instance) {
        if (instance instanceof ImmutableGrouping) {
            return (ImmutableGrouping)instance;
        }
        return ImmutableGrouping.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<? extends T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private List<Expression> expressions = new ArrayList<Expression>();

        private Builder() {
        }

        public final Builder from(Aggregate.Grouping instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllExpressions(instance.getExpressions());
            return this;
        }

        public final Builder addExpressions(Expression element) {
            this.expressions.add(Objects.requireNonNull(element, "expressions element"));
            return this;
        }

        public final Builder addExpressions(Expression ... elements) {
            for (Expression element : elements) {
                this.expressions.add(Objects.requireNonNull(element, "expressions element"));
            }
            return this;
        }

        public final Builder expressions(Iterable<? extends Expression> elements) {
            this.expressions.clear();
            return this.addAllExpressions(elements);
        }

        public final Builder addAllExpressions(Iterable<? extends Expression> elements) {
            for (Expression expression : elements) {
                this.expressions.add(Objects.requireNonNull(expression, "expressions element"));
            }
            return this;
        }

        public ImmutableGrouping build() {
            return new ImmutableGrouping(ImmutableGrouping.createUnmodifiableList(true, this.expressions));
        }
    }
}

