/*
 * Decompiled with CFR 0.152.
 */
package io.substrait.hint;

import io.substrait.hint.Hint;
import java.util.ArrayList;
import java.util.Objects;

public final class ImmutableLoadedComputation
extends Hint.LoadedComputation {
    private final int computationId;
    private final Hint.ComputationType computationType;

    private ImmutableLoadedComputation(int computationId, Hint.ComputationType computationType) {
        this.computationId = computationId;
        this.computationType = computationType;
    }

    @Override
    public int computationId() {
        return this.computationId;
    }

    @Override
    public Hint.ComputationType computationType() {
        return this.computationType;
    }

    public final ImmutableLoadedComputation withComputationId(int value) {
        if (this.computationId == value) {
            return this;
        }
        return new ImmutableLoadedComputation(value, this.computationType);
    }

    public final ImmutableLoadedComputation withComputationType(Hint.ComputationType value) {
        Hint.ComputationType newValue = Objects.requireNonNull(value, "computationType");
        if (this.computationType == newValue) {
            return this;
        }
        return new ImmutableLoadedComputation(this.computationId, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableLoadedComputation && this.equalsByValue((ImmutableLoadedComputation)another);
    }

    private boolean equalsByValue(ImmutableLoadedComputation another) {
        return this.computationId == another.computationId && this.computationType.equals((Object)another.computationType);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.computationId;
        h += (h << 5) + this.computationType.hashCode();
        return h;
    }

    public String toString() {
        return "LoadedComputation{computationId=" + this.computationId + ", computationType=" + (Object)((Object)this.computationType) + "}";
    }

    public static ImmutableLoadedComputation copyOf(Hint.LoadedComputation instance) {
        if (instance instanceof ImmutableLoadedComputation) {
            return (ImmutableLoadedComputation)instance;
        }
        return ImmutableLoadedComputation.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_COMPUTATION_ID = 1L;
        private static final long INIT_BIT_COMPUTATION_TYPE = 2L;
        private long initBits = 3L;
        private int computationId;
        private Hint.ComputationType computationType;

        private Builder() {
        }

        public final Builder from(Hint.LoadedComputation instance) {
            Objects.requireNonNull(instance, "instance");
            this.computationId(instance.computationId());
            this.computationType(instance.computationType());
            return this;
        }

        public final Builder computationId(int computationId) {
            this.computationId = computationId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder computationType(Hint.ComputationType computationType) {
            this.computationType = Objects.requireNonNull(computationType, "computationType");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableLoadedComputation build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableLoadedComputation(this.computationId, this.computationType);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("computationId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("computationType");
            }
            return "Cannot build LoadedComputation, some of required attributes are not set " + attributes;
        }
    }
}

