/*
 * Decompiled with CFR 0.152.
 */
package io.substrait.hint;

import io.substrait.extension.AdvancedExtension;
import io.substrait.hint.Hint;
import io.substrait.relation.HasExtension;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class ImmutableHint
extends Hint {
    private final AdvancedExtension extension;
    private final String alias;
    private final List<String> outputNames;
    private final Hint.Stats stats;
    private final Hint.RuntimeConstraint runtimeConstraint;
    private final List<Hint.LoadedComputation> loadedComputations;
    private final List<Hint.SavedComputation> savedComputations;

    private ImmutableHint(AdvancedExtension extension, String alias, List<String> outputNames, Hint.Stats stats, Hint.RuntimeConstraint runtimeConstraint, List<Hint.LoadedComputation> loadedComputations, List<Hint.SavedComputation> savedComputations) {
        this.extension = extension;
        this.alias = alias;
        this.outputNames = outputNames;
        this.stats = stats;
        this.runtimeConstraint = runtimeConstraint;
        this.loadedComputations = loadedComputations;
        this.savedComputations = savedComputations;
    }

    @Override
    public Optional<AdvancedExtension> getExtension() {
        return Optional.ofNullable(this.extension);
    }

    @Override
    public Optional<String> getAlias() {
        return Optional.ofNullable(this.alias);
    }

    @Override
    public List<String> getOutputNames() {
        return this.outputNames;
    }

    @Override
    public Optional<Hint.Stats> getStats() {
        return Optional.ofNullable(this.stats);
    }

    @Override
    public Optional<Hint.RuntimeConstraint> getRuntimeConstraint() {
        return Optional.ofNullable(this.runtimeConstraint);
    }

    @Override
    public List<Hint.LoadedComputation> getLoadedComputations() {
        return this.loadedComputations;
    }

    @Override
    public List<Hint.SavedComputation> getSavedComputations() {
        return this.savedComputations;
    }

    public final ImmutableHint withExtension(AdvancedExtension value) {
        AdvancedExtension newValue = Objects.requireNonNull(value, "extension");
        if (this.extension == newValue) {
            return this;
        }
        return new ImmutableHint(newValue, this.alias, this.outputNames, this.stats, this.runtimeConstraint, this.loadedComputations, this.savedComputations);
    }

    public final ImmutableHint withExtension(Optional<? extends AdvancedExtension> optional) {
        AdvancedExtension value = optional.orElse(null);
        if (this.extension == value) {
            return this;
        }
        return new ImmutableHint(value, this.alias, this.outputNames, this.stats, this.runtimeConstraint, this.loadedComputations, this.savedComputations);
    }

    public final ImmutableHint withAlias(String value) {
        String newValue = Objects.requireNonNull(value, "alias");
        if (Objects.equals(this.alias, newValue)) {
            return this;
        }
        return new ImmutableHint(this.extension, newValue, this.outputNames, this.stats, this.runtimeConstraint, this.loadedComputations, this.savedComputations);
    }

    public final ImmutableHint withAlias(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.alias, value)) {
            return this;
        }
        return new ImmutableHint(this.extension, value, this.outputNames, this.stats, this.runtimeConstraint, this.loadedComputations, this.savedComputations);
    }

    public final ImmutableHint withOutputNames(String ... elements) {
        List<String> newValue = ImmutableHint.createUnmodifiableList(false, ImmutableHint.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableHint(this.extension, this.alias, newValue, this.stats, this.runtimeConstraint, this.loadedComputations, this.savedComputations);
    }

    public final ImmutableHint withOutputNames(Iterable<String> elements) {
        if (this.outputNames == elements) {
            return this;
        }
        List<String> newValue = ImmutableHint.createUnmodifiableList(false, ImmutableHint.createSafeList(elements, true, false));
        return new ImmutableHint(this.extension, this.alias, newValue, this.stats, this.runtimeConstraint, this.loadedComputations, this.savedComputations);
    }

    public final ImmutableHint withStats(Hint.Stats value) {
        Hint.Stats newValue = Objects.requireNonNull(value, "stats");
        if (this.stats == newValue) {
            return this;
        }
        return new ImmutableHint(this.extension, this.alias, this.outputNames, newValue, this.runtimeConstraint, this.loadedComputations, this.savedComputations);
    }

    public final ImmutableHint withStats(Optional<? extends Hint.Stats> optional) {
        Hint.Stats value = optional.orElse(null);
        if (this.stats == value) {
            return this;
        }
        return new ImmutableHint(this.extension, this.alias, this.outputNames, value, this.runtimeConstraint, this.loadedComputations, this.savedComputations);
    }

    public final ImmutableHint withRuntimeConstraint(Hint.RuntimeConstraint value) {
        Hint.RuntimeConstraint newValue = Objects.requireNonNull(value, "runtimeConstraint");
        if (this.runtimeConstraint == newValue) {
            return this;
        }
        return new ImmutableHint(this.extension, this.alias, this.outputNames, this.stats, newValue, this.loadedComputations, this.savedComputations);
    }

    public final ImmutableHint withRuntimeConstraint(Optional<? extends Hint.RuntimeConstraint> optional) {
        Hint.RuntimeConstraint value = optional.orElse(null);
        if (this.runtimeConstraint == value) {
            return this;
        }
        return new ImmutableHint(this.extension, this.alias, this.outputNames, this.stats, value, this.loadedComputations, this.savedComputations);
    }

    public final ImmutableHint withLoadedComputations(Hint.LoadedComputation ... elements) {
        List<Hint.LoadedComputation> newValue = ImmutableHint.createUnmodifiableList(false, ImmutableHint.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableHint(this.extension, this.alias, this.outputNames, this.stats, this.runtimeConstraint, newValue, this.savedComputations);
    }

    public final ImmutableHint withLoadedComputations(Iterable<? extends Hint.LoadedComputation> elements) {
        if (this.loadedComputations == elements) {
            return this;
        }
        List<Hint.LoadedComputation> newValue = ImmutableHint.createUnmodifiableList(false, ImmutableHint.createSafeList(elements, true, false));
        return new ImmutableHint(this.extension, this.alias, this.outputNames, this.stats, this.runtimeConstraint, newValue, this.savedComputations);
    }

    public final ImmutableHint withSavedComputations(Hint.SavedComputation ... elements) {
        List<Hint.SavedComputation> newValue = ImmutableHint.createUnmodifiableList(false, ImmutableHint.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableHint(this.extension, this.alias, this.outputNames, this.stats, this.runtimeConstraint, this.loadedComputations, newValue);
    }

    public final ImmutableHint withSavedComputations(Iterable<? extends Hint.SavedComputation> elements) {
        if (this.savedComputations == elements) {
            return this;
        }
        List<Hint.SavedComputation> newValue = ImmutableHint.createUnmodifiableList(false, ImmutableHint.createSafeList(elements, true, false));
        return new ImmutableHint(this.extension, this.alias, this.outputNames, this.stats, this.runtimeConstraint, this.loadedComputations, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableHint && this.equalsByValue((ImmutableHint)another);
    }

    private boolean equalsByValue(ImmutableHint another) {
        return Objects.equals(this.extension, another.extension) && Objects.equals(this.alias, another.alias) && this.outputNames.equals(another.outputNames) && Objects.equals(this.stats, another.stats) && Objects.equals(this.runtimeConstraint, another.runtimeConstraint) && this.loadedComputations.equals(another.loadedComputations) && this.savedComputations.equals(another.savedComputations);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.extension);
        h += (h << 5) + Objects.hashCode(this.alias);
        h += (h << 5) + this.outputNames.hashCode();
        h += (h << 5) + Objects.hashCode(this.stats);
        h += (h << 5) + Objects.hashCode(this.runtimeConstraint);
        h += (h << 5) + this.loadedComputations.hashCode();
        h += (h << 5) + this.savedComputations.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Hint{");
        if (this.extension != null) {
            builder.append("extension=").append(this.extension);
        }
        if (this.alias != null) {
            if (builder.length() > 5) {
                builder.append(", ");
            }
            builder.append("alias=").append(this.alias);
        }
        if (builder.length() > 5) {
            builder.append(", ");
        }
        builder.append("outputNames=").append(this.outputNames);
        if (this.stats != null) {
            builder.append(", ");
            builder.append("stats=").append(this.stats);
        }
        if (this.runtimeConstraint != null) {
            builder.append(", ");
            builder.append("runtimeConstraint=").append(this.runtimeConstraint);
        }
        builder.append(", ");
        builder.append("loadedComputations=").append(this.loadedComputations);
        builder.append(", ");
        builder.append("savedComputations=").append(this.savedComputations);
        return builder.append("}").toString();
    }

    public static ImmutableHint copyOf(Hint instance) {
        if (instance instanceof ImmutableHint) {
            return (ImmutableHint)instance;
        }
        return ImmutableHint.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<? extends T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private AdvancedExtension extension;
        private String alias;
        private List<String> outputNames = new ArrayList<String>();
        private Hint.Stats stats;
        private Hint.RuntimeConstraint runtimeConstraint;
        private List<Hint.LoadedComputation> loadedComputations = new ArrayList<Hint.LoadedComputation>();
        private List<Hint.SavedComputation> savedComputations = new ArrayList<Hint.SavedComputation>();

        private Builder() {
        }

        public final Builder from(HasExtension instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        public final Builder from(Hint instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        private void mergeInternal(Object object) {
            HasExtension instance;
            Optional<AdvancedExtension> extensionOptional;
            long bits = 0L;
            if (object instanceof HasExtension && (extensionOptional = (instance = (HasExtension)object).getExtension()).isPresent()) {
                this.extension(extensionOptional);
            }
            if (object instanceof Hint) {
                Optional<Hint.RuntimeConstraint> runtimeConstraintOptional;
                instance = (Hint)object;
                this.addAllLoadedComputations(((Hint)instance).getLoadedComputations());
                Optional<String> aliasOptional = ((Hint)instance).getAlias();
                if (aliasOptional.isPresent()) {
                    this.alias(aliasOptional);
                }
                this.addAllSavedComputations(((Hint)instance).getSavedComputations());
                this.addAllOutputNames(((Hint)instance).getOutputNames());
                Optional<Hint.Stats> statsOptional = ((Hint)instance).getStats();
                if (statsOptional.isPresent()) {
                    this.stats(statsOptional);
                }
                if ((runtimeConstraintOptional = ((Hint)instance).getRuntimeConstraint()).isPresent()) {
                    this.runtimeConstraint(runtimeConstraintOptional);
                }
            }
        }

        public final Builder extension(AdvancedExtension extension) {
            this.extension = Objects.requireNonNull(extension, "extension");
            return this;
        }

        public final Builder extension(Optional<? extends AdvancedExtension> extension) {
            this.extension = extension.orElse(null);
            return this;
        }

        public final Builder alias(String alias) {
            this.alias = Objects.requireNonNull(alias, "alias");
            return this;
        }

        public final Builder alias(Optional<String> alias) {
            this.alias = alias.orElse(null);
            return this;
        }

        public final Builder addOutputNames(String element) {
            this.outputNames.add(Objects.requireNonNull(element, "outputNames element"));
            return this;
        }

        public final Builder addOutputNames(String ... elements) {
            for (String element : elements) {
                this.outputNames.add(Objects.requireNonNull(element, "outputNames element"));
            }
            return this;
        }

        public final Builder outputNames(Iterable<String> elements) {
            this.outputNames.clear();
            return this.addAllOutputNames(elements);
        }

        public final Builder addAllOutputNames(Iterable<String> elements) {
            for (String element : elements) {
                this.outputNames.add(Objects.requireNonNull(element, "outputNames element"));
            }
            return this;
        }

        public final Builder stats(Hint.Stats stats) {
            this.stats = Objects.requireNonNull(stats, "stats");
            return this;
        }

        public final Builder stats(Optional<? extends Hint.Stats> stats) {
            this.stats = stats.orElse(null);
            return this;
        }

        public final Builder runtimeConstraint(Hint.RuntimeConstraint runtimeConstraint) {
            this.runtimeConstraint = Objects.requireNonNull(runtimeConstraint, "runtimeConstraint");
            return this;
        }

        public final Builder runtimeConstraint(Optional<? extends Hint.RuntimeConstraint> runtimeConstraint) {
            this.runtimeConstraint = runtimeConstraint.orElse(null);
            return this;
        }

        public final Builder addLoadedComputations(Hint.LoadedComputation element) {
            this.loadedComputations.add(Objects.requireNonNull(element, "loadedComputations element"));
            return this;
        }

        public final Builder addLoadedComputations(Hint.LoadedComputation ... elements) {
            for (Hint.LoadedComputation element : elements) {
                this.loadedComputations.add(Objects.requireNonNull(element, "loadedComputations element"));
            }
            return this;
        }

        public final Builder loadedComputations(Iterable<? extends Hint.LoadedComputation> elements) {
            this.loadedComputations.clear();
            return this.addAllLoadedComputations(elements);
        }

        public final Builder addAllLoadedComputations(Iterable<? extends Hint.LoadedComputation> elements) {
            for (Hint.LoadedComputation loadedComputation : elements) {
                this.loadedComputations.add(Objects.requireNonNull(loadedComputation, "loadedComputations element"));
            }
            return this;
        }

        public final Builder addSavedComputations(Hint.SavedComputation element) {
            this.savedComputations.add(Objects.requireNonNull(element, "savedComputations element"));
            return this;
        }

        public final Builder addSavedComputations(Hint.SavedComputation ... elements) {
            for (Hint.SavedComputation element : elements) {
                this.savedComputations.add(Objects.requireNonNull(element, "savedComputations element"));
            }
            return this;
        }

        public final Builder savedComputations(Iterable<? extends Hint.SavedComputation> elements) {
            this.savedComputations.clear();
            return this.addAllSavedComputations(elements);
        }

        public final Builder addAllSavedComputations(Iterable<? extends Hint.SavedComputation> elements) {
            for (Hint.SavedComputation savedComputation : elements) {
                this.savedComputations.add(Objects.requireNonNull(savedComputation, "savedComputations element"));
            }
            return this;
        }

        public ImmutableHint build() {
            return new ImmutableHint(this.extension, this.alias, ImmutableHint.createUnmodifiableList(true, this.outputNames), this.stats, this.runtimeConstraint, ImmutableHint.createUnmodifiableList(true, this.loadedComputations), ImmutableHint.createUnmodifiableList(true, this.savedComputations));
        }
    }
}

