/*
 * Decompiled with CFR 0.152.
 */
package io.substrait.extension;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class BidiMap<T1, T2> {
    private final Map<T1, T2> forwardMap;
    private final Map<T2, T1> reverseMap;

    BidiMap(Map<T1, T2> forwardMap) {
        this.forwardMap = forwardMap;
        this.reverseMap = new HashMap<T2, T1>();
        for (Map.Entry<T1, T2> entry : forwardMap.entrySet()) {
            this.reverseMap.put(entry.getValue(), entry.getKey());
        }
    }

    BidiMap() {
        this.forwardMap = new HashMap<T1, T2>();
        this.reverseMap = new HashMap<T2, T1>();
    }

    T2 get(T1 t1) {
        return this.forwardMap.get(t1);
    }

    T1 reverseGet(T2 t2) {
        return this.reverseMap.get(t2);
    }

    void put(T1 t1, T2 t2) {
        T2 existingForward = this.forwardMap.get(t1);
        T1 existingReverse = this.reverseMap.get(t2);
        if (existingForward != null && !existingForward.equals(t2)) {
            throw new IllegalArgumentException("Key already exists in map with different value");
        }
        if (existingReverse != null && !existingReverse.equals(t1)) {
            throw new IllegalArgumentException("Key already exists in map with different value");
        }
        this.forwardMap.put(t1, t2);
        this.reverseMap.put(t2, t1);
    }

    void merge(BidiMap<T1, T2> other) {
        for (Map.Entry<T1, T2> entry : other.forwardEntrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    Set<Map.Entry<T1, T2>> forwardEntrySet() {
        return this.forwardMap.entrySet();
    }

    Set<Map.Entry<T2, T1>> reverseEntrySet() {
        return this.reverseMap.entrySet();
    }
}

