/*
 * Decompiled with CFR 0.152.
 */
package io.streamthoughts.kafka.connect.filepulse.state.internal;

import io.streamthoughts.kafka.connect.filepulse.state.internal.ResourceDisposer;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;

public class OpaqueMemoryResource<T>
implements AutoCloseable {
    private final T resource;
    private final ResourceDisposer<Exception> disposer;
    private final AtomicBoolean closed = new AtomicBoolean(false);

    public OpaqueMemoryResource(T resource, ResourceDisposer<Exception> disposer) {
        this.resource = Objects.requireNonNull(resource, "resource should not be null");
        this.disposer = Objects.requireNonNull(disposer, "disposer should not be null");
    }

    public T getResource() {
        return this.resource;
    }

    @Override
    public void close() throws Exception {
        if (this.closed.compareAndSet(false, true)) {
            this.disposer.dispose();
        }
    }
}

