/*
 * Decompiled with CFR 0.152.
 */
package io.streamthoughts.kafka.connect.filepulse.state;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;

public class KafkaFileObjectStateBackingStoreConfig
extends AbstractConfig {
    private static final String GROUP = "KafkaFileObjectStateBackingStore";
    public static final String TASKS_FILE_STATUS_STORAGE_TOPIC_CONFIG = "tasks.file.status.storage.topic";
    private static final String TASKS_FILE_STATUS_STORAGE_TOPIC_DOC = "The topic name which is used to report file states.";
    private static final String TASKS_FILE_STATUS_STORAGE_TOPIC_DEFAULT = "connect-file-pulse-status";
    public static final String TASKS_FILE_STATUS_STORAGE_NAME_CONFIG = "tasks.file.status.storage.name";
    private static final String TASKS_FILE_STATUS_STORAGE_NAME_DOC = "The reporter identifier to be used by tasks and connector to report and monitor file progression.";
    public static final String TASKS_FILE_STATUS_STORAGE_BOOTSTRAP_SERVERS_CONFIG = "tasks.file.status.storage.bootstrap.servers";
    public static final String TASKS_FILE_STATUS_STORAGE_CONSUMER_ENABLED_CONFIG = "tasks.file.status.storage.consumer.enabled";
    public static final String TASKS_FILE_STATUS_STORAGE_CONSUMER_ENABLED_DOC = "Boolean to indicate if the storage should consume the status topic.";
    public static final String TASKS_FILE_STATUS_STORAGE_TOPIC_PARTITIONS_CONFIG = "tasks.file.status.storage.topic.partitions";
    public static final String TASKS_FILE_STATUS_STORAGE_TOPIC_PARTITIONS_DOC = "The number of partitions to be used for the status storage topic.";
    public static final String TASKS_FILE_STATUS_STORAGE_TOPIC_REPLICATION_FACTOR_CONFIG = "tasks.file.status.storage.topic.replication.factor";
    public static final String TASKS_FILE_STATUS_STORAGE_TOPIC_REPLICATION_FACTOR_DOC = "The replication factor to be used for the status storage topic.";

    public KafkaFileObjectStateBackingStoreConfig(Map<?, ?> originals) {
        super(KafkaFileObjectStateBackingStoreConfig.configDef(), originals, false);
    }

    public boolean getTaskStorageConsumerEnabled() {
        return this.getBoolean(TASKS_FILE_STATUS_STORAGE_CONSUMER_ENABLED_CONFIG);
    }

    public String getTaskStorageTopic() {
        return this.getString(TASKS_FILE_STATUS_STORAGE_TOPIC_CONFIG);
    }

    public String getTaskStorageName() {
        return this.getString(TASKS_FILE_STATUS_STORAGE_NAME_CONFIG);
    }

    public Map<String, Object> getTaskStorageConfigs() {
        HashMap<String, Object> configs = new HashMap<String, Object>();
        configs.put("bootstrap.servers", this.getInternalBootstrapServers());
        configs.putAll(this.getInternalKafkaConsumerConfigs());
        configs.putAll(this.getInternalKafkaProducerConfigs());
        return configs;
    }

    private String getInternalBootstrapServers() {
        return this.getString(TASKS_FILE_STATUS_STORAGE_BOOTSTRAP_SERVERS_CONFIG);
    }

    private Map<String, Object> getInternalKafkaConsumerConfigs() {
        return this.originalsWithPrefix("tasks.file.status.storage.consumer.");
    }

    private Map<String, Object> getInternalKafkaProducerConfigs() {
        return this.originalsWithPrefix("tasks.file.status.storage.producer.");
    }

    Optional<Integer> getTopicPartitions() {
        return Optional.ofNullable(this.getInt(TASKS_FILE_STATUS_STORAGE_TOPIC_PARTITIONS_CONFIG));
    }

    Optional<Short> getReplicationFactor() {
        return Optional.ofNullable(this.getShort(TASKS_FILE_STATUS_STORAGE_TOPIC_REPLICATION_FACTOR_CONFIG));
    }

    static ConfigDef configDef() {
        int groupCounter = 0;
        return new ConfigDef().define(TASKS_FILE_STATUS_STORAGE_TOPIC_CONFIG, ConfigDef.Type.STRING, (Object)TASKS_FILE_STATUS_STORAGE_TOPIC_DEFAULT, ConfigDef.Importance.HIGH, TASKS_FILE_STATUS_STORAGE_TOPIC_DOC, GROUP, groupCounter++, ConfigDef.Width.NONE, TASKS_FILE_STATUS_STORAGE_TOPIC_CONFIG).define(TASKS_FILE_STATUS_STORAGE_BOOTSTRAP_SERVERS_CONFIG, ConfigDef.Type.STRING, ConfigDef.Importance.HIGH, "A list of host/port pairs to use for establishing the initial connection to the Kafka cluster. The client will make use of all servers irrespective of which servers are specified here for bootstrapping&mdash;this list only impacts the initial hosts used to discover the full set of servers. This list should be in the form <code>host1:port1,host2:port2,...</code>. Since these servers are just used for the initial connection to discover the full cluster membership (which may change dynamically), this list need not contain the full set of servers (you may want more than one, though, in case a server is down).", GROUP, groupCounter++, ConfigDef.Width.NONE, TASKS_FILE_STATUS_STORAGE_BOOTSTRAP_SERVERS_CONFIG).define(TASKS_FILE_STATUS_STORAGE_TOPIC_REPLICATION_FACTOR_CONFIG, ConfigDef.Type.SHORT, null, ConfigDef.Importance.MEDIUM, TASKS_FILE_STATUS_STORAGE_TOPIC_REPLICATION_FACTOR_DOC, GROUP, groupCounter++, ConfigDef.Width.NONE, TASKS_FILE_STATUS_STORAGE_TOPIC_REPLICATION_FACTOR_CONFIG).define(TASKS_FILE_STATUS_STORAGE_TOPIC_PARTITIONS_CONFIG, ConfigDef.Type.INT, null, ConfigDef.Importance.MEDIUM, TASKS_FILE_STATUS_STORAGE_TOPIC_PARTITIONS_DOC, GROUP, groupCounter++, ConfigDef.Width.NONE, TASKS_FILE_STATUS_STORAGE_TOPIC_PARTITIONS_CONFIG).define(TASKS_FILE_STATUS_STORAGE_NAME_CONFIG, ConfigDef.Type.STRING, ConfigDef.Importance.HIGH, TASKS_FILE_STATUS_STORAGE_NAME_DOC, GROUP, groupCounter++, ConfigDef.Width.NONE, TASKS_FILE_STATUS_STORAGE_NAME_CONFIG).define(TASKS_FILE_STATUS_STORAGE_CONSUMER_ENABLED_CONFIG, ConfigDef.Type.BOOLEAN, (Object)true, ConfigDef.Importance.HIGH, TASKS_FILE_STATUS_STORAGE_CONSUMER_ENABLED_DOC, GROUP, groupCounter++, ConfigDef.Width.NONE, TASKS_FILE_STATUS_STORAGE_CONSUMER_ENABLED_CONFIG);
    }
}

