/*
 * Decompiled with CFR 0.152.
 */
package io.streamthoughts.kafka.connect.filepulse.state;

import com.jsoniter.JsonIterator;
import com.jsoniter.output.EncodingMode;
import com.jsoniter.output.JsonStream;
import com.jsoniter.spi.JsoniterSpi;
import io.streamthoughts.kafka.connect.filepulse.source.FileObject;
import io.streamthoughts.kafka.connect.filepulse.source.FileObjectMeta;
import io.streamthoughts.kafka.connect.filepulse.source.GenericFileObjectMeta;
import io.streamthoughts.kafka.connect.filepulse.storage.StateSerde;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import org.apache.kafka.common.errors.SerializationException;

public class FileObjectSerde
implements StateSerde<FileObject> {
    public byte[] serialize(FileObject object) {
        if (object == null) {
            return null;
        }
        try {
            String serialized = JsonStream.serialize((Object)object);
            return serialized.getBytes(StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            throw new SerializationException("Failed to serialized object '" + object + "'", (Throwable)e);
        }
    }

    public FileObject deserialize(byte[] data) {
        JsonIterator iterator = JsonIterator.parse((byte[])data);
        try {
            return (FileObject)iterator.read(FileObject.class);
        }
        catch (IOException e) {
            throw new SerializationException((Throwable)e);
        }
    }

    static {
        JsoniterSpi.registerTypeImplementation(FileObjectMeta.class, GenericFileObjectMeta.class);
        JsoniterSpi.registerTypeEncoder(URI.class, (obj, stream) -> stream.writeVal(obj.toString()));
        JsoniterSpi.registerTypeDecoder(URI.class, iter -> URI.create(iter.readString()));
        JsonStream.setMode((EncodingMode)EncodingMode.REFLECTION_MODE);
    }
}

