/*
 * Decompiled with CFR 0.152.
 */
package io.streamthoughts.kafka.connect.filepulse.fs.filter;

import io.streamthoughts.kafka.connect.filepulse.fs.PredicateFileListFilter;
import io.streamthoughts.kafka.connect.filepulse.source.FileObjectMeta;
import java.util.Map;
import java.util.function.Predicate;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SizeFileListFilter
extends PredicateFileListFilter {
    private static final String GROUP = "SizeFileListFilter";
    private static final Logger LOG = LoggerFactory.getLogger(SizeFileListFilter.class);
    public static final String FILE_MINIMUM_SIZE_MS_CONFIG = "file.filter.minimum.size.bytes";
    private static final String FILE_MINIMUM_AGE_MS_DOC = "The minimum size in bytes of a file to be eligible for processing (default: 0).";
    private static final long FILE_MINIMUM_SIZE_MS_DEFAULT = 0L;
    public static final String FILE_MAXIMUM_SIZE_MS_CONFIG = "file.filter.maximum.size.bytes";
    private static final String FILE_MAXIMUM_SIZE_MS_DOC = "The maximum size in bytes of a file to be eligible for processing (default: Long.MAX_VALUE).";
    private static final long FILE_MAXIMUM_SIZE_MS_DEFAULT = Long.MAX_VALUE;
    private Predicate<FileObjectMeta> minimumSizePredicate;
    private Predicate<FileObjectMeta> maximumSizePredicate;

    public void configure(Map<String, ?> props) {
        AbstractConfig abstractConfig = new AbstractConfig(SizeFileListFilter.getConfigDef(), props);
        Long minimumSizeBytes = abstractConfig.getLong(FILE_MINIMUM_SIZE_MS_CONFIG);
        this.minimumSizePredicate = it -> it.contentLength() >= minimumSizeBytes;
        Long maximumSizeBytes = abstractConfig.getLong(FILE_MAXIMUM_SIZE_MS_CONFIG);
        this.maximumSizePredicate = it -> it.contentLength() <= maximumSizeBytes;
    }

    public boolean test(FileObjectMeta meta) {
        if (!this.minimumSizePredicate.test(meta)) {
            LOG.debug("Filtered '{}'. File do not match minimum size bytes predicate.", (Object)meta);
            return false;
        }
        if (!this.maximumSizePredicate.test(meta)) {
            LOG.debug("Filtered '{}'. File do not match maximum size bytes  predicate.", (Object)meta);
            return false;
        }
        return true;
    }

    private static ConfigDef getConfigDef() {
        int groupCounter = 0;
        return new ConfigDef().define(FILE_MINIMUM_SIZE_MS_CONFIG, ConfigDef.Type.LONG, (Object)0L, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0), ConfigDef.Importance.HIGH, FILE_MINIMUM_AGE_MS_DOC, GROUP, groupCounter++, ConfigDef.Width.NONE, FILE_MINIMUM_SIZE_MS_CONFIG).define(FILE_MAXIMUM_SIZE_MS_CONFIG, ConfigDef.Type.LONG, (Object)Long.MAX_VALUE, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0), ConfigDef.Importance.HIGH, FILE_MAXIMUM_SIZE_MS_DOC, GROUP, groupCounter++, ConfigDef.Width.NONE, FILE_MAXIMUM_SIZE_MS_CONFIG);
    }
}

