/*
 * Decompiled with CFR 0.152.
 */
package io.streamthoughts.kafka.connect.filepulse.fs;

import io.streamthoughts.kafka.connect.filepulse.source.FileObjectMeta;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

public interface TaskFileOrder
extends Function<Collection<FileObjectMeta>, List<FileObjectMeta>> {
    public static TaskFileOrder findBuiltInByName(String name) {
        return BuiltIn.valueOf(name).get();
    }

    public List<FileObjectMeta> sort(Collection<FileObjectMeta> var1);

    @Override
    default public List<FileObjectMeta> apply(Collection<FileObjectMeta> objects) {
        return this.sort(objects);
    }

    public static class AbstractTaskFileOrder
    implements TaskFileOrder {
        private final Comparator<FileObjectMeta> comparator;

        protected AbstractTaskFileOrder(Comparator<FileObjectMeta> comparator) {
            this.comparator = comparator;
        }

        @Override
        public List<FileObjectMeta> sort(Collection<FileObjectMeta> objects) {
            return objects.stream().sorted(this.comparator).collect(Collectors.toList());
        }
    }

    public static enum BuiltIn {
        LAST_MODIFIED(new AbstractTaskFileOrder(Comparator.comparingLong(FileObjectMeta::lastModified))),
        URI(new AbstractTaskFileOrder(Comparator.comparing(FileObjectMeta::uri))),
        CONTENT_LENGTH(new AbstractTaskFileOrder(Comparator.comparingLong(FileObjectMeta::contentLength))),
        CONTENT_LENGTH_DESC(new AbstractTaskFileOrder(Comparator.comparingLong(FileObjectMeta::contentLength).reversed()));

        final TaskFileOrder order;

        private BuiltIn(TaskFileOrder order) {
            this.order = order;
        }

        TaskFileOrder get() {
            return this.order;
        }
    }
}

