/*
 * Decompiled with CFR 0.152.
 */
package io.streamthoughts.kafka.connect.filepulse.fs;

import io.streamthoughts.kafka.connect.filepulse.fs.TaskFileURIProvider;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;

public class DefaultTaskFileURIProvider
implements TaskFileURIProvider {
    private List<URI> objectURIs;
    private final AtomicBoolean hasMore = new AtomicBoolean(true);

    public void configure(Map<String, ?> configs) {
        this.objectURIs = new Config(configs).objectURIs();
    }

    public List<URI> nextURIs() {
        if (this.hasMore.compareAndSet(true, false)) {
            return this.objectURIs;
        }
        throw new NoSuchElementException("No more URIs can be retrieved from this provider.");
    }

    public boolean hasMore() {
        return this.hasMore.get();
    }

    public static final class Config
    extends AbstractConfig {
        public static final String FILE_OBJECT_URIS_CONFIG = "file.object.uris";
        private static final String FILE_OBJECT_URIS_DOC = "The list of files task must proceed.";

        public Config(Map<String, ?> originals) {
            super(Config.getConf(), originals, false);
        }

        static ConfigDef getConf() {
            return new ConfigDef().define(FILE_OBJECT_URIS_CONFIG, ConfigDef.Type.LIST, ConfigDef.Importance.HIGH, FILE_OBJECT_URIS_DOC);
        }

        public List<URI> objectURIs() {
            return this.getList(FILE_OBJECT_URIS_CONFIG).stream().map(URI::create).collect(Collectors.toList());
        }
    }
}

