/*
 * Decompiled with CFR 0.152.
 */
package io.streamthoughts.kafka.connect.filepulse.config;

import io.streamthoughts.kafka.connect.filepulse.config.CommonSourceConfig;
import io.streamthoughts.kafka.connect.filepulse.filter.RecordFilter;
import io.streamthoughts.kafka.connect.filepulse.fs.DefaultTaskFileURIProvider;
import io.streamthoughts.kafka.connect.filepulse.fs.TaskFileURIProvider;
import io.streamthoughts.kafka.connect.filepulse.reader.FileInputReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.connect.errors.ConnectException;

public class SourceTaskConfig
extends CommonSourceConfig {
    public static final String FILE_URIS_PROVIDER_CONFIG = "file.uris.provider";
    private static final String FILE_URIS_PROVIDER_DOC = "The FileURIProvider class to be used for retrieving the file URIs to process.";
    private static final String OMIT_READ_COMMITTED_FILE_CONFIG = "ignore.committed.offsets";
    private static final String OMIT_READ_COMMITTED_FILE_DOC = "Should a task ignore committed offsets while scheduling a file (default : false).";
    public static final String TASK_GENERATION_ID = "task.generation.id";
    private static final String TASK_GENERATION_DOC = "The task configuration generation id.";
    private final EnrichedConnectorConfig enrichedConfig;

    static ConfigDef getConf() {
        return CommonSourceConfig.getConfigDev().define(FILE_URIS_PROVIDER_CONFIG, ConfigDef.Type.CLASS, DefaultTaskFileURIProvider.class, ConfigDef.Importance.HIGH, FILE_URIS_PROVIDER_DOC).define(OMIT_READ_COMMITTED_FILE_CONFIG, ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.LOW, OMIT_READ_COMMITTED_FILE_DOC).define(TASK_GENERATION_ID, ConfigDef.Type.INT, (Object)0, ConfigDef.Importance.LOW, TASK_GENERATION_DOC);
    }

    public SourceTaskConfig(Map<String, String> originals) {
        this(SourceTaskConfig.getConf(), originals);
    }

    private SourceTaskConfig(ConfigDef configDef, Map<String, String> originals) {
        super(SourceTaskConfig.getConf(), originals);
        this.enrichedConfig = new EnrichedConnectorConfig(SourceTaskConfig.enrich(configDef, originals), originals);
    }

    public Object get(String key) {
        return this.enrichedConfig.get(key);
    }

    private static ConfigDef enrich(ConfigDef baseConfigDef, Map<String, String> props) {
        Object filterAliases = ConfigDef.parseType((String)"filters", (Object)props.get("filters"), (ConfigDef.Type)ConfigDef.Type.LIST);
        if (!(filterAliases instanceof List)) {
            return baseConfigDef;
        }
        ConfigDef newDef = new ConfigDef(baseConfigDef);
        LinkedHashSet<String> uniqueFilterAliases = new LinkedHashSet<String>();
        SourceTaskConfig.lookupAllFilterAliases(props, (List)filterAliases, uniqueFilterAliases);
        uniqueFilterAliases.forEach(alias -> SourceTaskConfig.addConfigDefForFilter(props, newDef, alias));
        return newDef;
    }

    private static void lookupAllFilterAliases(Map<String, String> props, Collection<?> filterAliases, LinkedHashSet<String> accumulator) {
        for (Object alias : filterAliases) {
            if (!(alias instanceof String)) {
                throw new ConfigException("Item in " + filterAliases + " property is not of type string");
            }
            accumulator.add((String)alias);
            String failure = props.get("filters." + alias + ".withOnFailure");
            if (failure == null || failure.isEmpty()) continue;
            Set filters = Arrays.stream(failure.split(",")).map(String::trim).collect(Collectors.toSet());
            SourceTaskConfig.lookupAllFilterAliases(props, filters, accumulator);
        }
    }

    private static void addConfigDefForFilter(Map<String, String> props, ConfigDef newDef, String alias) {
        ConfigDef filterConfigDef;
        String prefix = "filters." + alias + ".";
        String group = "Filters:" + alias;
        int orderInGroup = 0;
        String filterTypeConfig = prefix + "type";
        ConfigDef.Validator typeValidator = (name, value) -> SourceTaskConfig.getConfigDefFromFilter(filterTypeConfig, (Class)value);
        newDef.define(filterTypeConfig, ConfigDef.Type.CLASS, ConfigDef.NO_DEFAULT_VALUE, typeValidator, ConfigDef.Importance.HIGH, "Class for the '" + alias + "' filter.", group, orderInGroup++, ConfigDef.Width.LONG, "Filter type for " + alias);
        try {
            String className = props.get(filterTypeConfig);
            Class cls = (Class)ConfigDef.parseType((String)filterTypeConfig, (Object)className, (ConfigDef.Type)ConfigDef.Type.CLASS);
            filterConfigDef = SourceTaskConfig.getConfigDefFromFilter(filterTypeConfig, cls);
        }
        catch (ConfigException e) {
            return;
        }
        newDef.embed(prefix, group, orderInGroup, filterConfigDef);
    }

    public TaskFileURIProvider getFileURIProvider() {
        return (TaskFileURIProvider)this.getConfiguredInstance(FILE_URIS_PROVIDER_CONFIG, TaskFileURIProvider.class);
    }

    public boolean isReadCommittedFile() {
        return this.getBoolean(OMIT_READ_COMMITTED_FILE_CONFIG);
    }

    public String topic() {
        return this.getString("topic");
    }

    public FileInputReader reader() {
        return (FileInputReader)this.getConfiguredInstance("tasks.reader.class", FileInputReader.class);
    }

    public int getTaskGenerationId() {
        return this.getInt(TASK_GENERATION_ID);
    }

    public List<RecordFilter> filters() {
        List filterAliases = this.getList("filters");
        ArrayList<RecordFilter> filters = new ArrayList<RecordFilter>(filterAliases.size());
        for (String alias : filterAliases) {
            filters.add(this.filterByAlias(alias));
        }
        return filters;
    }

    public RecordFilter filterByAlias(String alias) {
        String prefix = "filters." + alias + ".";
        try {
            RecordFilter filter = this.getClass(prefix + "type").asSubclass(RecordFilter.class).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            filter.configure(this.originalsWithPrefix(prefix), this::filterByAlias);
            return filter;
        }
        catch (Exception e) {
            throw new ConnectException("Failed to create filter with alias '" + alias + "'", (Throwable)e);
        }
    }

    private static ConfigDef getConfigDefFromFilter(String key, Class<?> filterClass) {
        RecordFilter filter;
        if (filterClass == null || !RecordFilter.class.isAssignableFrom(filterClass)) {
            throw new ConfigException(key, (Object)String.valueOf(filterClass), "Not a RecordFilter");
        }
        try {
            filter = filterClass.asSubclass(RecordFilter.class).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new ConfigException(key, (Object)String.valueOf(filterClass), "Error getting configDef definition from RecordFilter: " + e.getMessage());
        }
        ConfigDef configDef = filter.configDef();
        if (null == configDef) {
            throw new ConnectException(String.format("%s.configDef() must return a ConfigDef that is not null.", filterClass.getName()));
        }
        return configDef;
    }

    private static class EnrichedConnectorConfig
    extends AbstractConfig {
        EnrichedConnectorConfig(ConfigDef configDef, Map<String, String> props) {
            super(configDef, props);
        }

        public Object get(String key) {
            return super.get(key);
        }
    }
}

