/*
 * Decompiled with CFR 0.152.
 */
package io.straas.android.sdk.streaming;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.TextureView;
import com.google.android.gms.tasks.Continuation;
import com.google.android.gms.tasks.OnFailureListener;
import com.google.android.gms.tasks.OnSuccessListener;
import com.google.android.gms.tasks.Task;
import io.straas.android.sdk.base.credential.Credential;
import io.straas.android.sdk.base.credential.CredentialFailException;
import io.straas.android.sdk.base.credential.CredentialFailReason;
import io.straas.android.sdk.base.identity.Identity;
import io.straas.android.sdk.base.interfaces.OnResultListener;
import io.straas.android.sdk.streaming.BaseImageFilter;
import io.straas.android.sdk.streaming.CameraController;
import io.straas.android.sdk.streaming.StreamConfig;
import io.straas.android.sdk.streaming.error.PrepareError;
import io.straas.android.sdk.streaming.error.StreamError;
import io.straas.android.sdk.streaming.interfaces.EventListener;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class StreamManager {
    public static final int STATE_IDLE = 0;
    public static final int STATE_PREPARING = 1;
    public static final int STATE_PREPARED = 2;
    public static final int STATE_CONNECTING = 3;
    public static final int STATE_STREAMING = 4;
    public static final int STATE_DISCONNECTING = 5;
    private d a = new d();

    @Deprecated
    public static void initialize(final OnResultListener<StreamManager, CredentialFailReason> callback) {
        StreamManager.initialize().addOnSuccessListener((OnSuccessListener)new OnSuccessListener<StreamManager>(){

            public void onSuccess(StreamManager streamManager) {
                if (callback == null) {
                    return;
                }
                callback.onSuccess((Object)streamManager);
            }
        }).addOnFailureListener(new OnFailureListener(){

            public void onFailure(@NonNull Exception e2) {
                if (e2 instanceof CredentialFailException.NetworkException) {
                    callback.onFailure((Object)CredentialFailReason.NETWORK_ERROR);
                } else if (e2 instanceof CredentialFailException.ServerException) {
                    callback.onFailure((Object)CredentialFailReason.SERVER_ERROR);
                } else if (e2 instanceof CredentialFailException.WrongInformationException) {
                    callback.onFailure((Object)CredentialFailReason.WRONG_INFORMATION);
                }
            }
        });
    }

    public static Task<StreamManager> initialize() {
        return Credential.validate().continueWith((Continuation)new GenerateManager());
    }

    private StreamManager() {
    }

    @Deprecated
    public void prepare(StreamConfig config, TextureView preview, final OnResultListener<CameraController, PrepareError> callback) {
        this.prepare(config, preview).addOnSuccessListener((OnSuccessListener)new OnSuccessListener<CameraController>(){

            public void onSuccess(CameraController cameraController) {
                callback.onSuccess((Object)cameraController);
            }
        }).addOnFailureListener(new OnFailureListener(){

            public void onFailure(@NonNull Exception e2) {
                callback.onFailure((Object)((PrepareError)d.a(e2)));
            }
        });
    }

    public Task<CameraController> prepare(StreamConfig config, TextureView preview) {
        return this.a.a(config, preview);
    }

    public boolean setFilter(@Nullable BaseImageFilter filter) {
        return this.a.a(filter);
    }

    public Task<String> startStreaming(@NonNull Identity identity, String title, String synopsis, boolean listed, boolean reuseLiveEvent) {
        return this.startStreaming(identity, title, synopsis, listed, reuseLiveEvent, null);
    }

    public Task<String> startStreaming(@NonNull Identity identity, String title, String synopsis, boolean listed, boolean reuseLiveEvent, EventListener ... listeners) {
        return this.a.a(identity, title, synopsis, listed, reuseLiveEvent, listeners);
    }

    public boolean addEventListener(EventListener listener) {
        return this.a.a(listener);
    }

    public void addAllEventListener(EventListener ... listeners) {
        this.a.a(listeners);
    }

    public boolean removeEventListener(EventListener listener) {
        return this.a.b(listener);
    }

    public void removeAllEventListener() {
        this.a.c();
    }

    public Task<Void> stopStreaming() {
        return this.a.a();
    }

    public Task<Void> destroy() {
        return this.a.b();
    }

    @Deprecated
    public void cleanLiveEvent(@NonNull String liveId, final OnResultListener<Void, StreamError> callback) {
        this.cleanLiveEvent(liveId).addOnSuccessListener((OnSuccessListener)new OnSuccessListener<Void>(){

            public void onSuccess(Void aVoid) {
                callback.onSuccess((Object)aVoid);
            }
        }).addOnFailureListener(new OnFailureListener(){

            public void onFailure(@NonNull Exception e2) {
                callback.onFailure((Object)((StreamError)d.a(e2)));
            }
        });
    }

    public Task<Void> cleanLiveEvent(@NonNull String liveId) {
        return this.a.a(liveId);
    }

    public int getStreamState() {
        return this.a.d();
    }

    static class GenerateManager
    implements Continuation<Void, StreamManager> {
        private GenerateManager() {
        }

        public StreamManager then(@NonNull Task<Void> task) throws Exception {
            if (task.isSuccessful()) {
                return new StreamManager();
            }
            if (task.getException() != null) {
                throw task.getException();
            }
            return null;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface StreamState {
    }
}

