/*
 * Decompiled with CFR 0.152.
 */
package io.straas.android.sdk.streaming.filter;

import android.opengl.GLES20;
import android.text.TextUtils;
import io.straas.android.sdk.authentication.credential.Credential;
import io.straas.android.sdk.streaming.BaseImageFilter;
import io.straas.android.sdk.streaming.R;
import io.straas.android.sdk.streaming.error.StreamException;
import io.straas.android.sdk.streaming.proguard.e;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.util.concurrent.atomic.AtomicBoolean;

public class SkinBeautifyFilter
extends BaseImageFilter {
    private final String a;
    private final String b;
    private int c;
    private int d;
    private int e;
    private int f;
    private int g;
    private int h;
    private int i;
    private float j;
    private float k;
    private AtomicBoolean l = new AtomicBoolean(false);

    public SkinBeautifyFilter(float skinSmoothnessLevel, float brightnessLevel) throws StreamException.InternalException {
        if (Credential.getContext() == null) {
            throw new StreamException.InternalException("Failed to get context.");
        }
        this.a = io.straas.android.sdk.streaming.proguard.e.a(Credential.getContext(), R.raw.skin_beautify_vertex_shader_code);
        this.b = io.straas.android.sdk.streaming.proguard.e.a(Credential.getContext(), R.raw.skin_beautify_fragment_shader_code);
        if (TextUtils.isEmpty((CharSequence)this.a) || TextUtils.isEmpty((CharSequence)this.b)) {
            throw new StreamException.InternalException("Failed to get shader raw resources.");
        }
        this.j = skinSmoothnessLevel;
        this.k = brightnessLevel;
    }

    @Override
    public void onInit(int width, int height) {
        super.onInit(width, height);
        this.c = this.a(this.a, this.b);
        GLES20.glUseProgram((int)this.c);
        this.e = GLES20.glGetAttribLocation((int)this.c, (String)"position");
        this.d = GLES20.glGetUniformLocation((int)this.c, (String)"inputImageTexture");
        this.f = GLES20.glGetAttribLocation((int)this.c, (String)"inputTextureCoordinate");
        this.g = GLES20.glGetUniformLocation((int)this.c, (String)"params");
        this.h = GLES20.glGetUniformLocation((int)this.c, (String)"brightness");
        this.i = GLES20.glGetUniformLocation((int)this.c, (String)"singleStepOffset");
        this.a(this.j);
        this.b(this.k);
        this.a(width, height);
    }

    @Override
    public void onDraw(int textureName, int frameBufferName) {
        super.onDraw(textureName, frameBufferName);
        GLES20.glBindFramebuffer((int)36160, (int)frameBufferName);
        GLES20.glUseProgram((int)this.c);
        if (this.l.compareAndSet(true, false)) {
            this.a(this.j);
            this.b(this.k);
        }
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)3553, (int)textureName);
        GLES20.glUniform1i((int)this.d, (int)0);
        this.mShapeCoordinate.position(0);
        GLES20.glEnableVertexAttribArray((int)this.e);
        GLES20.glVertexAttribPointer((int)this.e, (int)2, (int)5126, (boolean)false, (int)8, (Buffer)this.mShapeCoordinate);
        this.mTextureCoordinate.position(0);
        GLES20.glEnableVertexAttribArray((int)this.f);
        GLES20.glVertexAttribPointer((int)this.f, (int)2, (int)5126, (boolean)false, (int)8, (Buffer)this.mTextureCoordinate);
        GLES20.glViewport((int)0, (int)0, (int)this.mWidth, (int)this.mHeight);
        GLES20.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        GLES20.glClear((int)16384);
        GLES20.glDrawElements((int)4, (int)this.mIndicesOrder.limit(), (int)5123, (Buffer)this.mIndicesOrder);
        GLES20.glFinish();
        GLES20.glDisableVertexAttribArray((int)this.e);
        GLES20.glDisableVertexAttribArray((int)this.f);
        GLES20.glBindTexture((int)36197, (int)0);
        GLES20.glUseProgram((int)0);
        GLES20.glBindFramebuffer((int)36160, (int)0);
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        GLES20.glDeleteProgram((int)this.c);
    }

    public void setSkinSmoothnessLevel(float skinSmoothnessLevel) {
        this.a(skinSmoothnessLevel, this.k);
    }

    public void setBrightnessLevel(float brightnessLevel) {
        this.a(this.j, brightnessLevel);
    }

    public float getSkinSmoothnessLevel() {
        return this.j;
    }

    public float getBrightnessLevel() {
        return this.k;
    }

    private void a(float f2, float f3) {
        this.j = f2;
        this.k = f3;
        this.l.set(true);
    }

    private int a(String string2, String string3) {
        int n2 = GLES20.glCreateShader((int)35633);
        GLES20.glShaderSource((int)n2, (String)string2);
        GLES20.glCompileShader((int)n2);
        int n3 = GLES20.glCreateShader((int)35632);
        GLES20.glShaderSource((int)n3, (String)string3);
        GLES20.glCompileShader((int)n3);
        int n4 = GLES20.glCreateProgram();
        GLES20.glAttachShader((int)n4, (int)n2);
        GLES20.glAttachShader((int)n4, (int)n3);
        GLES20.glLinkProgram((int)n4);
        return n4;
    }

    private static FloatBuffer a(float[] fArray) {
        FloatBuffer floatBuffer = ByteBuffer.allocateDirect(fArray.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        floatBuffer.put(fArray);
        floatBuffer.position(0);
        return floatBuffer;
    }

    private void a(int n2, int n3) {
        float[] fArray = new float[]{2.0f / (float)n2, 2.0f / (float)n3};
        GLES20.glUniform2fv((int)this.i, (int)1, (float[])fArray, (int)0);
    }

    private void a(float f2) {
        float[] fArray = new float[]{1.0f - 0.6f * f2, 1.0f - 0.3f * f2, 0.25f, 0.25f};
        GLES20.glUniform4fv((int)this.g, (int)1, (FloatBuffer)SkinBeautifyFilter.a(fArray));
    }

    private void b(float f2) {
        float f3 = 0.6f * (-0.5f + f2);
        GLES20.glUniform1f((int)this.h, (float)f3);
    }
}

