/*
 * Decompiled with CFR 0.152.
 */
package io.straas.android.sdk.streaming;

import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.TextureView;
import com.google.android.gms.tasks.Continuation;
import com.google.android.gms.tasks.Task;
import io.straas.android.sdk.authentication.credential.Credential;
import io.straas.android.sdk.authentication.identity.Identity;
import io.straas.android.sdk.streaming.BaseImageFilter;
import io.straas.android.sdk.streaming.CameraController;
import io.straas.android.sdk.streaming.LiveEventConfig;
import io.straas.android.sdk.streaming.ScreencastStreamConfig;
import io.straas.android.sdk.streaming.StreamConfig;
import io.straas.android.sdk.streaming.StreamStatsReport;
import io.straas.android.sdk.streaming.interfaces.EventListener;
import io.straas.android.sdk.streaming.internal.ScreencastService;
import io.straas.android.sdk.streaming.proguard.d;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class StreamManager {
    public static final int STATE_IDLE = 0;
    public static final int STATE_PREPARING = 1;
    public static final int STATE_PREPARED = 2;
    public static final int STATE_CONNECTING = 3;
    public static final int STATE_STREAMING = 4;
    public static final int STATE_DISCONNECTING = 5;
    private d a;

    public static Task<StreamManager> initialize(Identity identity) {
        return Credential.validate().continueWith((Continuation)new GenerateManager(identity));
    }

    public static void initialize(Identity identity, Bundle bundle) {
        Credential.getContext().startService(ScreencastService.a(Credential.getContext(), identity, bundle));
    }

    private StreamManager(Identity identity) {
        this.a = new d(identity);
    }

    public Task<CameraController> prepare(StreamConfig config, TextureView preview) {
        return this.a.a(config, preview);
    }

    public Task<Void> prepare(ScreencastStreamConfig config) {
        return this.a.a(config);
    }

    public boolean setFilter(@Nullable BaseImageFilter filter) {
        return this.a.a(filter);
    }

    public void setAudioEnabled(boolean enabled) {
        this.a.a(enabled);
    }

    public boolean isAudioEnabled() {
        return this.a.b();
    }

    public Task<String> createLiveEvent(@NonNull LiveEventConfig config) {
        return this.a.a(config);
    }

    @Deprecated
    public Task<String> startStreaming(@NonNull String liveId) {
        return this.a.b(liveId);
    }

    public Task<Void> startStreamingWithLiveId(@NonNull String liveId) {
        return this.a.b(liveId).continueWith((Continuation)new Continuation<String, Void>(){

            public Void then(@NonNull Task<String> task) throws Exception {
                if (task.isSuccessful()) {
                    return null;
                }
                throw task.getException();
            }
        });
    }

    public Task<Void> startStreamingWithStreamKey(@NonNull String streamKey) {
        return this.a.c(streamKey);
    }

    public boolean addEventListener(EventListener listener) {
        return this.a.a(listener);
    }

    public void addAllEventListener(EventListener ... listeners) {
        this.a.a(listeners);
    }

    public boolean removeEventListener(EventListener listener) {
        return this.a.b(listener);
    }

    public void removeAllEventListener() {
        this.a.d();
    }

    public Task<Void> stopStreaming() {
        return this.a.b(false);
    }

    public Task<Void> destroy() {
        return this.a.c();
    }

    @Deprecated
    public Task<Void> cleanLiveEvent(@NonNull String liveId) {
        return this.a.a(liveId);
    }

    public Task<Void> endLiveEvent(@NonNull String liveId) {
        return this.a.a(liveId);
    }

    @StreamState
    public int getStreamState() {
        return this.a.a();
    }

    @Nullable
    public StreamStatsReport getStreamStatsReport() {
        return this.a.e();
    }

    public void setStreamStatsReportUpdatePeriod(int periodMs) {
        this.a.a(periodMs);
    }

    static class GenerateManager
    implements Continuation<Void, StreamManager> {
        private Identity a;

        private GenerateManager(Identity identity) {
            this.a = identity;
        }

        public StreamManager then(@NonNull Task<Void> task) throws Exception {
            if (task.isSuccessful()) {
                return new StreamManager(this.a);
            }
            if (task.getException() != null) {
                throw task.getException();
            }
            return null;
        }
    }

    @Retention(value=RetentionPolicy.CLASS)
    public static @interface StreamState {
    }
}

