/*
 * Decompiled with CFR 0.152.
 */
package io.straas.android.sdk.streaming;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;

public class BaseImageFilter {
    protected static final int COORDS_PER_VERTEX = 2;
    protected static final int TEXTURE_COORDS_PER_VERTEX = 2;
    private static final int BYTES_PER_SHORT = 2;
    private static final int BYTES_PER_FLOAT = 4;
    private static final short[] DRAW_ORDER = new short[]{0, 1, 2, 0, 2, 3};
    private static final float[] SHAPE_COORDINATE = new float[]{-1.0f, 1.0f, -1.0f, -1.0f, 1.0f, -1.0f, 1.0f, 1.0f};
    private static float[] TEXTURE_COORDINATE = new float[]{0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f};
    protected int mWidth;
    protected int mHeight;
    protected ShortBuffer mIndicesOrder;
    protected FloatBuffer mShapeCoordinate;
    protected FloatBuffer mTextureCoordinate;

    public void onInit(int width, int height) {
        this.mWidth = width;
        this.mHeight = height;
        this.mIndicesOrder = this.getIndicesOrder();
        this.mShapeCoordinate = this.getShapeCoordinate();
        this.mTextureCoordinate = this.getTextureCoordinate();
    }

    public void onDraw(int imageTexture, int targetFrameBuffer) {
    }

    public void onDestroy() {
    }

    private ShortBuffer getIndicesOrder() {
        ShortBuffer shortBuffer = ByteBuffer.allocateDirect(DRAW_ORDER.length * 2).order(ByteOrder.nativeOrder()).asShortBuffer();
        shortBuffer.put(DRAW_ORDER);
        shortBuffer.position(0);
        return shortBuffer;
    }

    private FloatBuffer getShapeCoordinate() {
        FloatBuffer floatBuffer = ByteBuffer.allocateDirect(SHAPE_COORDINATE.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        floatBuffer.put(SHAPE_COORDINATE);
        floatBuffer.position(0);
        return floatBuffer;
    }

    private FloatBuffer getTextureCoordinate() {
        FloatBuffer floatBuffer = ByteBuffer.allocateDirect(TEXTURE_COORDINATE.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        floatBuffer.put(TEXTURE_COORDINATE);
        floatBuffer.position(0);
        return floatBuffer;
    }
}

