/*
 * Decompiled with CFR 0.152.
 */
package io.straas.android.sdk.messaging;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.CountDownTimer;
import android.os.Handler;
import android.preference.PreferenceManager;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.util.SimpleArrayMap;
import android.text.TextUtils;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.android.gms.tasks.Tasks;
import com.ikala.android.controller.Retriable;
import com.ikala.android.controller.RetryDelayController;
import com.ikala.android.httptask.CallManager;
import com.ikala.android.httptask.error.HttpTaskError;
import com.ikala.android.utils.iKalaJSONUtil;
import com.ikala.android.utils.iKalaUtils;
import com.squareup.moshi.JsonDataException;
import com.squareup.moshi.Moshi;
import io.socket.client.IO;
import io.socket.client.Socket;
import io.socket.client.SocketIOException;
import io.socket.emitter.Emitter;
import io.straas.android.sdk.base.credential.Credential;
import io.straas.android.sdk.base.identity.Identity;
import io.straas.android.sdk.base.internal.Configuration;
import io.straas.android.sdk.base.internal.Utils;
import io.straas.android.sdk.messaging.AggregatedData;
import io.straas.android.sdk.messaging.ChatMode;
import io.straas.android.sdk.messaging.ChatroomInfo;
import io.straas.android.sdk.messaging.ChatroomState;
import io.straas.android.sdk.messaging.Message;
import io.straas.android.sdk.messaging.MessagingException;
import io.straas.android.sdk.messaging.Role;
import io.straas.android.sdk.messaging.Sticker;
import io.straas.android.sdk.messaging.User;
import io.straas.android.sdk.messaging.a.a;
import io.straas.android.sdk.messaging.a.a.a;
import io.straas.android.sdk.messaging.interfaces.EventListener;
import io.straas.android.sdk.messaging.message.MessageRequest;
import io.straas.android.sdk.messaging.user.UserType;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.URISyntaxException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLContext;
import okhttp3.Interceptor;
import okhttp3.ResponseBody;
import org.json.JSONArray;
import org.json.JSONObject;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

final class a {
    private static final String[] a = new String[]{"websocket"};
    private ChatroomState b = ChatroomState.IDLE;
    private int c;
    private String d;
    private Identity e;
    private boolean f;
    private List<EventListener> g;
    private int h;
    private SimpleArrayMap<String, String> i;
    private SimpleArrayMap<String, Integer> j;
    private List<Sticker> k;
    private String l;
    private String m;
    private Integer n;
    private User o;
    private boolean p;
    private io.straas.android.sdk.messaging.a.a q;
    private final CallManager r = new CallManager();
    private RetryDelayController s;
    private String t;
    private SharedPreferences u;
    private Handler v = new Handler();
    private c w;
    private TaskCompletionSource<Void> x;
    private io.straas.android.sdk.messaging.b y;
    private ChatMode z = ChatMode.ALL;
    private a.a$a A = new a.a$a(){

        @Override
        public void a(String string) {
            a.this.t = string;
            if (a.this.u != null) {
                a.this.u.edit().putString("KEY_API_TOKEN", string).apply();
            }
        }
    };
    private CountDownTimer B = new CountDownTimer(5000L, 5000L){

        public void onTick(long l2) {
        }

        public void onFinish() {
            a.this.a(new MessagingException.InternalException("timeout"));
        }
    };

    a(Context context) {
        this.k();
        this.u = PreferenceManager.getDefaultSharedPreferences((Context)context);
    }

    private void k() {
        this.s = new RetryDelayController(new Retriable(){

            public void retry() {
                a.this.q();
            }
        });
        this.s.setMaxCount(7);
        this.s.enableExponentialBackoff(true);
        this.s.setBaseRetryInterval(500L);
        this.j = new SimpleArrayMap();
        this.g = new ArrayList<EventListener>();
    }

    private io.straas.android.sdk.messaging.a.a b(Identity identity) {
        return (io.straas.android.sdk.messaging.a.a)Utils.createMemberRetrofit((String)"https://mgr.straas.net", (Identity)identity, (Interceptor[])new Interceptor[]{new io.straas.android.sdk.messaging.a.a.a("https://mgr.straas.net", this.A)}).create(io.straas.android.sdk.messaging.a.a.class);
    }

    Task<Void> a(@NonNull String string, @NonNull Identity identity) {
        MessagingException.RequestRejectedException requestRejectedException = null;
        if (this.b != ChatroomState.IDLE) {
            requestRejectedException = new MessagingException.RequestRejectedException(new IllegalStateException("State must be IDLE."));
        }
        if (TextUtils.isEmpty((CharSequence)string) || identity == null) {
            requestRejectedException = new MessagingException.RequestRejectedException(new IllegalArgumentException("Check chatroom name or Identity."));
        }
        if (requestRejectedException != null) {
            return Tasks.forException((Exception)requestRejectedException);
        }
        this.x = new TaskCompletionSource();
        this.b = ChatroomState.CONNECTING;
        this.e = identity;
        this.d = string;
        this.f = string.startsWith("p#");
        this.q = this.b(identity);
        this.y = new io.straas.android.sdk.messaging.b(this.q);
        this.s.stop();
        this.p = false;
        this.m();
        return this.x.getTask();
    }

    boolean a(Identity identity) {
        if (this.b.equals((Object)ChatroomState.CONNECTED)) {
            this.e = identity;
            this.q = this.b(identity);
            return true;
        }
        return false;
    }

    private void l() {
        if (!TextUtils.isEmpty((CharSequence)this.t)) {
            return;
        }
        String string = null;
        if (this.u != null) {
            string = this.u.getString("KEY_API_TOKEN", null);
        }
        this.t = !TextUtils.isEmpty(string) ? string : "unknownApiToken";
    }

    private void a(int n2) {
        switch (n2) {
            case 0: {
                this.n();
                break;
            }
            case 1: {
                this.o();
                break;
            }
            case 2: {
                this.p();
            }
        }
    }

    private void m() {
        this.b = ChatroomState.CONNECTING;
        this.l();
        this.a(0);
    }

    private void n() {
        final String string = Credential.getAccountId();
        if (TextUtils.isEmpty((CharSequence)string)) {
            this.b(new MessagingException.InternalException("check your sdk account_id"));
            this.j();
        }
        Call<a$h> call = this.q.a(this.t, this.d, string);
        call.enqueue((Callback)new a<a$h>(this.r, call, null){

            @Override
            public void onResponse(Call<a$h> call, Response<a$h> response) {
                super.onResponse(call, response);
                if (!a.this.t()) {
                    return;
                }
                if (response.isSuccessful() && response.body() != null) {
                    a.this.l = ((a$h)response.body()).id;
                    a.this.c = ((a$h)response.body()).inputInterval;
                    a.this.z = ChatMode.a(((a$h)response.body()).chatWriteMode);
                    a.this.h = ((a$h)response.body()).guestCount + ((a$h)response.body()).memberCount;
                    a.this.i = ((a$h)response.body()).getStickerMap();
                    a.this.k = ((a$h)response.body()).getStickerSuite();
                    if (a.this.j.size() == 0) {
                        for (Map map : ((a$h)response.body()).aggregated) {
                            a.this.j.put((Object)((String)map.get("key")), (Object)((Double)map.get("n")).intValue());
                        }
                    } else {
                        SimpleArrayMap simpleArrayMap = new SimpleArrayMap();
                        for (Map object : ((a$h)response.body()).aggregated) {
                            String string2 = (String)object.get("key");
                            int n2 = ((Double)object.get("n")).intValue();
                            if (a.this.j.containsKey((Object)string2)) {
                                if ((Integer)a.this.j.get((Object)string2) == n2) continue;
                                int n3 = n2 - (Integer)a.this.j.get((Object)string2);
                                a.this.j.put((Object)string2, (Object)n2);
                                simpleArrayMap.put((Object)string2, (Object)n3);
                                continue;
                            }
                            a.this.j.put((Object)string2, (Object)n2);
                            simpleArrayMap.put((Object)string2, (Object)n2);
                        }
                        if (simpleArrayMap.size() > 0) {
                            for (EventListener eventListener : a.this.g) {
                                eventListener.onAggregatedDataAdded((SimpleArrayMap<String, Integer>)simpleArrayMap);
                            }
                        }
                    }
                    a.this.a(1);
                }
            }

            @Override
            protected void a(Exception exception) {
                if (exception instanceof MessagingException.ChatroomNameNotFoundException && a.this.f && !a.this.e.isGuest()) {
                    a.this.a(a.this.d, string);
                } else {
                    super.a(exception);
                }
            }
        });
    }

    private void a(String string, String string2) {
        Call<ResponseBody> call = this.q.a(this.t, new a$f(ChatroomInfo.a(string), string2));
        call.enqueue((Callback)new a<ResponseBody>(this.r, call, null){

            @Override
            public void onResponse(Call<ResponseBody> call, Response<ResponseBody> response) {
                super.onResponse(call, response);
                if (!a.this.t()) {
                    return;
                }
                if (response.isSuccessful()) {
                    a.this.a(0);
                }
            }
        });
    }

    private void o() {
        String string = this.e == Identity.GUEST ? "Guest" : null;
        Call<a$c> call = this.q.a(this.t, new a$b(this.l, this.m, string));
        call.enqueue((Callback)new a<a$c>(this.r, call, null){

            @Override
            public void onResponse(Call<a$c> call, Response<a$c> response) {
                super.onResponse(call, response);
                if (!a.this.t()) {
                    return;
                }
                if (response.isSuccessful() && response.body() != null) {
                    a$c$a a2 = ((a$c)response.body()).userMetas[0];
                    a.this.m = a2.userToken;
                    a.this.n = (Integer)a2.label;
                    a.this.o = new User.a(((a$c)response.body()).userModel).a();
                    a.this.a(((a$c)response.body()).socket);
                }
            }
        });
    }

    private void p() {
        this.s.stop();
        this.b = ChatroomState.CONNECTED;
        if (!this.p) {
            this.p = true;
            if (this.x != null) {
                this.x.trySetResult(null);
                this.x = null;
            }
            this.c(this.g);
        }
        this.y.a(this.t, this.m, this.l, this.h);
    }

    private void a(a$o o2) {
        Socket socket;
        IO.Options options = new IO.Options();
        options.reconnection = false;
        options.rememberUpgrade = true;
        options.forceNew = true;
        options.path = o2.path;
        options.query = (!TextUtils.isEmpty((CharSequence)o2.query) ? o2.query + "&" : "") + "userAgent=" + Configuration.USER_AGENT;
        options.transports = a;
        options.timeout = 30000L;
        try {
            options.sslContext = SSLContext.getDefault();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            noSuchAlgorithmException.printStackTrace();
        }
        try {
            socket = IO.socket((String)o2.host, (IO.Options)options);
        }
        catch (URISyntaxException uRISyntaxException) {
            this.a(new MessagingException.InternalException(uRISyntaxException.getMessage()));
            return;
        }
        this.w = new c(socket);
        this.a(this.w);
        this.b(this.w);
        socket.connect();
    }

    private void a(final c c2) {
        if (c2 == null) {
            return;
        }
        c2.a("connect", new Emitter.Listener(){

            public void call(Object ... args) {
                a.this.B.start();
                c2.a("subscribe", a.this.m, a.this.l);
            }
        });
        c2.a("connect_error", new Emitter.Listener(){

            public void call(Object ... args) {
                Object object = args.length > 0 ? args[0] : null;
                a.this.a(new MessagingException.NetworkException((Throwable)new SocketIOException("Connection error", (Throwable)(object instanceof Exception ? (Exception)object : null))));
            }
        });
        c2.a("disconnect", new Emitter.Listener(){

            public void call(Object ... args) {
                if (!a.this.t()) {
                    return;
                }
                Object object = args.length > 0 ? args[0] : null;
                String string = object instanceof String ? (String)object : null;
                a.this.a(new MessagingException.NetworkException((Throwable)new SocketIOException(string)));
            }
        });
    }

    private void b(c c2) {
        if (c2 == null) {
            return;
        }
        c2.a("subscribed", new Emitter.Listener(){

            public void call(Object ... args) {
                a.this.B.cancel();
                a.this.o.a("ACTIVE");
                a.this.h++;
                a.this.a(2);
            }
        });
        c2.a("message", new Emitter.Listener(){

            public void call(Object ... args) {
                if (args.length <= 0) {
                    return;
                }
                if (!(args[0] instanceof JSONObject)) {
                    return;
                }
                JSONObject jSONObject = (JSONObject)args[0];
                a.this.a(a.this.g, Message.a(jSONObject, (SimpleArrayMap<String, String>)a.this.i), 0L);
            }
        });
        c2.a("raw_data", new Emitter.Listener(){

            public void call(Object ... args) {
                if (args.length <= 0) {
                    return;
                }
                if (!(args[0] instanceof JSONObject)) {
                    return;
                }
                JSONObject jSONObject = (JSONObject)args[0];
                a.this.a((List<EventListener>)a.this.g, Message.a(jSONObject, null));
            }
        });
        c2.a("agg_data", new Emitter.Listener(){

            public void call(Object ... args) {
                if (args.length <= 0) {
                    return;
                }
                if (!(args[0] instanceof JSONObject)) {
                    return;
                }
                JSONObject jSONObject = (JSONObject)args[0];
                a.this.a(iKalaJSONUtil.getJSONArray((JSONObject)jSONObject, (String)"aggregated"));
            }
        });
        c2.a("message_remove", new Emitter.Listener(){

            public void call(Object ... args) {
                if (args == null || args.length <= 0) {
                    return;
                }
                if (!(args[0] instanceof String)) {
                    return;
                }
                String string = (String)args[0];
                a.this.a((List<EventListener>)a.this.g, string);
            }
        });
        c2.a("message_flush", new Emitter.Listener(){

            public void call(Object ... args) {
                a.this.e(a.this.g);
            }
        });
        c2.a("user_add", new Emitter.Listener(){

            public void call(Object ... args) {
                if (args == null || args.length <= 0) {
                    return;
                }
                if (!(args[0] instanceof JSONArray)) {
                    return;
                }
                JSONArray jSONArray = (JSONArray)args[0];
                int n2 = jSONArray.length();
                ArrayList<User> arrayList = new ArrayList<User>();
                for (int i2 = 0; i2 < n2; ++i2) {
                    JSONObject jSONObject = iKalaJSONUtil.getJSONObjectFromJSONArray((JSONArray)jSONArray, (int)i2);
                    if (jSONObject == null) continue;
                    User user = User.a(jSONObject);
                    if (a.this.n != null && a.this.n.intValue() == user.getLabel().intValue()) continue;
                    arrayList.add(user);
                    a.this.h++;
                }
                if (arrayList.size() != 0) {
                    User[] userArray = arrayList.toArray(new User[0]);
                    a.this.a((List<EventListener>)a.this.g, userArray);
                    a.this.a((List<EventListener>)a.this.g, a.this.h);
                    a.this.y.a(userArray);
                }
            }
        });
        c2.a("user_update", new Emitter.Listener(){

            public void call(Object ... args) {
                int n2 = 0;
                if (args == null || args.length <= 0) {
                    return;
                }
                if (!(args[0] instanceof JSONArray)) {
                    return;
                }
                JSONArray jSONArray = (JSONArray)args[0];
                n2 = jSONArray.length();
                ArrayList<User> arrayList = new ArrayList<User>();
                for (int i2 = 0; i2 < n2; ++i2) {
                    JSONObject jSONObject = (JSONObject)iKalaJSONUtil.getObjectFromJSONArray((JSONArray)jSONArray, (int)i2);
                    User user = User.a(jSONObject);
                    arrayList.add(user);
                    if (a.this.n == null || a.this.n.intValue() != user.getLabel().intValue()) continue;
                    a.this.o = user;
                }
                if (arrayList.size() != 0) {
                    User[] userArray = arrayList.toArray(arrayList.toArray(new User[0]));
                    a.this.b((List<EventListener>)a.this.g, userArray);
                    a.this.y.b(userArray);
                }
            }
        });
        c2.a("user_remove", new Emitter.Listener(){

            public void call(Object ... args) {
                if (args == null || args.length <= 0) {
                    return;
                }
                if (!(args[0] instanceof JSONArray)) {
                    return;
                }
                JSONArray jSONArray = (JSONArray)args[0];
                int n2 = jSONArray.length();
                ArrayList<Integer> arrayList = new ArrayList<Integer>();
                for (int i2 = 0; i2 < n2; ++i2) {
                    JSONObject jSONObject = (JSONObject)iKalaJSONUtil.getObjectFromJSONArray((JSONArray)jSONArray, (int)i2);
                    int n3 = iKalaJSONUtil.getJSONInt((JSONObject)jSONObject, (String)"label", (int)-1);
                    if (-1 == n3) continue;
                    String string = iKalaJSONUtil.getJSONString((JSONObject)jSONObject, (String)"status");
                    if (a.this.n != null && n3 == a.this.n) {
                        switch (string) {
                            case "DELETED": {
                                if (!a.this.t()) break;
                                break;
                            }
                        }
                    } else {
                        Object object = new User.a();
                        ((User.a)object).a(n3).a(string);
                        arrayList.add(n3);
                    }
                    a.this.h--;
                    a.this.h = a.this.h >= 1 ? a.this.h : 1;
                }
                if (arrayList.size() != 0) {
                    Integer[] integerArray = arrayList.toArray(new Integer[0]);
                    a.this.a((List<EventListener>)a.this.g, integerArray);
                    a.this.a((List<EventListener>)a.this.g, a.this.h);
                    a.this.y.a(integerArray);
                }
            }
        });
        c2.a("user_count", new Emitter.Listener(){

            public void call(Object ... args) {
                if (args == null || args.length <= 0) {
                    return;
                }
                if (!(args[0] instanceof JSONObject)) {
                    return;
                }
                JSONObject jSONObject = (JSONObject)args[0];
                a.this.h = iKalaJSONUtil.getJSONInt((JSONObject)jSONObject, (String)"guestCount") + iKalaJSONUtil.getJSONInt((JSONObject)jSONObject, (String)"memberCount");
                a.this.a((List<EventListener>)a.this.g, a.this.h);
                a.this.y.a(a.this.h);
            }
        });
        c2.a("error", new Emitter.Listener(){

            public void call(Object ... args) {
            }
        });
        c2.a("chat_write_mode", new Emitter.Listener(){

            public void call(Object ... args) {
                if (args == null || args.length <= 0) {
                    return;
                }
                if (!(args[0] instanceof JSONObject)) {
                    return;
                }
                JSONObject jSONObject = (JSONObject)args[0];
                String string = iKalaJSONUtil.getJSONString((JSONObject)jSONObject, (String)"chatWriteMode", (String)"ALL");
                a.this.z = ChatMode.a(string);
                a.this.a((List<EventListener>)a.this.g, a.this.g());
            }
        });
        c2.a("message_input_interval", new Emitter.Listener(){

            public void call(Object ... args) {
                if (args == null || args.length <= 0) {
                    return;
                }
                if (!(args[0] instanceof JSONObject)) {
                    return;
                }
                JSONObject jSONObject = (JSONObject)args[0];
                String string = iKalaJSONUtil.getJSONString((JSONObject)jSONObject, (String)"chatId");
                if (!string.equals(a.this.l)) {
                    return;
                }
                a.this.c = iKalaJSONUtil.getJSONInt((JSONObject)jSONObject, (String)"inputInterval");
                a.this.b((List<EventListener>)a.this.g, a.this.h());
            }
        });
    }

    boolean a(EventListener eventListener) {
        if (eventListener == null) {
            return false;
        }
        return !this.g.contains(eventListener) && this.g.add(eventListener);
    }

    void a(EventListener ... eventListenerArray) {
        if (eventListenerArray == null) {
            return;
        }
        for (EventListener eventListener : eventListenerArray) {
            this.a(eventListener);
        }
    }

    boolean b(EventListener eventListener) {
        return eventListener != null && !this.g.isEmpty() && this.g.remove(eventListener);
    }

    void a() {
        if (this.g.isEmpty()) {
            return;
        }
        this.g.clear();
    }

    private void c(final List<EventListener> list) {
        this.v.post(new Runnable(){

            @Override
            public void run() {
                for (EventListener eventListener : list) {
                    eventListener.onConnected();
                }
            }
        });
    }

    private void a(final List<EventListener> list, final Exception exception) {
        this.v.post(new Runnable(){

            @Override
            public void run() {
                for (EventListener eventListener : list) {
                    eventListener.onConnectFailed(exception);
                }
            }
        });
    }

    private void b(final List<EventListener> list, final Exception exception) {
        this.v.post(new Runnable(){

            @Override
            public void run() {
                for (EventListener eventListener : list) {
                    eventListener.onError(exception);
                }
            }
        });
    }

    private void d(final List<EventListener> list) {
        this.v.post(new Runnable(){

            @Override
            public void run() {
                for (EventListener eventListener : list) {
                    eventListener.onDisconnected();
                }
            }
        });
    }

    private void a(final List<EventListener> list, final Message message, long l2) {
        this.v.postDelayed(new Runnable(){

            @Override
            public void run() {
                for (EventListener eventListener : list) {
                    eventListener.onMessageAdded(message);
                }
            }
        }, l2);
    }

    private void a(final List<EventListener> list, final String string) {
        this.v.post(new Runnable(){

            @Override
            public void run() {
                for (EventListener eventListener : list) {
                    eventListener.onMessageRemoved(string);
                }
            }
        });
    }

    private void e(final List<EventListener> list) {
        this.v.post(new Runnable(){

            @Override
            public void run() {
                for (EventListener eventListener : list) {
                    eventListener.onMessageFlushed();
                }
            }
        });
    }

    private void a(final List<EventListener> list, final User[] userArray) {
        this.v.post(new Runnable(){

            @Override
            public void run() {
                for (EventListener eventListener : list) {
                    eventListener.onUserJoined(userArray);
                }
            }
        });
    }

    private void b(final List<EventListener> list, final User[] userArray) {
        this.v.post(new Runnable(){

            @Override
            public void run() {
                for (EventListener eventListener : list) {
                    eventListener.onUserUpdated(userArray);
                }
            }
        });
    }

    private void a(final List<EventListener> list, final Integer[] integerArray) {
        this.v.post(new Runnable(){

            @Override
            public void run() {
                for (EventListener eventListener : list) {
                    eventListener.onUserLeft(integerArray);
                }
            }
        });
    }

    private void a(final List<EventListener> list, final int n2) {
        this.v.post(new Runnable(){

            @Override
            public void run() {
                for (EventListener eventListener : list) {
                    eventListener.userCount(n2);
                }
            }
        });
    }

    private void a(final List<EventListener> list, final ChatMode chatMode) {
        this.v.post(new Runnable(){

            @Override
            public void run() {
                for (EventListener eventListener : list) {
                    eventListener.onChatWriteModeChanged(chatMode);
                }
            }
        });
    }

    private void b(final List<EventListener> list, final int n2) {
        this.v.post(new Runnable(){

            @Override
            public void run() {
                for (EventListener eventListener : list) {
                    eventListener.onInputIntervalChanged(n2);
                }
            }
        });
    }

    private void a(JSONArray jSONArray) {
        if (jSONArray == null || this.g.isEmpty()) {
            return;
        }
        final SimpleArrayMap simpleArrayMap = new SimpleArrayMap(jSONArray.length());
        int n2 = jSONArray.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            JSONObject jSONObject = iKalaJSONUtil.getJSONObjectFromJSONArray((JSONArray)jSONArray, (int)i2);
            if (jSONObject == null || !jSONObject.has("key")) continue;
            String string = iKalaJSONUtil.getJSONString((JSONObject)jSONObject, (String)"key", (String)"", (boolean)false);
            int n3 = iKalaJSONUtil.getJSONInt((JSONObject)jSONObject, (String)"n", (int)0);
            if (TextUtils.isEmpty((CharSequence)string) || n3 == 0) continue;
            simpleArrayMap.put((Object)string, (Object)n3);
            Integer n4 = (Integer)this.j.get((Object)string);
            this.j.put((Object)string, (Object)(n4 == null ? n3 : n4 + n3));
        }
        if (simpleArrayMap.size() == 0) {
            return;
        }
        this.v.post(new Runnable(){

            @Override
            public void run() {
                for (EventListener eventListener : a.this.g) {
                    eventListener.onAggregatedDataAdded((SimpleArrayMap<String, Integer>)simpleArrayMap);
                }
            }
        });
    }

    private void a(final List<EventListener> list, final Message message) {
        this.v.post(new Runnable(){

            @Override
            public void run() {
                for (EventListener eventListener : list) {
                    eventListener.onRawDataAdded(message);
                }
            }
        });
    }

    Task<Message[]> a(MessageRequest messageRequest, String string) {
        if (this.b != ChatroomState.CONNECTED) {
            return Tasks.forException((Exception)new MessagingException.RequestRejectedException(new IllegalStateException("State must be CONNECTED.")));
        }
        if (TextUtils.equals((CharSequence)string, (CharSequence)"aggregate")) {
            return Tasks.forException((Exception)new MessagingException.RequestRejectedException(new IllegalArgumentException("Please use getAggregatedDataHistory")));
        }
        int n2 = messageRequest.getPerPage();
        int n3 = messageRequest.getPage();
        if (!this.a(n3, n2, 100)) {
            return Tasks.forException((Exception)new MessagingException.RequestRejectedException(new IllegalArgumentException("Check page format is valid or not.")));
        }
        final TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        int n4 = (n3 - 1) * n2;
        Call<a$i> call = this.q.a(this.t, this.m, this.l, n4, n2, messageRequest.getOldestDate(), messageRequest.getLatestDate(), messageRequest.getOrder(), string);
        call.enqueue((Callback)new b<a$i>(this.r, call, taskCompletionSource){

            @Override
            public void onResponse(Call<a$i> call, Response<a$i> response) {
                super.onResponse(call, response);
                a$i i2 = (a$i)response.body();
                if (!response.isSuccessful() || i2 == null || i2.messages == null) {
                    taskCompletionSource.trySetException((Exception)new MessagingException.InternalException());
                    return;
                }
                int n2 = i2.messages.length;
                Message[] messageArray = new Message[n2];
                for (int i3 = 0; i3 < n2; ++i3) {
                    Message message;
                    messageArray[i3] = message = new Message.Builder(i2.messages[i3], (SimpleArrayMap<String, String>)a.this.i).build();
                }
                taskCompletionSource.setResult((Object)messageArray);
            }
        });
        return taskCompletionSource.getTask();
    }

    @NonNull
    SimpleArrayMap<String, Integer> b() {
        return this.j;
    }

    Task<User[]> a(UserType userType) {
        if (this.b != ChatroomState.CONNECTED) {
            return Tasks.forException((Exception)new MessagingException.RequestRejectedException(new IllegalStateException("State must be CONNECTED.")));
        }
        return this.y.a(userType);
    }

    Task<ChatroomInfo> c() {
        if (this.b != ChatroomState.CONNECTED) {
            return Tasks.forException((Exception)new MessagingException.RequestRejectedException(new IllegalStateException("State must be CONNECTED.")));
        }
        String string = Credential.getAccountId();
        if (TextUtils.isEmpty((CharSequence)string)) {
            MessagingException.InternalException internalException = new MessagingException.InternalException("check your sdk account_id");
            this.b(internalException);
            return Tasks.forException((Exception)internalException);
        }
        final TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        Call<a$h> call = this.q.a(this.t, this.d, string);
        call.enqueue((Callback)new b<a$h>(this.r, call, taskCompletionSource){

            @Override
            public void onResponse(Call<a$h> call, Response<a$h> response) {
                super.onResponse(call, response);
                if (response.isSuccessful() && response.body() != null) {
                    taskCompletionSource.setResult((Object)((a$h)response.body()).toChatroomInfo());
                }
            }
        });
        return taskCompletionSource.getTask();
    }

    Task<Void> a(String string, Object object) {
        if (this.b != ChatroomState.CONNECTED) {
            return Tasks.forException((Exception)new MessagingException.RequestRejectedException(new IllegalStateException("State must be CONNECTED.")));
        }
        if (string.equals("text") && object instanceof CharSequence) {
            if (TextUtils.isEmpty((CharSequence)((CharSequence)object))) {
                return Tasks.forException((Exception)new MessagingException.RequestRejectedException(new IllegalArgumentException("Message is empty, say something please.")));
            }
            if (((CharSequence)object).length() > 300) {
                return Tasks.forException((Exception)new MessagingException.RequestRejectedException(new IllegalArgumentException("Message should be within 300 characters.")));
            }
        }
        final TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        Call<ResponseBody> call = this.q.a(this.t, new a$a(this.l, this.m, string, object));
        call.enqueue((Callback)new b<ResponseBody>(this.r, call, taskCompletionSource){

            @Override
            public void onResponse(Call<ResponseBody> call, Response<ResponseBody> response) {
                super.onResponse(call, response);
                if (response.isSuccessful()) {
                    taskCompletionSource.setResult(null);
                }
            }
        });
        return taskCompletionSource.getTask();
    }

    void a(Message message) {
        this.a(this.g, message, 100L);
    }

    Task<Void> a(final String string) {
        if (this.b != ChatroomState.CONNECTED) {
            return Tasks.forException((Exception)new IllegalStateException("State must be CONNECTED."));
        }
        if (this.e != Identity.GUEST) {
            return Tasks.forException((Exception)new IllegalStateException("Identity must be Identity.GUEST."));
        }
        final TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        Call<ResponseBody> call = this.q.a(this.t, new a$q(this.l, this.m, Collections.singletonList(new a$k(this.n, string, null))));
        call.enqueue((Callback)new b<ResponseBody>(this.r, call, taskCompletionSource){

            @Override
            public void onResponse(Call<ResponseBody> call, Response<ResponseBody> response) {
                super.onResponse(call, response);
                if (response.isSuccessful()) {
                    a.this.o.setName(string);
                    taskCompletionSource.setResult(null);
                }
            }
        });
        return taskCompletionSource.getTask();
    }

    Task<Void> a(List<User> list) {
        boolean bl;
        User user2;
        Role role = this.o.getRole();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (User user2 : list) {
            arrayList.add(user2.getLabel());
        }
        boolean bl2 = bl = role == Role.MASTER || role == Role.GLOBAL_MANAGER || role == Role.LOCAL_MANAGER;
        if (this.b != ChatroomState.CONNECTED) {
            return Tasks.forException((Exception)new MessagingException.RequestRejectedException(new IllegalStateException("State must be CONNECTED.")));
        }
        if (arrayList.size() == 0) {
            return Tasks.forException((Exception)new MessagingException.RequestRejectedException(new IllegalArgumentException("Users are emptys")));
        }
        if (!bl) {
            return Tasks.forException((Exception)new MessagingException.PermissionException("User must be MASTER, GLOBAL_MANAGER or LOCAL_MANAGER."));
        }
        user2 = new TaskCompletionSource();
        Call<ResponseBody> call = this.q.a(this.t, new a$e(this.l, this.m, arrayList));
        call.enqueue((Callback)new b<ResponseBody>(this.r, call, (TaskCompletionSource)user2, (TaskCompletionSource)user2){
            final /* synthetic */ TaskCompletionSource b;
            {
                this.b = taskCompletionSource2;
                super(callManager, call, taskCompletionSource);
            }

            @Override
            public void onResponse(Call<ResponseBody> call, Response<ResponseBody> response) {
                super.onResponse(call, response);
                if (response.isSuccessful()) {
                    this.b.setResult(null);
                }
            }
        });
        return user2.getTask();
    }

    Task<Void> b(List<User> list) {
        boolean bl;
        User user2;
        Role role = this.o.getRole();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (User user2 : list) {
            arrayList.add(user2.getLabel());
        }
        boolean bl2 = bl = role == Role.MASTER || role == Role.GLOBAL_MANAGER || role == Role.LOCAL_MANAGER;
        if (this.b != ChatroomState.CONNECTED) {
            return Tasks.forException((Exception)new MessagingException.RequestRejectedException(new IllegalStateException("State must be CONNECTED.")));
        }
        if (arrayList.size() == 0) {
            return Tasks.forException((Exception)new MessagingException.RequestRejectedException(new IllegalArgumentException("Users are empties")));
        }
        if (!bl) {
            return Tasks.forException((Exception)new MessagingException.PermissionException("User must be MASTER, GLOBAL_MANAGER or LOCAL_MANAGER."));
        }
        user2 = new TaskCompletionSource();
        Call<ResponseBody> call = this.q.b(this.t, new a$e(this.l, this.m, arrayList));
        call.enqueue((Callback)new b<ResponseBody>(this.r, call, (TaskCompletionSource)user2, (TaskCompletionSource)user2){
            final /* synthetic */ TaskCompletionSource b;
            {
                this.b = taskCompletionSource2;
                super(callManager, call, taskCompletionSource);
            }

            @Override
            public void onResponse(Call<ResponseBody> call, Response<ResponseBody> response) {
                super.onResponse(call, response);
                if (response.isSuccessful()) {
                    this.b.setResult(null);
                }
            }
        });
        return user2.getTask();
    }

    Task<Void> b(Message message) {
        boolean bl;
        Role role = this.o.getRole();
        String string = message.getId();
        boolean bl2 = bl = role == Role.MASTER || role == Role.GLOBAL_MANAGER || role == Role.LOCAL_MANAGER;
        if (this.b != ChatroomState.CONNECTED) {
            return Tasks.forException((Exception)new MessagingException.RequestRejectedException(new IllegalStateException("State must be CONNECTED.")));
        }
        if (string == null) {
            return Tasks.forException((Exception)new MessagingException.RequestRejectedException(new IllegalArgumentException("Check message ID.")));
        }
        if (!bl) {
            return Tasks.forException((Exception)new MessagingException.PermissionException("User must be MASTER, GLOBAL_MANAGER or LOCAL_MANAGER."));
        }
        final TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        Call<ResponseBody> call = this.q.a(this.t, this.m, this.l, string);
        call.enqueue((Callback)new b<ResponseBody>(this.r, call, taskCompletionSource){

            @Override
            public void onResponse(Call<ResponseBody> call, Response<ResponseBody> response) {
                super.onResponse(call, response);
                if (response.isSuccessful()) {
                    taskCompletionSource.setResult(null);
                }
            }
        });
        return taskCompletionSource.getTask();
    }

    Task<AggregatedData[]> a(MessageRequest messageRequest) {
        if (this.b != ChatroomState.CONNECTED) {
            return Tasks.forException((Exception)new MessagingException.RequestRejectedException(new IllegalStateException("State must be CONNECTED.")));
        }
        int n2 = messageRequest.getPerPage();
        int n3 = messageRequest.getPage();
        if (!this.a(n3, n2, 100)) {
            return Tasks.forException((Exception)new MessagingException.RequestRejectedException(new IllegalArgumentException("Check page format is valid or not.")));
        }
        final TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        int n4 = (n3 - 1) * n2;
        Call<a$g> call = this.q.a(this.t, this.m, this.l, n4, n2, messageRequest.getOldestDate(), messageRequest.getLatestDate(), messageRequest.getOrder());
        call.enqueue((Callback)new b<a$g>(this.r, call, taskCompletionSource){

            @Override
            public void onResponse(Call<a$g> call, Response<a$g> response) {
                super.onResponse(call, response);
                a$g g2 = (a$g)response.body();
                if (!response.isSuccessful() || g2 == null || g2.messages == null) {
                    taskCompletionSource.trySetException((Exception)new MessagingException.InternalException());
                    return;
                }
                int n2 = g2.messages.length;
                AggregatedData[] aggregatedDataArray = new AggregatedData[n2];
                for (int i2 = 0; i2 < n2; ++i2) {
                    aggregatedDataArray[i2] = new AggregatedData();
                    aggregatedDataArray[i2].b = io.straas.android.sdk.messaging.c.a(g2.messages[i2].createdDate);
                    for (Map map : g2.messages[i2].aggregated) {
                        aggregatedDataArray[i2].a.put((Object)((String)map.get("key")), (Object)((Double)map.get("n")).intValue());
                    }
                }
                taskCompletionSource.setResult((Object)aggregatedDataArray);
            }
        });
        return taskCompletionSource.getTask();
    }

    List<Sticker> d() {
        return this.k;
    }

    User e() {
        if (this.b != ChatroomState.CONNECTED) {
            return null;
        }
        return this.o;
    }

    int f() {
        return this.h;
    }

    ChatMode g() {
        return this.z;
    }

    int h() {
        return this.c;
    }

    ChatroomState i() {
        return this.b;
    }

    Task<Void> j() {
        if (!this.t()) {
            return Tasks.forException((Exception)new MessagingException.RequestRejectedException(new IllegalStateException()));
        }
        return this.a(false);
    }

    private void q() {
        this.a(true);
    }

    private Task<Void> a(boolean bl) {
        if (bl) {
            this.b = ChatroomState.CONNECTING;
            this.y.a();
        } else {
            this.b = ChatroomState.DISCONNECTING;
            this.s.stop();
            this.y.b();
            this.j.clear();
        }
        this.r.cancelAllCalls();
        this.s();
        if (iKalaUtils.isEmptyString((CharSequence)this.m) || iKalaUtils.isEmptyString((CharSequence)this.l) || this.n == null) {
            if (bl) {
                this.m();
            }
        } else {
            this.b(bl);
            this.r();
        }
        if (!bl) {
            this.b = ChatroomState.IDLE;
            if (this.p) {
                this.d(this.g);
                return Tasks.forResult(null);
            }
        }
        return Tasks.forException((Exception)new Exception());
    }

    private void r() {
        this.l = null;
        this.m = null;
        this.n = null;
        this.o = null;
    }

    private synchronized void s() {
        if (this.w == null) {
            return;
        }
        this.w.a.off();
        this.w.a.disconnect();
    }

    private void b(final boolean bl) {
        Call<ResponseBody> call = this.q.a(this.t, this.m, this.l, Collections.singletonList(this.n));
        call.enqueue((Callback)new CallManager.Callback<ResponseBody>(this.r, call, null){

            public void onResponse(Call<ResponseBody> call, Response<ResponseBody> response) {
                super.onResponse(call, response);
                if (bl) {
                    a.this.m();
                }
            }

            public void onFailure(Call<ResponseBody> call, Throwable t) {
                super.onFailure(call, t);
                Exception exception = a.this.a(call, t);
                if (bl && !(exception instanceof InterruptedIOException)) {
                    a.this.m();
                }
            }
        });
    }

    private void a(Exception exception) {
        if (!this.t()) {
            this.b(exception);
            return;
        }
        if (!this.c(exception) || !this.s.retry()) {
            this.b(exception);
            this.j();
        }
    }

    private void b(Exception exception) {
        if (!this.p) {
            this.a(this.g, exception);
            if (this.x != null) {
                this.x.trySetException(exception);
            }
        } else if (!(exception instanceof InterruptedIOException)) {
            this.b(this.g, exception);
        }
    }

    private boolean c(Exception exception) {
        if (exception instanceof MessagingException.NetworkException || exception instanceof MessagingException.InternalException || exception instanceof MessagingException.ServerException) {
            return true;
        }
        if (exception instanceof MessagingException.UnauthorizedException || exception instanceof MessagingException.PermissionException || exception instanceof MessagingException.ChatroomNameNotFoundException || exception instanceof MessagingException.RequestRejectedException || exception instanceof InterruptedIOException) {
            return false;
        }
        return false;
    }

    private Exception a(Response response) {
        int n2 = response.code();
        a$n n3 = this.a(response.errorBody());
        if (n3 == null || n3.code == null) {
            return new MessagingException.InternalException("Unknown error");
        }
        switch (n2) {
            case 401: {
                if (!n3.code.equals("UnauthorizedError")) break;
                return new MessagingException.UnauthorizedException();
            }
            case 403: {
                if (!n3.code.equals("PermissionViolationError")) break;
                return new MessagingException.PermissionException(Integer.toString(n2));
            }
            case 404: {
                if (!n3.code.equals("EntityNotFoundError")) break;
                return new MessagingException.ChatroomNameNotFoundException(this.d);
            }
            case 409: {
                if (!n3.code.equals("DuplicateEntityError") && !n3.code.equals("InvalidRequestError")) break;
                return new MessagingException.InternalException(Integer.toString(n2));
            }
            case 500: 
            case 501: 
            case 502: 
            case 503: 
            case 504: 
            case 505: {
                return new MessagingException.ServerException(n2);
            }
            case 400: {
                return new MessagingException.InternalException(Integer.toString(n2));
            }
            default: {
                return new MessagingException.InternalException();
            }
        }
        return new MessagingException.InternalException();
    }

    private Exception a(Call call, Throwable throwable) {
        int n2 = HttpTaskError.getThrowableMappingId((Call)call, (Throwable)throwable);
        switch (n2) {
            case 6: {
                return new InterruptedIOException("canceled");
            }
        }
        return new MessagingException.NetworkException(throwable);
    }

    private boolean t() {
        return this.b == ChatroomState.CONNECTING || this.b == ChatroomState.CONNECTED;
    }

    private a$n a(ResponseBody responseBody) {
        a$n n2;
        Moshi moshi = new Moshi.Builder().build();
        try {
            n2 = (a$n)moshi.adapter(a$n.class).fromJson(responseBody.source());
        }
        catch (JsonDataException | IOException throwable) {
            throwable.printStackTrace();
            n2 = new a$n();
        }
        return n2;
    }

    private boolean a(int n2, int n3, int n4) {
        return n2 > 0 && n3 > 0 && n3 <= n4;
    }

    private static final class c {
        Socket a;

        c(Socket socket) {
            this.a = socket;
        }

        Emitter a(String string, Object ... objectArray) {
            return this.a.emit(string, objectArray);
        }

        Emitter a(String string, Emitter.Listener listener) {
            return this.a.on(string, listener);
        }
    }

    private class b<T>
    extends CallManager.Callback<T> {
        private int b;
        private final TaskCompletionSource c;

        b(@Nullable CallManager callManager, @Nullable Call call, TaskCompletionSource taskCompletionSource) {
            super(callManager, call, null);
            this.b = 0;
            this.c = taskCompletionSource;
        }

        public void onResponse(Call<T> call, Response<T> response) {
            super.onResponse(call, response);
            if (!response.isSuccessful()) {
                Exception exception = a.this.a(response);
                this.a(call, exception);
            }
        }

        public void onFailure(Call<T> call, Throwable t) {
            super.onFailure(call, t);
            Exception exception = a.this.a(call, t);
            this.a(call, exception);
        }

        private void a(final Call<T> call, Exception exception) {
            if (++this.b <= 3 && a.this.t() && a.this.c(exception)) {
                a.this.v.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        Call call2 = call.clone();
                        call2.enqueue((Callback)b.this);
                    }
                }, 1000L);
            } else if (this.c != null && !(exception instanceof InterruptedIOException)) {
                this.c.trySetException(exception);
            }
        }
    }

    private class a<T>
    extends CallManager.Callback<T> {
        a(@Nullable CallManager callManager, @Nullable Call call, @Nullable CallManager.OnHttpTaskLoadingCallback onHttpTaskLoadingCallback) {
            super(callManager, call, onHttpTaskLoadingCallback);
        }

        public void onResponse(Call<T> call, Response<T> response) {
            super.onResponse(call, response);
            if (!response.isSuccessful()) {
                Exception exception = a.this.a(response);
                this.a(exception);
            }
        }

        public void onFailure(Call<T> call, Throwable t) {
            super.onFailure(call, t);
            Exception exception = a.this.a(call, t);
            this.a(exception);
        }

        protected void a(Exception exception) {
            a.this.a(exception);
        }
    }
}

