/*
 * Decompiled with CFR 0.152.
 */
package io.straas.android.sdk.messaging;

import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.google.android.gms.tasks.Continuation;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.squareup.moshi.JsonReader;
import io.straas.android.sdk.base.credential.Credential;
import io.straas.android.sdk.base.identity.Identity;
import io.straas.android.sdk.messaging.ChatMode;
import io.straas.android.sdk.messaging.ChatroomInfo;
import io.straas.android.sdk.messaging.ChatroomState;
import io.straas.android.sdk.messaging.Message;
import io.straas.android.sdk.messaging.MessagingException;
import io.straas.android.sdk.messaging.RawData;
import io.straas.android.sdk.messaging.Sticker;
import io.straas.android.sdk.messaging.User;
import io.straas.android.sdk.messaging.interfaces.EventListener;
import io.straas.android.sdk.messaging.message.MessageRequest;
import io.straas.android.sdk.messaging.user.UserType;
import java.io.IOException;
import java.util.List;
import okio.Buffer;
import okio.BufferedSource;

public class ChatroomManager {
    private io.straas.android.sdk.messaging.a a = new io.straas.android.sdk.messaging.a(Credential.getContext());

    public static Task<ChatroomManager> initialize() {
        return Credential.validate().continueWith((Continuation)new a());
    }

    private ChatroomManager() {
    }

    public Task<Void> connect(@NonNull String chatroomName, @NonNull Identity identity, boolean isPersonalChat) {
        return this.a.a(isPersonalChat ? "p#" + chatroomName : chatroomName, identity);
    }

    public boolean resetIdentity(Identity identity) {
        return this.a.a(identity);
    }

    public Task<Message[]> getMessages(MessageRequest request) {
        return this.a.a(request);
    }

    public Task<User[]> getUsers(UserType userType) {
        return this.a.a(userType);
    }

    public Task<ChatroomInfo> getChatroomInfo() {
        return this.a.b();
    }

    public Task<Void> updateNickname(String name) {
        return this.a.a(name);
    }

    public Task<Void> blockUsers(List<User> users) {
        return this.a.a(users);
    }

    public Task<Void> reviveUsers(List<User> users) {
        return this.a.b(users);
    }

    public Task<Void> removeMessage(Message message) {
        return this.a.b(message);
    }

    public Task<Void> sendMessage(String message) {
        return this.a.a("text", (Object)message);
    }

    public Task<Void> sendAggregatedDataTypeMessage(String message) {
        if (TextUtils.isEmpty((CharSequence)message) || message.length() > 100) {
            return Tasks.forException((Exception)new MessagingException.RequestRejectedException(new IllegalArgumentException("Aggregate data must be between 1~100 characters.")));
        }
        return this.a.a("aggregate", (Object)message);
    }

    public Task<Void> sendRawData(@NonNull RawData rawData) {
        if (rawData == null) {
            return Tasks.forException((Exception)new MessagingException.RequestRejectedException(new IllegalArgumentException("Check your raw data.")));
        }
        try {
            return this.a.a("raw", JsonReader.of((BufferedSource)new Buffer().writeUtf8(rawData.getJsonText())).readJsonValue());
        }
        catch (IOException iOException) {
            return Tasks.forException((Exception)new MessagingException.RequestRejectedException(iOException));
        }
    }

    public void addFakeMessage(Message message) {
        this.a.a(message);
    }

    public User getCurrentUser() {
        return this.a.d();
    }

    public List<Sticker> getSticker() {
        return this.a.c();
    }

    public int getUserCount() {
        return this.a.e();
    }

    public ChatMode getChatMode() {
        return this.a.f();
    }

    public int getSendMessageInterval() {
        return this.a.g();
    }

    public ChatroomState getChatroomState() {
        return this.a.h();
    }

    public Task<Void> disconnect() {
        return this.a.i();
    }

    public boolean addEventListener(EventListener listener) {
        return this.a.a(listener);
    }

    public void addAllEventListener(EventListener ... listeners) {
        this.a.a(listeners);
    }

    public boolean removeEventListener(EventListener listener) {
        return this.a.b(listener);
    }

    public void removeAllEventListener() {
        this.a.a();
    }

    private static class a
    implements Continuation<Void, ChatroomManager> {
        private a() {
        }

        public ChatroomManager a(@NonNull Task<Void> task) throws Exception {
            if (task.isSuccessful()) {
                return new ChatroomManager();
            }
            if (task.getException() != null) {
                throw task.getException();
            }
            return null;
        }

        public /* synthetic */ Object then(@NonNull Task task) throws Exception {
            return this.a((Task<Void>)task);
        }
    }
}

