/*
 * Decompiled with CFR 0.152.
 */
package io.straas.android.sdk.messaging;

import android.content.Context;
import android.support.v4.util.SimpleArrayMap;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.android.gms.tasks.Tasks;
import com.ikala.android.utils.iKalaJSONUtil;
import io.socket.emitter.Emitter;
import io.straas.android.sdk.base.identity.Identity;
import io.straas.android.sdk.messaging.ChatMode;
import io.straas.android.sdk.messaging.ChatroomState;
import io.straas.android.sdk.messaging.Message;
import io.straas.android.sdk.messaging.MessagingException;
import io.straas.android.sdk.messaging.Role;
import io.straas.android.sdk.messaging.Sticker;
import io.straas.android.sdk.messaging.User;
import io.straas.android.sdk.messaging.a;
import io.straas.android.sdk.messaging.a.a;
import io.straas.android.sdk.messaging.interfaces.EventListener;
import io.straas.android.sdk.messaging.message.MessageRequest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import okhttp3.ResponseBody;
import org.json.JSONArray;
import org.json.JSONObject;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

final class b
extends a {
    private SimpleArrayMap<String, String> o;
    private List<Sticker> p;

    b(Context context) {
        super(context);
    }

    @Override
    protected void a(a.f f2) {
        this.o = f2.getStickerMap();
        this.p = f2.getStickerSuite();
    }

    @Override
    protected void a(Object ... objectArray) {
        JSONObject jSONObject = (JSONObject)objectArray[0];
        this.a(this.d, Message.a(jSONObject, this.o), 0L);
    }

    @Override
    protected void a(a.c c2) {
        super.a(c2);
        if (c2 == null) {
            return;
        }
        c2.a("message_remove", new Emitter.Listener(){

            public void call(Object ... args) {
                if (args == null || args.length <= 0) {
                    return;
                }
                if (!(args[0] instanceof String)) {
                    return;
                }
                String string = (String)args[0];
                b.this.a((List<EventListener>)b.this.d, string);
            }
        });
        c2.a("message_flush", new Emitter.Listener(){

            public void call(Object ... args) {
                b.this.c(b.this.d);
            }
        });
        c2.a("user_add", new Emitter.Listener(){

            public void call(Object ... args) {
                if (args == null || args.length <= 0) {
                    return;
                }
                if (!(args[0] instanceof JSONArray)) {
                    return;
                }
                JSONArray jSONArray = (JSONArray)args[0];
                int n2 = jSONArray.length();
                ArrayList<User> arrayList = new ArrayList<User>();
                for (int i2 = 0; i2 < n2; ++i2) {
                    JSONObject jSONObject = iKalaJSONUtil.getJSONObjectFromJSONArray((JSONArray)jSONArray, (int)i2);
                    if (jSONObject == null) continue;
                    User user = User.a(jSONObject);
                    if (b.this.h != null && b.this.h.intValue() == user.getLabel().intValue()) continue;
                    arrayList.add(user);
                    ++b.this.e;
                }
                if (arrayList.size() != 0) {
                    b.this.a((List<EventListener>)b.this.d, arrayList.toArray(new User[0]));
                    b.this.a((List<EventListener>)b.this.d, b.this.e);
                }
            }
        });
        c2.a("user_update", new Emitter.Listener(){

            public void call(Object ... args) {
                int n2 = 0;
                if (args == null || args.length <= 0) {
                    return;
                }
                if (!(args[0] instanceof JSONArray)) {
                    return;
                }
                JSONArray jSONArray = (JSONArray)args[0];
                n2 = jSONArray.length();
                ArrayList<User> arrayList = new ArrayList<User>();
                for (int i2 = 0; i2 < n2; ++i2) {
                    JSONObject jSONObject = (JSONObject)iKalaJSONUtil.getObjectFromJSONArray((JSONArray)jSONArray, (int)i2);
                    User user = User.a(jSONObject);
                    arrayList.add(user);
                    if (b.this.h == null || b.this.h.intValue() != user.getLabel().intValue()) continue;
                    b.this.i = user;
                }
                if (arrayList.size() != 0) {
                    b.this.b((List<EventListener>)b.this.d, arrayList.toArray(new User[0]));
                }
            }
        });
        c2.a("user_remove", new Emitter.Listener(){

            public void call(Object ... args) {
                if (args == null || args.length <= 0) {
                    return;
                }
                if (!(args[0] instanceof JSONArray)) {
                    return;
                }
                JSONArray jSONArray = (JSONArray)args[0];
                int n2 = jSONArray.length();
                ArrayList<Integer> arrayList = new ArrayList<Integer>();
                for (int i2 = 0; i2 < n2; ++i2) {
                    JSONObject jSONObject = (JSONObject)iKalaJSONUtil.getObjectFromJSONArray((JSONArray)jSONArray, (int)i2);
                    int n3 = iKalaJSONUtil.getJSONInt((JSONObject)jSONObject, (String)"label", (int)-1);
                    if (-1 == n3) continue;
                    String string = iKalaJSONUtil.getJSONString((JSONObject)jSONObject, (String)"status");
                    if (b.this.h != null && n3 == b.this.h) {
                        switch (string) {
                            case "DELETED": {
                                if (!b.this.j()) break;
                                break;
                            }
                        }
                    } else {
                        Object object = new User.a();
                        ((User.a)object).a(n3).a(string);
                        arrayList.add(n3);
                    }
                    --b.this.e;
                    b.this.e = b.this.e >= 1 ? b.this.e : 1;
                }
                if (arrayList.size() != 0) {
                    b.this.a((List<EventListener>)b.this.d, arrayList.toArray(new Integer[0]));
                    b.this.a((List<EventListener>)b.this.d, b.this.e);
                }
            }
        });
        c2.a("user_count", new Emitter.Listener(){

            public void call(Object ... args) {
                if (args == null || args.length <= 0) {
                    return;
                }
                if (!(args[0] instanceof JSONObject)) {
                    return;
                }
                JSONObject jSONObject = (JSONObject)args[0];
                b.this.e = iKalaJSONUtil.getJSONInt((JSONObject)jSONObject, (String)"guestCount") + iKalaJSONUtil.getJSONInt((JSONObject)jSONObject, (String)"memberCount");
                b.this.a((List<EventListener>)b.this.d, b.this.e);
            }
        });
        c2.a("error", new Emitter.Listener(){

            public void call(Object ... args) {
            }
        });
        c2.a("chat_write_mode", new Emitter.Listener(){

            public void call(Object ... args) {
                if (args == null || args.length <= 0) {
                    return;
                }
                if (!(args[0] instanceof JSONObject)) {
                    return;
                }
                JSONObject jSONObject = (JSONObject)args[0];
                String string = iKalaJSONUtil.getJSONString((JSONObject)jSONObject, (String)"chatWriteMode", (String)"ALL");
                b.this.n = ChatMode.a(string);
                b.this.a((List<EventListener>)b.this.d, b.this.f());
            }
        });
        c2.a("message_input_interval", new Emitter.Listener(){

            public void call(Object ... args) {
                if (args == null || args.length <= 0) {
                    return;
                }
                if (!(args[0] instanceof JSONObject)) {
                    return;
                }
                JSONObject jSONObject = (JSONObject)args[0];
                String string = iKalaJSONUtil.getJSONString((JSONObject)jSONObject, (String)"chatId");
                if (!string.equals(b.this.f)) {
                    return;
                }
                b.this.b = iKalaJSONUtil.getJSONInt((JSONObject)jSONObject, (String)"inputInterval");
                b.this.b((List<EventListener>)b.this.d, b.this.g());
            }
        });
    }

    private void a(final List<EventListener> list, final Message message, long l2) {
        if (list == null) {
            return;
        }
        this.m.postDelayed(new Runnable(){

            @Override
            public void run() {
                for (EventListener eventListener : list) {
                    eventListener.onMessageAdded(message);
                }
            }
        }, l2);
    }

    private void a(final List<EventListener> list, final String string) {
        if (list == null) {
            return;
        }
        this.m.post(new Runnable(){

            @Override
            public void run() {
                for (EventListener eventListener : list) {
                    eventListener.onMessageRemoved(string);
                }
            }
        });
    }

    private void c(final List<EventListener> list) {
        if (list == null) {
            return;
        }
        this.m.post(new Runnable(){

            @Override
            public void run() {
                for (EventListener eventListener : list) {
                    eventListener.onMessageFlushed();
                }
            }
        });
    }

    private void a(final List<EventListener> list, final User[] userArray) {
        if (list == null) {
            return;
        }
        this.m.post(new Runnable(){

            @Override
            public void run() {
                for (EventListener eventListener : list) {
                    eventListener.onUserJoined(userArray);
                }
            }
        });
    }

    private void b(final List<EventListener> list, final User[] userArray) {
        if (list == null) {
            return;
        }
        this.m.post(new Runnable(){

            @Override
            public void run() {
                for (EventListener eventListener : list) {
                    eventListener.onUserUpdated(userArray);
                }
            }
        });
    }

    private void a(final List<EventListener> list, final Integer[] integerArray) {
        if (list == null) {
            return;
        }
        this.m.post(new Runnable(){

            @Override
            public void run() {
                for (EventListener eventListener : list) {
                    eventListener.onUserLeft(integerArray);
                }
            }
        });
    }

    private void a(final List<EventListener> list, final int n2) {
        if (list == null) {
            return;
        }
        this.m.post(new Runnable(){

            @Override
            public void run() {
                for (EventListener eventListener : list) {
                    eventListener.userCount(n2);
                }
            }
        });
    }

    private void a(final List<EventListener> list, final ChatMode chatMode) {
        if (list == null) {
            return;
        }
        this.m.post(new Runnable(){

            @Override
            public void run() {
                for (EventListener eventListener : list) {
                    eventListener.onChatWriteModeChanged(chatMode);
                }
            }
        });
    }

    private void b(final List<EventListener> list, final int n2) {
        if (list == null) {
            return;
        }
        this.m.post(new Runnable(){

            @Override
            public void run() {
                for (EventListener eventListener : list) {
                    eventListener.onInputIntervalChanged(n2);
                }
            }
        });
    }

    Task<Message[]> a(MessageRequest messageRequest) {
        if (this.a != ChatroomState.CONNECTED) {
            return Tasks.forException((Exception)new MessagingException.RequestRejectedException(new IllegalStateException("State must be CONNECTED.")));
        }
        int n2 = messageRequest.getPerPage();
        int n3 = messageRequest.getPage();
        Long l2 = messageRequest.getOldestDate();
        Long l3 = messageRequest.getLatestDate();
        if (!this.a(n3, n2, 100)) {
            return Tasks.forException((Exception)new MessagingException.RequestRejectedException(new IllegalArgumentException("Check page format is valid or not.")));
        }
        final TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        int n4 = (n3 - 1) * n2;
        Call<a.g> call = this.j.a(this.l, this.g, this.f, Collections.singletonList("USER"), true, n4, n2, l2, l3);
        call.enqueue((Callback)new a.b<a.g>(this.k, call, taskCompletionSource){

            @Override
            public void onResponse(Call<a.g> call, Response<a.g> response) {
                super.onResponse(call, response);
                a.g g2 = (a.g)response.body();
                if (!response.isSuccessful() || g2 == null || g2.messages == null) {
                    taskCompletionSource.trySetException((Exception)new MessagingException.InternalException());
                    return;
                }
                int n2 = g2.messages.length;
                Message[] messageArray = new Message[n2];
                for (int i2 = 0; i2 < n2; ++i2) {
                    Message message;
                    messageArray[i2] = message = new Message.Builder(g2.messages[i2], (SimpleArrayMap<String, String>)b.this.o).build();
                }
                taskCompletionSource.setResult((Object)messageArray);
            }
        });
        return taskCompletionSource.getTask();
    }

    Task<User[]> a(int n2, int n3) {
        if (this.a != ChatroomState.CONNECTED) {
            return Tasks.forException((Exception)new MessagingException.RequestRejectedException(new IllegalStateException("State must be CONNECTED.")));
        }
        if (!this.a(n2, n3, 200)) {
            return Tasks.forException((Exception)new MessagingException.RequestRejectedException(new IllegalArgumentException("Check page format is valid or not.")));
        }
        final TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        int n4 = (n2 - 1) * n3;
        Call<a.h> call = this.j.a(this.l, this.g, this.f, Collections.singletonList("ACTIVE"), null, null, n3, n4);
        call.enqueue((Callback)new a.b<a.h>(this.k, call, taskCompletionSource){

            @Override
            public void onResponse(Call<a.h> call, Response<a.h> response) {
                super.onResponse(call, response);
                a.h h2 = (a.h)response.body();
                if (!response.isSuccessful() || h2 == null || h2.users == null) {
                    taskCompletionSource.trySetException((Exception)new MessagingException.InternalException());
                    return;
                }
                int n2 = h2.users.length;
                User[] userArray = new User[n2];
                for (int i2 = 0; i2 < n2; ++i2) {
                    User user;
                    userArray[i2] = user = new User.a(h2.users[i2]).a();
                }
                taskCompletionSource.setResult((Object)userArray);
            }
        });
        return taskCompletionSource.getTask();
    }

    void a(Message message) {
        this.a(this.d, message, 100L);
    }

    Task<Void> b(final String string) {
        if (this.a != ChatroomState.CONNECTED) {
            return Tasks.forException((Exception)new IllegalStateException("State must be CONNECTED."));
        }
        if (this.c != Identity.GUEST) {
            return Tasks.forException((Exception)new IllegalStateException("Identity must be Identity.GUEST."));
        }
        final TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        Call<ResponseBody> call = this.j.a(this.l, new a.o(this.f, this.g, Collections.singletonList(new a.i(this.h, string, null))));
        call.enqueue((Callback)new a.b<ResponseBody>(this.k, call, taskCompletionSource){

            @Override
            public void onResponse(Call<ResponseBody> call, Response<ResponseBody> response) {
                super.onResponse(call, response);
                if (response.isSuccessful()) {
                    b.this.i.setName(string);
                    taskCompletionSource.setResult(null);
                }
            }
        });
        return taskCompletionSource.getTask();
    }

    Task<Void> a(List<User> list) {
        boolean bl;
        User user2;
        Role role = this.i.getRole();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (User user2 : list) {
            arrayList.add(user2.getLabel());
        }
        boolean bl2 = bl = role == Role.MASTER || role == Role.GLOBAL_MANAGER || role == Role.LOCAL_MANAGER;
        if (this.a != ChatroomState.CONNECTED) {
            return Tasks.forException((Exception)new MessagingException.RequestRejectedException(new IllegalStateException("State must be CONNECTED.")));
        }
        if (arrayList.size() == 0) {
            return Tasks.forException((Exception)new MessagingException.RequestRejectedException(new IllegalArgumentException("Users are emptys")));
        }
        if (!bl) {
            return Tasks.forException((Exception)new MessagingException.PermissionException("User must be MASTER, GLOBAL_MANAGER or LOCAL_MANAGER."));
        }
        user2 = new TaskCompletionSource();
        Call<ResponseBody> call = this.j.a(this.l, new a.d(this.f, this.g, arrayList));
        call.enqueue((Callback)new a.b<ResponseBody>(this.k, call, (TaskCompletionSource)user2, (TaskCompletionSource)user2){
            final /* synthetic */ TaskCompletionSource b;
            {
                this.b = taskCompletionSource2;
                super(callManager, call, taskCompletionSource);
            }

            @Override
            public void onResponse(Call<ResponseBody> call, Response<ResponseBody> response) {
                super.onResponse(call, response);
                if (response.isSuccessful()) {
                    this.b.setResult(null);
                }
            }
        });
        return user2.getTask();
    }

    Task<Void> b(List<User> list) {
        boolean bl;
        User user2;
        Role role = this.i.getRole();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (User user2 : list) {
            arrayList.add(user2.getLabel());
        }
        boolean bl2 = bl = role == Role.MASTER || role == Role.GLOBAL_MANAGER || role == Role.LOCAL_MANAGER;
        if (this.a != ChatroomState.CONNECTED) {
            return Tasks.forException((Exception)new MessagingException.RequestRejectedException(new IllegalStateException("State must be CONNECTED.")));
        }
        if (arrayList.size() == 0) {
            return Tasks.forException((Exception)new MessagingException.RequestRejectedException(new IllegalArgumentException("Users are empties")));
        }
        if (!bl) {
            return Tasks.forException((Exception)new MessagingException.PermissionException("User must be MASTER, GLOBAL_MANAGER or LOCAL_MANAGER."));
        }
        user2 = new TaskCompletionSource();
        Call<ResponseBody> call = this.j.b(this.l, new a.d(this.f, this.g, arrayList));
        call.enqueue((Callback)new a.b<ResponseBody>(this.k, call, (TaskCompletionSource)user2, (TaskCompletionSource)user2){
            final /* synthetic */ TaskCompletionSource b;
            {
                this.b = taskCompletionSource2;
                super(callManager, call, taskCompletionSource);
            }

            @Override
            public void onResponse(Call<ResponseBody> call, Response<ResponseBody> response) {
                super.onResponse(call, response);
                if (response.isSuccessful()) {
                    this.b.setResult(null);
                }
            }
        });
        return user2.getTask();
    }

    Task<Void> b(Message message) {
        boolean bl;
        Role role = this.i.getRole();
        String string = message.getId();
        boolean bl2 = bl = role == Role.MASTER || role == Role.GLOBAL_MANAGER || role == Role.LOCAL_MANAGER;
        if (this.a != ChatroomState.CONNECTED) {
            return Tasks.forException((Exception)new MessagingException.RequestRejectedException(new IllegalStateException("State must be CONNECTED.")));
        }
        if (string == null) {
            return Tasks.forException((Exception)new MessagingException.RequestRejectedException(new IllegalArgumentException("Check message ID.")));
        }
        if (!bl) {
            return Tasks.forException((Exception)new MessagingException.PermissionException("User must be MASTER, GLOBAL_MANAGER or LOCAL_MANAGER."));
        }
        final TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        Call<ResponseBody> call = this.j.a(this.l, this.g, this.f, string);
        call.enqueue((Callback)new a.b<ResponseBody>(this.k, call, taskCompletionSource){

            @Override
            public void onResponse(Call<ResponseBody> call, Response<ResponseBody> response) {
                super.onResponse(call, response);
                if (response.isSuccessful()) {
                    taskCompletionSource.setResult(null);
                }
            }
        });
        return taskCompletionSource.getTask();
    }

    List<Sticker> k() {
        return this.p;
    }
}

