/*
 * Decompiled with CFR 0.152.
 */
package io.straas.android.sdk.messaging;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.CountDownTimer;
import android.os.Handler;
import android.preference.PreferenceManager;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.android.gms.tasks.Tasks;
import com.ikala.android.controller.Retriable;
import com.ikala.android.controller.RetryDelayController;
import com.ikala.android.httptask.CallManager;
import com.ikala.android.httptask.error.HttpTaskError;
import com.ikala.android.utils.iKalaUtils;
import com.squareup.moshi.JsonDataException;
import com.squareup.moshi.Moshi;
import io.socket.client.IO;
import io.socket.client.Socket;
import io.socket.client.SocketIOException;
import io.socket.emitter.Emitter;
import io.straas.android.sdk.base.credential.Credential;
import io.straas.android.sdk.base.identity.Identity;
import io.straas.android.sdk.base.internal.Utils;
import io.straas.android.sdk.messaging.ChatMode;
import io.straas.android.sdk.messaging.ChatroomInfo;
import io.straas.android.sdk.messaging.ChatroomManager;
import io.straas.android.sdk.messaging.ChatroomState;
import io.straas.android.sdk.messaging.MessagingException;
import io.straas.android.sdk.messaging.User;
import io.straas.android.sdk.messaging.a.a;
import io.straas.android.sdk.messaging.a.a.a;
import io.straas.android.sdk.messaging.interfaces.EventListener;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.URISyntaxException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.SSLContext;
import okhttp3.Interceptor;
import okhttp3.ResponseBody;
import org.json.JSONArray;
import org.json.JSONObject;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

abstract class a {
    private static final String[] o = new String[]{"websocket"};
    ChatroomState a = ChatroomState.IDLE;
    int b;
    private String p;
    Identity c;
    private boolean q;
    List<EventListener> d;
    int e;
    String f;
    String g;
    Integer h;
    User i;
    private boolean r;
    io.straas.android.sdk.messaging.a.a j;
    final CallManager k = new CallManager();
    private RetryDelayController s;
    String l;
    private SharedPreferences t;
    Handler m = new Handler();
    private c u;
    private TaskCompletionSource<Void> v;
    ChatMode n = ChatMode.ALL;
    private a.a$a w = new a.a$a(){

        @Override
        public void a(String string) {
            a.this.l = string;
            if (a.this.t != null) {
                a.this.t.edit().putString("KEY_API_TOKEN", string).apply();
            }
        }
    };
    private CountDownTimer x = new CountDownTimer(5000L, 5000L){

        public void onTick(long l2) {
        }

        public void onFinish() {
            a.this.a(new MessagingException.InternalException("timeout"));
        }
    };

    a(Context context) {
        this.k();
        this.t = PreferenceManager.getDefaultSharedPreferences((Context)context);
    }

    private void k() {
        this.s = new RetryDelayController(new Retriable(){

            public void retry() {
                a.this.q();
            }
        });
        this.s.setMaxCount(7);
        this.s.enableExponentialBackoff(true);
        this.s.setBaseRetryInterval(500L);
    }

    private io.straas.android.sdk.messaging.a.a b(Identity identity) {
        return (io.straas.android.sdk.messaging.a.a)Utils.createMemberRetrofit((String)"https://mgr.straas.net", (Identity)identity, (Interceptor[])new Interceptor[]{new io.straas.android.sdk.messaging.a.a.a("https://mgr.straas.net", this.w)}).create(io.straas.android.sdk.messaging.a.a.class);
    }

    Task<Void> a(@NonNull String string, @NonNull Identity identity, EventListener ... eventListenerArray) {
        MessagingException.RequestRejectedException requestRejectedException = null;
        if (this.a != ChatroomState.IDLE) {
            requestRejectedException = new MessagingException.RequestRejectedException(new IllegalStateException("State must be IDLE."));
        }
        if (TextUtils.isEmpty((CharSequence)string) || identity == null) {
            requestRejectedException = new MessagingException.RequestRejectedException(new IllegalArgumentException("Check chatroom name or Identity."));
        }
        if (requestRejectedException != null) {
            this.a(new ArrayList<EventListener>(Arrays.asList(eventListenerArray)), requestRejectedException);
            return Tasks.forException((Exception)requestRejectedException);
        }
        this.v = new TaskCompletionSource();
        this.a = ChatroomState.CONNECTING;
        this.c = identity;
        this.p = string;
        boolean bl = this.q = string.startsWith("p#") || string.startsWith("dp#");
        if (eventListenerArray != null) {
            this.d = new ArrayList<EventListener>(Arrays.asList(eventListenerArray));
        }
        this.j = this.b(identity);
        this.s.stop();
        this.r = false;
        this.m();
        return this.v.getTask();
    }

    boolean a(Identity identity) {
        if (this.a.equals((Object)ChatroomState.CONNECTED)) {
            this.c = identity;
            this.j = this.b(identity);
            return true;
        }
        return false;
    }

    private void l() {
        if (!TextUtils.isEmpty((CharSequence)this.l)) {
            return;
        }
        String string = null;
        if (this.t != null) {
            string = this.t.getString("KEY_API_TOKEN", null);
        }
        this.l = !TextUtils.isEmpty(string) ? string : "unknownApiToken";
    }

    private void a(int n2) {
        switch (n2) {
            case 0: {
                this.n();
                break;
            }
            case 1: {
                this.o();
                break;
            }
            case 2: {
                this.p();
            }
        }
    }

    private void m() {
        this.a = ChatroomState.CONNECTING;
        this.l();
        this.a(0);
    }

    protected void a(a$f f2) {
    }

    private void n() {
        final String string = Credential.getAccountId();
        if (TextUtils.isEmpty((CharSequence)string)) {
            this.b(new MessagingException.InternalException("check your sdk account_id"));
            this.i();
        }
        Call<a$f> call = this.j.a(this.l, this.p, string);
        call.enqueue((Callback)new a<a$f>(this.k, call, null){

            @Override
            public void onResponse(Call<a$f> call, Response<a$f> response) {
                super.onResponse(call, response);
                if (!a.this.j()) {
                    return;
                }
                if (response.isSuccessful() && response.body() != null) {
                    a.this.f = ((a$f)response.body()).id;
                    a.this.b = ((a$f)response.body()).inputInterval;
                    a.this.n = ChatMode.a(((a$f)response.body()).chatWriteMode);
                    a.this.e = ((a$f)response.body()).guestCount + ((a$f)response.body()).memberCount;
                    a.this.a((a$f)response.body());
                    a.this.a(1);
                }
            }

            @Override
            protected void a(Exception exception) {
                if (exception instanceof MessagingException.ChatroomNameNotFoundException && a.this.q && !a.this.c.isGuest()) {
                    a.this.a(a.this.p, string);
                } else {
                    super.a(exception);
                }
            }
        });
    }

    private void a(String string, String string2) {
        Call<ResponseBody> call = this.j.a(this.l, new a$e(string2, string.startsWith("d")));
        call.enqueue((Callback)new a<ResponseBody>(this.k, call, null){

            @Override
            public void onResponse(Call<ResponseBody> call, Response<ResponseBody> response) {
                super.onResponse(call, response);
                if (!a.this.j()) {
                    return;
                }
                if (response.isSuccessful()) {
                    a.this.a(0);
                }
            }
        });
    }

    private void o() {
        String string = this.c == Identity.GUEST ? "Guest" : null;
        Call<a$c> call = this.j.a(this.l, new a$b(this.f, this.g, string));
        call.enqueue((Callback)new a<a$c>(this.k, call, null){

            @Override
            public void onResponse(Call<a$c> call, Response<a$c> response) {
                super.onResponse(call, response);
                if (!a.this.j()) {
                    return;
                }
                if (response.isSuccessful() && response.body() != null) {
                    a$c$a a2 = ((a$c)response.body()).userMetas[0];
                    a.this.g = a2.userToken;
                    a.this.h = a2.label;
                    a.this.a(((a$c)response.body()).socket);
                }
            }
        });
    }

    private void p() {
        this.s.stop();
        this.a = ChatroomState.CONNECTED;
        if (!this.r) {
            this.r = true;
            if (this.v != null) {
                this.v.trySetResult(null);
                this.v = null;
            }
            this.a(this.d);
        }
    }

    private void a(a$m m2) {
        Socket socket;
        IO.Options options = new IO.Options();
        options.reconnection = false;
        options.rememberUpgrade = true;
        options.forceNew = true;
        options.path = m2.path;
        options.query = m2.query;
        options.transports = o;
        options.timeout = 30000L;
        try {
            options.sslContext = SSLContext.getDefault();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            noSuchAlgorithmException.printStackTrace();
        }
        try {
            socket = IO.socket((String)m2.host, (IO.Options)options);
        }
        catch (URISyntaxException uRISyntaxException) {
            this.a(new MessagingException.InternalException(uRISyntaxException.getMessage()));
            return;
        }
        this.u = new c(socket);
        this.b(this.u);
        this.a(this.u);
        socket.connect();
    }

    private void b(final c c2) {
        if (c2 == null) {
            return;
        }
        c2.a("connect", new Emitter.Listener(){

            public void call(Object ... args) {
                JSONArray jSONArray = new JSONArray();
                jSONArray.put((Object)a.this.g);
                jSONArray.put((Object)a.this.f);
                a.this.x.start();
                c2.a("subscribe", a.this.g, a.this.f);
            }
        });
        c2.a("connect_error", new Emitter.Listener(){

            public void call(Object ... args) {
                Object object = args.length > 0 ? args[0] : null;
                a.this.a(new MessagingException.NetworkException((Throwable)new SocketIOException("Connection error", (Throwable)(object instanceof Exception ? (Exception)object : null))));
            }
        });
        c2.a("disconnect", new Emitter.Listener(){

            public void call(Object ... args) {
                if (!a.this.j()) {
                    return;
                }
                Object object = args.length > 0 ? args[0] : null;
                String string = object instanceof String ? (String)object : null;
                a.this.a(new MessagingException.NetworkException((Throwable)new SocketIOException(string)));
            }
        });
    }

    protected void a(c c2) {
        if (c2 == null) {
            return;
        }
        c2.a("subscribed", new Emitter.Listener(){

            public void call(Object ... args) {
                if (args == null || args.length <= 0) {
                    return;
                }
                if (!(args[0] instanceof JSONObject)) {
                    return;
                }
                a.this.x.cancel();
                a.this.i = User.a((JSONObject)args[0]);
                ++a.this.e;
                a.this.a(2);
            }
        });
        c2.a("message", new Emitter.Listener(){

            public void call(Object ... args) {
                if (args.length <= 0) {
                    return;
                }
                if (!(args[0] instanceof JSONObject)) {
                    return;
                }
                a.this.a(args);
            }
        });
    }

    protected abstract void a(Object ... var1);

    void a() {
        if (this.d == null) {
            return;
        }
        this.d.clear();
    }

    void b() {
        this.m.removeCallbacksAndMessages(null);
    }

    private void a(final List<EventListener> list) {
        if (list == null) {
            return;
        }
        this.m.post(new Runnable(){

            @Override
            public void run() {
                for (EventListener eventListener : list) {
                    eventListener.onConnected();
                }
            }
        });
    }

    private void a(final List<EventListener> list, final Exception exception) {
        if (list == null) {
            return;
        }
        this.m.post(new Runnable(){

            @Override
            public void run() {
                for (EventListener eventListener : list) {
                    eventListener.onConnectFailed(exception);
                    eventListener.onConnectFailed(ChatroomManager.exceptionToMessagingError(exception));
                }
            }
        });
    }

    private void b(final List<EventListener> list, final Exception exception) {
        if (list == null) {
            return;
        }
        this.m.post(new Runnable(){

            @Override
            public void run() {
                for (EventListener eventListener : list) {
                    eventListener.onError(exception);
                    eventListener.onError(ChatroomManager.exceptionToMessagingError(exception));
                }
            }
        });
    }

    private void b(final List<EventListener> list) {
        if (list == null) {
            return;
        }
        this.m.post(new Runnable(){

            @Override
            public void run() {
                for (EventListener eventListener : list) {
                    eventListener.onDisconnected();
                }
            }
        });
    }

    Task<ChatroomInfo> c() {
        if (this.a != ChatroomState.CONNECTED) {
            return Tasks.forException((Exception)new MessagingException.RequestRejectedException(new IllegalStateException("State must be CONNECTED.")));
        }
        String string = Credential.getAccountId();
        if (TextUtils.isEmpty((CharSequence)string)) {
            MessagingException.InternalException internalException = new MessagingException.InternalException("check your sdk account_id");
            this.b(internalException);
            return Tasks.forException((Exception)internalException);
        }
        final TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        Call<a$f> call = this.j.a(this.l, this.p, string);
        call.enqueue((Callback)new b<a$f>(this.k, call, taskCompletionSource){

            @Override
            public void onResponse(Call<a$f> call, Response<a$f> response) {
                super.onResponse(call, response);
                if (response.isSuccessful() && response.body() != null) {
                    taskCompletionSource.setResult((Object)((a$f)response.body()).toChatroomInfo());
                }
            }
        });
        return taskCompletionSource.getTask();
    }

    Task<Void> a(String string) {
        if (this.a != ChatroomState.CONNECTED) {
            return Tasks.forException((Exception)new MessagingException.RequestRejectedException(new IllegalStateException("State must be CONNECTED.")));
        }
        if (TextUtils.isEmpty((CharSequence)string)) {
            return Tasks.forException((Exception)new MessagingException.RequestRejectedException(new IllegalArgumentException("Message is empty, say something please.")));
        }
        final TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        Call<ResponseBody> call = this.j.a(this.l, new a$a(this.f, this.g, string, null));
        call.enqueue((Callback)new b<ResponseBody>(this.k, call, taskCompletionSource){

            @Override
            public void onResponse(Call<ResponseBody> call, Response<ResponseBody> response) {
                super.onResponse(call, response);
                if (response.isSuccessful()) {
                    taskCompletionSource.setResult(null);
                }
            }
        });
        return taskCompletionSource.getTask();
    }

    User d() {
        return this.i;
    }

    int e() {
        return this.e;
    }

    ChatMode f() {
        return this.n;
    }

    int g() {
        return this.b;
    }

    ChatroomState h() {
        return this.a;
    }

    Task<Void> i() {
        if (!this.j()) {
            return Tasks.forException((Exception)new IllegalStateException());
        }
        return this.a(false);
    }

    private void q() {
        this.a(true);
    }

    private Task<Void> a(boolean bl) {
        if (bl) {
            this.a = ChatroomState.CONNECTING;
        } else {
            this.a = ChatroomState.DISCONNECTING;
            this.s.stop();
        }
        this.k.cancelAllCalls();
        this.s();
        if (iKalaUtils.isEmptyString((CharSequence)this.g) || iKalaUtils.isEmptyString((CharSequence)this.f) || this.h == null) {
            if (bl) {
                this.m();
            }
        } else {
            this.b(bl);
            this.r();
        }
        if (!bl) {
            this.a = ChatroomState.IDLE;
            if (this.r) {
                this.b(this.d);
                return Tasks.forResult(null);
            }
        }
        return Tasks.forException((Exception)new Exception());
    }

    private void r() {
        this.f = null;
        this.g = null;
        this.h = null;
        this.i = null;
    }

    private synchronized void s() {
        if (this.u == null) {
            return;
        }
        this.u.a.off();
        this.u.a.disconnect();
    }

    private void b(final boolean bl) {
        Call<ResponseBody> call = this.j.a(this.l, this.g, this.f, Collections.singletonList(this.h));
        call.enqueue((Callback)new CallManager.Callback<ResponseBody>(this.k, call, null){

            public void onResponse(Call<ResponseBody> call, Response<ResponseBody> response) {
                super.onResponse(call, response);
                if (bl) {
                    a.this.m();
                }
            }

            public void onFailure(Call<ResponseBody> call, Throwable t) {
                super.onFailure(call, t);
                Exception exception = a.this.a(call, t);
                if (bl && !(exception instanceof InterruptedIOException)) {
                    a.this.m();
                }
            }
        });
    }

    private void a(Exception exception) {
        if (!this.j()) {
            this.b(exception);
            return;
        }
        if (!this.c(exception) || !this.s.retry()) {
            this.b(exception);
            this.i();
        }
    }

    private void b(Exception exception) {
        if (!this.r) {
            this.a(this.d, exception);
            if (this.v != null) {
                this.v.trySetException(exception);
            }
        } else if (!(exception instanceof InterruptedIOException)) {
            this.b(this.d, exception);
        }
    }

    private boolean c(Exception exception) {
        if (exception instanceof MessagingException.NetworkException || exception instanceof MessagingException.InternalException || exception instanceof MessagingException.ServerException) {
            return true;
        }
        if (exception instanceof MessagingException.UnauthorizedException || exception instanceof MessagingException.PermissionException || exception instanceof MessagingException.ChatroomNameNotFoundException || exception instanceof MessagingException.RequestRejectedException || exception instanceof InterruptedIOException) {
            return false;
        }
        return false;
    }

    private Exception a(Response response) {
        int n2 = response.code();
        a$l l2 = this.a(response.errorBody());
        if (l2 == null || l2.code == null) {
            return new MessagingException.InternalException("Unknown error");
        }
        switch (n2) {
            case 401: {
                if (!l2.code.equals("UnauthorizedError")) break;
                return new MessagingException.UnauthorizedException();
            }
            case 403: {
                if (!l2.code.equals("PermissionViolationError")) break;
                return new MessagingException.PermissionException(Integer.toString(n2));
            }
            case 404: {
                if (!l2.code.equals("EntityNotFoundError")) break;
                return new MessagingException.ChatroomNameNotFoundException(this.p);
            }
            case 409: {
                if (!l2.code.equals("DuplicateEntityError") && !l2.code.equals("InvalidRequestError")) break;
                return new MessagingException.InternalException(Integer.toString(n2));
            }
            case 500: 
            case 501: 
            case 502: 
            case 503: 
            case 504: 
            case 505: {
                return new MessagingException.ServerException(n2);
            }
            case 400: {
                return new MessagingException.InternalException(Integer.toString(n2));
            }
            default: {
                return new MessagingException.InternalException();
            }
        }
        return new MessagingException.InternalException();
    }

    private Exception a(Call call, Throwable throwable) {
        int n2 = HttpTaskError.getThrowableMappingId((Call)call, (Throwable)throwable);
        switch (n2) {
            case 6: {
                return new InterruptedIOException("canceled");
            }
        }
        return new MessagingException.NetworkException(throwable);
    }

    boolean j() {
        return this.a == ChatroomState.CONNECTING || this.a == ChatroomState.CONNECTED;
    }

    private a$l a(ResponseBody responseBody) {
        a$l l2;
        Moshi moshi = new Moshi.Builder().build();
        try {
            l2 = (a$l)moshi.adapter(a$l.class).fromJson(responseBody.source());
        }
        catch (JsonDataException | IOException throwable) {
            throwable.printStackTrace();
            l2 = new a$l();
        }
        return l2;
    }

    boolean a(int n2, int n3, int n4) {
        return n2 > 0 && n3 > 0 && n3 <= n4;
    }

    static final class c {
        Socket a;

        c(Socket socket) {
            this.a = socket;
        }

        Emitter a(String string, Object ... objectArray) {
            return this.a.emit(string, objectArray);
        }

        Emitter a(String string, Emitter.Listener listener) {
            return this.a.on(string, listener);
        }
    }

    class b<T>
    extends CallManager.Callback<T> {
        private int b;
        private final TaskCompletionSource c;

        b(@Nullable CallManager callManager, @Nullable Call call, TaskCompletionSource taskCompletionSource) {
            super(callManager, call, null);
            this.b = 0;
            this.c = taskCompletionSource;
        }

        public void onResponse(Call<T> call, Response<T> response) {
            super.onResponse(call, response);
            if (!response.isSuccessful()) {
                Exception exception = a.this.a(response);
                this.a(call, exception);
            }
        }

        public void onFailure(Call<T> call, Throwable t) {
            super.onFailure(call, t);
            Exception exception = a.this.a(call, t);
            this.a(call, exception);
        }

        private void a(final Call<T> call, Exception exception) {
            if (++this.b <= 3 && a.this.j() && a.this.c(exception)) {
                a.this.m.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        Call call2 = call.clone();
                        call2.enqueue((Callback)b.this);
                    }
                }, 1000L);
            } else if (this.c != null && !(exception instanceof InterruptedIOException)) {
                this.c.trySetException(exception);
            }
        }
    }

    private class a<T>
    extends CallManager.Callback<T> {
        public a(@Nullable CallManager callManager, @Nullable Call call, @Nullable CallManager.OnHttpTaskLoadingCallback onHttpTaskLoadingCallback) {
            super(callManager, call, onHttpTaskLoadingCallback);
        }

        public void onResponse(Call<T> call, Response<T> response) {
            super.onResponse(call, response);
            if (!response.isSuccessful()) {
                Exception exception = a.this.a(response);
                this.a(exception);
            }
        }

        public void onFailure(Call<T> call, Throwable t) {
            super.onFailure(call, t);
            Exception exception = a.this.a(call, t);
            this.a(exception);
        }

        protected void a(Exception exception) {
            a.this.a(exception);
        }
    }
}

