/*
 * Decompiled with CFR 0.152.
 */
package io.straas.android.sdk.messaging;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.CountDownTimer;
import android.os.Handler;
import android.preference.PreferenceManager;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.util.SimpleArrayMap;
import android.text.TextUtils;
import com.ikala.android.controller.Retriable;
import com.ikala.android.controller.RetryDelayController;
import com.ikala.android.httptask.CallManager;
import com.ikala.android.httptask.error.HttpTaskError;
import com.ikala.android.utils.iKalaJSONUtil;
import com.ikala.android.utils.iKalaUtils;
import com.squareup.moshi.JsonDataException;
import com.squareup.moshi.Moshi;
import io.socket.client.IO;
import io.socket.client.Socket;
import io.socket.emitter.Emitter;
import io.straas.android.sdk.base.credential.Credential;
import io.straas.android.sdk.base.identity.Identity;
import io.straas.android.sdk.base.interfaces.OnResultListener;
import io.straas.android.sdk.base.internal.Utils;
import io.straas.android.sdk.messaging.ChatMode;
import io.straas.android.sdk.messaging.ChatroomInfo;
import io.straas.android.sdk.messaging.ChatroomState;
import io.straas.android.sdk.messaging.Message;
import io.straas.android.sdk.messaging.MessagingError;
import io.straas.android.sdk.messaging.Role;
import io.straas.android.sdk.messaging.User;
import io.straas.android.sdk.messaging.a.a;
import io.straas.android.sdk.messaging.a.a.a;
import io.straas.android.sdk.messaging.interfaces.EventListener;
import java.io.IOException;
import java.net.URISyntaxException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.SSLContext;
import okhttp3.Interceptor;
import okhttp3.ResponseBody;
import org.json.JSONArray;
import org.json.JSONObject;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

class a {
    private static final String[] a = new String[]{"websocket"};
    private ChatroomState b = ChatroomState.IDLE;
    private int c;
    private String d;
    private Identity e;
    private boolean f;
    private List<EventListener> g;
    private String h;
    private int i;
    private SimpleArrayMap<String, String> j;
    private String k;
    private String l;
    private Integer m;
    private User n;
    private boolean o;
    private io.straas.android.sdk.messaging.a.a p;
    private final CallManager q = new CallManager();
    private RetryDelayController r;
    private String s;
    private SharedPreferences t;
    private Handler u = new Handler();
    private c v;
    private ChatMode w = ChatMode.ALL;
    private a.a$a x = new a.a$a(){

        @Override
        public void a(String string) {
            a.this.s = string;
            if (a.this.t != null) {
                a.this.t.edit().putString("KEY_API_TOKEN", string).apply();
            }
        }
    };
    private CountDownTimer y = new CountDownTimer(5000L, 5000L){

        public void onTick(long l2) {
        }

        public void onFinish() {
            a.this.a(MessagingError.INTERNAL_ERROR);
        }
    };

    a(Context context) {
        this.h();
        this.t = PreferenceManager.getDefaultSharedPreferences((Context)context);
    }

    private void h() {
        this.r = new RetryDelayController(new Retriable(){

            public void retry() {
                a.this.p();
            }
        });
        this.r.setMaxCount(7);
        this.r.enableExponentialBackoff(true);
        this.r.setBaseRetryInterval(500L);
    }

    private io.straas.android.sdk.messaging.a.a b(Identity identity) {
        return (io.straas.android.sdk.messaging.a.a)Utils.createMemberRetrofit((String)"https://mgr.straas.net", (Identity)identity, (Interceptor[])new Interceptor[]{new io.straas.android.sdk.messaging.a.a.a("https://mgr.straas.net", this.x)}).create(io.straas.android.sdk.messaging.a.a.class);
    }

    void a(@NonNull String string, @NonNull Identity identity, boolean bl, EventListener ... eventListenerArray) {
        if (this.b != ChatroomState.IDLE || TextUtils.isEmpty((CharSequence)string) || identity == null) {
            this.a(new ArrayList<EventListener>(Arrays.asList(eventListenerArray)), MessagingError.REQUEST_REJECTED);
            return;
        }
        this.b = ChatroomState.CONNECTING;
        this.e = identity;
        this.d = string;
        this.f = bl;
        if (eventListenerArray != null) {
            this.g = new ArrayList<EventListener>(Arrays.asList(eventListenerArray));
        }
        this.p = this.b(identity);
        this.r.stop();
        this.o = false;
        this.j();
    }

    boolean a(Identity identity) {
        if (this.b.equals((Object)ChatroomState.CONNECTED)) {
            this.e = identity;
            this.p = this.b(identity);
            return true;
        }
        return false;
    }

    private void i() {
        if (!TextUtils.isEmpty((CharSequence)this.s)) {
            return;
        }
        String string = null;
        if (this.t != null) {
            string = this.t.getString("KEY_API_TOKEN", null);
        }
        this.s = !TextUtils.isEmpty(string) ? string : "unknownApiToken";
    }

    private void a(int n2) {
        switch (n2) {
            case 0: {
                this.k();
                break;
            }
            case 1: {
                this.l();
                break;
            }
            case 2: {
                this.m();
                break;
            }
            case 3: {
                this.n();
            }
        }
    }

    private void j() {
        this.b = ChatroomState.CONNECTING;
        this.i();
        this.a(0);
    }

    private void k() {
        final String string = Credential.getAccountId();
        if (TextUtils.isEmpty((CharSequence)string)) {
            this.b(MessagingError.INTERNAL_ERROR);
            this.g();
        }
        Call<a$f> call = this.p.a(this.s, this.d, string);
        call.enqueue((Callback)new a<a$f>(this.q, call, null){

            @Override
            public void onResponse(Call<a$f> call, Response<a$f> response) {
                super.onResponse(call, response);
                if (!a.this.s()) {
                    return;
                }
                if (response.isSuccessful() && response.body() != null) {
                    a.this.k = ((a$f)response.body()).id;
                    a.this.c = ((a$f)response.body()).inputInterval;
                    a.this.w = ChatMode.a(((a$f)response.body()).chatWriteMode);
                    a.this.i = ((a$f)response.body()).guestCount + ((a$f)response.body()).memberCount;
                    a.this.j = ((a$f)response.body()).getStickerMap();
                    a.this.a(1);
                }
            }

            @Override
            protected void a(MessagingError messagingError) {
                if (messagingError == MessagingError.UNKNOWN_CHATROOM && a.this.f && !a.this.e.isGuest()) {
                    a.this.a(a.this.d, string);
                } else {
                    super.a(messagingError);
                }
            }
        });
    }

    private void a(String string, String string2) {
        Call<ResponseBody> call = this.p.a(this.s, new a$e(string, string2));
        call.enqueue((Callback)new a<ResponseBody>(this.q, call, null){

            @Override
            public void onResponse(Call<ResponseBody> call, Response<ResponseBody> response) {
                super.onResponse(call, response);
                if (!a.this.s()) {
                    return;
                }
                if (response.isSuccessful()) {
                    a.this.a(0);
                }
            }
        });
    }

    private void l() {
        this.h = this.e == Identity.GUEST ? "Guest" : null;
        Call<a$c> call = this.p.a(this.s, new a$b(this.k, this.l, this.h));
        call.enqueue((Callback)new a<a$c>(this.q, call, null){

            @Override
            public void onResponse(Call<a$c> call, Response<a$c> response) {
                super.onResponse(call, response);
                if (!a.this.s()) {
                    return;
                }
                if (response.isSuccessful() && response.body() != null) {
                    a$c$a a2 = ((a$c)response.body()).userMetas[0];
                    a.this.l = a2.userToken;
                    a.this.m = (Integer)a2.label;
                    a.this.a(2);
                }
            }
        });
    }

    private void m() {
        this.o();
    }

    private void n() {
        this.r.stop();
        this.b = ChatroomState.CONNECTED;
        if (!this.o) {
            this.o = true;
            this.a(this.g);
        }
    }

    private void o() {
        Socket socket;
        IO.Options options = new IO.Options();
        options.reconnection = false;
        options.rememberUpgrade = true;
        options.forceNew = true;
        options.transports = a;
        options.timeout = 30000L;
        try {
            options.sslContext = SSLContext.getDefault();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            noSuchAlgorithmException.printStackTrace();
        }
        try {
            socket = IO.socket((String)"https://mgs.straas.net", (IO.Options)options);
        }
        catch (URISyntaxException uRISyntaxException) {
            uRISyntaxException.printStackTrace();
            this.a(MessagingError.INTERNAL_ERROR);
            return;
        }
        this.v = new c(socket);
        this.a(this.v);
        this.b(this.v);
        socket.connect();
    }

    private void a(final c c2) {
        if (c2 == null) {
            return;
        }
        c2.a("connect", new Emitter.Listener(){

            public void call(Object ... objectArray) {
                JSONArray jSONArray = new JSONArray();
                jSONArray.put((Object)a.this.l);
                jSONArray.put((Object)a.this.k);
                a.this.y.start();
                c2.a("subscribe", a.this.l, a.this.k);
            }
        });
        c2.a("connect_error", new Emitter.Listener(){

            public void call(Object ... objectArray) {
                a.this.a(MessagingError.NETWORK_ERROR);
            }
        });
        c2.a("disconnect", new Emitter.Listener(){

            public void call(Object ... objectArray) {
                if (!a.this.s()) {
                    return;
                }
                a.this.a(MessagingError.NETWORK_ERROR);
            }
        });
    }

    private void b(c c2) {
        if (c2 == null) {
            return;
        }
        c2.a("subscribed", new Emitter.Listener(){

            public void call(Object ... objectArray) {
                if (objectArray == null || objectArray.length <= 0) {
                    return;
                }
                if (!(objectArray[0] instanceof JSONObject)) {
                    return;
                }
                a.this.y.cancel();
                a.this.n = User.a((JSONObject)objectArray[0]);
                a.this.i++;
                a.this.a(3);
            }
        });
        c2.a("message", new Emitter.Listener(){

            public void call(Object ... objectArray) {
                if (objectArray.length <= 0) {
                    return;
                }
                if (!(objectArray[0] instanceof JSONObject)) {
                    return;
                }
                JSONObject jSONObject = (JSONObject)objectArray[0];
                Message message = Message.a(jSONObject, (SimpleArrayMap<String, String>)a.this.j);
                a.this.a((List<EventListener>)a.this.g, message);
            }
        });
        c2.a("message_remove", new Emitter.Listener(){

            public void call(Object ... objectArray) {
                if (objectArray == null || objectArray.length <= 0) {
                    return;
                }
                if (!(objectArray[0] instanceof String)) {
                    return;
                }
                String string = (String)objectArray[0];
                a.this.a((List<EventListener>)a.this.g, string);
            }
        });
        c2.a("message_flush", new Emitter.Listener(){

            public void call(Object ... objectArray) {
                a.this.c(a.this.g);
            }
        });
        c2.a("user_add", new Emitter.Listener(){

            public void call(Object ... objectArray) {
                if (objectArray == null || objectArray.length <= 0) {
                    return;
                }
                if (!(objectArray[0] instanceof JSONArray)) {
                    return;
                }
                JSONArray jSONArray = (JSONArray)objectArray[0];
                int n2 = jSONArray.length();
                ArrayList<User> arrayList = new ArrayList<User>();
                for (int i2 = 0; i2 < n2; ++i2) {
                    JSONObject jSONObject = iKalaJSONUtil.getJSONObjectFromJSONArray((JSONArray)jSONArray, (int)i2);
                    if (jSONObject == null) continue;
                    User user = User.a(jSONObject);
                    if (a.this.m != null && a.this.m.intValue() == user.getLabel().intValue()) continue;
                    arrayList.add(user);
                    a.this.i++;
                }
                if (arrayList.size() != 0) {
                    a.this.a((List<EventListener>)a.this.g, arrayList.toArray(new User[0]));
                    a.this.a((List<EventListener>)a.this.g, a.this.i);
                }
            }
        });
        c2.a("user_update", new Emitter.Listener(){

            public void call(Object ... objectArray) {
                int n2 = 0;
                if (objectArray == null || objectArray.length <= 0) {
                    return;
                }
                if (!(objectArray[0] instanceof JSONArray)) {
                    return;
                }
                JSONArray jSONArray = (JSONArray)objectArray[0];
                n2 = jSONArray.length();
                ArrayList<User> arrayList = new ArrayList<User>();
                for (int i2 = 0; i2 < n2; ++i2) {
                    JSONObject jSONObject = (JSONObject)iKalaJSONUtil.getObjectFromJSONArray((JSONArray)jSONArray, (int)i2);
                    User user = User.a(jSONObject);
                    arrayList.add(user);
                    if (a.this.m == null || a.this.m.intValue() != user.getLabel().intValue()) continue;
                    a.this.n = user;
                }
                if (arrayList.size() != 0) {
                    a.this.b((List<EventListener>)a.this.g, arrayList.toArray(new User[0]));
                }
            }
        });
        c2.a("user_remove", new Emitter.Listener(){

            public void call(Object ... objectArray) {
                if (objectArray == null || objectArray.length <= 0) {
                    return;
                }
                if (!(objectArray[0] instanceof JSONArray)) {
                    return;
                }
                JSONArray jSONArray = (JSONArray)objectArray[0];
                int n2 = jSONArray.length();
                ArrayList<Integer> arrayList = new ArrayList<Integer>();
                for (int i2 = 0; i2 < n2; ++i2) {
                    JSONObject jSONObject = (JSONObject)iKalaJSONUtil.getObjectFromJSONArray((JSONArray)jSONArray, (int)i2);
                    int n3 = iKalaJSONUtil.getJSONInt((JSONObject)jSONObject, (String)"label", (int)-1);
                    if (-1 == n3) continue;
                    String string = iKalaJSONUtil.getJSONString((JSONObject)jSONObject, (String)"status");
                    if (a.this.m != null && n3 == a.this.m) {
                        switch (string) {
                            case "DELETED": {
                                if (!a.this.s()) break;
                                break;
                            }
                        }
                    } else {
                        Object object = new User.a();
                        ((User.a)object).a(n3).a(string);
                        arrayList.add(n3);
                    }
                    a.this.i--;
                    a.this.i = a.this.i >= 1 ? a.this.i : 1;
                }
                if (arrayList.size() != 0) {
                    a.this.a((List<EventListener>)a.this.g, arrayList.toArray(new Integer[0]));
                    a.this.a((List<EventListener>)a.this.g, a.this.i);
                }
            }
        });
        c2.a("user_count", new Emitter.Listener(){

            public void call(Object ... objectArray) {
                if (objectArray == null || objectArray.length <= 0) {
                    return;
                }
                if (!(objectArray[0] instanceof JSONObject)) {
                    return;
                }
                JSONObject jSONObject = (JSONObject)objectArray[0];
                a.this.i = iKalaJSONUtil.getJSONInt((JSONObject)jSONObject, (String)"guestCount") + iKalaJSONUtil.getJSONInt((JSONObject)jSONObject, (String)"memberCount");
                a.this.a((List<EventListener>)a.this.g, a.this.i);
            }
        });
        c2.a("error", new Emitter.Listener(){

            public void call(Object ... objectArray) {
            }
        });
        c2.a("chat_write_mode", new Emitter.Listener(){

            public void call(Object ... objectArray) {
                if (objectArray == null || objectArray.length <= 0) {
                    return;
                }
                if (!(objectArray[0] instanceof JSONObject)) {
                    return;
                }
                JSONObject jSONObject = (JSONObject)objectArray[0];
                String string = iKalaJSONUtil.getJSONString((JSONObject)jSONObject, (String)"chatWriteMode", (String)"ALL");
                a.this.w = ChatMode.a(string);
                a.this.a((List<EventListener>)a.this.g, a.this.w);
            }
        });
        c2.a("message_input_interval", new Emitter.Listener(){

            public void call(Object ... objectArray) {
                if (objectArray == null || objectArray.length <= 0) {
                    return;
                }
                if (!(objectArray[0] instanceof JSONObject)) {
                    return;
                }
                JSONObject jSONObject = (JSONObject)objectArray[0];
                String string = iKalaJSONUtil.getJSONString((JSONObject)jSONObject, (String)"chatId");
                if (!string.equals(a.this.k)) {
                    return;
                }
                a.this.c = iKalaJSONUtil.getJSONInt((JSONObject)jSONObject, (String)"inputInterval");
                a.this.b((List<EventListener>)a.this.g, a.this.c);
            }
        });
    }

    boolean a(EventListener eventListener) {
        if (eventListener == null) {
            return false;
        }
        if (this.g == null) {
            this.g = new ArrayList<EventListener>();
        }
        if (this.g.size() > 1 && this.g.contains(eventListener)) {
            return false;
        }
        return this.g.add(eventListener);
    }

    void a(EventListener ... eventListenerArray) {
        if (eventListenerArray == null) {
            return;
        }
        for (EventListener eventListener : eventListenerArray) {
            this.a(eventListener);
        }
    }

    boolean b(EventListener eventListener) {
        return eventListener != null && this.g != null && this.g.remove(eventListener);
    }

    void a() {
        if (this.g == null) {
            return;
        }
        this.g.clear();
    }

    private void a(final List<EventListener> list) {
        this.u.post(new Runnable(){

            @Override
            public void run() {
                for (EventListener eventListener : list) {
                    eventListener.onConnected();
                }
            }
        });
    }

    private void a(final List<EventListener> list, final MessagingError messagingError) {
        this.u.post(new Runnable(){

            @Override
            public void run() {
                for (EventListener eventListener : list) {
                    eventListener.onConnectFailed(messagingError);
                }
            }
        });
    }

    private void b(final List<EventListener> list, final MessagingError messagingError) {
        this.u.post(new Runnable(){

            @Override
            public void run() {
                for (EventListener eventListener : list) {
                    eventListener.onError(messagingError);
                }
            }
        });
    }

    private void b(final List<EventListener> list) {
        this.u.post(new Runnable(){

            @Override
            public void run() {
                for (EventListener eventListener : list) {
                    eventListener.onDisconnected();
                }
            }
        });
    }

    private void a(final List<EventListener> list, final Message message) {
        this.u.post(new Runnable(){

            @Override
            public void run() {
                for (EventListener eventListener : list) {
                    eventListener.onMessageAdded(message);
                }
            }
        });
    }

    private void a(final List<EventListener> list, final String string) {
        this.u.post(new Runnable(){

            @Override
            public void run() {
                for (EventListener eventListener : list) {
                    eventListener.onMessageRemoved(string);
                }
            }
        });
    }

    private void c(final List<EventListener> list) {
        this.u.post(new Runnable(){

            @Override
            public void run() {
                for (EventListener eventListener : list) {
                    eventListener.onMessageFlushed();
                }
            }
        });
    }

    private void a(final List<EventListener> list, final User[] userArray) {
        this.u.post(new Runnable(){

            @Override
            public void run() {
                for (EventListener eventListener : list) {
                    eventListener.onUserJoined(userArray);
                }
            }
        });
    }

    private void b(final List<EventListener> list, final User[] userArray) {
        this.u.post(new Runnable(){

            @Override
            public void run() {
                for (EventListener eventListener : list) {
                    eventListener.onUserUpdated(userArray);
                }
            }
        });
    }

    private void a(final List<EventListener> list, final Integer[] integerArray) {
        this.u.post(new Runnable(){

            @Override
            public void run() {
                for (EventListener eventListener : list) {
                    eventListener.onUserLeft(integerArray);
                }
            }
        });
    }

    private void a(final List<EventListener> list, final int n2) {
        this.u.post(new Runnable(){

            @Override
            public void run() {
                for (EventListener eventListener : list) {
                    eventListener.userCount(n2);
                }
            }
        });
    }

    private void a(final List<EventListener> list, final ChatMode chatMode) {
        this.u.post(new Runnable(){

            @Override
            public void run() {
                for (EventListener eventListener : list) {
                    eventListener.onChatWriteModeChanged(chatMode);
                }
            }
        });
    }

    private void b(final List<EventListener> list, final int n2) {
        this.u.post(new Runnable(){

            @Override
            public void run() {
                for (EventListener eventListener : list) {
                    eventListener.onInputIntervalChanged(n2);
                }
            }
        });
    }

    void a(int n2, int n3, final @NonNull OnResultListener<Message[], MessagingError> onResultListener) {
        if (onResultListener == null) {
            return;
        }
        if (this.b != ChatroomState.CONNECTED || !this.a(n2, n3, 100)) {
            onResultListener.onFailure((Object)MessagingError.REQUEST_REJECTED);
            return;
        }
        int n4 = (n2 - 1) * n3;
        Call<a$g> call = this.p.a(this.s, this.l, this.k, Collections.singletonList("USER"), true, n3, n4);
        call.enqueue((Callback)new b<a$g>(this.q, call, onResultListener){

            @Override
            public void onResponse(Call<a$g> call, Response<a$g> response) {
                super.onResponse(call, response);
                a$g g2 = (a$g)response.body();
                if (!response.isSuccessful() || g2 == null || g2.messages == null) {
                    return;
                }
                int n2 = g2.messages.length;
                Message[] messageArray = new Message[n2];
                for (int i2 = 0; i2 < n2; ++i2) {
                    Message message;
                    messageArray[i2] = message = new Message.a(g2.messages[i2], (SimpleArrayMap<String, String>)a.this.j).a();
                }
                onResultListener.onSuccess((Object)messageArray);
            }
        });
    }

    void b(int n2, int n3, final @NonNull OnResultListener<User[], MessagingError> onResultListener) {
        if (onResultListener == null) {
            return;
        }
        if (this.b != ChatroomState.CONNECTED || !this.a(n2, n3, 200)) {
            onResultListener.onFailure((Object)MessagingError.REQUEST_REJECTED);
            return;
        }
        int n4 = (n2 - 1) * n3;
        Call<a$h> call = this.p.a(this.s, this.l, this.k, Collections.singletonList("ACTIVE"), null, null, n3, n4);
        call.enqueue((Callback)new b<a$h>(this.q, call, onResultListener){

            @Override
            public void onResponse(Call<a$h> call, Response<a$h> response) {
                super.onResponse(call, response);
                a$h h2 = (a$h)response.body();
                if (!response.isSuccessful() || h2 == null || h2.users == null) {
                    return;
                }
                int n2 = h2.users.length;
                User[] userArray = new User[n2];
                for (int i2 = 0; i2 < n2; ++i2) {
                    User user;
                    userArray[i2] = user = new User.a(h2.users[i2]).a();
                }
                onResultListener.onSuccess((Object)userArray);
            }
        });
    }

    void a(final @NonNull OnResultListener<ChatroomInfo, MessagingError> onResultListener) {
        if (onResultListener == null) {
            return;
        }
        if (this.b != ChatroomState.CONNECTED) {
            onResultListener.onFailure((Object)MessagingError.REQUEST_REJECTED);
            return;
        }
        String string = Credential.getAccountId();
        if (TextUtils.isEmpty((CharSequence)string)) {
            onResultListener.onFailure((Object)MessagingError.INTERNAL_ERROR);
            return;
        }
        Call<a$f> call = this.p.a(this.s, this.d, string);
        call.enqueue((Callback)new b<a$f>(this.q, call, onResultListener){

            @Override
            public void onResponse(Call<a$f> call, Response<a$f> response) {
                super.onResponse(call, response);
                if (response.isSuccessful() && response.body() != null) {
                    onResultListener.onSuccess((Object)((a$f)response.body()).toChatroomInfo());
                }
            }
        });
    }

    void a(String string, final OnResultListener<Void, MessagingError> onResultListener) {
        if (this.b != ChatroomState.CONNECTED || TextUtils.isEmpty((CharSequence)string)) {
            if (onResultListener != null) {
                onResultListener.onFailure((Object)MessagingError.REQUEST_REJECTED);
            }
            return;
        }
        Call<ResponseBody> call = this.p.a(this.s, new a$a(this.k, this.l, string, null));
        call.enqueue((Callback)new b<ResponseBody>(this.q, call, onResultListener){

            @Override
            public void onResponse(Call<ResponseBody> call, Response<ResponseBody> response) {
                super.onResponse(call, response);
                if (response.isSuccessful() && onResultListener != null) {
                    onResultListener.onSuccess(null);
                }
            }

            @Override
            public void onFailure(Call<ResponseBody> call, Throwable throwable) {
                super.onFailure(call, throwable);
            }
        });
    }

    void b(final String string, final OnResultListener<Void, MessagingError> onResultListener) {
        if (this.b != ChatroomState.CONNECTED || this.e != Identity.GUEST) {
            if (onResultListener != null) {
                onResultListener.onFailure((Object)MessagingError.REQUEST_REJECTED);
            }
            return;
        }
        this.h = string;
        Call<ResponseBody> call = this.p.a(this.s, new a$n(this.k, this.l, Collections.singletonList(new a$i(this.m, this.h, null))));
        call.enqueue((Callback)new b<ResponseBody>(this.q, call, onResultListener){

            @Override
            public void onResponse(Call<ResponseBody> call, Response<ResponseBody> response) {
                super.onResponse(call, response);
                if (response.isSuccessful()) {
                    a.this.n.a(string);
                    if (onResultListener != null) {
                        onResultListener.onSuccess(null);
                    }
                }
            }
        });
    }

    void a(List<User> list, final OnResultListener<Void, MessagingError> onResultListener) {
        boolean bl;
        Role role = this.n.getRole();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (User call2 : list) {
            arrayList.add(call2.getLabel());
        }
        boolean bl2 = bl = role == Role.MASTER || role == Role.GLOBAL_MANAGER || role == Role.LOCAL_MANAGER;
        if (this.b != ChatroomState.CONNECTED || arrayList.size() == 0) {
            if (onResultListener != null) {
                onResultListener.onFailure((Object)MessagingError.REQUEST_REJECTED);
            }
            return;
        }
        if (!bl) {
            if (onResultListener != null) {
                onResultListener.onFailure((Object)MessagingError.PERMISSION_ERROR);
            }
            return;
        }
        Call<ResponseBody> call = this.p.a(this.s, new a$d(this.k, this.l, arrayList));
        call.enqueue((Callback)new b<ResponseBody>(this.q, call, onResultListener){

            @Override
            public void onResponse(Call<ResponseBody> call, Response<ResponseBody> response) {
                super.onResponse(call, response);
                if (response.isSuccessful() && onResultListener != null) {
                    onResultListener.onSuccess(null);
                }
            }
        });
    }

    void b(List<User> list, final OnResultListener<Void, MessagingError> onResultListener) {
        boolean bl;
        Role role = this.n.getRole();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (User call2 : list) {
            arrayList.add(call2.getLabel());
        }
        boolean bl2 = bl = role == Role.MASTER || role == Role.GLOBAL_MANAGER || role == Role.LOCAL_MANAGER;
        if (this.b != ChatroomState.CONNECTED || arrayList.size() == 0) {
            if (onResultListener != null) {
                onResultListener.onFailure((Object)MessagingError.REQUEST_REJECTED);
            }
            return;
        }
        if (!bl) {
            if (onResultListener != null) {
                onResultListener.onFailure((Object)MessagingError.PERMISSION_ERROR);
            }
            return;
        }
        Call<ResponseBody> call = this.p.b(this.s, new a$d(this.k, this.l, arrayList));
        call.enqueue((Callback)new b<ResponseBody>(this.q, call, onResultListener){

            @Override
            public void onResponse(Call<ResponseBody> call, Response<ResponseBody> response) {
                super.onResponse(call, response);
                if (response.isSuccessful() && onResultListener != null) {
                    onResultListener.onSuccess(null);
                }
            }
        });
    }

    void a(Message message, final OnResultListener<Void, MessagingError> onResultListener) {
        boolean bl;
        Role role = this.n.getRole();
        String string = message.getId();
        boolean bl2 = bl = role == Role.MASTER || role == Role.GLOBAL_MANAGER || role == Role.LOCAL_MANAGER;
        if (this.b != ChatroomState.CONNECTED || string == null) {
            if (onResultListener != null) {
                onResultListener.onFailure((Object)MessagingError.REQUEST_REJECTED);
            }
            return;
        }
        if (!bl) {
            if (onResultListener != null) {
                onResultListener.onFailure((Object)MessagingError.PERMISSION_ERROR);
            }
            return;
        }
        Call<ResponseBody> call = this.p.a(this.s, this.l, this.k, string);
        call.enqueue((Callback)new b<ResponseBody>(this.q, call, onResultListener){

            @Override
            public void onResponse(Call<ResponseBody> call, Response<ResponseBody> response) {
                super.onResponse(call, response);
                if (response.isSuccessful() && onResultListener != null) {
                    onResultListener.onSuccess(null);
                }
            }
        });
    }

    User b() {
        return this.n;
    }

    int c() {
        return this.i;
    }

    ChatMode d() {
        return this.w;
    }

    int e() {
        return this.c;
    }

    ChatroomState f() {
        return this.b;
    }

    void g() {
        if (!this.s()) {
            return;
        }
        this.a(false);
    }

    private void p() {
        this.a(true);
    }

    private void a(boolean bl) {
        if (bl) {
            this.b = ChatroomState.CONNECTING;
        } else {
            this.b = ChatroomState.DISCONNECTING;
            this.r.stop();
        }
        this.q.cancelAllCalls();
        this.r();
        if (iKalaUtils.isEmptyString((CharSequence)this.l) || iKalaUtils.isEmptyString((CharSequence)this.k) || this.m == null) {
            if (bl) {
                this.j();
            }
        } else {
            this.b(bl);
            this.q();
        }
        if (!bl) {
            this.b = ChatroomState.IDLE;
            if (this.o) {
                this.b(this.g);
            }
        }
    }

    private void q() {
        this.k = null;
        this.l = null;
        this.m = null;
        this.n = null;
    }

    private synchronized void r() {
        if (this.v == null) {
            return;
        }
        this.v.a.off();
        this.v.a.disconnect();
    }

    private void b(final boolean bl) {
        Call<ResponseBody> call = this.p.a(this.s, this.l, this.k, Collections.singletonList(this.m));
        call.enqueue((Callback)new CallManager.Callback<ResponseBody>(this.q, call, null){

            public void onResponse(Call<ResponseBody> call, Response<ResponseBody> response) {
                super.onResponse(call, response);
                if (bl) {
                    a.this.j();
                }
            }

            public void onFailure(Call<ResponseBody> call, Throwable throwable) {
                super.onFailure(call, throwable);
                MessagingError messagingError = a.this.a(call, throwable);
                if (bl && messagingError != MessagingError.TASK_CANCELED) {
                    a.this.j();
                }
            }
        });
    }

    private void a(MessagingError messagingError) {
        if (!this.s()) {
            this.b(messagingError);
            return;
        }
        if (!this.c(messagingError) || !this.r.retry()) {
            this.b(messagingError);
            this.g();
        }
    }

    private void b(MessagingError messagingError) {
        if (!this.o) {
            this.a(this.g, messagingError);
        } else if (messagingError != MessagingError.TASK_CANCELED) {
            this.b(this.g, messagingError);
        }
    }

    private boolean c(MessagingError messagingError) {
        switch (messagingError) {
            case NETWORK_ERROR: 
            case INTERNAL_ERROR: 
            case SERVER_ERROR: {
                return true;
            }
        }
        return false;
    }

    private MessagingError a(Response response) {
        int n2 = response.code();
        a$l l2 = this.a(response.errorBody());
        if (l2 == null || l2.code == null) {
            return MessagingError.INTERNAL_ERROR;
        }
        switch (n2) {
            case 401: {
                if (!l2.code.equals("UnauthorizedError")) break;
                return MessagingError.UNAUTHORIZED_ERROR;
            }
            case 403: {
                if (!l2.code.equals("PermissionViolationError")) break;
                return MessagingError.PERMISSION_ERROR;
            }
            case 404: {
                if (!l2.code.equals("EntityNotFoundError")) break;
                return MessagingError.UNKNOWN_CHATROOM;
            }
            case 409: {
                if (!l2.code.equals("DuplicateEntityError") && !l2.code.equals("InvalidRequestError")) break;
                return MessagingError.INTERNAL_ERROR;
            }
            case 500: {
                return MessagingError.SERVER_ERROR;
            }
            default: {
                return MessagingError.INTERNAL_ERROR;
            }
        }
        return MessagingError.INTERNAL_ERROR;
    }

    private MessagingError a(Call call, Throwable throwable) {
        int n2 = HttpTaskError.getThrowableMappingId((Call)call, (Throwable)throwable);
        switch (n2) {
            case 6: {
                return MessagingError.TASK_CANCELED;
            }
        }
        return MessagingError.NETWORK_ERROR;
    }

    private boolean s() {
        return this.b == ChatroomState.CONNECTING || this.b == ChatroomState.CONNECTED;
    }

    private a$l a(ResponseBody responseBody) {
        a$l l2;
        Moshi moshi = new Moshi.Builder().build();
        try {
            l2 = (a$l)moshi.adapter(a$l.class).fromJson(responseBody.source());
        }
        catch (JsonDataException | IOException throwable) {
            throwable.printStackTrace();
            l2 = new a$l();
        }
        return l2;
    }

    private boolean a(int n2, int n3, int n4) {
        return n2 > 0 && n3 > 0 && n3 <= n4;
    }

    private static final class c {
        Socket a;

        c(Socket socket) {
            this.a = socket;
        }

        Emitter a(String string, Object ... objectArray) {
            return this.a.emit(string, objectArray);
        }

        Emitter a(String string, Emitter.Listener listener) {
            return this.a.on(string, listener);
        }
    }

    private class b<T>
    extends CallManager.Callback<T> {
        private int b;
        private OnResultListener c;

        public b(@Nullable CallManager callManager, @Nullable Call call, OnResultListener onResultListener) {
            super(callManager, call, null);
            this.b = 0;
            this.c = onResultListener;
        }

        public void onResponse(Call<T> call, Response<T> response) {
            super.onResponse(call, response);
            if (!response.isSuccessful()) {
                MessagingError messagingError = a.this.a(response);
                this.a(call, messagingError);
            }
        }

        public void onFailure(Call<T> call, Throwable throwable) {
            super.onFailure(call, throwable);
            MessagingError messagingError = a.this.a(call, throwable);
            this.a(call, messagingError);
        }

        private void a(final Call<T> call, MessagingError messagingError) {
            if (++this.b <= 3 && a.this.s() && a.this.c(messagingError)) {
                a.this.u.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        Call call2 = call.clone();
                        call2.enqueue((Callback)b.this);
                    }
                }, 1000L);
            } else if (this.c != null && messagingError != MessagingError.TASK_CANCELED) {
                this.c.onFailure((Object)messagingError);
            }
        }
    }

    private class a<T>
    extends CallManager.Callback<T> {
        public a(@Nullable CallManager callManager, @Nullable Call call, @Nullable CallManager.OnHttpTaskLoadingCallback onHttpTaskLoadingCallback) {
            super(callManager, call, onHttpTaskLoadingCallback);
        }

        public void onResponse(Call<T> call, Response<T> response) {
            super.onResponse(call, response);
            if (!response.isSuccessful()) {
                MessagingError messagingError = a.this.a(response);
                this.a(messagingError);
            }
        }

        public void onFailure(Call<T> call, Throwable throwable) {
            super.onFailure(call, throwable);
            MessagingError messagingError = a.this.a(call, throwable);
            this.a(messagingError);
        }

        protected void a(MessagingError messagingError) {
            a.this.a(messagingError);
        }
    }
}

