/*
 * Decompiled with CFR 0.152.
 */
package io.straas.android.sdk.messaging;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.CountDownTimer;
import android.os.Handler;
import android.preference.PreferenceManager;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.ikala.android.controller.Retriable;
import com.ikala.android.controller.RetryDelayController;
import com.ikala.android.httptask.CallManager;
import com.ikala.android.httptask.error.HttpTaskError;
import com.ikala.android.utils.iKalaJSONUtil;
import com.ikala.android.utils.iKalaUtils;
import com.squareup.moshi.JsonDataException;
import com.squareup.moshi.Moshi;
import io.socket.client.IO;
import io.socket.client.Socket;
import io.socket.emitter.Emitter;
import io.straas.android.sdk.base.credential.Credential;
import io.straas.android.sdk.base.identity.Identity;
import io.straas.android.sdk.base.interfaces.OnResultListener;
import io.straas.android.sdk.base.internal.Utils;
import io.straas.android.sdk.messaging.ChatMode;
import io.straas.android.sdk.messaging.ChatroomInfo;
import io.straas.android.sdk.messaging.ChatroomState;
import io.straas.android.sdk.messaging.Message;
import io.straas.android.sdk.messaging.MessagingError;
import io.straas.android.sdk.messaging.User;
import io.straas.android.sdk.messaging.a.a;
import io.straas.android.sdk.messaging.a.a.a;
import io.straas.android.sdk.messaging.interfaces.EventListener;
import io.straas.android.sdk.messaging.internal.MessageCategory;
import io.straas.android.sdk.messaging.internal.UserStatus;
import java.io.IOException;
import java.net.URISyntaxException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import javax.net.ssl.SSLContext;
import okhttp3.Interceptor;
import okhttp3.ResponseBody;
import org.json.JSONArray;
import org.json.JSONObject;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class a {
    private static String a = iKalaUtils.getLogTag((String)a.class.getSimpleName());
    private static final String[] b = new String[]{"websocket"};
    private ChatroomState c = ChatroomState.IDLE;
    private int d;
    private String e;
    private Identity f;
    private boolean g;
    private EventListener h;
    private String i;
    private int j;
    private int k;
    private String l;
    private String m;
    private Integer n;
    private User o;
    private boolean p;
    private io.straas.android.sdk.messaging.a.a q;
    private final CallManager r = new CallManager();
    private RetryDelayController s;
    private String t;
    private SharedPreferences u;
    private Handler v = new Handler();
    private Socket w;
    private ChatMode x = ChatMode.ALL;
    private a.a$a y = new a.a$a(){

        @Override
        public void a(String string) {
            a.this.t = string;
            if (a.this.u != null) {
                a.this.u.edit().putString("KEY_API_TOKEN", string).apply();
            }
        }
    };
    private CountDownTimer z = new CountDownTimer(5000L, 5000L){

        public void onTick(long l2) {
        }

        public void onFinish() {
            a.this.a(MessagingError.INTERNAL_ERROR);
        }
    };

    a(Context context) {
        this.h();
        this.u = PreferenceManager.getDefaultSharedPreferences((Context)context);
    }

    private void h() {
        this.s = new RetryDelayController(new Retriable(){

            public void retry() {
                a.this.p();
            }
        });
        this.s.setMaxCount(7);
        this.s.enableExponentialBackoff(true);
        this.s.setBaseRetryInterval(500L);
    }

    private io.straas.android.sdk.messaging.a.a b(Identity identity) {
        return (io.straas.android.sdk.messaging.a.a)Utils.createMemberRetrofit((String)"https://mgr.straas.net", (Identity)identity, (Interceptor[])new Interceptor[]{new io.straas.android.sdk.messaging.a.a.a("https://mgr.straas.net", this.y)}).create(io.straas.android.sdk.messaging.a.a.class);
    }

    void a(@NonNull String string, @NonNull Identity identity, boolean bl, @NonNull EventListener eventListener) {
        if (eventListener == null) {
            return;
        }
        if (this.c != ChatroomState.IDLE || TextUtils.isEmpty((CharSequence)string) || identity == null) {
            this.a(eventListener, MessagingError.REQUEST_REJECTED);
            return;
        }
        this.c = ChatroomState.CONNECTING;
        this.f = identity;
        this.e = string;
        this.g = bl;
        this.h = eventListener;
        this.q = this.b(identity);
        this.s.stop();
        this.p = false;
        this.j();
    }

    boolean a(Identity identity) {
        if (this.c.equals((Object)ChatroomState.CONNECTED)) {
            this.f = identity;
            this.q = this.b(identity);
            return true;
        }
        return false;
    }

    private void i() {
        if (!TextUtils.isEmpty((CharSequence)this.t)) {
            return;
        }
        String string = null;
        if (this.u != null) {
            string = this.u.getString("KEY_API_TOKEN", null);
        }
        this.t = !TextUtils.isEmpty(string) ? string : "unknownApiToken";
    }

    private void a(b b2) {
        switch (b2) {
            case a: {
                this.k();
                break;
            }
            case b: {
                this.l();
                break;
            }
            case c: {
                this.m();
                break;
            }
            case d: {
                this.n();
            }
        }
    }

    private void j() {
        this.c = ChatroomState.CONNECTING;
        this.i();
        this.a(io.straas.android.sdk.messaging.a$b.a);
    }

    private void k() {
        String string = Credential.getAccountId();
        if (TextUtils.isEmpty((CharSequence)string)) {
            this.b(MessagingError.INTERNAL_ERROR);
            this.g();
        }
        Call<a$d> call = this.q.a(this.t, this.e, string);
        call.enqueue((Callback)new c<a$d>(this.r, call, null){

            @Override
            public void onResponse(Call<a$d> call, Response<a$d> response) {
                super.onResponse(call, response);
                if (!a.this.s()) {
                    return;
                }
                if (response.isSuccessful() && response.body() != null) {
                    a.this.l = ((a$d)response.body()).id;
                    a.this.d = ((a$d)response.body()).inputInterval;
                    a.this.x = ChatMode.a(((a$d)response.body()).chatWriteMode);
                    a.this.k = ((a$d)response.body()).guestCount;
                    a.this.j = ((a$d)response.body()).memberCount;
                    a.this.a(io.straas.android.sdk.messaging.a$b.b);
                }
            }
        });
    }

    private void l() {
        this.i = this.f.isGuest() ? "Guest" : null;
        Call<a$c> call = this.q.a(this.t, new a$b(this.l, this.m, this.i));
        call.enqueue((Callback)new c<a$c>(this.r, call, null){

            @Override
            public void onResponse(Call<a$c> call, Response<a$c> response) {
                super.onResponse(call, response);
                if (!a.this.s()) {
                    return;
                }
                if (response.isSuccessful() && response.body() != null) {
                    a$c$a a2 = ((a$c)response.body()).userMetas[0];
                    a.this.m = a2.userToken;
                    a.this.n = (Integer)a2.label;
                    a.this.a(io.straas.android.sdk.messaging.a$b.c);
                }
            }
        });
    }

    private void m() {
        this.o();
    }

    private void n() {
        this.s.stop();
        this.c = ChatroomState.CONNECTED;
        if (!this.p) {
            this.p = true;
            this.a(this.h);
        }
    }

    private void o() {
        Socket socket;
        IO.Options options = new IO.Options();
        options.reconnection = false;
        options.rememberUpgrade = true;
        options.forceNew = true;
        options.transports = b;
        options.timeout = 30000L;
        try {
            options.sslContext = SSLContext.getDefault();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            noSuchAlgorithmException.printStackTrace();
        }
        try {
            socket = IO.socket((String)"https://mgs.straas.net", (IO.Options)options);
        }
        catch (URISyntaxException uRISyntaxException) {
            uRISyntaxException.printStackTrace();
            this.a(MessagingError.INTERNAL_ERROR);
            return;
        }
        this.a(socket);
        this.b(socket);
        this.w = socket;
        socket.connect();
    }

    private void a(final Socket socket) {
        if (socket == null) {
            return;
        }
        socket.on("connect", new Emitter.Listener(){

            public void call(Object ... objectArray) {
                JSONArray jSONArray = new JSONArray();
                jSONArray.put((Object)a.this.m);
                jSONArray.put((Object)a.this.l);
                a.this.z.start();
                socket.emit(io.straas.android.sdk.messaging.a$a.a.a(), new Object[]{a.this.m, a.this.l});
            }
        });
        socket.on("connect_error", new Emitter.Listener(){

            public void call(Object ... objectArray) {
                a.this.a(MessagingError.NETWORK_ERROR);
            }
        });
        socket.on("disconnect", new Emitter.Listener(){

            public void call(Object ... objectArray) {
                if (!a.this.s()) {
                    return;
                }
                a.this.a(MessagingError.NETWORK_ERROR);
            }
        });
    }

    private void b(Socket socket) {
        if (socket == null) {
            return;
        }
        socket.on(io.straas.android.sdk.messaging.a$a.b.a(), new Emitter.Listener(){

            public void call(Object ... objectArray) {
                if (objectArray == null || objectArray.length <= 0) {
                    return;
                }
                if (!(objectArray[0] instanceof JSONObject)) {
                    return;
                }
                a.this.z.cancel();
                a.this.o = User.a((JSONObject)objectArray[0]);
                a.this.a(io.straas.android.sdk.messaging.a$b.d);
            }
        });
        socket.on(io.straas.android.sdk.messaging.a$a.c.a(), new Emitter.Listener(){

            public void call(Object ... objectArray) {
                if (objectArray.length <= 0) {
                    return;
                }
                if (!(objectArray[0] instanceof JSONObject)) {
                    return;
                }
                JSONObject jSONObject = (JSONObject)objectArray[0];
                Message message = Message.a(jSONObject);
                a.this.a(a.this.h, message);
            }
        });
        socket.on(io.straas.android.sdk.messaging.a$a.d.a(), new Emitter.Listener(){

            public void call(Object ... objectArray) {
                if (objectArray == null || objectArray.length <= 0) {
                    return;
                }
                if (!(objectArray[0] instanceof String)) {
                    return;
                }
                String string = (String)objectArray[0];
                a.this.a(a.this.h, string);
            }
        });
        socket.on(io.straas.android.sdk.messaging.a$a.e.a(), new Emitter.Listener(){

            public void call(Object ... objectArray) {
                a.this.c(a.this.h);
            }
        });
        socket.on(io.straas.android.sdk.messaging.a$a.f.a(), new Emitter.Listener(){

            public void call(Object ... objectArray) {
                int n = 0;
                if (objectArray == null || objectArray.length <= 0) {
                    return;
                }
                if (!(objectArray[0] instanceof JSONArray)) {
                    return;
                }
                JSONArray jSONArray = (JSONArray)objectArray[0];
                n = jSONArray.length();
                ArrayList<User> arrayList = new ArrayList<User>();
                for (int i2 = 0; i2 < n; ++i2) {
                    JSONObject jSONObject = iKalaJSONUtil.getJSONObjectFromJSONArray((JSONArray)jSONArray, (int)i2);
                    if (jSONObject == null) continue;
                    User user = User.a(jSONObject);
                    if (a.this.n != null && a.this.n.intValue() == user.getLabel().intValue()) continue;
                    arrayList.add(user);
                }
                if (arrayList.size() != 0) {
                    a.this.a(a.this.h, arrayList.toArray(new User[0]));
                }
            }
        });
        socket.on(io.straas.android.sdk.messaging.a$a.g.a(), new Emitter.Listener(){

            public void call(Object ... objectArray) {
                int n = 0;
                if (objectArray == null || objectArray.length <= 0) {
                    return;
                }
                if (!(objectArray[0] instanceof JSONArray)) {
                    return;
                }
                JSONArray jSONArray = (JSONArray)objectArray[0];
                n = jSONArray.length();
                ArrayList<User> arrayList = new ArrayList<User>();
                for (int i2 = 0; i2 < n; ++i2) {
                    JSONObject jSONObject = (JSONObject)iKalaJSONUtil.getObjectFromJSONArray((JSONArray)jSONArray, (int)i2);
                    User user = User.a(jSONObject);
                    arrayList.add(user);
                    if (a.this.n == null || a.this.n.intValue() != user.getLabel().intValue()) continue;
                    a.this.o = user;
                }
                if (arrayList.size() != 0) {
                    a.this.b(a.this.h, arrayList.toArray(new User[0]));
                }
            }
        });
        socket.on(io.straas.android.sdk.messaging.a$a.h.a(), new Emitter.Listener(){

            public void call(Object ... objectArray) {
                int n = 0;
                if (objectArray == null || objectArray.length <= 0) {
                    return;
                }
                if (!(objectArray[0] instanceof JSONArray)) {
                    return;
                }
                JSONArray jSONArray = (JSONArray)objectArray[0];
                n = jSONArray.length();
                ArrayList<Integer> arrayList = new ArrayList<Integer>();
                block3: for (int i2 = 0; i2 < n; ++i2) {
                    JSONObject jSONObject = (JSONObject)iKalaJSONUtil.getObjectFromJSONArray((JSONArray)jSONArray, (int)i2);
                    int n2 = iKalaJSONUtil.getJSONInt((JSONObject)jSONObject, (String)"label", (int)-1);
                    if (-1 == n2) continue;
                    String string = iKalaJSONUtil.getJSONString((JSONObject)jSONObject, (String)"status");
                    if (a.this.n != null && n2 == a.this.n) {
                        switch (UserStatus.a(string)) {
                            case DELETED: {
                                if (!a.this.s()) continue block3;
                                break;
                            }
                        }
                        continue;
                    }
                    User.a a2 = new User.a();
                    a2.a(n2).a(string);
                    arrayList.add(n2);
                }
                if (arrayList.size() != 0) {
                    a.this.a(a.this.h, arrayList.toArray(new Integer[0]));
                }
            }
        });
        socket.on(io.straas.android.sdk.messaging.a$a.i.a(), new Emitter.Listener(){

            public void call(Object ... objectArray) {
                if (objectArray == null || objectArray.length <= 0) {
                    return;
                }
                if (!(objectArray[0] instanceof JSONObject)) {
                    return;
                }
                JSONObject jSONObject = (JSONObject)objectArray[0];
                a.this.k = iKalaJSONUtil.getJSONInt((JSONObject)jSONObject, (String)"guestCount");
                a.this.j = iKalaJSONUtil.getJSONInt((JSONObject)jSONObject, (String)"memberCount");
                a.this.a(a.this.h, a.this.k, a.this.j);
            }
        });
        socket.on(io.straas.android.sdk.messaging.a$a.j.a(), new Emitter.Listener(){

            public void call(Object ... objectArray) {
            }
        });
        socket.on(io.straas.android.sdk.messaging.a$a.k.a(), new Emitter.Listener(){

            public void call(Object ... objectArray) {
                if (objectArray == null || objectArray.length <= 0) {
                    return;
                }
                if (!(objectArray[0] instanceof JSONObject)) {
                    return;
                }
                JSONObject jSONObject = (JSONObject)objectArray[0];
                String string = iKalaJSONUtil.getJSONString((JSONObject)jSONObject, (String)"chatWriteMode", (String)"ALL");
                a.this.x = ChatMode.a(string);
                a.this.a(a.this.h, a.this.x);
            }
        });
        socket.on(io.straas.android.sdk.messaging.a$a.l.a(), new Emitter.Listener(){

            public void call(Object ... objectArray) {
                if (objectArray == null || objectArray.length <= 0) {
                    return;
                }
                if (!(objectArray[0] instanceof JSONObject)) {
                    return;
                }
                JSONObject jSONObject = (JSONObject)objectArray[0];
                String string = iKalaJSONUtil.getJSONString((JSONObject)jSONObject, (String)"chatId");
                if (!string.equals(a.this.l)) {
                    return;
                }
                a.this.d = iKalaJSONUtil.getJSONInt((JSONObject)jSONObject, (String)"inputInterval");
                a.this.a(a.this.h, a.this.d);
            }
        });
    }

    private void a(final EventListener eventListener) {
        this.v.post(new Runnable(){

            @Override
            public void run() {
                eventListener.onConnected();
            }
        });
    }

    private void a(final EventListener eventListener, final MessagingError messagingError) {
        this.v.post(new Runnable(){

            @Override
            public void run() {
                eventListener.onConnectFailed(messagingError);
            }
        });
    }

    private void b(final EventListener eventListener, final MessagingError messagingError) {
        this.v.post(new Runnable(){

            @Override
            public void run() {
                eventListener.onError(messagingError);
            }
        });
    }

    private void b(final EventListener eventListener) {
        this.v.post(new Runnable(){

            @Override
            public void run() {
                eventListener.onDisconnected();
            }
        });
    }

    private void a(final EventListener eventListener, final Message message) {
        this.v.post(new Runnable(){

            @Override
            public void run() {
                eventListener.onMessageAdded(message);
            }
        });
    }

    private void a(final EventListener eventListener, final String string) {
        this.v.post(new Runnable(){

            @Override
            public void run() {
                eventListener.onMessageRemoved(string);
            }
        });
    }

    private void c(final EventListener eventListener) {
        this.v.post(new Runnable(){

            @Override
            public void run() {
                eventListener.onMessageFlushed();
            }
        });
    }

    private void a(final EventListener eventListener, final User[] userArray) {
        this.v.post(new Runnable(){

            @Override
            public void run() {
                eventListener.onUserJoined(userArray);
            }
        });
    }

    private void b(final EventListener eventListener, final User[] userArray) {
        this.v.post(new Runnable(){

            @Override
            public void run() {
                eventListener.onUserUpdated(userArray);
            }
        });
    }

    private void a(final EventListener eventListener, final Integer[] integerArray) {
        this.v.post(new Runnable(){

            @Override
            public void run() {
                eventListener.onUserLeft(integerArray);
            }
        });
    }

    private void a(final EventListener eventListener, final int n, final int n2) {
        this.v.post(new Runnable(){

            @Override
            public void run() {
                eventListener.userCount(n, n2);
            }
        });
    }

    private void a(final EventListener eventListener, final ChatMode chatMode) {
        this.v.post(new Runnable(){

            @Override
            public void run() {
                eventListener.onChatWriteModeChanged(chatMode);
            }
        });
    }

    private void a(final EventListener eventListener, final int n) {
        this.v.post(new Runnable(){

            @Override
            public void run() {
                eventListener.onInputIntervalChanged(n);
            }
        });
    }

    void a(int n, int n2, final @NonNull OnResultListener<Message[], MessagingError> onResultListener) {
        if (onResultListener == null) {
            return;
        }
        if (this.c != ChatroomState.CONNECTED || !this.a(n, n2, 100)) {
            onResultListener.onFailure((Object)MessagingError.REQUEST_REJECTED);
            return;
        }
        int n3 = (n - 1) * n2;
        Call<a$e> call = this.q.a(this.t, this.m, this.l, Collections.singletonList(MessageCategory.USER), true, n2, n3);
        call.enqueue((Callback)new d<a$e>(this.r, call, onResultListener){

            @Override
            public void onResponse(Call<a$e> call, Response<a$e> response) {
                super.onResponse(call, response);
                a$e e2 = (a$e)response.body();
                if (!response.isSuccessful() || e2 == null || e2.messages == null) {
                    return;
                }
                int n = e2.messages.length;
                Message[] messageArray = new Message[n];
                for (int i2 = 0; i2 < n; ++i2) {
                    Message message;
                    messageArray[i2] = message = new Message.a(e2.messages[i2]).a();
                }
                onResultListener.onSuccess((Object)messageArray);
            }
        });
    }

    void b(int n, int n2, final @NonNull OnResultListener<User[], MessagingError> onResultListener) {
        if (onResultListener == null) {
            return;
        }
        if (this.c != ChatroomState.CONNECTED || !this.a(n, n2, 200)) {
            onResultListener.onFailure((Object)MessagingError.REQUEST_REJECTED);
            return;
        }
        int n3 = (n - 1) * n2;
        Call<a$f> call = this.q.a(this.t, this.m, this.l, Collections.singletonList(UserStatus.ACTIVE), null, null, n2, n3);
        call.enqueue((Callback)new d<a$f>(this.r, call, onResultListener){

            @Override
            public void onResponse(Call<a$f> call, Response<a$f> response) {
                super.onResponse(call, response);
                a$f f2 = (a$f)response.body();
                if (!response.isSuccessful() || f2 == null || f2.users == null) {
                    return;
                }
                int n = f2.users.length;
                User[] userArray = new User[n];
                for (int i2 = 0; i2 < n; ++i2) {
                    User user;
                    userArray[i2] = user = new User.a(f2.users[i2]).a();
                }
                onResultListener.onSuccess((Object)userArray);
            }
        });
    }

    void a(final @NonNull OnResultListener<ChatroomInfo, MessagingError> onResultListener) {
        if (onResultListener == null) {
            return;
        }
        if (this.c != ChatroomState.CONNECTED) {
            onResultListener.onFailure((Object)MessagingError.REQUEST_REJECTED);
            return;
        }
        String string = Credential.getAccountId();
        if (TextUtils.isEmpty((CharSequence)string)) {
            onResultListener.onFailure((Object)MessagingError.INTERNAL_ERROR);
            return;
        }
        Call<a$d> call = this.q.a(this.t, this.e, string);
        call.enqueue((Callback)new d<a$d>(this.r, call, onResultListener){

            @Override
            public void onResponse(Call<a$d> call, Response<a$d> response) {
                super.onResponse(call, response);
                if (response.isSuccessful() && response.body() != null) {
                    onResultListener.onSuccess((Object)((a$d)response.body()).toChatroomInfo());
                }
            }
        });
    }

    void a(String string, final OnResultListener<Void, MessagingError> onResultListener) {
        if (this.c != ChatroomState.CONNECTED || TextUtils.isEmpty((CharSequence)string)) {
            if (onResultListener != null) {
                onResultListener.onFailure((Object)MessagingError.REQUEST_REJECTED);
            }
            return;
        }
        Call<ResponseBody> call = this.q.a(this.t, new a$a(this.l, this.m, string, null));
        call.enqueue((Callback)new d<ResponseBody>(this.r, call, onResultListener){

            @Override
            public void onResponse(Call<ResponseBody> call, Response<ResponseBody> response) {
                super.onResponse(call, response);
                if (response.isSuccessful() && onResultListener != null) {
                    onResultListener.onSuccess(null);
                }
            }

            @Override
            public void onFailure(Call<ResponseBody> call, Throwable throwable) {
                super.onFailure(call, throwable);
            }
        });
    }

    void b(final String string, final OnResultListener<Void, MessagingError> onResultListener) {
        if (this.c != ChatroomState.CONNECTED || !this.f.isGuest()) {
            if (onResultListener != null) {
                onResultListener.onFailure((Object)MessagingError.REQUEST_REJECTED);
            }
            return;
        }
        this.i = string;
        Call<ResponseBody> call = this.q.a(this.t, new a$l(this.l, this.m, Collections.singletonList(new a$g(this.n, this.i, null))));
        call.enqueue((Callback)new d<ResponseBody>(this.r, call, onResultListener){

            @Override
            public void onResponse(Call<ResponseBody> call, Response<ResponseBody> response) {
                super.onResponse(call, response);
                if (response.isSuccessful()) {
                    a.this.o.a(string);
                    if (onResultListener != null) {
                        onResultListener.onSuccess(null);
                    }
                }
            }
        });
    }

    User a() {
        return this.o;
    }

    int b() {
        return this.j;
    }

    int c() {
        return this.k;
    }

    ChatMode d() {
        return this.x;
    }

    int e() {
        return this.d;
    }

    ChatroomState f() {
        return this.c;
    }

    void g() {
        if (!this.s()) {
            return;
        }
        this.a(false);
    }

    private void p() {
        this.a(true);
    }

    private void a(boolean bl) {
        if (bl) {
            this.c = ChatroomState.CONNECTING;
        } else {
            this.c = ChatroomState.DISCONNECTING;
            this.s.stop();
        }
        this.r.cancelAllCalls();
        this.r();
        if (iKalaUtils.isEmptyString((CharSequence)this.m) || iKalaUtils.isEmptyString((CharSequence)this.l) || this.n == null) {
            if (bl) {
                this.j();
            }
        } else {
            this.b(bl);
            this.q();
        }
        if (!bl) {
            this.c = ChatroomState.IDLE;
            if (this.p) {
                this.b(this.h);
            }
        }
    }

    private void q() {
        this.l = null;
        this.m = null;
        this.n = null;
        this.o = null;
    }

    private synchronized void r() {
        if (this.w == null) {
            return;
        }
        this.w.off();
        this.w.disconnect();
    }

    private void b(final boolean bl) {
        Call<ResponseBody> call = this.q.a(this.t, this.m, this.l, Collections.singletonList(this.n));
        call.enqueue((Callback)new CallManager.Callback<ResponseBody>(this.r, call, null){

            public void onResponse(Call<ResponseBody> call, Response<ResponseBody> response) {
                super.onResponse(call, response);
                if (bl) {
                    a.this.j();
                }
            }

            public void onFailure(Call<ResponseBody> call, Throwable throwable) {
                super.onFailure(call, throwable);
                MessagingError messagingError = a.this.a(call, throwable);
                if (bl && messagingError != MessagingError.TASK_CANCELED) {
                    a.this.j();
                }
            }
        });
    }

    private void a(MessagingError messagingError) {
        if (!this.s()) {
            this.b(messagingError);
            return;
        }
        if (!this.c(messagingError) || !this.s.retry()) {
            this.b(messagingError);
            this.g();
        }
    }

    private void b(MessagingError messagingError) {
        if (!this.p) {
            this.a(this.h, messagingError);
        } else if (messagingError != MessagingError.TASK_CANCELED) {
            this.b(this.h, messagingError);
        }
    }

    private boolean c(MessagingError messagingError) {
        switch (messagingError) {
            case NETWORK_ERROR: 
            case INTERNAL_ERROR: 
            case SERVER_ERROR: {
                return true;
            }
        }
        return false;
    }

    private MessagingError a(Response response) {
        int n = response.code();
        a$j j2 = this.a(response.errorBody());
        if (j2 == null || j2.code == null) {
            return MessagingError.INTERNAL_ERROR;
        }
        switch (n) {
            case 401: {
                if (!j2.code.equals("UnauthorizedError")) break;
                return MessagingError.UNAUTHORIZED_ERROR;
            }
            case 403: {
                if (!j2.code.equals("PermissionViolationError")) break;
                return MessagingError.PERMISSION_ERROR;
            }
            case 404: {
                if (!j2.code.equals("EntityNotFoundError")) break;
                return MessagingError.UNKNOWN_CHATROOM;
            }
            case 409: {
                if (!j2.code.equals("DuplicateEntityError") && !j2.code.equals("InvalidRequestError")) break;
                return MessagingError.INTERNAL_ERROR;
            }
            case 500: {
                return MessagingError.SERVER_ERROR;
            }
            default: {
                return MessagingError.INTERNAL_ERROR;
            }
        }
        return MessagingError.INTERNAL_ERROR;
    }

    private MessagingError a(Call call, Throwable throwable) {
        int n = HttpTaskError.getThrowableMappingId((Call)call, (Throwable)throwable);
        switch (n) {
            case 6: {
                return MessagingError.TASK_CANCELED;
            }
        }
        return MessagingError.NETWORK_ERROR;
    }

    private boolean s() {
        return this.c == ChatroomState.CONNECTING || this.c == ChatroomState.CONNECTED;
    }

    private a$j a(ResponseBody responseBody) {
        a$j j2;
        Moshi moshi = new Moshi.Builder().build();
        try {
            j2 = (a$j)moshi.adapter(a$j.class).fromJson(responseBody.source());
        }
        catch (JsonDataException | IOException throwable) {
            throwable.printStackTrace();
            j2 = new a$j();
        }
        return j2;
    }

    private boolean a(int n, int n2, int n3) {
        return n > 0 && n2 > 0 && n2 <= n3;
    }

    private class d<T>
    extends CallManager.Callback<T> {
        private int b;
        private OnResultListener c;

        public d(@Nullable CallManager callManager, @Nullable Call call, OnResultListener onResultListener) {
            super(callManager, call, null);
            this.b = 0;
            this.c = onResultListener;
        }

        public void onResponse(Call<T> call, Response<T> response) {
            super.onResponse(call, response);
            if (!response.isSuccessful()) {
                MessagingError messagingError = a.this.a(response);
                this.a(call, messagingError);
            }
        }

        public void onFailure(Call<T> call, Throwable throwable) {
            super.onFailure(call, throwable);
            MessagingError messagingError = a.this.a(call, throwable);
            this.a(call, messagingError);
        }

        private void a(final Call<T> call, MessagingError messagingError) {
            if (++this.b <= 3 && a.this.s() && a.this.c(messagingError)) {
                a.this.v.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        Call call2 = call.clone();
                        call2.enqueue((Callback)d.this);
                    }
                }, 1000L);
            } else if (this.c != null && messagingError != MessagingError.TASK_CANCELED) {
                this.c.onFailure((Object)messagingError);
            }
        }
    }

    private class c<T>
    extends CallManager.Callback<T> {
        public c(@Nullable CallManager callManager, @Nullable Call call, @Nullable CallManager.OnHttpTaskLoadingCallback onHttpTaskLoadingCallback) {
            super(callManager, call, onHttpTaskLoadingCallback);
        }

        public void onResponse(Call<T> call, Response<T> response) {
            super.onResponse(call, response);
            if (!response.isSuccessful()) {
                MessagingError messagingError = a.this.a(response);
                this.a(messagingError);
            }
        }

        public void onFailure(Call<T> call, Throwable throwable) {
            super.onFailure(call, throwable);
            MessagingError messagingError = a.this.a(call, throwable);
            this.a(messagingError);
        }

        protected void a(MessagingError messagingError) {
            a.this.a(messagingError);
        }
    }

    static enum a {
        a,
        b,
        c,
        d,
        e,
        f,
        g,
        h,
        i,
        j,
        k,
        l;


        public String a() {
            switch (this) {
                case a: {
                    return "subscribe";
                }
                case b: {
                    return "subscribed";
                }
                case c: {
                    return "message";
                }
                case d: {
                    return "message_remove";
                }
                case e: {
                    return "message_flush";
                }
                case f: {
                    return "user_add";
                }
                case g: {
                    return "user_update";
                }
                case h: {
                    return "user_remove";
                }
                case i: {
                    return "user_count";
                }
                case j: {
                    return "error";
                }
                case k: {
                    return "chat_write_mode";
                }
                case l: {
                    return "message_input_interval";
                }
            }
            return null;
        }
    }

    private static enum b {
        a,
        b,
        c,
        d;

    }
}

