/*
 * Decompiled with CFR 0.152.
 */
package io.straas.android.sdk.messaging.ui;

import android.content.Context;
import android.content.DialogInterface;
import android.os.CountDownTimer;
import android.os.IBinder;
import android.support.annotation.NonNull;
import android.support.v4.view.GestureDetectorCompat;
import android.support.v7.app.AlertDialog;
import android.support.v7.view.ContextThemeWrapper;
import android.support.v7.widget.AppCompatEditText;
import android.text.Editable;
import android.text.InputFilter;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.util.Log;
import android.util.TypedValue;
import android.view.GestureDetector;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.Button;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.TextView;
import android.widget.Toast;
import com.ikala.android.utils.iKalaUtils;
import io.straas.android.sdk.base.interfaces.OnResultListener;
import io.straas.android.sdk.messaging.ChatMode;
import io.straas.android.sdk.messaging.ChatroomManager;
import io.straas.android.sdk.messaging.ChatroomState;
import io.straas.android.sdk.messaging.Message;
import io.straas.android.sdk.messaging.MessagingError;
import io.straas.android.sdk.messaging.User;
import io.straas.android.sdk.messaging.interfaces.EventListener;
import io.straas.android.sdk.messaging.ui.R;
import io.straas.android.sdk.messaging.ui.interfaces.SignInListener;

public class ChatroomInputView
extends FrameLayout {
    private static final String a = ChatroomInputView.class.getSimpleName();
    private int b;
    private ChatMode c;
    private User d;
    private OnResultListener<Void, MessagingError> e;
    private SignInListener f;
    private View g;
    private TextView h;
    private ChatroomManager i;
    private View.OnTouchListener j;
    private GestureDetectorCompat k;
    private GestureDetector.SimpleOnGestureListener l = new GestureDetector.SimpleOnGestureListener(){

        public boolean onSingleTapUp(MotionEvent motionEvent) {
            if (ChatroomInputView.this.d.isGuest()) {
                if (ChatroomInputView.this.c.equals((Object)ChatMode.ALL)) {
                    if (ChatroomInputView.c(ChatroomInputView.this.d)) {
                        ChatroomInputView.this.a();
                        return true;
                    }
                } else if (ChatroomInputView.this.c.equals((Object)ChatMode.LOGIN)) {
                    if (ChatroomInputView.this.f != null) {
                        ChatroomInputView.this.f.signIn();
                    }
                    return true;
                }
            }
            return ChatroomInputView.this.j != null && ChatroomInputView.this.j.onTouch((View)ChatroomInputView.this, motionEvent);
        }

        public boolean onDown(MotionEvent motionEvent) {
            return true;
        }
    };
    private EventListener m = new EventListener(){

        public void onConnected() {
            ChatroomInputView.this.setSendBtnVisibility(0);
            ChatroomInputView.this.d = ChatroomInputView.this.i.getCurrentUser();
            ChatroomInputView.this.c = ChatroomInputView.this.i.getChatMode();
            ChatroomInputView.this.a(ChatroomInputView.this.c, ChatroomInputView.this.d.isGuest());
        }

        public void onConnectFailed(MessagingError messagingError) {
        }

        public void onError(MessagingError messagingError) {
        }

        public void onDisconnected() {
        }

        public void onMessageAdded(Message message) {
        }

        public void onMessageRemoved(String string2) {
        }

        public void onMessageFlushed() {
        }

        public void onUserJoined(User[] userArray) {
        }

        public void onUserUpdated(User[] userArray) {
        }

        public void onUserLeft(Integer[] integerArray) {
        }

        public void userCount(int n) {
        }

        public void onChatWriteModeChanged(ChatMode chatMode) {
            ChatroomInputView.this.c = chatMode;
            ChatroomInputView.this.a(chatMode, ChatroomInputView.this.d.isGuest());
        }

        public void onInputIntervalChanged(int n) {
        }
    };

    public ChatroomInputView(Context context) {
        this(context, null);
    }

    public ChatroomInputView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public ChatroomInputView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.a(context, attributeSet);
    }

    private void a(Context context, AttributeSet attributeSet) {
        ViewGroup viewGroup = (ViewGroup)LayoutInflater.from((Context)new ContextThemeWrapper(context, R.style.ChatroomTheme)).inflate(R.layout.chatroom_input_layout, (ViewGroup)this, false);
        TypedValue typedValue = new TypedValue();
        this.getContext().getTheme().resolveAttribute(R.attr.dialogPreferredPadding, typedValue, true);
        this.b = this.getResources().getDimensionPixelSize(typedValue.resourceId);
        this.addView((View)viewGroup);
        this.h = (TextView)iKalaUtils.getView((View)viewGroup, (int)R.id.inputEditText);
        this.k = new GestureDetectorCompat(this.getContext(), (GestureDetector.OnGestureListener)this.l);
        this.h.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View view, MotionEvent motionEvent) {
                boolean bl = ChatroomInputView.this.k.onTouchEvent(motionEvent);
                if (motionEvent.getAction() == 0) {
                    return view.onTouchEvent(motionEvent);
                }
                return bl || view.onTouchEvent(motionEvent);
            }
        });
        this.g = iKalaUtils.getView((View)viewGroup, (int)R.id.btnSend);
        this.g.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                String string2 = ChatroomInputView.this.h.getText().toString();
                ChatroomInputView.this.sendMessage(string2);
            }
        });
        if (this.i != null && this.i.getChatroomState() == ChatroomState.CONNECTED) {
            this.m.onConnected();
        }
    }

    public void setOnTouchListener(View.OnTouchListener onTouchListener) {
        this.j = onTouchListener;
    }

    public void sendMessage(String string2) {
        if (this.i == null) {
            Log.w((String)a, (String)"Chatroom is not connected. Please call connect function first.");
            return;
        }
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return;
        }
        iKalaUtils.hideKeyboard((Context)this.getContext(), (IBinder)this.getWindowToken());
        this.i.sendMessage(string2, (OnResultListener)new OnResultListener<Void, MessagingError>(){

            public void a(Void void_) {
                if (!TextUtils.isEmpty((CharSequence)ChatroomInputView.this.h.getText().toString())) {
                    ChatroomInputView.this.h.setText((CharSequence)"");
                }
                ChatroomInputView.this.a(ChatroomInputView.this.i.getSendMessageInterval());
                if (ChatroomInputView.this.e != null) {
                    ChatroomInputView.this.e.onSuccess((Object)void_);
                }
            }

            public void a(MessagingError messagingError) {
                if (ChatroomInputView.this.e != null) {
                    ChatroomInputView.this.e.onFailure((Object)messagingError);
                }
            }

            public /* synthetic */ void onFailure(Object object) {
                this.a((MessagingError)object);
            }

            public /* synthetic */ void onSuccess(Object object) {
                this.a((Void)object);
            }
        });
    }

    public void setChatroomManager(@NonNull ChatroomManager chatroomManager) {
        if (chatroomManager == null) {
            return;
        }
        this.i = chatroomManager;
        this.i.addEventListener(this.m);
        if (this.i.getChatroomState() == ChatroomState.CONNECTED) {
            this.m.onConnected();
        }
    }

    private void a(boolean bl, String string2) {
        this.setSendButton(bl);
        this.g.setEnabled(bl);
        this.h.setHint((CharSequence)string2);
        if (!bl) {
            this.h.clearFocus();
        }
    }

    private void setSendButton(boolean bl) {
        this.g.setEnabled(bl);
        this.g.setAlpha(bl ? 1.0f : 0.3f);
    }

    private void setSendBtnVisibility(int n) {
        this.g.setVisibility(n);
    }

    private void a(ChatMode chatMode, boolean bl) {
        if (bl && chatMode.equals((Object)ChatMode.LOGIN)) {
            this.a(false, this.getResources().getString(R.string.plz_signin));
        } else {
            this.a(true, this.b(this.d));
        }
        this.h.setEnabled(true);
    }

    private void a(int n) {
        if (n <= 0) {
            return;
        }
        a a2 = new a((long)n * 1000L, 500L);
        a2.a();
    }

    private String b(User user) {
        if (user.isGuest() && !ChatroomInputView.c(user)) {
            return String.format(this.getResources().getString(R.string.input_hint_guest), user.getName());
        }
        return this.getResources().getString(R.string.input_hint);
    }

    private static boolean c(User user) {
        return user.getName().equals("Guest");
    }

    private void a(String string2) {
        this.i.updateNickname(string2, (OnResultListener)new OnResultListener<Void, MessagingError>(){

            public void a(Void void_) {
                ChatroomInputView.this.a(true, ChatroomInputView.this.b(ChatroomInputView.this.d));
            }

            public void a(MessagingError messagingError) {
                Toast.makeText((Context)ChatroomInputView.this.getContext(), (CharSequence)ChatroomInputView.this.getResources().getString(R.string.update_nickname_fail), (int)1).show();
            }

            public /* synthetic */ void onFailure(Object object) {
                this.a((MessagingError)object);
            }

            public /* synthetic */ void onSuccess(Object object) {
                this.a((Void)object);
            }
        });
    }

    private void a() {
        AlertDialog.Builder builder = new AlertDialog.Builder(this.getContext());
        builder.setTitle((CharSequence)this.getResources().getString(R.string.enter_nickname));
        AppCompatEditText appCompatEditText = new AppCompatEditText(this.getContext());
        InputFilter[] inputFilterArray = new InputFilter[]{new InputFilter.LengthFilter(15)};
        appCompatEditText.setFilters(inputFilterArray);
        appCompatEditText.setMaxLines(1);
        appCompatEditText.setImeOptions(6);
        builder.setPositiveButton((CharSequence)this.getResources().getString(R.string.common_confirm), null);
        builder.setNegativeButton((CharSequence)this.getResources().getString(R.string.common_cancel), null);
        final AlertDialog alertDialog = builder.create();
        iKalaUtils.showKeyboard((Window)alertDialog.getWindow());
        alertDialog.setView((View)appCompatEditText, this.b, this.b, this.b, 0);
        alertDialog.setOnShowListener(new DialogInterface.OnShowListener((EditText)appCompatEditText){
            final /* synthetic */ EditText b;
            {
                this.b = editText;
            }

            public void onShow(DialogInterface dialogInterface) {
                final Button button = alertDialog.getButton(-1);
                Button button2 = alertDialog.getButton(-2);
                button.setEnabled(false);
                this.b.setOnEditorActionListener(new TextView.OnEditorActionListener(){

                    public boolean onEditorAction(TextView textView, int n, KeyEvent keyEvent) {
                        if (n == 6) {
                            ChatroomInputView.this.a(b.getText().toString());
                            alertDialog.dismiss();
                        }
                        return false;
                    }
                });
                this.b.addTextChangedListener(new TextWatcher(){

                    public void afterTextChanged(Editable editable) {
                        button.setEnabled(editable.length() != 0);
                    }

                    public void beforeTextChanged(CharSequence charSequence, int n, int n2, int n3) {
                    }

                    public void onTextChanged(CharSequence charSequence, int n, int n2, int n3) {
                    }
                });
                button.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        ChatroomInputView.this.a(b.getText().toString());
                        alertDialog.dismiss();
                    }
                });
                button2.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        alertDialog.dismiss();
                    }
                });
            }
        });
        alertDialog.show();
    }

    public void setSendMessageListener(OnResultListener<Void, MessagingError> onResultListener) {
        this.e = onResultListener;
    }

    public void setSignInListener(SignInListener signInListener) {
        this.f = signInListener;
    }

    private class a
    extends CountDownTimer {
        private long b;

        public a(long l, long l2) {
            super(l, l2);
            this.b = l;
        }

        public CountDownTimer a() {
            ChatroomInputView.this.a(false, ChatroomInputView.this.getResources().getString(R.string.send_msg_time_left_android, new Object[]{this.b / 1000L + 1L}));
            ChatroomInputView.this.h.setEnabled(false);
            return super.start();
        }

        public void onTick(long l) {
            ChatroomInputView.this.a(false, ChatroomInputView.this.getResources().getString(R.string.send_msg_time_left_android, new Object[]{l / 1000L + 1L}));
        }

        public void onFinish() {
            ChatroomInputView.this.a(true, ChatroomInputView.this.b(ChatroomInputView.this.d));
            ChatroomInputView.this.h.setEnabled(true);
        }
    }
}

