/*
 * Decompiled with CFR 0.152.
 */
package io.straas.android.sdk.messaging.ui;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.app.Activity;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.support.annotation.ColorInt;
import android.support.annotation.LayoutRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.FragmentActivity;
import android.support.v4.content.ContextCompat;
import android.support.v4.graphics.drawable.DrawableCompat;
import android.support.v4.util.SimpleArrayMap;
import android.support.v4.view.ViewCompat;
import android.support.v4.widget.TextViewCompat;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import android.view.ContextThemeWrapper;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.TextView;
import android.widget.Toast;
import com.google.android.gms.tasks.OnFailureListener;
import com.google.android.gms.tasks.OnSuccessListener;
import io.straas.android.sdk.authentication.identity.Identity;
import io.straas.android.sdk.messaging.ChatMetadata;
import io.straas.android.sdk.messaging.ChatMode;
import io.straas.android.sdk.messaging.ChatroomManager;
import io.straas.android.sdk.messaging.ChatroomState;
import io.straas.android.sdk.messaging.Message;
import io.straas.android.sdk.messaging.Role;
import io.straas.android.sdk.messaging.User;
import io.straas.android.sdk.messaging.interfaces.EventListener;
import io.straas.android.sdk.messaging.message.MessageRequest;
import io.straas.android.sdk.messaging.ui.R;
import io.straas.android.sdk.messaging.ui.c;
import io.straas.android.sdk.messaging.ui.d;
import io.straas.android.sdk.messaging.ui.interfaces.CredentialAuthorizeListener;
import io.straas.android.sdk.messaging.ui.sticker.h;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public final class ChatroomOutputView
extends io.straas.android.sdk.messaging.ui.a {
    private static final String a = ChatroomOutputView.class.getSimpleName();
    private boolean b = false;
    private ChatroomManager c;
    private a d;
    private RecyclerView e;
    private View f;
    private CredentialAuthorizeListener g;
    private EventListener h;
    private boolean i;
    private boolean j;
    private ViewGroup k;
    private TextView l;
    private RecyclerView.ItemDecoration m;
    private FragmentActivity n;
    private View o;
    private ImageView p;
    private TextView q;
    private TextView r;
    private View s;
    private View t;
    private int u = 1;
    private EventListener v = new EventListener(){

        public void onConnected() {
            if (ViewCompat.isAttachedToWindow((View)ChatroomOutputView.this) && ((ChatroomOutputView)ChatroomOutputView.this).d.a.isEmpty()) {
                ChatroomOutputView.this.getLatestMessages();
            } else {
                ChatroomOutputView.this.f.setVisibility(8);
            }
            ChatroomOutputView.this.d();
            ChatroomOutputView.this.setPinnedMessage(ChatroomOutputView.this.c.getPinnedMessage());
        }

        public void onConnectFailed(Exception error) {
            ChatroomOutputView.this.f.setVisibility(8);
        }

        public void onError(Exception error) {
            ChatroomOutputView.this.f.setVisibility(8);
        }

        public void onDisconnected() {
            ChatroomOutputView.this.f.setVisibility(8);
        }

        public void onChatWriteModeChanged(ChatMode chatMode) {
        }

        public void onInputIntervalChanged(int inputInterval) {
        }

        public void onPinnedMessageUpdated(@Nullable Message pinnedMessage) {
            ChatroomOutputView.this.setPinnedMessage(pinnedMessage);
        }

        public void onMetadataUpdated(SimpleArrayMap<String, ChatMetadata> map) {
        }

        public void onMessageAdded(Message message) {
            if (!ChatroomOutputView.this.d.a(message)) {
                ChatroomOutputView.this.b();
            }
        }

        public void onMessageRemoved(String messageId) {
            ChatroomOutputView.this.d.b(new Message.Builder(messageId).build());
        }

        public void onAggregatedDataAdded(SimpleArrayMap<String, Integer> map) {
        }

        public void onRawDataAdded(Message message) {
        }

        public void onMessageFlushed() {
        }

        public void onUserJoined(User[] users) {
        }

        public void onUserUpdated(User[] users) {
        }

        public void onUserLeft(Integer[] userLabels) {
        }

        public void userCount(int userCount) {
        }
    };
    private c.b w = new c.b(){

        @Override
        public void a(Message message) {
            ChatroomOutputView.this.c.pinMessage(message).addOnFailureListener(ChatroomOutputView.this.x);
        }

        @Override
        public void a() {
            ChatroomOutputView.this.c.unpinMessage().addOnFailureListener(ChatroomOutputView.this.x);
        }

        @Override
        public void b(Message message) {
            ChatroomOutputView.this.c.removeMessage(message).addOnFailureListener(ChatroomOutputView.this.x);
        }
    };
    private OnFailureListener x = new OnFailureListener(){

        public void onFailure(@NonNull Exception e2) {
            Toast.makeText((Context)ChatroomOutputView.this.getContext(), (int)R.string.operation_failed_log, (int)1).show();
        }
    };

    public ChatroomOutputView(Context context) {
        this(context, null);
    }

    public ChatroomOutputView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ChatroomOutputView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.a(context, attrs);
    }

    @Override
    public void enableUpdate() {
        if (this.c != null) {
            this.c.addEventListener(this.v);
        }
    }

    @Override
    public void disableUpdate() {
        if (this.c != null) {
            this.c.removeEventListener(this.v);
        }
    }

    private void a(Context context, AttributeSet attributeSet) {
        ViewGroup viewGroup = (ViewGroup)LayoutInflater.from((Context)new ContextThemeWrapper(context, R.style.ChatroomTheme)).inflate(R.layout.chatroom_main_container, (ViewGroup)this, false);
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.Chatroom, 0, R.style.ChatroomTheme);
        Activity activity = io.straas.android.sdk.messaging.ui.d.a((View)viewGroup);
        if (activity instanceof FragmentActivity) {
            this.n = (FragmentActivity)activity;
        }
        this.a((View)io.straas.android.sdk.messaging.ui.d.a((View)viewGroup, R.id.pinned_message_group), typedArray);
        this.t = io.straas.android.sdk.messaging.ui.d.a((View)viewGroup, R.id.shadow);
        this.e = (RecyclerView)io.straas.android.sdk.messaging.ui.d.a((View)viewGroup, 16908298);
        this.f = io.straas.android.sdk.messaging.ui.d.a((View)viewGroup, R.id.loadingBar);
        this.d = new a(this, typedArray.getColor(R.styleable.Chatroom_msgAuthorColor, 0));
        this.e.setAdapter((RecyclerView.Adapter)this.d);
        this.m = this.a(typedArray.getColor(R.styleable.Chatroom_msgDividerColor, 0));
        this.e.addItemDecoration(this.m);
        this.e.addOnScrollListener((RecyclerView.OnScrollListener)new b());
        this.i = typedArray.getBoolean(R.styleable.Chatroom_showAvatar, true);
        this.j = typedArray.getBoolean(R.styleable.Chatroom_relativeTime, true);
        this.k = (ViewGroup)io.straas.android.sdk.messaging.ui.d.a((View)viewGroup, R.id.new_msg_container);
        this.l = (TextView)io.straas.android.sdk.messaging.ui.d.a((View)viewGroup, R.id.new_msg_btn);
        this.l.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ChatroomOutputView.this.a();
                ChatroomOutputView.this.d.c();
            }
        });
        Drawable drawable2 = io.straas.android.sdk.messaging.ui.d.a(this.getContext(), R.drawable.ic_arrow_downward_chatroom);
        TextViewCompat.setCompoundDrawablesRelativeWithIntrinsicBounds((TextView)this.l, (Drawable)drawable2, null, null, null);
        Drawable drawable3 = ContextCompat.getDrawable((Context)context, (int)R.drawable.new_msg_background);
        int n = typedArray.getColor(R.styleable.Chatroom_sendButtonColor, 0);
        DrawableCompat.setTintList((Drawable)drawable3, (ColorStateList)this.a(n, this.a(n, 0.9f)));
        ViewCompat.setBackground((View)this.l, (Drawable)drawable3);
        this.addView((View)viewGroup);
        typedArray.recycle();
    }

    private void a(View view, TypedArray typedArray) {
        if (this.o != null) {
            this.o.setVisibility(8);
            this.removeView(this.o);
        }
        if (this.t != null) {
            this.t.setVisibility(8);
            this.removeView(this.t);
            this.t = null;
        }
        this.o = view;
        if (this.o == null) {
            return;
        }
        this.p = (ImageView)io.straas.android.sdk.messaging.ui.d.a(view, 16908294);
        this.q = (TextView)io.straas.android.sdk.messaging.ui.d.a(view, 16908308);
        this.r = (TextView)io.straas.android.sdk.messaging.ui.d.a(view, 16908299);
        this.s = io.straas.android.sdk.messaging.ui.d.a(view, 16908311);
        this.d();
        if (typedArray != null) {
            int n = typedArray.getColor(R.styleable.Chatroom_pinnedMessageBackground, Color.argb((int)244, (int)244, (int)244, (int)244));
            this.o.setBackgroundColor(n);
            int n2 = typedArray.getColor(R.styleable.Chatroom_pinnedMessageTextColor, Color.argb((int)139, (int)0, (int)0, (int)0));
            this.r.setTextColor(n2);
            if (this.s instanceof ImageButton) {
                int n3 = typedArray.getColor(R.styleable.Chatroom_pinnedMessagePinIconColor, Color.argb((int)128, (int)0, (int)0, (int)0));
                Drawable drawable2 = io.straas.android.sdk.messaging.ui.d.a(this.getContext(), R.drawable.ic_pin_message_white);
                DrawableCompat.setTintList((Drawable)drawable2, (ColorStateList)this.a(n3, n3));
                ((ImageButton)this.s).setImageDrawable(drawable2);
            }
        }
    }

    private RecyclerView.ItemDecoration a(@ColorInt int n) {
        GradientDrawable gradientDrawable = (GradientDrawable)ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.recyclerview_divider);
        gradientDrawable.setColor(n);
        return new io.straas.android.sdk.messaging.ui.b((Drawable)gradientDrawable);
    }

    private ColorStateList a(int n, int n2) {
        int[] nArray = new int[]{n2, n};
        int[][] nArrayArray = new int[][]{{16842919}, new int[0]};
        return new ColorStateList((int[][])nArrayArray, nArray);
    }

    private int a(int n, float f2) {
        int n2 = Color.alpha((int)n);
        int n3 = Math.round((float)Color.red((int)n) * f2);
        int n4 = Math.round((float)Color.green((int)n) * f2);
        int n5 = Math.round((float)Color.blue((int)n) * f2);
        return Color.argb((int)n2, (int)Math.min(n3, 255), (int)Math.min(n4, 255), (int)Math.min(n5, 255));
    }

    public ChatroomOutputView setShowAvatar(boolean showAvatar) {
        this.i = showAvatar;
        return this;
    }

    public ChatroomOutputView enableRelativeTime(boolean enable) {
        this.j = enable;
        return this;
    }

    public void setMessageItemCustomView(@LayoutRes int customView) {
        this.d.a(customView);
    }

    public void setPinnedMessageCustomView(@Nullable View customView) {
        if (this.t != null) {
            this.removeView(this.t);
            this.t = null;
        }
        this.a(customView, null);
        if (this.c != null) {
            this.setPinnedMessage(this.c.getPinnedMessage());
        }
    }

    public void setVerticalScrollBarEnabled(boolean enabled) {
        this.e.setVerticalScrollBarEnabled(enabled);
    }

    public void setMsgDividerColor(@ColorInt int color2) {
        this.e.removeItemDecoration(this.m);
        this.m = this.a(color2);
        this.e.addItemDecoration(this.m);
    }

    public void connect(final String chatroomName, final Identity identity) {
        this.f.setVisibility(0);
        Activity activity = io.straas.android.sdk.messaging.ui.d.a((View)this);
        if (activity == null) {
            return;
        }
        ChatroomManager.initialize().addOnSuccessListener(activity, (OnSuccessListener)new OnSuccessListener<ChatroomManager>(){

            public void a(ChatroomManager chatroomManager) {
                ChatroomOutputView.this.setChatroomManager(chatroomManager);
                ChatroomOutputView.this.c.connect(chatroomName, identity);
                if (ChatroomOutputView.this.g != null) {
                    ChatroomOutputView.this.g.onSuccess(chatroomManager);
                }
            }

            public /* synthetic */ void onSuccess(Object object) {
                this.a((ChatroomManager)object);
            }
        }).addOnFailureListener(activity, new OnFailureListener(){

            public void onFailure(@NonNull Exception e2) {
                if (ChatroomOutputView.this.g != null) {
                    ChatroomOutputView.this.g.onFailure(e2);
                }
                ChatroomOutputView.this.f.setVisibility(8);
            }
        });
    }

    public void setChatroomManager(@NonNull ChatroomManager chatroomManager) {
        if (chatroomManager == null) {
            return;
        }
        if (this.c != null) {
            this.c.removeEventListener(this.v);
            this.c.removeEventListener(this.h);
        }
        this.c = chatroomManager;
        this.c.addEventListener(this.v);
        if (this.h != null) {
            this.c.addEventListener(this.h);
        }
        if (this.c.getChatroomState() == ChatroomState.CONNECTED) {
            this.v.onConnected();
        }
    }

    public void clearMessages() {
        this.d.b();
    }

    public void disconnect() {
        if (this.c != null) {
            this.c.disconnect();
        }
    }

    private void setPinnedMessage(Message message) {
        if (message != null) {
            io.straas.android.sdk.messaging.ui.d.a(this.p, message, io.straas.android.sdk.messaging.ui.d.a(this.getContext(), R.drawable.common_default_avatar), this.i);
            io.straas.android.sdk.messaging.ui.d.a(this.q, message, this.d.c);
            io.straas.android.sdk.messaging.ui.d.a(this.r, message);
            if (this.t != null) {
                this.t.setVisibility(0);
            }
            if (this.o != null) {
                this.o.setVisibility(0);
            }
        } else {
            if (this.t != null) {
                this.t.setVisibility(8);
            }
            if (this.o != null) {
                this.o.setVisibility(8);
            }
        }
    }

    private void getLatestMessages() {
        this.c.getMessages(new MessageRequest.Builder().page(1).perPage(40).build()).addOnSuccessListener((OnSuccessListener)new OnSuccessListener<Message[]>(){

            public void a(Message[] messageArray) {
                ChatroomOutputView.this.d.a(messageArray, true);
                ChatroomOutputView.this.f.setVisibility(8);
            }

            public /* synthetic */ void onSuccess(Object object) {
                this.a((Message[])object);
            }
        }).addOnFailureListener(new OnFailureListener(){

            public void onFailure(@NonNull Exception e2) {
                ChatroomOutputView.this.f.setVisibility(8);
            }
        });
    }

    public ChatroomManager getChatroomManager() {
        return this.c;
    }

    public ChatroomOutputView setCredentialAuthorizeListener(CredentialAuthorizeListener listener) {
        this.g = listener;
        return this;
    }

    public ChatroomOutputView setEventListener(EventListener listener) {
        if (this.c != null) {
            this.c.removeEventListener(this.h);
            this.c.addEventListener(listener);
        }
        this.h = listener;
        return this;
    }

    private void a() {
        this.k.animate().setDuration(100L).translationY((float)this.k.getHeight()).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                ChatroomOutputView.this.u = 2;
            }

            public void onAnimationEnd(Animator animation) {
                ChatroomOutputView.this.u = 1;
            }
        });
    }

    private void b() {
        this.k.animate().setDuration(200L).translationY(0.0f).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                ChatroomOutputView.this.u = 2;
            }

            public void onAnimationEnd(Animator animation) {
                ChatroomOutputView.this.u = 0;
                if (ViewCompat.isAttachedToWindow((View)ChatroomOutputView.this)) {
                    ChatroomOutputView.this.c();
                }
            }
        });
    }

    private void c() {
        if (this.u != 0) {
            return;
        }
        if (this.e.getAdapter().getItemCount() - 1 == ((LinearLayoutManager)this.e.getLayoutManager()).findLastCompletelyVisibleItemPosition()) {
            this.a();
        }
    }

    private void a(int n, Message message) {
        if (this.n == null || !this.e()) {
            return;
        }
        c c2 = new c();
        c2.a(n);
        c2.a(message);
        c2.a(this.w);
        c2.show(this.n.getSupportFragmentManager(), c2.getTag());
    }

    private void d() {
        if (this.s != null) {
            if (this.e()) {
                this.s.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        ChatroomOutputView.this.c.unpinMessage().addOnFailureListener(ChatroomOutputView.this.x);
                    }
                });
            } else {
                this.s.setClickable(false);
            }
        }
    }

    private boolean e() {
        if (this.c == null || this.c.getCurrentUser() == null || this.c.getCurrentUser().getRole() == null) {
            return false;
        }
        Role role = this.c.getCurrentUser().getRole();
        return role == Role.GLOBAL_MANAGER || role == Role.LOCAL_MANAGER || role == Role.MASTER || role == Role.MODERATOR;
    }

    @Override
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        io.straas.android.sdk.messaging.ui.sticker.h.a();
    }

    private class b
    extends RecyclerView.OnScrollListener {
        private b() {
        }

        public void onScrollStateChanged(RecyclerView recyclerView, int newState) {
            super.onScrollStateChanged(recyclerView, newState);
            int n = ((LinearLayoutManager)recyclerView.getLayoutManager()).findLastCompletelyVisibleItemPosition();
            ChatroomOutputView.this.b = n == recyclerView.getAdapter().getItemCount() - 1;
            ChatroomOutputView.this.c();
        }
    }

    private static class io.straas.android.sdk.messaging.ui.ChatroomOutputView$a
    extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
        List<Message> a = new ArrayList<Message>();
        private ChatroomOutputView b;
        @ColorInt
        private int c;
        @LayoutRes
        private int d = R.layout.message_item;
        private LayoutInflater e;

        io.straas.android.sdk.messaging.ui.ChatroomOutputView$a(ChatroomOutputView chatroomOutputView, int n) {
            this.b = chatroomOutputView;
            this.c = n;
        }

        void a(@LayoutRes int n) {
            this.d = n;
            this.a();
            this.b.e.removeAllViews();
        }

        void a() {
            TextView textView;
            if (this.e == null) {
                this.e = LayoutInflater.from((Context)new ContextThemeWrapper(this.b.getContext(), R.style.ChatroomTheme));
            }
            if ((textView = new a(this.e.inflate(this.d, (ViewGroup)this.b, false)).b()) != null) {
                this.c = textView.getCurrentTextColor();
            }
        }

        public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
            if (this.e == null) {
                this.e = LayoutInflater.from((Context)new ContextThemeWrapper(parent.getContext(), R.style.ChatroomTheme));
            }
            return new a(this.e.inflate(this.d, parent, false));
        }

        public void onBindViewHolder(RecyclerView.ViewHolder holder, int position) {
            if (!(holder instanceof a)) {
                return;
            }
            a a2 = (a)holder;
            final Message message = this.a.get(position);
            ImageView imageView = a2.a();
            io.straas.android.sdk.messaging.ui.d.a(imageView, message, io.straas.android.sdk.messaging.ui.d.a(this.b.getContext(), R.drawable.common_default_avatar), this.b.i);
            io.straas.android.sdk.messaging.ui.d.a(a2.b(), message, this.c);
            io.straas.android.sdk.messaging.ui.d.a(a2.d(), message);
            io.straas.android.sdk.messaging.ui.d.a(a2.c(), message, this.b.j);
            a2.e().setOnLongClickListener(new View.OnLongClickListener(){

                public boolean onLongClick(View v) {
                    Message message2 = a.this.b.getChatroomManager().getPinnedMessage();
                    int n = message.isSticker() ? 1 : (message2 != null && message2.getId() != null && message2.getId().equals(message.getId()) ? 2 : 0);
                    a.this.b.a(n, message);
                    return true;
                }
            });
        }

        public int getItemViewType(int position) {
            return this.d;
        }

        public int getItemCount() {
            return this.a.size();
        }

        boolean a(Message message) {
            int n = this.a.size();
            this.a.add(n, message);
            this.notifyItemInserted(n);
            if (this.b.b || message.getCreator().equals((Object)this.b.getChatroomManager().getCurrentUser())) {
                this.c();
                return true;
            }
            return false;
        }

        void a(Message[] messageArray, boolean bl) {
            this.a.addAll(0, Arrays.asList(messageArray));
            Collections.sort(this.a, new Comparator<Message>(){

                public int a(Message message, Message message2) {
                    return a.this.a(message, message2);
                }

                @Override
                public /* synthetic */ int compare(Object object, Object object2) {
                    return this.a((Message)object, (Message)object2);
                }
            });
            this.notifyItemRangeInserted(0, messageArray.length);
            if (bl) {
                this.c();
            }
        }

        private int a(Message message, Message message2) {
            long l;
            long l2 = message.getCreatedDate();
            if (l2 > (l = message2.getCreatedDate())) {
                return 1;
            }
            if (l2 < l) {
                return -1;
            }
            return 0;
        }

        private void c() {
            int n = this.getItemCount() - 1;
            if (n >= 0) {
                this.b.e.smoothScrollToPosition(n);
                this.b.b = true;
            }
        }

        boolean b(Message message) {
            if (this.a.contains(message)) {
                int n = this.a.indexOf(message);
                if (this.a.remove(message)) {
                    this.notifyItemRemoved(n);
                    return true;
                }
            }
            return false;
        }

        void b() {
            int n = this.a.size();
            this.a.clear();
            this.notifyItemRangeRemoved(0, n);
        }

        private class a
        extends RecyclerView.ViewHolder {
            private ImageView b;
            private TextView c;
            private TextView d;
            private TextView e;
            private View f;

            a(View view) {
                super(view);
                this.f = view;
                this.b = (ImageView)io.straas.android.sdk.messaging.ui.d.a(view, 16908294);
                this.c = (TextView)io.straas.android.sdk.messaging.ui.d.a(view, 16908308);
                this.d = (TextView)io.straas.android.sdk.messaging.ui.d.a(view, 16908309);
                this.e = (TextView)io.straas.android.sdk.messaging.ui.d.a(view, 16908299);
            }

            public ImageView a() {
                return this.b;
            }

            public TextView b() {
                return this.c;
            }

            public TextView c() {
                return this.d;
            }

            public TextView d() {
                return this.e;
            }

            public View e() {
                return this.f;
            }
        }
    }
}

