/*
 * Decompiled with CFR 0.152.
 */
package com.ikala.android.utils;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.app.Activity;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.graphics.Point;
import android.graphics.drawable.Drawable;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import android.os.IBinder;
import android.support.annotation.IntegerRes;
import android.support.annotation.NonNull;
import android.telephony.TelephonyManager;
import android.text.SpannableString;
import android.text.style.UnderlineSpan;
import android.util.Base64;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.View;
import android.view.ViewPropertyAnimator;
import android.view.Window;
import android.view.WindowManager;
import android.view.inputmethod.InputMethodManager;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import okhttp3.internal.Util;

public class iKalaUtils {
    private static final String a = iKalaUtils.class.getName();
    public static final String APP_TAG = "LIVEhouse";
    public static final String DEFAULT_USER_AGENT = "LIVEhouse" + " " + "inApp";
    public static final long ONE_SEC = 1000L;
    public static final long ONE_MIN = 60000L;
    public static final long ONE_HOUR = 3600000L;
    public static final long ONE_DAY = 86400000L;
    public static final long ONE_WEEK = 604800000L;
    public static final long ONE_MONTH = 2592000000L;
    public static final long ONE_YEAR = 31104000000L;
    public static final String CHARSET_UTF_8 = Charset.defaultCharset().name();

    public static String getLogTag(String className) {
        return String.format("%s:%s", APP_TAG, className);
    }

    public static String getLogTag(String prefix, String className) {
        return String.format("%s:%s", prefix, className);
    }

    public static int getHeightWithRatio(int width, float ratio) {
        return (int)Math.ceil((float)width * ratio);
    }

    public static int getWidthWithRatio(int height, float ratio) {
        return (int)Math.ceil((float)height * ratio);
    }

    public static DisplayMetrics getDeviceSize(Context context) {
        DisplayMetrics displayMetrics = new DisplayMetrics();
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        windowManager.getDefaultDisplay().getMetrics(displayMetrics);
        return displayMetrics;
    }

    public static int getDeviceOrientation(Context context) {
        boolean bl = false;
        if (context == null) {
            return 0;
        }
        Configuration configuration = context.getResources().getConfiguration();
        if (configuration == null) {
            return 0;
        }
        return configuration.orientation;
    }

    public static boolean isLandscapeMode(Context context) {
        return iKalaUtils.getDeviceOrientation(context) == 2;
    }

    public static Point getNavigationBarSize(Context context) {
        Point point = iKalaUtils.getAppUsableScreenSize(context);
        Point point2 = iKalaUtils.getRealScreenSize(context);
        if (point.x < point2.x) {
            return new Point(point2.x - point.x, point.y);
        }
        if (point.y < point2.y) {
            return new Point(point.x, point2.y - point.y);
        }
        return new Point();
    }

    public static Point getAppUsableScreenSize(Context context) {
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        Display display = windowManager.getDefaultDisplay();
        Point point = new Point();
        display.getSize(point);
        return point;
    }

    public static Point getRealScreenSize(Context context) {
        DisplayMetrics displayMetrics = new DisplayMetrics();
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        Display display = windowManager.getDefaultDisplay();
        Point point = new Point();
        if (Build.VERSION.SDK_INT >= 17) {
            display.getRealSize(point);
        } else if (Build.VERSION.SDK_INT >= 14) {
            try {
                point.x = (Integer)Display.class.getMethod("getRawWidth", new Class[0]).invoke((Object)display, new Object[0]);
                point.y = (Integer)Display.class.getMethod("getRawHeight", new Class[0]).invoke((Object)display, new Object[0]);
            }
            catch (Exception exception) {
                display.getMetrics(displayMetrics);
            }
        }
        return point;
    }

    public static boolean isEmptyString(CharSequence s) {
        return null == s || 0 == s.length();
    }

    public static SpannableString addUnderscore(String s, int start, int end) {
        if (s == null) {
            return null;
        }
        SpannableString spannableString = new SpannableString((CharSequence)s);
        spannableString.setSpan((Object)new UnderlineSpan(), start, end, 0);
        return spannableString;
    }

    public static Bundle decodeUrl(String s) {
        Bundle bundle = new Bundle();
        if (s != null) {
            String[] stringArray;
            for (String string : stringArray = s.split("&")) {
                String[] stringArray2 = string.split("=");
                if (stringArray2.length != 2) continue;
                try {
                    bundle.putString(URLDecoder.decode(stringArray2[0], CHARSET_UTF_8), URLDecoder.decode(stringArray2[1], CHARSET_UTF_8));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    unsupportedEncodingException.printStackTrace();
                }
            }
        }
        return bundle;
    }

    public static Bundle parseUrl(String url) {
        try {
            URL uRL = new URL(url);
            Bundle bundle = iKalaUtils.decodeUrl(uRL.getQuery());
            bundle.putAll(iKalaUtils.decodeUrl(uRL.getRef()));
            return bundle;
        }
        catch (MalformedURLException malformedURLException) {
            return new Bundle();
        }
    }

    public static String encodeURL(String str) {
        try {
            return URLEncoder.encode(str, CHARSET_UTF_8);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            return str;
        }
    }

    public static String encodeKey(String key) {
        String string = new StringBuilder(key).reverse().toString();
        return Base64.encodeToString((byte[])string.getBytes(), (int)0);
    }

    public static String decodeKey(String encodeObj) {
        String string = null;
        try {
            string = new String(Base64.decode((String)encodeObj, (int)0), "US-ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        String string2 = new StringBuilder(string).reverse().toString();
        return string2;
    }

    public static void showKeyboard(Window window) {
        window.setSoftInputMode(5);
    }

    public static void showKeyboard(Activity activity, View view) {
        iKalaUtils.showKeyboard(activity, view, 1);
    }

    public static void showKeyboard(Activity activity, View view, int flag) {
        InputMethodManager inputMethodManager = (InputMethodManager)activity.getSystemService("input_method");
        inputMethodManager.showSoftInput(view, flag);
    }

    public static void hideKeyboard(Window window) {
        window.setSoftInputMode(3);
    }

    public static void hideKeyboard(Context context, IBinder windowToken) {
        InputMethodManager inputMethodManager = (InputMethodManager)context.getSystemService("input_method");
        inputMethodManager.hideSoftInputFromWindow(windowToken, 2);
    }

    public static void sleep(long msec) {
        try {
            Thread.sleep(msec);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    public static void bringViewToFront(View view) {
        boolean bl = Build.VERSION.SDK_INT < 19;
        view.bringToFront();
        if (bl && view.getParent() instanceof View) {
            View view2 = (View)view.getParent();
            view2.requestLayout();
            view2.invalidate();
        }
    }

    public static <E extends View> E getView(Activity activity, int id) {
        return (E)activity.findViewById(id);
    }

    public static <E extends View> E getView(View view, int id) {
        return (E)view.findViewById(id);
    }

    public static void cancelAsyncTask(AsyncTask task, boolean mayInterruptIfRunning) {
        if (task == null) {
            return;
        }
        if (task.getStatus() != AsyncTask.Status.FINISHED) {
            task.cancel(mayInterruptIfRunning);
        }
    }

    public static int roundDownToNearestPowerOf2(int v) {
        --v;
        v |= v >> 1;
        v |= v >> 2;
        v |= v >> 4;
        v |= v >> 8;
        v |= v >> 16;
        return v + 1;
    }

    public static void fadeOutView(@NonNull View view, @IntegerRes int durationRes, Animator.AnimatorListener listener) {
        iKalaUtils.fadeOutView(view, durationRes, listener, 0L);
    }

    public static void fadeOutView(@NonNull View view, @IntegerRes int durationRes, Animator.AnimatorListener listener, long startDelay) {
        long l = view.getResources().getInteger(durationRes);
        iKalaUtils.fadeOutView(view, l, listener, startDelay);
    }

    public static void fadeOutView(final @NonNull View view, long duration, Animator.AnimatorListener listener, long startDelay) {
        if (view == null) {
            return;
        }
        ViewPropertyAnimator viewPropertyAnimator = view.animate();
        if (startDelay > 0L) {
            viewPropertyAnimator.setStartDelay(startDelay);
        } else if (viewPropertyAnimator.getStartDelay() > 0L) {
            viewPropertyAnimator.setStartDelay(0L);
        }
        viewPropertyAnimator.alpha(0.0f).setDuration(duration).setListener((Animator.AnimatorListener)(listener != null ? listener : new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                view.setVisibility(8);
            }
        }));
    }

    public static void fadeInView(@NonNull View view, @IntegerRes int durationRes, Animator.AnimatorListener listener) {
        long l = view.getResources().getInteger(durationRes);
        iKalaUtils.fadeInView(view, l, listener);
    }

    public static void fadeInView(@NonNull View view, long duration, Animator.AnimatorListener listener) {
        ViewPropertyAnimator viewPropertyAnimator;
        if (view == null) {
            return;
        }
        view.setAlpha(0.0f);
        if (view.getVisibility() != 0) {
            view.setVisibility(0);
        }
        if ((viewPropertyAnimator = view.animate()).getStartDelay() > 0L) {
            viewPropertyAnimator.setStartDelay(0L);
        }
        viewPropertyAnimator.alpha(1.0f).setDuration(duration).setListener((Animator.AnimatorListener)(listener != null ? listener : null));
    }

    public static Activity getActivity(View view) {
        Context context = view.getContext();
        while (context instanceof ContextWrapper) {
            if (context instanceof Activity) {
                return (Activity)context;
            }
            context = ((ContextWrapper)context).getBaseContext();
        }
        return null;
    }

    public static int getStatusBarHeight(Context context) {
        int n = 0;
        Resources resources = context.getResources();
        int n2 = resources.getIdentifier("status_bar_height", "dimen", "android");
        if (n2 > 0) {
            n = resources.getDimensionPixelSize(n2);
        }
        return n;
    }

    public static String inputStreamToString(InputStream inputStream) throws IOException {
        if (inputStream != null) {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, Util.UTF_8));
            StringBuilder stringBuilder = new StringBuilder();
            while ((string = bufferedReader.readLine()) != null) {
                stringBuilder.append(string);
                stringBuilder.append('\n');
            }
            return stringBuilder.toString();
        }
        return "";
    }

    public static void setViewBackground(View view, Drawable drawable) {
        if (Build.VERSION.SDK_INT < 16) {
            view.setBackgroundDrawable(drawable);
        } else {
            view.setBackground(drawable);
        }
    }

    public static NetworkType getCurrentNetworkType(Context context) {
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
        if (null == networkInfo) {
            return NetworkType.None;
        }
        if (!networkInfo.isConnected()) {
            return NetworkType.None;
        }
        int n = networkInfo.getType();
        switch (n) {
            case 9: {
                return NetworkType.Ethernet;
            }
            case 1: {
                return NetworkType.Wifi;
            }
            case 6: {
                return NetworkType.Wimax;
            }
            case 0: {
                TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
                int n2 = telephonyManager.getNetworkType();
                switch (n2) {
                    case 1: 
                    case 2: 
                    case 4: 
                    case 7: 
                    case 11: {
                        return NetworkType.Mobile2G;
                    }
                    case 3: 
                    case 5: 
                    case 6: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 12: 
                    case 14: 
                    case 15: {
                        return NetworkType.Mobile3G;
                    }
                    case 13: {
                        return NetworkType.Mobile4G;
                    }
                }
            }
        }
        return NetworkType.Unknown;
    }

    public static boolean StringsCompare(String a2, String b2) {
        return a2 != null && b2 != null && a2.compareTo(b2) == 0;
    }

    public static int secondsFromHms(String hms) {
        hms = hms.toLowerCase();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        try {
            if (hms.contains("h")) {
                n3 = Integer.parseInt(hms.split("h")[0].replaceAll(" ", ""));
                if (hms.contains("m") || hms.contains("s")) {
                    hms = hms.split("h")[1];
                }
            }
            if (hms.contains("m")) {
                n2 = Integer.parseInt(hms.split("m")[0].replaceAll(" ", ""));
                if (hms.contains("s")) {
                    hms = hms.split("m")[1];
                }
            }
            if (hms.contains("s")) {
                n = Integer.parseInt(hms.split("s")[0].replaceAll(" ", ""));
            }
            return n3 * 3600 + n2 * 60 + n;
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public static enum NetworkType {
        None,
        Ethernet,
        Wifi,
        Mobile2G,
        Mobile3G,
        Mobile4G,
        Wimax,
        Unknown;

    }
}

