/*
 * Decompiled with CFR 0.152.
 */
package com.ikala.android.manager.sdk;

import android.content.Context;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.util.Log;
import com.ikala.android.httptask.error.HttpTaskError;
import com.ikala.android.manager.sdk.ApiError;
import com.ikala.android.manager.sdk.SdkValidationError;
import com.ikala.android.manager.sdk.SdkValidationTask;
import com.ikala.android.utils.iKalaUtils;
import java.util.HashMap;
import okio.ByteString;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;
import retrofit2.Retrofit;

public class SdkValidator {
    private static final String a = iKalaUtils.getLogTag(SdkValidator.class.getSimpleName());
    private static final HashMap<String, String> b = new HashMap();
    private Retrofit c;
    private SdkValidationTask d;
    private Call e;

    public SdkValidator(Retrofit retrofit) {
        this.c = retrofit;
        this.d = (SdkValidationTask)retrofit.create(SdkValidationTask.class);
    }

    public void validate(final Context context, final String clientId, String secret, final ValidationResultListener listener) {
        boolean bl;
        if (listener == null) {
            Log.w((String)a, (String)"ValidationResultListener should not be null!! Ignore this execution.");
            return;
        }
        String string = b.get(clientId);
        if (string != null && (bl = this.a(context, string, listener))) {
            listener.onSuccess();
            return;
        }
        if (this.e == null) {
            this.e = this.d.getHashKey(clientId, secret);
        } else {
            this.e.cancel();
            this.e = this.d.getHashKey(clientId, secret);
        }
        this.e.enqueue((Callback)new Callback<SdkValidationTask.HashKeyResponse>(){

            public void onResponse(Call<SdkValidationTask.HashKeyResponse> call, Response<SdkValidationTask.HashKeyResponse> response) {
                if (!response.isSuccessful()) {
                    ApiError apiError = HttpTaskError.parseError(SdkValidator.this.c, response, ApiError.class);
                    listener.onFailure(new SdkValidationError(3, "", apiError));
                    return;
                }
                String string = ((SdkValidationTask.HashKeyResponse)response.body()).android_certificate;
                b.put(clientId, string);
                boolean bl = SdkValidator.this.a(context, string, listener);
                if (!bl) {
                    return;
                }
                listener.onSuccess();
            }

            public void onFailure(Call<SdkValidationTask.HashKeyResponse> call, Throwable t) {
                listener.onFailure(new SdkValidationError(1, "", new HttpTaskError(HttpTaskError.getThrowableMappingId(call, t))));
            }
        });
    }

    private boolean a(Context context, String string, ValidationResultListener validationResultListener) {
        String string2 = this.a(context);
        if (string2 == null || string == null) {
            validationResultListener.onFailure(new SdkValidationError(2));
            return false;
        }
        if (!string2.equals(string)) {
            validationResultListener.onFailure(new SdkValidationError(2));
            return false;
        }
        return true;
    }

    private String a(Context context) {
        String string = "";
        Signature[] signatureArray = new Signature[]{};
        try {
            signatureArray = context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)64).signatures;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            nameNotFoundException.printStackTrace();
        }
        for (Signature signature : signatureArray) {
            string = ByteString.of((byte[])signature.toByteArray()).sha1().hex();
        }
        return string;
    }

    public void cancel() {
        if (this.e != null) {
            this.e.cancel();
        }
    }

    public static interface ValidationResultListener {
        public void onFailure(SdkValidationError var1);

        public void onSuccess();
    }
}

