/*
 * Decompiled with CFR 0.152.
 */
package com.ikala.android.httptask.interceptor;

import android.support.v4.util.SimpleArrayMap;
import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public class CommonHeaderInterceptor
implements Interceptor {
    private final SimpleArrayMap<String, String> a;

    private CommonHeaderInterceptor(SimpleArrayMap<String, String> headers) {
        this.a = headers;
    }

    public int getHeaderCount() {
        if (this.a == null) {
            return 0;
        }
        return this.a.size();
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request.Builder builder = chain.request().newBuilder();
        for (int i = 0; i < this.a.size(); ++i) {
            builder.header((String)this.a.keyAt(i), (String)this.a.valueAt(i));
        }
        return chain.proceed(builder.build());
    }

    public static class Builder {
        private final SimpleArrayMap<String, String> a = new SimpleArrayMap();

        public Builder setUserAgent(String userAgent) {
            this.setHeader("User-Agent", userAgent);
            return this;
        }

        public Builder setAccept(String accept) {
            this.setHeader("Accept", accept);
            return this;
        }

        public Builder setContentType(String contentType) {
            this.setHeader("Content-Type", contentType);
            return this;
        }

        public Builder setHeader(String key, String value) {
            this.a.put((Object)key, (Object)value);
            return this;
        }

        public CommonHeaderInterceptor build() {
            return new CommonHeaderInterceptor(this.a);
        }
    }
}

